/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.recipebook;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.recipebook.GhostSlots;
import net.minecraft.client.gui.screens.recipebook.RecipeBookPage;
import net.minecraft.client.gui.screens.recipebook.RecipeBookTabButton;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.gui.screens.recipebook.SearchRecipeBookCategory;
import net.minecraft.client.gui.screens.recipebook.SlotSelectTime;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ServerboundRecipeBookChangeSettingsPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AbstractFurnaceMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.ExtendedRecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;

public abstract class RecipeBookComponent<T extends RecipeBookMenu>
implements Renderable,
GuiEventListener,
NarratableEntry {
    public static final WidgetSprites RECIPE_BUTTON_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace("recipe_book/button"), ResourceLocation.withDefaultNamespace("recipe_book/button_highlighted"));
    protected static final ResourceLocation RECIPE_BOOK_LOCATION = ResourceLocation.withDefaultNamespace("textures/gui/recipe_book.png");
    private static final int BACKGROUND_TEXTURE_WIDTH = 256;
    private static final int BACKGROUND_TEXTURE_HEIGHT = 256;
    private static final Component SEARCH_HINT = Component.translatable("gui.recipebook.search_hint").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY);
    public static final int IMAGE_WIDTH = 147;
    public static final int IMAGE_HEIGHT = 166;
    private static final int OFFSET_X_POSITION = 86;
    private static final int BORDER_WIDTH = 8;
    private static final Component ALL_RECIPES_TOOLTIP = Component.translatable("gui.recipebook.toggleRecipes.all");
    private static final int TICKS_TO_SWAP_SLOT = 30;
    private int xOffset;
    private int width;
    private int height;
    private float time;
    @Nullable
    private RecipeDisplayId lastPlacedRecipe;
    private final GhostSlots ghostSlots;
    private final List<RecipeBookTabButton> tabButtons = Lists.newArrayList();
    @Nullable
    private RecipeBookTabButton selectedTab;
    protected StateSwitchingButton filterButton;
    protected final T menu;
    protected Minecraft minecraft;
    @Nullable
    private EditBox searchBox;
    private String lastSearch = "";
    private final List<TabInfo> tabInfos;
    private ClientRecipeBook book;
    private final RecipeBookPage recipeBookPage;
    @Nullable
    private RecipeDisplayId lastRecipe;
    @Nullable
    private RecipeCollection lastRecipeCollection;
    private final StackedItemContents stackedContents = new StackedItemContents();
    private int timesInventoryChanged;
    private boolean ignoreTextInput;
    private boolean visible;
    private boolean widthTooNarrow;
    @Nullable
    private ScreenRectangle magnifierIconPlacement;

    public RecipeBookComponent(T p_365070_, List<TabInfo> p_379952_) {
        this.menu = p_365070_;
        this.tabInfos = p_379952_;
        SlotSelectTime $$2 = () -> Mth.floor(this.time / 30.0f);
        this.ghostSlots = new GhostSlots($$2);
        this.recipeBookPage = new RecipeBookPage(this, $$2, p_365070_ instanceof AbstractFurnaceMenu);
    }

    public void init(int p_100310_, int p_100311_, Minecraft p_100312_, boolean p_100313_) {
        this.minecraft = p_100312_;
        this.width = p_100310_;
        this.height = p_100311_;
        this.widthTooNarrow = p_100313_;
        this.book = p_100312_.player.getRecipeBook();
        this.timesInventoryChanged = p_100312_.player.getInventory().getTimesChanged();
        this.visible = this.isVisibleAccordingToBookData();
        if (this.visible) {
            this.initVisuals();
        }
    }

    private void initVisuals() {
        boolean $$0 = this.isFiltering();
        this.xOffset = this.widthTooNarrow ? 0 : 86;
        int $$1 = this.getXOrigin();
        int $$2 = this.getYOrigin();
        this.stackedContents.clear();
        this.minecraft.player.getInventory().fillStackedContents(this.stackedContents);
        ((RecipeBookMenu)this.menu).fillCraftSlotsStackedContents(this.stackedContents);
        String $$3 = this.searchBox != null ? this.searchBox.getValue() : "";
        this.searchBox = new EditBox(this.minecraft.font, $$1 + 25, $$2 + 13, 81, this.minecraft.font.lineHeight + 5, Component.translatable("itemGroup.search"));
        this.searchBox.setMaxLength(50);
        this.searchBox.setVisible(true);
        this.searchBox.setTextColor(-1);
        this.searchBox.setValue($$3);
        this.searchBox.setHint(SEARCH_HINT);
        this.magnifierIconPlacement = ScreenRectangle.of(ScreenAxis.HORIZONTAL, $$1 + 8, this.searchBox.getY(), this.searchBox.getX() - this.getXOrigin(), this.searchBox.getHeight());
        this.recipeBookPage.init(this.minecraft, $$1, $$2);
        this.filterButton = new StateSwitchingButton($$1 + 110, $$2 + 12, 26, 16, $$0);
        this.updateFilterButtonTooltip();
        this.initFilterButtonTextures();
        this.tabButtons.clear();
        for (TabInfo $$4 : this.tabInfos) {
            this.tabButtons.add(new RecipeBookTabButton($$4));
        }
        if (this.selectedTab != null) {
            this.selectedTab = this.tabButtons.stream().filter(p_380796_ -> p_380796_.getCategory().equals(this.selectedTab.getCategory())).findFirst().orElse(null);
        }
        if (this.selectedTab == null) {
            this.selectedTab = this.tabButtons.get(0);
        }
        this.selectedTab.setStateTriggered(true);
        this.selectMatchingRecipes();
        this.updateTabs($$0);
        this.updateCollections(false, $$0);
    }

    private int getYOrigin() {
        return (this.height - 166) / 2;
    }

    private int getXOrigin() {
        return (this.width - 147) / 2 - this.xOffset;
    }

    private void updateFilterButtonTooltip() {
        this.filterButton.setTooltip(this.filterButton.isStateTriggered() ? Tooltip.create(this.getRecipeFilterName()) : Tooltip.create(ALL_RECIPES_TOOLTIP));
    }

    protected abstract void initFilterButtonTextures();

    public int updateScreenPosition(int p_181402_, int p_181403_) {
        int $$3;
        if (this.isVisible() && !this.widthTooNarrow) {
            int $$2 = 177 + (p_181402_ - p_181403_ - 200) / 2;
        } else {
            $$3 = (p_181402_ - p_181403_) / 2;
        }
        return $$3;
    }

    public void toggleVisibility() {
        this.setVisible(!this.isVisible());
    }

    public boolean isVisible() {
        return this.visible;
    }

    private boolean isVisibleAccordingToBookData() {
        return this.book.isOpen(((RecipeBookMenu)this.menu).getRecipeBookType());
    }

    protected void setVisible(boolean p_100370_) {
        if (p_100370_) {
            this.initVisuals();
        }
        this.visible = p_100370_;
        this.book.setOpen(((RecipeBookMenu)this.menu).getRecipeBookType(), p_100370_);
        if (!p_100370_) {
            this.recipeBookPage.setInvisible();
        }
        this.sendUpdateSettings();
    }

    protected abstract boolean isCraftingSlot(Slot var1);

    public void slotClicked(@Nullable Slot p_100315_) {
        if (p_100315_ != null && this.isCraftingSlot(p_100315_)) {
            this.lastPlacedRecipe = null;
            this.ghostSlots.clear();
            if (this.isVisible()) {
                this.updateStackedContents();
            }
        }
    }

    private void selectMatchingRecipes() {
        for (TabInfo $$0 : this.tabInfos) {
            for (RecipeCollection $$1 : this.book.getCollection($$0.category())) {
                this.selectMatchingRecipes($$1, this.stackedContents);
            }
        }
    }

    protected abstract void selectMatchingRecipes(RecipeCollection var1, StackedItemContents var2);

    private void updateCollections(boolean p_100383_, boolean p_362917_) {
        ClientPacketListener $$5;
        List<RecipeCollection> $$2 = this.book.getCollection(this.selectedTab.getCategory());
        ArrayList $$3 = Lists.newArrayList($$2);
        $$3.removeIf(p_378795_ -> !p_378795_.hasAnySelected());
        String $$4 = this.searchBox.getValue();
        if (!$$4.isEmpty() && ($$5 = this.minecraft.getConnection()) != null) {
            ObjectLinkedOpenHashSet $$6 = new ObjectLinkedOpenHashSet($$5.searchTrees().recipes().search($$4.toLowerCase(Locale.ROOT)));
            $$3.removeIf(arg_0 -> RecipeBookComponent.lambda$updateCollections$3((ObjectSet)$$6, arg_0));
        }
        if (p_362917_) {
            $$3.removeIf(p_100331_ -> !p_100331_.hasCraftable());
        }
        this.recipeBookPage.updateCollections($$3, p_100383_, p_362917_);
    }

    private void updateTabs(boolean p_361255_) {
        int $$1 = (this.width - 147) / 2 - this.xOffset - 30;
        int $$2 = (this.height - 166) / 2 + 3;
        int $$3 = 27;
        int $$4 = 0;
        for (RecipeBookTabButton $$5 : this.tabButtons) {
            ExtendedRecipeBookCategory $$6 = $$5.getCategory();
            if ($$6 instanceof SearchRecipeBookCategory) {
                $$5.visible = true;
                $$5.setPosition($$1, $$2 + 27 * $$4++);
                continue;
            }
            if (!$$5.updateVisibility(this.book)) continue;
            $$5.setPosition($$1, $$2 + 27 * $$4++);
            $$5.startAnimation(this.book, p_361255_);
        }
    }

    public void tick() {
        boolean $$0 = this.isVisibleAccordingToBookData();
        if (this.isVisible() != $$0) {
            this.setVisible($$0);
        }
        if (!this.isVisible()) {
            return;
        }
        if (this.timesInventoryChanged != this.minecraft.player.getInventory().getTimesChanged()) {
            this.updateStackedContents();
            this.timesInventoryChanged = this.minecraft.player.getInventory().getTimesChanged();
        }
    }

    private void updateStackedContents() {
        this.stackedContents.clear();
        this.minecraft.player.getInventory().fillStackedContents(this.stackedContents);
        ((RecipeBookMenu)this.menu).fillCraftSlotsStackedContents(this.stackedContents);
        this.selectMatchingRecipes();
        this.updateCollections(false, this.isFiltering());
    }

    private boolean isFiltering() {
        return this.book.isFiltering(((RecipeBookMenu)this.menu).getRecipeBookType());
    }

    @Override
    public void render(GuiGraphics p_283597_, int p_282668_, int p_283506_, float p_282813_) {
        if (!this.isVisible()) {
            return;
        }
        if (!Screen.hasControlDown()) {
            this.time += p_282813_;
        }
        int $$4 = this.getXOrigin();
        int $$5 = this.getYOrigin();
        p_283597_.blit(RenderPipelines.GUI_TEXTURED, RECIPE_BOOK_LOCATION, $$4, $$5, 1.0f, 1.0f, 147, 166, 256, 256);
        this.searchBox.render(p_283597_, p_282668_, p_283506_, p_282813_);
        for (RecipeBookTabButton $$6 : this.tabButtons) {
            $$6.render(p_283597_, p_282668_, p_283506_, p_282813_);
        }
        this.filterButton.render(p_283597_, p_282668_, p_283506_, p_282813_);
        this.recipeBookPage.render(p_283597_, $$4, $$5, p_282668_, p_283506_, p_282813_);
    }

    public void renderTooltip(GuiGraphics p_281740_, int p_281520_, int p_282050_, @Nullable Slot p_362561_) {
        if (!this.isVisible()) {
            return;
        }
        this.recipeBookPage.renderTooltip(p_281740_, p_281520_, p_282050_);
        this.ghostSlots.renderTooltip(p_281740_, this.minecraft, p_281520_, p_282050_, p_362561_);
    }

    protected abstract Component getRecipeFilterName();

    public void renderGhostRecipe(GuiGraphics p_283634_, boolean p_283495_) {
        this.ghostSlots.render(p_283634_, this.minecraft, p_283495_);
    }

    @Override
    public boolean mouseClicked(double p_100294_, double p_100295_, int p_100296_) {
        if (!this.isVisible() || this.minecraft.player.isSpectator()) {
            return false;
        }
        if (this.recipeBookPage.mouseClicked(p_100294_, p_100295_, p_100296_, this.getXOrigin(), this.getYOrigin(), 147, 166)) {
            RecipeDisplayId $$3 = this.recipeBookPage.getLastClickedRecipe();
            RecipeCollection $$4 = this.recipeBookPage.getLastClickedRecipeCollection();
            if ($$3 != null && $$4 != null) {
                if (!this.tryPlaceRecipe($$4, $$3)) {
                    return false;
                }
                this.lastRecipeCollection = $$4;
                this.lastRecipe = $$3;
                if (!this.isOffsetNextToMainGUI()) {
                    this.setVisible(false);
                }
            }
            return true;
        }
        if (this.searchBox != null) {
            boolean $$5;
            boolean bl = $$5 = this.magnifierIconPlacement != null && this.magnifierIconPlacement.containsPoint(Mth.floor(p_100294_), Mth.floor(p_100295_));
            if ($$5 || this.searchBox.mouseClicked(p_100294_, p_100295_, p_100296_)) {
                this.searchBox.setFocused(true);
                return true;
            }
            this.searchBox.setFocused(false);
        }
        if (this.filterButton.mouseClicked(p_100294_, p_100295_, p_100296_)) {
            boolean $$6 = this.toggleFiltering();
            this.filterButton.setStateTriggered($$6);
            this.updateFilterButtonTooltip();
            this.sendUpdateSettings();
            this.updateCollections(false, $$6);
            return true;
        }
        for (RecipeBookTabButton $$7 : this.tabButtons) {
            if (!$$7.mouseClicked(p_100294_, p_100295_, p_100296_)) continue;
            if (this.selectedTab != $$7) {
                if (this.selectedTab != null) {
                    this.selectedTab.setStateTriggered(false);
                }
                this.selectedTab = $$7;
                this.selectedTab.setStateTriggered(true);
                this.updateCollections(true, this.isFiltering());
            }
            return true;
        }
        return false;
    }

    private boolean tryPlaceRecipe(RecipeCollection p_366703_, RecipeDisplayId p_380106_) {
        if (!p_366703_.isCraftable(p_380106_) && p_380106_.equals(this.lastPlacedRecipe)) {
            return false;
        }
        this.lastPlacedRecipe = p_380106_;
        this.ghostSlots.clear();
        this.minecraft.gameMode.handlePlaceRecipe(this.minecraft.player.containerMenu.containerId, p_380106_, Screen.hasShiftDown());
        return true;
    }

    private boolean toggleFiltering() {
        RecipeBookType $$0 = ((RecipeBookMenu)this.menu).getRecipeBookType();
        boolean $$1 = !this.book.isFiltering($$0);
        this.book.setFiltering($$0, $$1);
        return $$1;
    }

    public boolean hasClickedOutside(double p_100298_, double p_100299_, int p_100300_, int p_100301_, int p_100302_, int p_100303_, int p_100304_) {
        if (!this.isVisible()) {
            return true;
        }
        boolean $$7 = p_100298_ < (double)p_100300_ || p_100299_ < (double)p_100301_ || p_100298_ >= (double)(p_100300_ + p_100302_) || p_100299_ >= (double)(p_100301_ + p_100303_);
        boolean $$8 = (double)(p_100300_ - 147) < p_100298_ && p_100298_ < (double)p_100300_ && (double)p_100301_ < p_100299_ && p_100299_ < (double)(p_100301_ + p_100303_);
        return $$7 && !$$8 && !this.selectedTab.isHoveredOrFocused();
    }

    @Override
    public boolean keyPressed(int p_100306_, int p_100307_, int p_100308_) {
        this.ignoreTextInput = false;
        if (!this.isVisible() || this.minecraft.player.isSpectator()) {
            return false;
        }
        if (p_100306_ == 256 && !this.isOffsetNextToMainGUI()) {
            this.setVisible(false);
            return true;
        }
        if (this.searchBox.keyPressed(p_100306_, p_100307_, p_100308_)) {
            this.checkSearchStringUpdate();
            return true;
        }
        if (this.searchBox.isFocused() && this.searchBox.isVisible() && p_100306_ != 256) {
            return true;
        }
        if (this.minecraft.options.keyChat.matches(p_100306_, p_100307_) && !this.searchBox.isFocused()) {
            this.ignoreTextInput = true;
            this.searchBox.setFocused(true);
            return true;
        }
        if (CommonInputs.selected(p_100306_) && this.lastRecipeCollection != null && this.lastRecipe != null) {
            AbstractWidget.playButtonClickSound(Minecraft.getInstance().getSoundManager());
            return this.tryPlaceRecipe(this.lastRecipeCollection, this.lastRecipe);
        }
        return false;
    }

    @Override
    public boolean keyReleased(int p_100356_, int p_100357_, int p_100358_) {
        this.ignoreTextInput = false;
        return GuiEventListener.super.keyReleased(p_100356_, p_100357_, p_100358_);
    }

    @Override
    public boolean charTyped(char p_100291_, int p_100292_) {
        if (this.ignoreTextInput) {
            return false;
        }
        if (!this.isVisible() || this.minecraft.player.isSpectator()) {
            return false;
        }
        if (this.searchBox.charTyped(p_100291_, p_100292_)) {
            this.checkSearchStringUpdate();
            return true;
        }
        return GuiEventListener.super.charTyped(p_100291_, p_100292_);
    }

    @Override
    public boolean isMouseOver(double p_100353_, double p_100354_) {
        return false;
    }

    @Override
    public void setFocused(boolean p_265089_) {
    }

    @Override
    public boolean isFocused() {
        return false;
    }

    private void checkSearchStringUpdate() {
        String $$0 = this.searchBox.getValue().toLowerCase(Locale.ROOT);
        this.pirateSpeechForThePeople($$0);
        if (!$$0.equals(this.lastSearch)) {
            this.updateCollections(false, this.isFiltering());
            this.lastSearch = $$0;
        }
    }

    private void pirateSpeechForThePeople(String p_100336_) {
        if ("excitedze".equals(p_100336_)) {
            LanguageManager $$1 = this.minecraft.getLanguageManager();
            String $$2 = "en_pt";
            LanguageInfo $$3 = $$1.getLanguage("en_pt");
            if ($$3 == null || $$1.getSelected().equals("en_pt")) {
                return;
            }
            $$1.setSelected("en_pt");
            this.minecraft.options.languageCode = "en_pt";
            this.minecraft.reloadResourcePacks();
            this.minecraft.options.save();
        }
    }

    private boolean isOffsetNextToMainGUI() {
        return this.xOffset == 86;
    }

    public void recipesUpdated() {
        this.selectMatchingRecipes();
        this.updateTabs(this.isFiltering());
        if (this.isVisible()) {
            this.updateCollections(false, this.isFiltering());
        }
    }

    public void recipeShown(RecipeDisplayId p_379661_) {
        this.minecraft.player.removeRecipeHighlight(p_379661_);
    }

    public void fillGhostRecipe(RecipeDisplay p_379299_) {
        this.ghostSlots.clear();
        ContextMap $$1 = SlotDisplayContext.fromLevel(Objects.requireNonNull(this.minecraft.level));
        this.fillGhostRecipe(this.ghostSlots, p_379299_, $$1);
    }

    protected abstract void fillGhostRecipe(GhostSlots var1, RecipeDisplay var2, ContextMap var3);

    protected void sendUpdateSettings() {
        if (this.minecraft.getConnection() != null) {
            RecipeBookType $$0 = ((RecipeBookMenu)this.menu).getRecipeBookType();
            boolean $$1 = this.book.getBookSettings().isOpen($$0);
            boolean $$2 = this.book.getBookSettings().isFiltering($$0);
            this.minecraft.getConnection().send(new ServerboundRecipeBookChangeSettingsPacket($$0, $$1, $$2));
        }
    }

    @Override
    public NarratableEntry.NarrationPriority narrationPriority() {
        return this.visible ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE;
    }

    @Override
    public void updateNarration(NarrationElementOutput p_170046_) {
        ArrayList $$1 = Lists.newArrayList();
        this.recipeBookPage.listButtons(p_170049_ -> {
            if (p_170049_.isActive()) {
                $$1.add(p_170049_);
            }
        });
        $$1.add(this.searchBox);
        $$1.add(this.filterButton);
        $$1.addAll(this.tabButtons);
        Screen.NarratableSearchResult $$2 = Screen.findNarratableWidget($$1, null);
        if ($$2 != null) {
            $$2.entry.updateNarration(p_170046_.nest());
        }
    }

    private static /* synthetic */ boolean lambda$updateCollections$3(ObjectSet p_302147_, RecipeCollection p_302148_) {
        return !p_302147_.contains((Object)p_302148_);
    }

    public record TabInfo(ItemStack primaryIcon, Optional<ItemStack> secondaryIcon, ExtendedRecipeBookCategory category) {
        public TabInfo(SearchRecipeBookCategory p_380261_) {
            this(new ItemStack(Items.COMPASS), Optional.empty(), p_380261_);
        }

        public TabInfo(Item p_379892_, RecipeBookCategory p_381074_) {
            this(new ItemStack(p_379892_), Optional.empty(), (ExtendedRecipeBookCategory)p_381074_);
        }

        public TabInfo(Item p_380069_, Item p_381165_, RecipeBookCategory p_381126_) {
            this(new ItemStack(p_380069_), Optional.of(new ItemStack(p_381165_)), (ExtendedRecipeBookCategory)p_381126_);
        }
    }
}

