/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.recipebook;

import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.recipebook.SlotSelectTime;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.display.SlotDisplay;

public class GhostSlots {
    private final Reference2ObjectMap<Slot, GhostSlot> ingredients = new Reference2ObjectArrayMap();
    private final SlotSelectTime slotSelectTime;

    public GhostSlots(SlotSelectTime p_361863_) {
        this.slotSelectTime = p_361863_;
    }

    public void clear() {
        this.ingredients.clear();
    }

    private void setSlot(Slot p_380315_, ContextMap p_380942_, SlotDisplay p_379948_, boolean p_379880_) {
        List<ItemStack> $$4 = p_379948_.resolveForStacks(p_380942_);
        if (!$$4.isEmpty()) {
            this.ingredients.put((Object)p_380315_, (Object)new GhostSlot($$4, p_379880_));
        }
    }

    protected void setInput(Slot p_379329_, ContextMap p_381026_, SlotDisplay p_379367_) {
        this.setSlot(p_379329_, p_381026_, p_379367_, false);
    }

    protected void setResult(Slot p_379733_, ContextMap p_381037_, SlotDisplay p_380406_) {
        this.setSlot(p_379733_, p_381037_, p_380406_, true);
    }

    public void render(GuiGraphics p_360912_, Minecraft p_363356_, boolean p_361600_) {
        this.ingredients.forEach((p_421286_, p_421287_) -> {
            int $$5 = p_421286_.x;
            int $$6 = p_421286_.y;
            if (p_421287_.isResultSlot && p_361600_) {
                p_360912_.fill($$5 - 4, $$6 - 4, $$5 + 20, $$6 + 20, 0x30FF0000);
            } else {
                p_360912_.fill($$5, $$6, $$5 + 16, $$6 + 16, 0x30FF0000);
            }
            ItemStack $$7 = p_421287_.getItem(this.slotSelectTime.currentIndex());
            p_360912_.renderFakeItem($$7, $$5, $$6);
            p_360912_.fill($$5, $$6, $$5 + 16, $$6 + 16, 0x30FFFFFF);
            if (p_421287_.isResultSlot) {
                p_360912_.renderItemDecorations(p_421285_.font, $$7, $$5, $$6);
            }
        });
    }

    public void renderTooltip(GuiGraphics p_363721_, Minecraft p_365392_, int p_363797_, int p_363310_, @Nullable Slot p_360907_) {
        if (p_360907_ == null) {
            return;
        }
        GhostSlot $$5 = (GhostSlot)this.ingredients.get((Object)p_360907_);
        if ($$5 != null) {
            ItemStack $$6 = $$5.getItem(this.slotSelectTime.currentIndex());
            p_363721_.setComponentTooltipForNextFrame(p_365392_.font, Screen.getTooltipFromItem(p_365392_, $$6), p_363797_, p_363310_, $$6.get(DataComponents.TOOLTIP_STYLE));
        }
    }

    record GhostSlot(List<ItemStack> items, boolean isResultSlot) {
        public ItemStack getItem(int p_361727_) {
            int $$1 = this.items.size();
            if ($$1 == 0) {
                return ItemStack.EMPTY;
            }
            return this.items.get(p_361727_ % $$1);
        }
    }
}

