/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.recipebook;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.recipebook.GhostSlots;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.gui.screens.recipebook.SearchRecipeBookCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.recipebook.PlaceRecipeHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AbstractCraftingMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;

public class CraftingRecipeBookComponent
extends RecipeBookComponent<AbstractCraftingMenu> {
    private static final WidgetSprites FILTER_BUTTON_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace("recipe_book/filter_enabled"), ResourceLocation.withDefaultNamespace("recipe_book/filter_disabled"), ResourceLocation.withDefaultNamespace("recipe_book/filter_enabled_highlighted"), ResourceLocation.withDefaultNamespace("recipe_book/filter_disabled_highlighted"));
    private static final Component ONLY_CRAFTABLES_TOOLTIP = Component.translatable("gui.recipebook.toggleRecipes.craftable");
    private static final List<RecipeBookComponent.TabInfo> TABS = List.of(new RecipeBookComponent.TabInfo(SearchRecipeBookCategory.CRAFTING), new RecipeBookComponent.TabInfo(Items.IRON_AXE, Items.GOLDEN_SWORD, RecipeBookCategories.CRAFTING_EQUIPMENT), new RecipeBookComponent.TabInfo(Items.BRICKS, RecipeBookCategories.CRAFTING_BUILDING_BLOCKS), new RecipeBookComponent.TabInfo(Items.LAVA_BUCKET, Items.APPLE, RecipeBookCategories.CRAFTING_MISC), new RecipeBookComponent.TabInfo(Items.REDSTONE, RecipeBookCategories.CRAFTING_REDSTONE));

    public CraftingRecipeBookComponent(AbstractCraftingMenu p_362638_) {
        super(p_362638_, TABS);
    }

    @Override
    protected boolean isCraftingSlot(Slot p_364400_) {
        return ((AbstractCraftingMenu)this.menu).getResultSlot() == p_364400_ || ((AbstractCraftingMenu)this.menu).getInputGridSlots().contains(p_364400_);
    }

    private boolean canDisplay(RecipeDisplay p_379470_) {
        int $$1 = ((AbstractCraftingMenu)this.menu).getGridWidth();
        int $$2 = ((AbstractCraftingMenu)this.menu).getGridHeight();
        RecipeDisplay recipeDisplay = p_379470_;
        Objects.requireNonNull(recipeDisplay);
        RecipeDisplay recipeDisplay2 = recipeDisplay;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ShapedCraftingRecipeDisplay.class, ShapelessCraftingRecipeDisplay.class}, (Object)recipeDisplay2, n)) {
            case 0 -> {
                ShapedCraftingRecipeDisplay $$3 = (ShapedCraftingRecipeDisplay)recipeDisplay2;
                if ($$1 >= $$3.width() && $$2 >= $$3.height()) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                ShapelessCraftingRecipeDisplay $$4 = (ShapelessCraftingRecipeDisplay)recipeDisplay2;
                if ($$1 * $$2 >= $$4.ingredients().size()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    protected void fillGhostRecipe(GhostSlots p_379930_, RecipeDisplay p_379870_, ContextMap p_380956_) {
        p_379930_.setResult(((AbstractCraftingMenu)this.menu).getResultSlot(), p_380956_, p_379870_.result());
        RecipeDisplay recipeDisplay = p_379870_;
        Objects.requireNonNull(recipeDisplay);
        RecipeDisplay recipeDisplay2 = recipeDisplay;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ShapedCraftingRecipeDisplay.class, ShapelessCraftingRecipeDisplay.class}, (Object)recipeDisplay2, n)) {
            case 0: {
                ShapedCraftingRecipeDisplay $$3 = (ShapedCraftingRecipeDisplay)recipeDisplay2;
                List<Slot> $$4 = ((AbstractCraftingMenu)this.menu).getInputGridSlots();
                PlaceRecipeHelper.placeRecipe(((AbstractCraftingMenu)this.menu).getGridWidth(), ((AbstractCraftingMenu)this.menu).getGridHeight(), $$3.width(), $$3.height(), $$3.ingredients(), (p_380786_, p_380787_, p_380788_, p_380789_) -> {
                    Slot $$7 = (Slot)$$4.get(p_380787_);
                    p_379930_.setInput($$7, p_380956_, (SlotDisplay)p_380786_);
                });
                break;
            }
            case 1: {
                ShapelessCraftingRecipeDisplay $$5 = (ShapelessCraftingRecipeDisplay)recipeDisplay2;
                List<Slot> $$6 = ((AbstractCraftingMenu)this.menu).getInputGridSlots();
                int $$7 = Math.min($$5.ingredients().size(), $$6.size());
                for (int $$8 = 0; $$8 < $$7; ++$$8) {
                    p_379930_.setInput($$6.get($$8), p_380956_, $$5.ingredients().get($$8));
                }
                break;
            }
        }
    }

    @Override
    protected void initFilterButtonTextures() {
        this.filterButton.initTextureValues(FILTER_BUTTON_SPRITES);
    }

    @Override
    protected Component getRecipeFilterName() {
        return ONLY_CRAFTABLES_TOOLTIP;
    }

    @Override
    protected void selectMatchingRecipes(RecipeCollection p_363827_, StackedItemContents p_362085_) {
        p_363827_.selectRecipes(p_362085_, this::canDisplay);
    }
}

