/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.inventory;

import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;

public class EffectsInInventory {
    private static final ResourceLocation EFFECT_BACKGROUND_LARGE_SPRITE = ResourceLocation.withDefaultNamespace("container/inventory/effect_background_large");
    private static final ResourceLocation EFFECT_BACKGROUND_SMALL_SPRITE = ResourceLocation.withDefaultNamespace("container/inventory/effect_background_small");
    private final AbstractContainerScreen<?> screen;
    private final Minecraft minecraft;
    @Nullable
    private MobEffectInstance hoveredEffect;

    public EffectsInInventory(AbstractContainerScreen<?> p_376708_) {
        this.screen = p_376708_;
        this.minecraft = Minecraft.getInstance();
    }

    public boolean canSeeEffects() {
        int $$0 = this.screen.leftPos + this.screen.imageWidth + 2;
        int $$1 = this.screen.width - $$0;
        return $$1 >= 32;
    }

    public void renderEffects(GuiGraphics p_376884_, int p_376869_, int p_376740_) {
        this.hoveredEffect = null;
        int $$3 = this.screen.leftPos + this.screen.imageWidth + 2;
        int $$4 = this.screen.width - $$3;
        Collection<MobEffectInstance> $$5 = this.minecraft.player.getActiveEffects();
        if ($$5.isEmpty() || $$4 < 32) {
            return;
        }
        boolean $$6 = $$4 >= 120;
        int $$7 = 33;
        if ($$5.size() > 5) {
            $$7 = 132 / ($$5.size() - 1);
        }
        List $$8 = Ordering.natural().sortedCopy($$5);
        this.renderBackgrounds(p_376884_, $$3, $$7, $$8, $$6);
        this.renderIcons(p_376884_, $$3, $$7, $$8, $$6);
        if ($$6) {
            this.renderLabels(p_376884_, $$3, $$7, $$8);
        } else if (p_376869_ >= $$3 && p_376869_ <= $$3 + 33) {
            int $$9 = this.screen.topPos;
            for (MobEffectInstance $$10 : $$8) {
                if (p_376740_ >= $$9 && p_376740_ <= $$9 + $$7) {
                    this.hoveredEffect = $$10;
                }
                $$9 += $$7;
            }
        }
    }

    public void renderTooltip(GuiGraphics p_418320_, int p_418474_, int p_418496_) {
        if (this.hoveredEffect != null) {
            List<Component> $$3 = List.of(this.getEffectName(this.hoveredEffect), MobEffectUtil.formatDuration(this.hoveredEffect, 1.0f, this.minecraft.level.tickRateManager().tickrate()));
            p_418320_.setTooltipForNextFrame(this.screen.getFont(), $$3, Optional.empty(), p_418474_, p_418496_);
        }
    }

    private void renderBackgrounds(GuiGraphics p_376873_, int p_376485_, int p_376217_, Iterable<MobEffectInstance> p_376444_, boolean p_376129_) {
        int $$5 = this.screen.topPos;
        for (MobEffectInstance $$6 : p_376444_) {
            if (p_376129_) {
                p_376873_.blitSprite(RenderPipelines.GUI_TEXTURED, EFFECT_BACKGROUND_LARGE_SPRITE, p_376485_, $$5, 120, 32);
            } else {
                p_376873_.blitSprite(RenderPipelines.GUI_TEXTURED, EFFECT_BACKGROUND_SMALL_SPRITE, p_376485_, $$5, 32, 32);
            }
            $$5 += p_376217_;
        }
    }

    private void renderIcons(GuiGraphics p_376734_, int p_376350_, int p_376678_, Iterable<MobEffectInstance> p_376215_, boolean p_376312_) {
        int $$5 = this.screen.topPos;
        for (MobEffectInstance $$6 : p_376215_) {
            Holder<MobEffect> $$7 = $$6.getEffect();
            ResourceLocation $$8 = Gui.getMobEffectSprite($$7);
            p_376734_.blitSprite(RenderPipelines.GUI_TEXTURED, $$8, p_376350_ + (p_376312_ ? 6 : 7), $$5 + 7, 18, 18);
            $$5 += p_376678_;
        }
    }

    private void renderLabels(GuiGraphics p_376227_, int p_376372_, int p_376395_, Iterable<MobEffectInstance> p_376910_) {
        int $$4 = this.screen.topPos;
        for (MobEffectInstance $$5 : p_376910_) {
            Component $$6 = this.getEffectName($$5);
            p_376227_.drawString(this.screen.getFont(), $$6, p_376372_ + 10 + 18, $$4 + 6, -1);
            Component $$7 = MobEffectUtil.formatDuration($$5, 1.0f, this.minecraft.level.tickRateManager().tickrate());
            p_376227_.drawString(this.screen.getFont(), $$7, p_376372_ + 10 + 18, $$4 + 6 + 10, -8421505);
            $$4 += p_376395_;
        }
    }

    private Component getEffectName(MobEffectInstance p_376252_) {
        MutableComponent $$1 = p_376252_.getEffect().value().getDisplayName().copy();
        if (p_376252_.getAmplifier() >= 1 && p_376252_.getAmplifier() <= 9) {
            $$1.append(CommonComponents.SPACE).append(Component.translatable("enchantment.level." + (p_376252_.getAmplifier() + 1)));
        }
        return $$1;
    }
}

