/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.inventory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.HotbarManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeInventoryListener;
import net.minecraft.client.gui.screens.inventory.EffectsInInventory;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.SessionSearchTrees;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.inventory.Hotbar;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.searchtree.SearchTree;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;

public class CreativeModeInventoryScreen
extends AbstractContainerScreen<ItemPickerMenu> {
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace("container/creative_inventory/scroller");
    private static final ResourceLocation SCROLLER_DISABLED_SPRITE = ResourceLocation.withDefaultNamespace("container/creative_inventory/scroller_disabled");
    private static final ResourceLocation[] UNSELECTED_TOP_TABS = new ResourceLocation[]{ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_top_unselected_1"), ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_top_unselected_2"), ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_top_unselected_3"), ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_top_unselected_4"), ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_top_unselected_5"), ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_top_unselected_6"), ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_top_unselected_7")};
    private static final ResourceLocation[] SELECTED_TOP_TABS = new ResourceLocation[]{ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_top_selected_1"), ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_top_selected_2"), ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_top_selected_3"), ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_top_selected_4"), ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_top_selected_5"), ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_top_selected_6"), ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_top_selected_7")};
    private static final ResourceLocation[] UNSELECTED_BOTTOM_TABS = new ResourceLocation[]{ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_bottom_unselected_1"), ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_bottom_unselected_2"), ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_bottom_unselected_3"), ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_bottom_unselected_4"), ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_bottom_unselected_5"), ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_bottom_unselected_6"), ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_bottom_unselected_7")};
    private static final ResourceLocation[] SELECTED_BOTTOM_TABS = new ResourceLocation[]{ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_bottom_selected_1"), ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_bottom_selected_2"), ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_bottom_selected_3"), ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_bottom_selected_4"), ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_bottom_selected_5"), ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_bottom_selected_6"), ResourceLocation.withDefaultNamespace("container/creative_inventory/tab_bottom_selected_7")};
    private static final int NUM_ROWS = 5;
    private static final int NUM_COLS = 9;
    private static final int TAB_WIDTH = 26;
    private static final int TAB_HEIGHT = 32;
    private static final int SCROLLER_WIDTH = 12;
    private static final int SCROLLER_HEIGHT = 15;
    static final SimpleContainer CONTAINER = new SimpleContainer(45);
    private static final Component TRASH_SLOT_TOOLTIP = Component.translatable("inventory.binSlot");
    private static CreativeModeTab selectedTab = CreativeModeTabs.getDefaultTab();
    private float scrollOffs;
    private boolean scrolling;
    private EditBox searchBox;
    @Nullable
    private List<Slot> originalSlots;
    @Nullable
    private Slot destroyItemSlot;
    private CreativeInventoryListener listener;
    private boolean ignoreTextInput;
    private boolean hasClickedOutside;
    private final Set<TagKey<Item>> visibleTags = new HashSet<TagKey<Item>>();
    private final boolean displayOperatorCreativeTab;
    private final EffectsInInventory effects;

    public CreativeModeInventoryScreen(LocalPlayer p_346290_, FeatureFlagSet p_260074_, boolean p_259569_) {
        super(new ItemPickerMenu(p_346290_), p_346290_.getInventory(), CommonComponents.EMPTY);
        p_346290_.containerMenu = this.menu;
        this.imageHeight = 136;
        this.imageWidth = 195;
        this.displayOperatorCreativeTab = p_259569_;
        this.tryRebuildTabContents(p_346290_.connection.searchTrees(), p_260074_, this.hasPermissions(p_346290_), p_346290_.level().registryAccess());
        this.effects = new EffectsInInventory(this);
    }

    private boolean hasPermissions(Player p_259959_) {
        return p_259959_.canUseGameMasterBlocks() && this.displayOperatorCreativeTab;
    }

    private void tryRefreshInvalidatedTabs(FeatureFlagSet p_259501_, boolean p_259713_, HolderLookup.Provider p_270898_) {
        ClientPacketListener $$3 = this.minecraft.getConnection();
        if (this.tryRebuildTabContents($$3 != null ? $$3.searchTrees() : null, p_259501_, p_259713_, p_270898_)) {
            for (CreativeModeTab $$4 : CreativeModeTabs.allTabs()) {
                Collection<ItemStack> $$5 = $$4.getDisplayItems();
                if ($$4 != selectedTab) continue;
                if ($$4.getType() == CreativeModeTab.Type.CATEGORY && $$5.isEmpty()) {
                    this.selectTab(CreativeModeTabs.getDefaultTab());
                    continue;
                }
                this.refreshCurrentTabContents($$5);
            }
        }
    }

    private boolean tryRebuildTabContents(@Nullable SessionSearchTrees p_345591_, FeatureFlagSet p_345904_, boolean p_345731_, HolderLookup.Provider p_344784_) {
        if (!CreativeModeTabs.tryRebuildTabContents(p_345904_, p_345731_, p_344784_)) {
            return false;
        }
        if (p_345591_ != null) {
            List<ItemStack> $$4 = List.copyOf(CreativeModeTabs.searchTab().getDisplayItems());
            p_345591_.updateCreativeTooltips(p_344784_, $$4);
            p_345591_.updateCreativeTags($$4);
        }
        return true;
    }

    private void refreshCurrentTabContents(Collection<ItemStack> p_261591_) {
        int $$1 = ((ItemPickerMenu)this.menu).getRowIndexForScroll(this.scrollOffs);
        ((ItemPickerMenu)this.menu).items.clear();
        if (selectedTab.getType() == CreativeModeTab.Type.SEARCH) {
            this.refreshSearchResults();
        } else {
            ((ItemPickerMenu)this.menu).items.addAll(p_261591_);
        }
        this.scrollOffs = ((ItemPickerMenu)this.menu).getScrollForRowIndex($$1);
        ((ItemPickerMenu)this.menu).scrollTo(this.scrollOffs);
    }

    @Override
    public void containerTick() {
        super.containerTick();
        if (this.minecraft == null) {
            return;
        }
        LocalPlayer $$0 = this.minecraft.player;
        if ($$0 != null) {
            this.tryRefreshInvalidatedTabs($$0.connection.enabledFeatures(), this.hasPermissions($$0), $$0.level().registryAccess());
            if (!$$0.hasInfiniteMaterials()) {
                this.minecraft.setScreen(new InventoryScreen($$0));
            }
        }
    }

    @Override
    protected void slotClicked(@Nullable Slot p_98556_, int p_98557_, int p_98558_, ClickType p_98559_) {
        if (this.isCreativeSlot(p_98556_)) {
            this.searchBox.moveCursorToEnd(false);
            this.searchBox.setHighlightPos(0);
        }
        boolean $$4 = p_98559_ == ClickType.QUICK_MOVE;
        ClickType clickType = p_98559_ = p_98557_ == -999 && p_98559_ == ClickType.PICKUP ? ClickType.THROW : p_98559_;
        if (p_98559_ == ClickType.THROW && !this.minecraft.player.canDropItems()) {
            return;
        }
        this.onMouseClickAction(p_98556_, p_98559_);
        if (p_98556_ != null || selectedTab.getType() == CreativeModeTab.Type.INVENTORY || p_98559_ == ClickType.QUICK_CRAFT) {
            if (p_98556_ != null && !p_98556_.mayPickup(this.minecraft.player)) {
                return;
            }
            if (p_98556_ == this.destroyItemSlot && $$4) {
                for (int $$5 = 0; $$5 < this.minecraft.player.inventoryMenu.getItems().size(); ++$$5) {
                    this.minecraft.player.inventoryMenu.getSlot($$5).set(ItemStack.EMPTY);
                    this.minecraft.gameMode.handleCreativeModeItemAdd(ItemStack.EMPTY, $$5);
                }
            } else if (selectedTab.getType() == CreativeModeTab.Type.INVENTORY) {
                if (p_98556_ == this.destroyItemSlot) {
                    ((ItemPickerMenu)this.menu).setCarried(ItemStack.EMPTY);
                } else if (p_98559_ == ClickType.THROW && p_98556_ != null && p_98556_.hasItem()) {
                    ItemStack $$6 = p_98556_.remove(p_98558_ == 0 ? 1 : p_98556_.getItem().getMaxStackSize());
                    ItemStack $$7 = p_98556_.getItem();
                    this.minecraft.player.drop($$6, true);
                    this.minecraft.gameMode.handleCreativeModeItemDrop($$6);
                    this.minecraft.gameMode.handleCreativeModeItemAdd($$7, ((SlotWrapper)p_98556_).target.index);
                } else if (p_98559_ == ClickType.THROW && p_98557_ == -999 && !((ItemPickerMenu)this.menu).getCarried().isEmpty()) {
                    this.minecraft.player.drop(((ItemPickerMenu)this.menu).getCarried(), true);
                    this.minecraft.gameMode.handleCreativeModeItemDrop(((ItemPickerMenu)this.menu).getCarried());
                    ((ItemPickerMenu)this.menu).setCarried(ItemStack.EMPTY);
                } else {
                    this.minecraft.player.inventoryMenu.clicked(p_98556_ == null ? p_98557_ : ((SlotWrapper)p_98556_).target.index, p_98558_, p_98559_, this.minecraft.player);
                    this.minecraft.player.inventoryMenu.broadcastChanges();
                }
            } else if (p_98559_ != ClickType.QUICK_CRAFT && p_98556_.container == CONTAINER) {
                ItemStack $$8 = ((ItemPickerMenu)this.menu).getCarried();
                ItemStack $$9 = p_98556_.getItem();
                if (p_98559_ == ClickType.SWAP) {
                    if (!$$9.isEmpty()) {
                        this.minecraft.player.getInventory().setItem(p_98558_, $$9.copyWithCount($$9.getMaxStackSize()));
                        this.minecraft.player.inventoryMenu.broadcastChanges();
                    }
                    return;
                }
                if (p_98559_ == ClickType.CLONE) {
                    if (((ItemPickerMenu)this.menu).getCarried().isEmpty() && p_98556_.hasItem()) {
                        ItemStack $$10 = p_98556_.getItem();
                        ((ItemPickerMenu)this.menu).setCarried($$10.copyWithCount($$10.getMaxStackSize()));
                    }
                    return;
                }
                if (p_98559_ == ClickType.THROW) {
                    if (!$$9.isEmpty()) {
                        ItemStack $$11 = $$9.copyWithCount(p_98558_ == 0 ? 1 : $$9.getMaxStackSize());
                        this.minecraft.player.drop($$11, true);
                        this.minecraft.gameMode.handleCreativeModeItemDrop($$11);
                    }
                    return;
                }
                if (!$$8.isEmpty() && !$$9.isEmpty() && ItemStack.isSameItemSameComponents($$8, $$9)) {
                    if (p_98558_ == 0) {
                        if ($$4) {
                            $$8.setCount($$8.getMaxStackSize());
                        } else if ($$8.getCount() < $$8.getMaxStackSize()) {
                            $$8.grow(1);
                        }
                    } else {
                        $$8.shrink(1);
                    }
                } else if ($$9.isEmpty() || !$$8.isEmpty()) {
                    if (p_98558_ == 0) {
                        ((ItemPickerMenu)this.menu).setCarried(ItemStack.EMPTY);
                    } else if (!((ItemPickerMenu)this.menu).getCarried().isEmpty()) {
                        ((ItemPickerMenu)this.menu).getCarried().shrink(1);
                    }
                } else {
                    int $$12 = $$4 ? $$9.getMaxStackSize() : $$9.getCount();
                    ((ItemPickerMenu)this.menu).setCarried($$9.copyWithCount($$12));
                }
            } else if (this.menu != null) {
                ItemStack $$13 = p_98556_ == null ? ItemStack.EMPTY : ((ItemPickerMenu)this.menu).getSlot(p_98556_.index).getItem();
                ((ItemPickerMenu)this.menu).clicked(p_98556_ == null ? p_98557_ : p_98556_.index, p_98558_, p_98559_, this.minecraft.player);
                if (AbstractContainerMenu.getQuickcraftHeader(p_98558_) == 2) {
                    for (int $$14 = 0; $$14 < 9; ++$$14) {
                        this.minecraft.gameMode.handleCreativeModeItemAdd(((ItemPickerMenu)this.menu).getSlot(45 + $$14).getItem(), 36 + $$14);
                    }
                } else if (p_98556_ != null && Inventory.isHotbarSlot(p_98556_.getContainerSlot()) && selectedTab.getType() != CreativeModeTab.Type.INVENTORY) {
                    if (p_98559_ == ClickType.THROW && !$$13.isEmpty() && !((ItemPickerMenu)this.menu).getCarried().isEmpty()) {
                        int $$15 = p_98558_ == 0 ? 1 : $$13.getCount();
                        ItemStack $$16 = $$13.copyWithCount($$15);
                        $$13.shrink($$15);
                        this.minecraft.player.drop($$16, true);
                        this.minecraft.gameMode.handleCreativeModeItemDrop($$16);
                    }
                    this.minecraft.player.inventoryMenu.broadcastChanges();
                }
            }
        } else if (!((ItemPickerMenu)this.menu).getCarried().isEmpty() && this.hasClickedOutside) {
            if (!this.minecraft.player.canDropItems()) {
                return;
            }
            if (p_98558_ == 0) {
                this.minecraft.player.drop(((ItemPickerMenu)this.menu).getCarried(), true);
                this.minecraft.gameMode.handleCreativeModeItemDrop(((ItemPickerMenu)this.menu).getCarried());
                ((ItemPickerMenu)this.menu).setCarried(ItemStack.EMPTY);
            }
            if (p_98558_ == 1) {
                ItemStack $$17 = ((ItemPickerMenu)this.menu).getCarried().split(1);
                this.minecraft.player.drop($$17, true);
                this.minecraft.gameMode.handleCreativeModeItemDrop($$17);
            }
        }
    }

    private boolean isCreativeSlot(@Nullable Slot p_98554_) {
        return p_98554_ != null && p_98554_.container == CONTAINER;
    }

    @Override
    protected void init() {
        if (this.minecraft.player.hasInfiniteMaterials()) {
            super.init();
            this.searchBox = new EditBox(this.font, this.leftPos + 82, this.topPos + 6, 80, this.font.lineHeight, Component.translatable("itemGroup.search"));
            this.searchBox.setMaxLength(50);
            this.searchBox.setBordered(false);
            this.searchBox.setVisible(false);
            this.searchBox.setTextColor(-1);
            this.addWidget(this.searchBox);
            CreativeModeTab $$0 = selectedTab;
            selectedTab = CreativeModeTabs.getDefaultTab();
            this.selectTab($$0);
            this.minecraft.player.inventoryMenu.removeSlotListener(this.listener);
            this.listener = new CreativeInventoryListener(this.minecraft);
            this.minecraft.player.inventoryMenu.addSlotListener(this.listener);
            if (!selectedTab.shouldDisplay()) {
                this.selectTab(CreativeModeTabs.getDefaultTab());
            }
        } else {
            this.minecraft.setScreen(new InventoryScreen(this.minecraft.player));
        }
    }

    @Override
    public void resize(Minecraft p_98595_, int p_98596_, int p_98597_) {
        int $$3 = ((ItemPickerMenu)this.menu).getRowIndexForScroll(this.scrollOffs);
        String $$4 = this.searchBox.getValue();
        this.init(p_98595_, p_98596_, p_98597_);
        this.searchBox.setValue($$4);
        if (!this.searchBox.getValue().isEmpty()) {
            this.refreshSearchResults();
        }
        this.scrollOffs = ((ItemPickerMenu)this.menu).getScrollForRowIndex($$3);
        ((ItemPickerMenu)this.menu).scrollTo(this.scrollOffs);
    }

    @Override
    public void removed() {
        super.removed();
        if (this.minecraft.player != null && this.minecraft.player.getInventory() != null) {
            this.minecraft.player.inventoryMenu.removeSlotListener(this.listener);
        }
    }

    @Override
    public boolean charTyped(char p_98521_, int p_98522_) {
        if (this.ignoreTextInput) {
            return false;
        }
        if (selectedTab.getType() != CreativeModeTab.Type.SEARCH) {
            return false;
        }
        String $$2 = this.searchBox.getValue();
        if (this.searchBox.charTyped(p_98521_, p_98522_)) {
            if (!Objects.equals($$2, this.searchBox.getValue())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int p_98547_, int p_98548_, int p_98549_) {
        this.ignoreTextInput = false;
        if (selectedTab.getType() != CreativeModeTab.Type.SEARCH) {
            if (this.minecraft.options.keyChat.matches(p_98547_, p_98548_)) {
                this.ignoreTextInput = true;
                this.selectTab(CreativeModeTabs.searchTab());
                return true;
            }
            return super.keyPressed(p_98547_, p_98548_, p_98549_);
        }
        boolean $$3 = !this.isCreativeSlot(this.hoveredSlot) || this.hoveredSlot.hasItem();
        boolean $$4 = InputConstants.getKey(p_98547_, p_98548_).getNumericKeyValue().isPresent();
        if ($$3 && $$4 && this.checkHotbarKeyPressed(p_98547_, p_98548_)) {
            this.ignoreTextInput = true;
            return true;
        }
        String $$5 = this.searchBox.getValue();
        if (this.searchBox.keyPressed(p_98547_, p_98548_, p_98549_)) {
            if (!Objects.equals($$5, this.searchBox.getValue())) {
                this.refreshSearchResults();
            }
            return true;
        }
        if (this.searchBox.isFocused() && this.searchBox.isVisible() && p_98547_ != 256) {
            return true;
        }
        return super.keyPressed(p_98547_, p_98548_, p_98549_);
    }

    @Override
    public boolean keyReleased(int p_98612_, int p_98613_, int p_98614_) {
        this.ignoreTextInput = false;
        return super.keyReleased(p_98612_, p_98613_, p_98614_);
    }

    private void refreshSearchResults() {
        ((ItemPickerMenu)this.menu).items.clear();
        this.visibleTags.clear();
        String $$0 = this.searchBox.getValue();
        if ($$0.isEmpty()) {
            ((ItemPickerMenu)this.menu).items.addAll(selectedTab.getDisplayItems());
        } else {
            ClientPacketListener $$1 = this.minecraft.getConnection();
            if ($$1 != null) {
                SearchTree<ItemStack> $$4;
                SessionSearchTrees $$2 = $$1.searchTrees();
                if ($$0.startsWith("#")) {
                    $$0 = $$0.substring(1);
                    SearchTree<ItemStack> $$3 = $$2.creativeTagSearch();
                    this.updateVisibleTags($$0);
                } else {
                    $$4 = $$2.creativeNameSearch();
                }
                ((ItemPickerMenu)this.menu).items.addAll($$4.search($$0.toLowerCase(Locale.ROOT)));
            }
        }
        this.scrollOffs = 0.0f;
        ((ItemPickerMenu)this.menu).scrollTo(0.0f);
    }

    private void updateVisibleTags(String p_98620_) {
        Predicate<ResourceLocation> $$5;
        int $$1 = p_98620_.indexOf(58);
        if ($$1 == -1) {
            Predicate<ResourceLocation> $$2 = p_98609_ -> p_98609_.getPath().contains(p_98620_);
        } else {
            String $$3 = p_98620_.substring(0, $$1).trim();
            String $$4 = p_98620_.substring($$1 + 1).trim();
            $$5 = p_98606_ -> p_98606_.getNamespace().contains($$3) && p_98606_.getPath().contains($$4);
        }
        BuiltInRegistries.ITEM.getTags().map(HolderSet.Named::key).filter(p_205410_ -> $$5.test(p_205410_.location())).forEach(this.visibleTags::add);
    }

    @Override
    protected void renderLabels(GuiGraphics p_283168_, int p_281774_, int p_281466_) {
        if (selectedTab.showTitle()) {
            p_283168_.drawString(this.font, selectedTab.getDisplayName(), 8, 6, -12566464, false);
        }
    }

    @Override
    public boolean mouseClicked(double p_98531_, double p_98532_, int p_98533_) {
        if (p_98533_ == 0) {
            double $$3 = p_98531_ - (double)this.leftPos;
            double $$4 = p_98532_ - (double)this.topPos;
            for (CreativeModeTab $$5 : CreativeModeTabs.tabs()) {
                if (!this.checkTabClicked($$5, $$3, $$4)) continue;
                return true;
            }
            if (selectedTab.getType() != CreativeModeTab.Type.INVENTORY && this.insideScrollbar(p_98531_, p_98532_)) {
                this.scrolling = this.canScroll();
                return true;
            }
        }
        return super.mouseClicked(p_98531_, p_98532_, p_98533_);
    }

    @Override
    public boolean mouseReleased(double p_98622_, double p_98623_, int p_98624_) {
        if (p_98624_ == 0) {
            double $$3 = p_98622_ - (double)this.leftPos;
            double $$4 = p_98623_ - (double)this.topPos;
            this.scrolling = false;
            for (CreativeModeTab $$5 : CreativeModeTabs.tabs()) {
                if (!this.checkTabClicked($$5, $$3, $$4)) continue;
                this.selectTab($$5);
                return true;
            }
        }
        return super.mouseReleased(p_98622_, p_98623_, p_98624_);
    }

    private boolean canScroll() {
        return selectedTab.canScroll() && ((ItemPickerMenu)this.menu).canScroll();
    }

    private void selectTab(CreativeModeTab p_98561_) {
        CreativeModeTab $$1 = selectedTab;
        selectedTab = p_98561_;
        this.quickCraftSlots.clear();
        ((ItemPickerMenu)this.menu).items.clear();
        this.clearDraggingState();
        if (selectedTab.getType() == CreativeModeTab.Type.HOTBAR) {
            HotbarManager $$2 = this.minecraft.getHotbarManager();
            for (int $$3 = 0; $$3 < 9; ++$$3) {
                Hotbar $$4 = $$2.get($$3);
                if ($$4.isEmpty()) {
                    for (int $$5 = 0; $$5 < 9; ++$$5) {
                        if ($$5 == $$3) {
                            ItemStack $$6 = new ItemStack(Items.PAPER);
                            $$6.set(DataComponents.CREATIVE_SLOT_LOCK, Unit.INSTANCE);
                            Component $$7 = this.minecraft.options.keyHotbarSlots[$$3].getTranslatedKeyMessage();
                            Component $$8 = this.minecraft.options.keySaveHotbarActivator.getTranslatedKeyMessage();
                            $$6.set(DataComponents.ITEM_NAME, Component.translatable("inventory.hotbarInfo", $$8, $$7));
                            ((ItemPickerMenu)this.menu).items.add($$6);
                            continue;
                        }
                        ((ItemPickerMenu)this.menu).items.add(ItemStack.EMPTY);
                    }
                    continue;
                }
                ((ItemPickerMenu)this.menu).items.addAll($$4.load(this.minecraft.level.registryAccess()));
            }
        } else if (selectedTab.getType() == CreativeModeTab.Type.CATEGORY) {
            ((ItemPickerMenu)this.menu).items.addAll(selectedTab.getDisplayItems());
        }
        if (selectedTab.getType() == CreativeModeTab.Type.INVENTORY) {
            InventoryMenu $$9 = this.minecraft.player.inventoryMenu;
            if (this.originalSlots == null) {
                this.originalSlots = ImmutableList.copyOf((Collection)((ItemPickerMenu)this.menu).slots);
            }
            ((ItemPickerMenu)this.menu).slots.clear();
            for (int $$10 = 0; $$10 < $$9.slots.size(); ++$$10) {
                int $$25;
                int $$23;
                if ($$10 >= 5 && $$10 < 9) {
                    int $$11 = $$10 - 5;
                    int $$12 = $$11 / 2;
                    int $$13 = $$11 % 2;
                    int $$14 = 54 + $$12 * 54;
                    int $$15 = 6 + $$13 * 27;
                } else if ($$10 >= 0 && $$10 < 5) {
                    int $$16 = -2000;
                    int $$17 = -2000;
                } else if ($$10 == 45) {
                    int $$18 = 35;
                    int $$19 = 20;
                } else {
                    int $$20 = $$10 - 9;
                    int $$21 = $$20 % 9;
                    int $$22 = $$20 / 9;
                    $$23 = 9 + $$21 * 18;
                    if ($$10 >= 36) {
                        int $$24 = 112;
                    } else {
                        $$25 = 54 + $$22 * 18;
                    }
                }
                SlotWrapper $$26 = new SlotWrapper($$9.slots.get($$10), $$10, $$23, $$25);
                ((ItemPickerMenu)this.menu).slots.add($$26);
            }
            this.destroyItemSlot = new Slot(CONTAINER, 0, 173, 112);
            ((ItemPickerMenu)this.menu).slots.add(this.destroyItemSlot);
        } else if ($$1.getType() == CreativeModeTab.Type.INVENTORY) {
            ((ItemPickerMenu)this.menu).slots.clear();
            ((ItemPickerMenu)this.menu).slots.addAll(this.originalSlots);
            this.originalSlots = null;
        }
        if (selectedTab.getType() == CreativeModeTab.Type.SEARCH) {
            this.searchBox.setVisible(true);
            this.searchBox.setCanLoseFocus(false);
            this.searchBox.setFocused(true);
            if ($$1 != p_98561_) {
                this.searchBox.setValue("");
            }
            this.refreshSearchResults();
        } else {
            this.searchBox.setVisible(false);
            this.searchBox.setCanLoseFocus(true);
            this.searchBox.setFocused(false);
            this.searchBox.setValue("");
        }
        this.scrollOffs = 0.0f;
        ((ItemPickerMenu)this.menu).scrollTo(0.0f);
    }

    @Override
    public boolean mouseScrolled(double p_98527_, double p_98528_, double p_98529_, double p_296489_) {
        if (super.mouseScrolled(p_98527_, p_98528_, p_98529_, p_296489_)) {
            return true;
        }
        if (!this.canScroll()) {
            return false;
        }
        this.scrollOffs = ((ItemPickerMenu)this.menu).subtractInputFromScroll(this.scrollOffs, p_296489_);
        ((ItemPickerMenu)this.menu).scrollTo(this.scrollOffs);
        return true;
    }

    @Override
    protected boolean hasClickedOutside(double p_98541_, double p_98542_, int p_98543_, int p_98544_, int p_98545_) {
        boolean $$5 = p_98541_ < (double)p_98543_ || p_98542_ < (double)p_98544_ || p_98541_ >= (double)(p_98543_ + this.imageWidth) || p_98542_ >= (double)(p_98544_ + this.imageHeight);
        this.hasClickedOutside = $$5 && !this.checkTabClicked(selectedTab, p_98541_, p_98542_);
        return this.hasClickedOutside;
    }

    protected boolean insideScrollbar(double p_98524_, double p_98525_) {
        int $$2 = this.leftPos;
        int $$3 = this.topPos;
        int $$4 = $$2 + 175;
        int $$5 = $$3 + 18;
        int $$6 = $$4 + 14;
        int $$7 = $$5 + 112;
        return p_98524_ >= (double)$$4 && p_98525_ >= (double)$$5 && p_98524_ < (double)$$6 && p_98525_ < (double)$$7;
    }

    @Override
    public boolean mouseDragged(double p_98535_, double p_98536_, int p_98537_, double p_98538_, double p_98539_) {
        if (this.scrolling) {
            int $$5 = this.topPos + 18;
            int $$6 = $$5 + 112;
            this.scrollOffs = ((float)p_98536_ - (float)$$5 - 7.5f) / ((float)($$6 - $$5) - 15.0f);
            this.scrollOffs = Mth.clamp(this.scrollOffs, 0.0f, 1.0f);
            ((ItemPickerMenu)this.menu).scrollTo(this.scrollOffs);
            return true;
        }
        return super.mouseDragged(p_98535_, p_98536_, p_98537_, p_98538_, p_98539_);
    }

    @Override
    public void render(GuiGraphics p_283000_, int p_281317_, int p_282770_, float p_281295_) {
        this.effects.renderEffects(p_283000_, p_281317_, p_282770_);
        super.render(p_283000_, p_281317_, p_282770_, p_281295_);
        this.effects.renderTooltip(p_283000_, p_281317_, p_282770_);
        for (CreativeModeTab $$4 : CreativeModeTabs.tabs()) {
            if (this.checkTabHovering(p_283000_, $$4, p_281317_, p_282770_)) break;
        }
        if (this.destroyItemSlot != null && selectedTab.getType() == CreativeModeTab.Type.INVENTORY && this.isHovering(this.destroyItemSlot.x, this.destroyItemSlot.y, 16, 16, p_281317_, p_282770_)) {
            p_283000_.setTooltipForNextFrame(this.font, TRASH_SLOT_TOOLTIP, p_281317_, p_282770_);
        }
        this.renderTooltip(p_283000_, p_281317_, p_282770_);
    }

    @Override
    public boolean showsActiveEffects() {
        return this.effects.canSeeEffects();
    }

    @Override
    public List<Component> getTooltipFromContainerItem(ItemStack p_281769_) {
        boolean $$1 = this.hoveredSlot != null && this.hoveredSlot instanceof CustomCreativeSlot;
        boolean $$2 = selectedTab.getType() == CreativeModeTab.Type.CATEGORY;
        boolean $$3 = selectedTab.getType() == CreativeModeTab.Type.SEARCH;
        TooltipFlag.Default $$4 = this.minecraft.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
        TooltipFlag.Default $$5 = $$1 ? $$4.asCreative() : $$4;
        List<Component> $$6 = p_281769_.getTooltipLines(Item.TooltipContext.of(this.minecraft.level), this.minecraft.player, $$5);
        if ($$6.isEmpty()) {
            return $$6;
        }
        if (!$$2 || !$$1) {
            ArrayList $$7 = Lists.newArrayList($$6);
            if ($$3 && $$1) {
                this.visibleTags.forEach(p_339283_ -> {
                    if (p_281769_.is((TagKey<Item>)p_339283_)) {
                        $$7.add(1, Component.literal("#" + String.valueOf(p_339283_.location())).withStyle(ChatFormatting.DARK_PURPLE));
                    }
                });
            }
            int $$8 = 1;
            for (CreativeModeTab $$9 : CreativeModeTabs.tabs()) {
                if ($$9.getType() == CreativeModeTab.Type.SEARCH || !$$9.contains(p_281769_)) continue;
                $$7.add($$8++, $$9.getDisplayName().copy().withStyle(ChatFormatting.BLUE));
            }
            return $$7;
        }
        return $$6;
    }

    @Override
    protected void renderBg(GuiGraphics p_282663_, float p_282504_, int p_282089_, int p_282249_) {
        for (CreativeModeTab $$4 : CreativeModeTabs.tabs()) {
            if ($$4 == selectedTab) continue;
            this.renderTabButton(p_282663_, $$4);
        }
        p_282663_.blit(RenderPipelines.GUI_TEXTURED, selectedTab.getBackgroundTexture(), this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        this.searchBox.render(p_282663_, p_282089_, p_282249_, p_282504_);
        int $$5 = this.leftPos + 175;
        int $$6 = this.topPos + 18;
        int $$7 = $$6 + 112;
        if (selectedTab.canScroll()) {
            ResourceLocation $$8 = this.canScroll() ? SCROLLER_SPRITE : SCROLLER_DISABLED_SPRITE;
            p_282663_.blitSprite(RenderPipelines.GUI_TEXTURED, $$8, $$5, $$6 + (int)((float)($$7 - $$6 - 17) * this.scrollOffs), 12, 15);
        }
        this.renderTabButton(p_282663_, selectedTab);
        if (selectedTab.getType() == CreativeModeTab.Type.INVENTORY) {
            InventoryScreen.renderEntityInInventoryFollowsMouse(p_282663_, this.leftPos + 73, this.topPos + 6, this.leftPos + 105, this.topPos + 49, 20, 0.0625f, p_282089_, p_282249_, this.minecraft.player);
        }
    }

    private int getTabX(CreativeModeTab p_260136_) {
        int $$1 = p_260136_.column();
        int $$2 = 27;
        int $$3 = 27 * $$1;
        if (p_260136_.isAlignedRight()) {
            $$3 = this.imageWidth - 27 * (7 - $$1) + 1;
        }
        return $$3;
    }

    private int getTabY(CreativeModeTab p_260181_) {
        int $$1 = 0;
        $$1 = p_260181_.row() == CreativeModeTab.Row.TOP ? ($$1 -= 32) : ($$1 += this.imageHeight);
        return $$1;
    }

    protected boolean checkTabClicked(CreativeModeTab p_98563_, double p_98564_, double p_98565_) {
        int $$3 = this.getTabX(p_98563_);
        int $$4 = this.getTabY(p_98563_);
        return p_98564_ >= (double)$$3 && p_98564_ <= (double)($$3 + 26) && p_98565_ >= (double)$$4 && p_98565_ <= (double)($$4 + 32);
    }

    protected boolean checkTabHovering(GuiGraphics p_282317_, CreativeModeTab p_282244_, int p_283469_, int p_283411_) {
        int $$5;
        int $$4 = this.getTabX(p_282244_);
        if (this.isHovering($$4 + 3, ($$5 = this.getTabY(p_282244_)) + 3, 21, 27, p_283469_, p_283411_)) {
            p_282317_.setTooltipForNextFrame(this.font, p_282244_.getDisplayName(), p_283469_, p_283411_);
            return true;
        }
        return false;
    }

    protected void renderTabButton(GuiGraphics p_283590_, CreativeModeTab p_283489_) {
        ResourceLocation[] $$8;
        boolean $$2 = p_283489_ == selectedTab;
        boolean $$3 = p_283489_.row() == CreativeModeTab.Row.TOP;
        int $$4 = p_283489_.column();
        int $$5 = this.leftPos + this.getTabX(p_283489_);
        int $$6 = this.topPos - ($$3 ? 28 : -(this.imageHeight - 4));
        if ($$3) {
            ResourceLocation[] $$7 = $$2 ? SELECTED_TOP_TABS : UNSELECTED_TOP_TABS;
        } else {
            $$8 = $$2 ? SELECTED_BOTTOM_TABS : UNSELECTED_BOTTOM_TABS;
        }
        p_283590_.blitSprite(RenderPipelines.GUI_TEXTURED, $$8[Mth.clamp($$4, 0, $$8.length)], $$5, $$6, 26, 32);
        int $$9 = $$5 + 13 - 8;
        int $$10 = $$6 + 16 - 8 + ($$3 ? 1 : -1);
        p_283590_.renderItem(p_283489_.getIconItem(), $$9, $$10);
    }

    public boolean isInventoryOpen() {
        return selectedTab.getType() == CreativeModeTab.Type.INVENTORY;
    }

    public static void handleHotbarLoadOrSave(Minecraft p_98599_, int p_98600_, boolean p_98601_, boolean p_98602_) {
        LocalPlayer $$4 = p_98599_.player;
        RegistryAccess $$5 = $$4.level().registryAccess();
        HotbarManager $$6 = p_98599_.getHotbarManager();
        Hotbar $$7 = $$6.get(p_98600_);
        if (p_98601_) {
            List<ItemStack> $$8 = $$7.load($$5);
            for (int $$9 = 0; $$9 < Inventory.getSelectionSize(); ++$$9) {
                ItemStack $$10 = $$8.get($$9);
                $$4.getInventory().setItem($$9, $$10);
                p_98599_.gameMode.handleCreativeModeItemAdd($$10, 36 + $$9);
            }
            $$4.inventoryMenu.broadcastChanges();
        } else if (p_98602_) {
            $$7.storeFrom($$4.getInventory(), $$5);
            Component $$11 = p_98599_.options.keyHotbarSlots[p_98600_].getTranslatedKeyMessage();
            Component $$12 = p_98599_.options.keyLoadHotbarActivator.getTranslatedKeyMessage();
            MutableComponent $$13 = Component.translatable("inventory.hotbarSaved", $$12, $$11);
            p_98599_.gui.setOverlayMessage($$13, false);
            p_98599_.getNarrator().saySystemNow($$13);
            $$6.save();
        }
    }

    public static class ItemPickerMenu
    extends AbstractContainerMenu {
        public final NonNullList<ItemStack> items = NonNullList.create();
        private final AbstractContainerMenu inventoryMenu;

        public ItemPickerMenu(Player p_98641_) {
            super(null, 0);
            this.inventoryMenu = p_98641_.inventoryMenu;
            Inventory $$1 = p_98641_.getInventory();
            for (int $$2 = 0; $$2 < 5; ++$$2) {
                for (int $$3 = 0; $$3 < 9; ++$$3) {
                    this.addSlot(new CustomCreativeSlot(CONTAINER, $$2 * 9 + $$3, 9 + $$3 * 18, 18 + $$2 * 18));
                }
            }
            this.addInventoryHotbarSlots($$1, 9, 112);
            this.scrollTo(0.0f);
        }

        @Override
        public boolean stillValid(Player p_98645_) {
            return true;
        }

        protected int calculateRowCount() {
            return Mth.positiveCeilDiv(this.items.size(), 9) - 5;
        }

        protected int getRowIndexForScroll(float p_259664_) {
            return Math.max((int)((double)(p_259664_ * (float)this.calculateRowCount()) + 0.5), 0);
        }

        protected float getScrollForRowIndex(int p_259315_) {
            return Mth.clamp((float)p_259315_ / (float)this.calculateRowCount(), 0.0f, 1.0f);
        }

        protected float subtractInputFromScroll(float p_259841_, double p_260358_) {
            return Mth.clamp(p_259841_ - (float)(p_260358_ / (double)this.calculateRowCount()), 0.0f, 1.0f);
        }

        public void scrollTo(float p_98643_) {
            int $$1 = this.getRowIndexForScroll(p_98643_);
            for (int $$2 = 0; $$2 < 5; ++$$2) {
                for (int $$3 = 0; $$3 < 9; ++$$3) {
                    int $$4 = $$3 + ($$2 + $$1) * 9;
                    if ($$4 >= 0 && $$4 < this.items.size()) {
                        CONTAINER.setItem($$3 + $$2 * 9, this.items.get($$4));
                        continue;
                    }
                    CONTAINER.setItem($$3 + $$2 * 9, ItemStack.EMPTY);
                }
            }
        }

        public boolean canScroll() {
            return this.items.size() > 45;
        }

        @Override
        public ItemStack quickMoveStack(Player p_98650_, int p_98651_) {
            Slot $$2;
            if (p_98651_ >= this.slots.size() - 9 && p_98651_ < this.slots.size() && ($$2 = (Slot)this.slots.get(p_98651_)) != null && $$2.hasItem()) {
                $$2.setByPlayer(ItemStack.EMPTY);
            }
            return ItemStack.EMPTY;
        }

        @Override
        public boolean canTakeItemForPickAll(ItemStack p_98647_, Slot p_98648_) {
            return p_98648_.container != CONTAINER;
        }

        @Override
        public boolean canDragTo(Slot p_98653_) {
            return p_98653_.container != CONTAINER;
        }

        @Override
        public ItemStack getCarried() {
            return this.inventoryMenu.getCarried();
        }

        @Override
        public void setCarried(ItemStack p_169751_) {
            this.inventoryMenu.setCarried(p_169751_);
        }
    }

    static class SlotWrapper
    extends Slot {
        final Slot target;

        public SlotWrapper(Slot p_98657_, int p_98658_, int p_98659_, int p_98660_) {
            super(p_98657_.container, p_98658_, p_98659_, p_98660_);
            this.target = p_98657_;
        }

        @Override
        public void onTake(Player p_169754_, ItemStack p_169755_) {
            this.target.onTake(p_169754_, p_169755_);
        }

        @Override
        public boolean mayPlace(ItemStack p_98670_) {
            return this.target.mayPlace(p_98670_);
        }

        @Override
        public ItemStack getItem() {
            return this.target.getItem();
        }

        @Override
        public boolean hasItem() {
            return this.target.hasItem();
        }

        @Override
        public void setByPlayer(ItemStack p_271008_, ItemStack p_299868_) {
            this.target.setByPlayer(p_271008_, p_299868_);
        }

        @Override
        public void set(ItemStack p_98679_) {
            this.target.set(p_98679_);
        }

        @Override
        public void setChanged() {
            this.target.setChanged();
        }

        @Override
        public int getMaxStackSize() {
            return this.target.getMaxStackSize();
        }

        @Override
        public int getMaxStackSize(ItemStack p_98675_) {
            return this.target.getMaxStackSize(p_98675_);
        }

        @Override
        @Nullable
        public ResourceLocation getNoItemIcon() {
            return this.target.getNoItemIcon();
        }

        @Override
        public ItemStack remove(int p_98663_) {
            return this.target.remove(p_98663_);
        }

        @Override
        public boolean isActive() {
            return this.target.isActive();
        }

        @Override
        public boolean mayPickup(Player p_98665_) {
            return this.target.mayPickup(p_98665_);
        }
    }

    static class CustomCreativeSlot
    extends Slot {
        public CustomCreativeSlot(Container p_98633_, int p_98634_, int p_98635_, int p_98636_) {
            super(p_98633_, p_98634_, p_98635_, p_98636_);
        }

        @Override
        public boolean mayPickup(Player p_98638_) {
            ItemStack $$1 = this.getItem();
            if (super.mayPickup(p_98638_) && !$$1.isEmpty()) {
                return $$1.isItemEnabled(p_98638_.level().enabledFeatures()) && !$$1.has(DataComponents.CREATIVE_SLOT_LOCK);
            }
            return $$1.isEmpty();
        }
    }
}

