/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.inventory;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.BundleMouseActions;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.ItemSlotMouseAction;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector2i;

public abstract class AbstractContainerScreen<T extends AbstractContainerMenu>
extends Screen
implements MenuAccess<T> {
    public static final ResourceLocation INVENTORY_LOCATION = ResourceLocation.withDefaultNamespace("textures/gui/container/inventory.png");
    private static final ResourceLocation SLOT_HIGHLIGHT_BACK_SPRITE = ResourceLocation.withDefaultNamespace("container/slot_highlight_back");
    private static final ResourceLocation SLOT_HIGHLIGHT_FRONT_SPRITE = ResourceLocation.withDefaultNamespace("container/slot_highlight_front");
    protected static final int BACKGROUND_TEXTURE_WIDTH = 256;
    protected static final int BACKGROUND_TEXTURE_HEIGHT = 256;
    private static final float SNAPBACK_SPEED = 100.0f;
    private static final int QUICKDROP_DELAY = 500;
    protected int imageWidth = 176;
    protected int imageHeight = 166;
    protected int titleLabelX;
    protected int titleLabelY;
    protected int inventoryLabelX;
    protected int inventoryLabelY;
    private final List<ItemSlotMouseAction> itemSlotMouseActions;
    protected final T menu;
    protected final Component playerInventoryTitle;
    @Nullable
    protected Slot hoveredSlot;
    @Nullable
    private Slot clickedSlot;
    @Nullable
    private Slot quickdropSlot;
    @Nullable
    private Slot lastClickSlot;
    @Nullable
    private SnapbackData snapbackData;
    protected int leftPos;
    protected int topPos;
    private boolean isSplittingStack;
    private ItemStack draggingItem = ItemStack.EMPTY;
    private long quickdropTime;
    protected final Set<Slot> quickCraftSlots = Sets.newHashSet();
    protected boolean isQuickCrafting;
    private int quickCraftingType;
    private int quickCraftingButton;
    private boolean skipNextRelease;
    private int quickCraftingRemainder;
    private long lastClickTime;
    private int lastClickButton;
    private boolean doubleclick;
    private ItemStack lastQuickMoved = ItemStack.EMPTY;

    public AbstractContainerScreen(T p_97741_, Inventory p_97742_, Component p_97743_) {
        super(p_97743_);
        this.menu = p_97741_;
        this.playerInventoryTitle = p_97742_.getDisplayName();
        this.skipNextRelease = true;
        this.titleLabelX = 8;
        this.titleLabelY = 6;
        this.inventoryLabelX = 8;
        this.inventoryLabelY = this.imageHeight - 94;
        this.itemSlotMouseActions = new ArrayList<ItemSlotMouseAction>();
    }

    @Override
    protected void init() {
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.itemSlotMouseActions.clear();
        this.addItemSlotMouseAction(new BundleMouseActions(this.minecraft));
    }

    protected void addItemSlotMouseAction(ItemSlotMouseAction p_362512_) {
        this.itemSlotMouseActions.add(p_362512_);
    }

    @Override
    public void render(GuiGraphics p_283479_, int p_283661_, int p_281248_, float p_281886_) {
        this.renderContents(p_283479_, p_283661_, p_281248_, p_281886_);
        this.renderCarriedItem(p_283479_, p_283661_, p_281248_);
        this.renderSnapbackItem(p_283479_);
    }

    public void renderContents(GuiGraphics p_418314_, int p_418170_, int p_418114_, float p_418250_) {
        int $$4 = this.leftPos;
        int $$5 = this.topPos;
        super.render(p_418314_, p_418170_, p_418114_, p_418250_);
        p_418314_.pose().pushMatrix();
        p_418314_.pose().translate((float)$$4, (float)$$5);
        this.renderLabels(p_418314_, p_418170_, p_418114_);
        Slot $$6 = this.hoveredSlot;
        this.hoveredSlot = this.getHoveredSlot(p_418170_, p_418114_);
        this.renderSlotHighlightBack(p_418314_);
        this.renderSlots(p_418314_);
        this.renderSlotHighlightFront(p_418314_);
        if ($$6 != null && $$6 != this.hoveredSlot) {
            this.onStopHovering($$6);
        }
        p_418314_.pose().popMatrix();
    }

    public void renderCarriedItem(GuiGraphics p_418153_, int p_418154_, int p_418125_) {
        ItemStack $$3;
        ItemStack itemStack = $$3 = this.draggingItem.isEmpty() ? ((AbstractContainerMenu)this.menu).getCarried() : this.draggingItem;
        if (!$$3.isEmpty()) {
            int $$4 = 8;
            int $$5 = this.draggingItem.isEmpty() ? 8 : 16;
            String $$6 = null;
            if (!this.draggingItem.isEmpty() && this.isSplittingStack) {
                $$3 = $$3.copyWithCount(Mth.ceil((float)$$3.getCount() / 2.0f));
            } else if (this.isQuickCrafting && this.quickCraftSlots.size() > 1 && ($$3 = $$3.copyWithCount(this.quickCraftingRemainder)).isEmpty()) {
                $$6 = String.valueOf(ChatFormatting.YELLOW) + "0";
            }
            p_418153_.nextStratum();
            this.renderFloatingItem(p_418153_, $$3, p_418154_ - 8, p_418125_ - $$5, $$6);
        }
    }

    public void renderSnapbackItem(GuiGraphics p_418096_) {
        if (this.snapbackData != null) {
            float $$1 = Mth.clamp((float)(Util.getMillis() - this.snapbackData.time) / 100.0f, 0.0f, 1.0f);
            int $$2 = this.snapbackData.end.x - this.snapbackData.start.x;
            int $$3 = this.snapbackData.end.y - this.snapbackData.start.y;
            int $$4 = this.snapbackData.start.x + (int)((float)$$2 * $$1);
            int $$5 = this.snapbackData.start.y + (int)((float)$$3 * $$1);
            p_418096_.nextStratum();
            this.renderFloatingItem(p_418096_, this.snapbackData.item, $$4, $$5, null);
            if ($$1 >= 1.0f) {
                this.snapbackData = null;
            }
        }
    }

    protected void renderSlots(GuiGraphics p_376313_) {
        for (Slot $$1 : ((AbstractContainerMenu)this.menu).slots) {
            if (!$$1.isActive()) continue;
            this.renderSlot(p_376313_, $$1);
        }
    }

    @Override
    public void renderBackground(GuiGraphics p_295206_, int p_295457_, int p_294596_, float p_296351_) {
        this.renderTransparentBackground(p_295206_);
        this.renderBg(p_295206_, p_296351_, p_295457_, p_294596_);
    }

    @Override
    public boolean mouseScrolled(double p_364830_, double p_360707_, double p_364436_, double p_364417_) {
        if (this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
            for (ItemSlotMouseAction $$4 : this.itemSlotMouseActions) {
                if (!$$4.matches(this.hoveredSlot) || !$$4.onMouseScrolled(p_364436_, p_364417_, this.hoveredSlot.index, this.hoveredSlot.getItem())) continue;
                return true;
            }
        }
        return false;
    }

    private void renderSlotHighlightBack(GuiGraphics p_372824_) {
        if (this.hoveredSlot != null && this.hoveredSlot.isHighlightable()) {
            p_372824_.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_HIGHLIGHT_BACK_SPRITE, this.hoveredSlot.x - 4, this.hoveredSlot.y - 4, 24, 24);
        }
    }

    private void renderSlotHighlightFront(GuiGraphics p_372940_) {
        if (this.hoveredSlot != null && this.hoveredSlot.isHighlightable()) {
            p_372940_.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_HIGHLIGHT_FRONT_SPRITE, this.hoveredSlot.x - 4, this.hoveredSlot.y - 4, 24, 24);
        }
    }

    protected void renderTooltip(GuiGraphics p_283594_, int p_282171_, int p_281909_) {
        if (this.hoveredSlot == null || !this.hoveredSlot.hasItem()) {
            return;
        }
        ItemStack $$3 = this.hoveredSlot.getItem();
        if (((AbstractContainerMenu)this.menu).getCarried().isEmpty() || this.showTooltipWithItemInHand($$3)) {
            p_283594_.setTooltipForNextFrame(this.font, this.getTooltipFromContainerItem($$3), $$3.getTooltipImage(), p_282171_, p_281909_, $$3.get(DataComponents.TOOLTIP_STYLE));
        }
    }

    private boolean showTooltipWithItemInHand(ItemStack p_360638_) {
        return p_360638_.getTooltipImage().map(ClientTooltipComponent::create).map(ClientTooltipComponent::showTooltipWithItemInHand).orElse(false);
    }

    protected List<Component> getTooltipFromContainerItem(ItemStack p_283689_) {
        return AbstractContainerScreen.getTooltipFromItem(this.minecraft, p_283689_);
    }

    private void renderFloatingItem(GuiGraphics p_282567_, ItemStack p_281330_, int p_281772_, int p_281689_, @Nullable String p_282568_) {
        p_282567_.renderItem(p_281330_, p_281772_, p_281689_);
        p_282567_.renderItemDecorations(this.font, p_281330_, p_281772_, p_281689_ - (this.draggingItem.isEmpty() ? 0 : 8), p_282568_);
    }

    protected void renderLabels(GuiGraphics p_281635_, int p_282681_, int p_283686_) {
        p_281635_.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, -12566464, false);
        p_281635_.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, -12566464, false);
    }

    protected abstract void renderBg(GuiGraphics var1, float var2, int var3, int var4);

    protected void renderSlot(GuiGraphics p_281607_, Slot p_282613_) {
        ResourceLocation $$12;
        int $$2 = p_282613_.x;
        int $$3 = p_282613_.y;
        ItemStack $$4 = p_282613_.getItem();
        boolean $$5 = false;
        boolean $$6 = p_282613_ == this.clickedSlot && !this.draggingItem.isEmpty() && !this.isSplittingStack;
        ItemStack $$7 = ((AbstractContainerMenu)this.menu).getCarried();
        String $$8 = null;
        if (p_282613_ == this.clickedSlot && !this.draggingItem.isEmpty() && this.isSplittingStack && !$$4.isEmpty()) {
            $$4 = $$4.copyWithCount($$4.getCount() / 2);
        } else if (this.isQuickCrafting && this.quickCraftSlots.contains(p_282613_) && !$$7.isEmpty()) {
            if (this.quickCraftSlots.size() == 1) {
                return;
            }
            if (AbstractContainerMenu.canItemQuickReplace(p_282613_, $$7, true) && ((AbstractContainerMenu)this.menu).canDragTo(p_282613_)) {
                $$5 = true;
                int $$9 = Math.min($$7.getMaxStackSize(), p_282613_.getMaxStackSize($$7));
                int $$10 = p_282613_.getItem().isEmpty() ? 0 : p_282613_.getItem().getCount();
                int $$11 = AbstractContainerMenu.getQuickCraftPlaceCount(this.quickCraftSlots, this.quickCraftingType, $$7) + $$10;
                if ($$11 > $$9) {
                    $$11 = $$9;
                    $$8 = ChatFormatting.YELLOW.toString() + $$9;
                }
                $$4 = $$7.copyWithCount($$11);
            } else {
                this.quickCraftSlots.remove(p_282613_);
                this.recalculateQuickCraftRemaining();
            }
        }
        if ($$4.isEmpty() && p_282613_.isActive() && ($$12 = p_282613_.getNoItemIcon()) != null) {
            p_281607_.blitSprite(RenderPipelines.GUI_TEXTURED, $$12, $$2, $$3, 16, 16);
            $$6 = true;
        }
        if (!$$6) {
            if ($$5) {
                p_281607_.fill($$2, $$3, $$2 + 16, $$3 + 16, -2130706433);
            }
            int $$13 = p_282613_.x + p_282613_.y * this.imageWidth;
            if (p_282613_.isFake()) {
                p_281607_.renderFakeItem($$4, $$2, $$3, $$13);
            } else {
                p_281607_.renderItem($$4, $$2, $$3, $$13);
            }
            p_281607_.renderItemDecorations(this.font, $$4, $$2, $$3, $$8);
        }
    }

    private void recalculateQuickCraftRemaining() {
        ItemStack $$0 = ((AbstractContainerMenu)this.menu).getCarried();
        if ($$0.isEmpty() || !this.isQuickCrafting) {
            return;
        }
        if (this.quickCraftingType == 2) {
            this.quickCraftingRemainder = $$0.getMaxStackSize();
            return;
        }
        this.quickCraftingRemainder = $$0.getCount();
        for (Slot $$1 : this.quickCraftSlots) {
            ItemStack $$2 = $$1.getItem();
            int $$3 = $$2.isEmpty() ? 0 : $$2.getCount();
            int $$4 = Math.min($$0.getMaxStackSize(), $$1.getMaxStackSize($$0));
            int $$5 = Math.min(AbstractContainerMenu.getQuickCraftPlaceCount(this.quickCraftSlots, this.quickCraftingType, $$0) + $$3, $$4);
            this.quickCraftingRemainder -= $$5 - $$3;
        }
    }

    @Nullable
    private Slot getHoveredSlot(double p_372985_, double p_372965_) {
        for (Slot $$2 : ((AbstractContainerMenu)this.menu).slots) {
            if (!$$2.isActive() || !this.isHovering($$2, p_372985_, p_372965_)) continue;
            return $$2;
        }
        return null;
    }

    @Override
    public boolean mouseClicked(double p_97748_, double p_97749_, int p_97750_) {
        if (super.mouseClicked(p_97748_, p_97749_, p_97750_)) {
            return true;
        }
        boolean $$3 = this.minecraft.options.keyPickItem.matchesMouse(p_97750_) && this.minecraft.player.hasInfiniteMaterials();
        Slot $$4 = this.getHoveredSlot(p_97748_, p_97749_);
        long $$5 = Util.getMillis();
        this.doubleclick = this.lastClickSlot == $$4 && $$5 - this.lastClickTime < 250L && this.lastClickButton == p_97750_;
        this.skipNextRelease = false;
        if (p_97750_ == 0 || p_97750_ == 1 || $$3) {
            int $$6 = this.leftPos;
            int $$7 = this.topPos;
            boolean $$8 = this.hasClickedOutside(p_97748_, p_97749_, $$6, $$7, p_97750_);
            int $$9 = -1;
            if ($$4 != null) {
                $$9 = $$4.index;
            }
            if ($$8) {
                $$9 = -999;
            }
            if (this.minecraft.options.touchscreen().get().booleanValue() && $$8 && ((AbstractContainerMenu)this.menu).getCarried().isEmpty()) {
                this.onClose();
                return true;
            }
            if ($$9 != -1) {
                if (this.minecraft.options.touchscreen().get().booleanValue()) {
                    if ($$4 != null && $$4.hasItem()) {
                        this.clickedSlot = $$4;
                        this.draggingItem = ItemStack.EMPTY;
                        this.isSplittingStack = p_97750_ == 1;
                    } else {
                        this.clickedSlot = null;
                    }
                } else if (!this.isQuickCrafting) {
                    if (((AbstractContainerMenu)this.menu).getCarried().isEmpty()) {
                        if ($$3) {
                            this.slotClicked($$4, $$9, p_97750_, ClickType.CLONE);
                        } else {
                            boolean $$10 = $$9 != -999 && (InputConstants.isKeyDown(Minecraft.getInstance().getWindow().getWindow(), 340) || InputConstants.isKeyDown(Minecraft.getInstance().getWindow().getWindow(), 344));
                            ClickType $$11 = ClickType.PICKUP;
                            if ($$10) {
                                this.lastQuickMoved = $$4 != null && $$4.hasItem() ? $$4.getItem().copy() : ItemStack.EMPTY;
                                $$11 = ClickType.QUICK_MOVE;
                            } else if ($$9 == -999) {
                                $$11 = ClickType.THROW;
                            }
                            this.slotClicked($$4, $$9, p_97750_, $$11);
                        }
                        this.skipNextRelease = true;
                    } else {
                        this.isQuickCrafting = true;
                        this.quickCraftingButton = p_97750_;
                        this.quickCraftSlots.clear();
                        if (p_97750_ == 0) {
                            this.quickCraftingType = 0;
                        } else if (p_97750_ == 1) {
                            this.quickCraftingType = 1;
                        } else if ($$3) {
                            this.quickCraftingType = 2;
                        }
                    }
                }
            }
        } else {
            this.checkHotbarMouseClicked(p_97750_);
        }
        this.lastClickSlot = $$4;
        this.lastClickTime = $$5;
        this.lastClickButton = p_97750_;
        return true;
    }

    private void checkHotbarMouseClicked(int p_97763_) {
        if (this.hoveredSlot != null && ((AbstractContainerMenu)this.menu).getCarried().isEmpty()) {
            if (this.minecraft.options.keySwapOffhand.matchesMouse(p_97763_)) {
                this.slotClicked(this.hoveredSlot, this.hoveredSlot.index, 40, ClickType.SWAP);
                return;
            }
            for (int $$1 = 0; $$1 < 9; ++$$1) {
                if (!this.minecraft.options.keyHotbarSlots[$$1].matchesMouse(p_97763_)) continue;
                this.slotClicked(this.hoveredSlot, this.hoveredSlot.index, $$1, ClickType.SWAP);
            }
        }
    }

    protected boolean hasClickedOutside(double p_97757_, double p_97758_, int p_97759_, int p_97760_, int p_97761_) {
        return p_97757_ < (double)p_97759_ || p_97758_ < (double)p_97760_ || p_97757_ >= (double)(p_97759_ + this.imageWidth) || p_97758_ >= (double)(p_97760_ + this.imageHeight);
    }

    @Override
    public boolean mouseDragged(double p_97752_, double p_97753_, int p_97754_, double p_97755_, double p_97756_) {
        Slot $$5 = this.getHoveredSlot(p_97752_, p_97753_);
        ItemStack $$6 = ((AbstractContainerMenu)this.menu).getCarried();
        if (this.clickedSlot != null && this.minecraft.options.touchscreen().get().booleanValue()) {
            if (p_97754_ == 0 || p_97754_ == 1) {
                if (this.draggingItem.isEmpty()) {
                    if ($$5 != this.clickedSlot && !this.clickedSlot.getItem().isEmpty()) {
                        this.draggingItem = this.clickedSlot.getItem().copy();
                    }
                } else if (this.draggingItem.getCount() > 1 && $$5 != null && AbstractContainerMenu.canItemQuickReplace($$5, this.draggingItem, false)) {
                    long $$7 = Util.getMillis();
                    if (this.quickdropSlot == $$5) {
                        if ($$7 - this.quickdropTime > 500L) {
                            this.slotClicked(this.clickedSlot, this.clickedSlot.index, 0, ClickType.PICKUP);
                            this.slotClicked($$5, $$5.index, 1, ClickType.PICKUP);
                            this.slotClicked(this.clickedSlot, this.clickedSlot.index, 0, ClickType.PICKUP);
                            this.quickdropTime = $$7 + 750L;
                            this.draggingItem.shrink(1);
                        }
                    } else {
                        this.quickdropSlot = $$5;
                        this.quickdropTime = $$7;
                    }
                }
            }
        } else if (this.isQuickCrafting && $$5 != null && !$$6.isEmpty() && ($$6.getCount() > this.quickCraftSlots.size() || this.quickCraftingType == 2) && AbstractContainerMenu.canItemQuickReplace($$5, $$6, true) && $$5.mayPlace($$6) && ((AbstractContainerMenu)this.menu).canDragTo($$5)) {
            this.quickCraftSlots.add($$5);
            this.recalculateQuickCraftRemaining();
        }
        return true;
    }

    @Override
    public boolean mouseReleased(double p_97812_, double p_97813_, int p_97814_) {
        Slot $$3 = this.getHoveredSlot(p_97812_, p_97813_);
        int $$4 = this.leftPos;
        int $$5 = this.topPos;
        boolean $$6 = this.hasClickedOutside(p_97812_, p_97813_, $$4, $$5, p_97814_);
        int $$7 = -1;
        if ($$3 != null) {
            $$7 = $$3.index;
        }
        if ($$6) {
            $$7 = -999;
        }
        if (this.doubleclick && $$3 != null && p_97814_ == 0 && ((AbstractContainerMenu)this.menu).canTakeItemForPickAll(ItemStack.EMPTY, $$3)) {
            if (AbstractContainerScreen.hasShiftDown()) {
                if (!this.lastQuickMoved.isEmpty()) {
                    for (Slot $$8 : ((AbstractContainerMenu)this.menu).slots) {
                        if ($$8 == null || !$$8.mayPickup(this.minecraft.player) || !$$8.hasItem() || $$8.container != $$3.container || !AbstractContainerMenu.canItemQuickReplace($$8, this.lastQuickMoved, true)) continue;
                        this.slotClicked($$8, $$8.index, p_97814_, ClickType.QUICK_MOVE);
                    }
                }
            } else {
                this.slotClicked($$3, $$7, p_97814_, ClickType.PICKUP_ALL);
            }
            this.doubleclick = false;
            this.lastClickTime = 0L;
        } else {
            if (this.isQuickCrafting && this.quickCraftingButton != p_97814_) {
                this.isQuickCrafting = false;
                this.quickCraftSlots.clear();
                this.skipNextRelease = true;
                return true;
            }
            if (this.skipNextRelease) {
                this.skipNextRelease = false;
                return true;
            }
            if (this.clickedSlot != null && this.minecraft.options.touchscreen().get().booleanValue()) {
                if (p_97814_ == 0 || p_97814_ == 1) {
                    if (this.draggingItem.isEmpty() && $$3 != this.clickedSlot) {
                        this.draggingItem = this.clickedSlot.getItem();
                    }
                    boolean $$9 = AbstractContainerMenu.canItemQuickReplace($$3, this.draggingItem, false);
                    if ($$7 != -1 && !this.draggingItem.isEmpty() && $$9) {
                        this.slotClicked(this.clickedSlot, this.clickedSlot.index, p_97814_, ClickType.PICKUP);
                        this.slotClicked($$3, $$7, 0, ClickType.PICKUP);
                        if (((AbstractContainerMenu)this.menu).getCarried().isEmpty()) {
                            this.snapbackData = null;
                        } else {
                            this.slotClicked(this.clickedSlot, this.clickedSlot.index, p_97814_, ClickType.PICKUP);
                            this.snapbackData = new SnapbackData(this.draggingItem, new Vector2i((int)p_97812_, (int)p_97813_), new Vector2i(this.clickedSlot.x + $$4, this.clickedSlot.y + $$5), Util.getMillis());
                        }
                    } else if (!this.draggingItem.isEmpty()) {
                        this.snapbackData = new SnapbackData(this.draggingItem, new Vector2i((int)p_97812_, (int)p_97813_), new Vector2i(this.clickedSlot.x + $$4, this.clickedSlot.y + $$5), Util.getMillis());
                    }
                    this.clearDraggingState();
                }
            } else if (this.isQuickCrafting && !this.quickCraftSlots.isEmpty()) {
                this.slotClicked(null, -999, AbstractContainerMenu.getQuickcraftMask(0, this.quickCraftingType), ClickType.QUICK_CRAFT);
                for (Slot $$10 : this.quickCraftSlots) {
                    this.slotClicked($$10, $$10.index, AbstractContainerMenu.getQuickcraftMask(1, this.quickCraftingType), ClickType.QUICK_CRAFT);
                }
                this.slotClicked(null, -999, AbstractContainerMenu.getQuickcraftMask(2, this.quickCraftingType), ClickType.QUICK_CRAFT);
            } else if (!((AbstractContainerMenu)this.menu).getCarried().isEmpty()) {
                if (this.minecraft.options.keyPickItem.matchesMouse(p_97814_)) {
                    this.slotClicked($$3, $$7, p_97814_, ClickType.CLONE);
                } else {
                    boolean $$11;
                    boolean bl = $$11 = $$7 != -999 && (InputConstants.isKeyDown(Minecraft.getInstance().getWindow().getWindow(), 340) || InputConstants.isKeyDown(Minecraft.getInstance().getWindow().getWindow(), 344));
                    if ($$11) {
                        this.lastQuickMoved = $$3 != null && $$3.hasItem() ? $$3.getItem().copy() : ItemStack.EMPTY;
                    }
                    this.slotClicked($$3, $$7, p_97814_, $$11 ? ClickType.QUICK_MOVE : ClickType.PICKUP);
                }
            }
        }
        if (((AbstractContainerMenu)this.menu).getCarried().isEmpty()) {
            this.lastClickTime = 0L;
        }
        this.isQuickCrafting = false;
        return true;
    }

    public void clearDraggingState() {
        this.draggingItem = ItemStack.EMPTY;
        this.clickedSlot = null;
    }

    private boolean isHovering(Slot p_97775_, double p_97776_, double p_97777_) {
        return this.isHovering(p_97775_.x, p_97775_.y, 16, 16, p_97776_, p_97777_);
    }

    protected boolean isHovering(int p_97768_, int p_97769_, int p_97770_, int p_97771_, double p_97772_, double p_97773_) {
        int $$6 = this.leftPos;
        int $$7 = this.topPos;
        return (p_97772_ -= (double)$$6) >= (double)(p_97768_ - 1) && p_97772_ < (double)(p_97768_ + p_97770_ + 1) && (p_97773_ -= (double)$$7) >= (double)(p_97769_ - 1) && p_97773_ < (double)(p_97769_ + p_97771_ + 1);
    }

    private void onStopHovering(Slot p_366690_) {
        if (p_366690_.hasItem()) {
            for (ItemSlotMouseAction $$1 : this.itemSlotMouseActions) {
                if (!$$1.matches(p_366690_)) continue;
                $$1.onStopHovering(p_366690_);
            }
        }
    }

    protected void slotClicked(Slot p_97778_, int p_97779_, int p_97780_, ClickType p_97781_) {
        if (p_97778_ != null) {
            p_97779_ = p_97778_.index;
        }
        this.onMouseClickAction(p_97778_, p_97781_);
        this.minecraft.gameMode.handleInventoryMouseClick(((AbstractContainerMenu)this.menu).containerId, p_97779_, p_97780_, p_97781_, this.minecraft.player);
    }

    void onMouseClickAction(@Nullable Slot p_373045_, ClickType p_373026_) {
        if (p_373045_ != null && p_373045_.hasItem()) {
            for (ItemSlotMouseAction $$2 : this.itemSlotMouseActions) {
                if (!$$2.matches(p_373045_)) continue;
                $$2.onSlotClicked(p_373045_, p_373026_);
            }
        }
    }

    protected void handleSlotStateChanged(int p_307539_, int p_307621_, boolean p_307388_) {
        this.minecraft.gameMode.handleSlotStateChanged(p_307539_, p_307621_, p_307388_);
    }

    @Override
    public boolean keyPressed(int p_97765_, int p_97766_, int p_97767_) {
        if (super.keyPressed(p_97765_, p_97766_, p_97767_)) {
            return true;
        }
        if (this.minecraft.options.keyInventory.matches(p_97765_, p_97766_)) {
            this.onClose();
            return true;
        }
        this.checkHotbarKeyPressed(p_97765_, p_97766_);
        if (this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
            if (this.minecraft.options.keyPickItem.matches(p_97765_, p_97766_)) {
                this.slotClicked(this.hoveredSlot, this.hoveredSlot.index, 0, ClickType.CLONE);
            } else if (this.minecraft.options.keyDrop.matches(p_97765_, p_97766_)) {
                this.slotClicked(this.hoveredSlot, this.hoveredSlot.index, AbstractContainerScreen.hasControlDown() ? 1 : 0, ClickType.THROW);
            }
        }
        return true;
    }

    protected boolean checkHotbarKeyPressed(int p_97806_, int p_97807_) {
        if (((AbstractContainerMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null) {
            if (this.minecraft.options.keySwapOffhand.matches(p_97806_, p_97807_)) {
                this.slotClicked(this.hoveredSlot, this.hoveredSlot.index, 40, ClickType.SWAP);
                return true;
            }
            for (int $$2 = 0; $$2 < 9; ++$$2) {
                if (!this.minecraft.options.keyHotbarSlots[$$2].matches(p_97806_, p_97807_)) continue;
                this.slotClicked(this.hoveredSlot, this.hoveredSlot.index, $$2, ClickType.SWAP);
                return true;
            }
        }
        return false;
    }

    @Override
    public void removed() {
        if (this.minecraft.player == null) {
            return;
        }
        ((AbstractContainerMenu)this.menu).removed(this.minecraft.player);
    }

    @Override
    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public final void tick() {
        super.tick();
        if (!this.minecraft.player.isAlive() || this.minecraft.player.isRemoved()) {
            this.minecraft.player.closeContainer();
        } else {
            this.containerTick();
        }
    }

    protected void containerTick() {
    }

    @Override
    public T getMenu() {
        return this.menu;
    }

    @Override
    public void onClose() {
        this.minecraft.player.closeContainer();
        if (this.hoveredSlot != null) {
            this.onStopHovering(this.hoveredSlot);
        }
        super.onClose();
    }

    record SnapbackData(ItemStack item, Vector2i start, Vector2i end, long time) {
    }
}

