/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.dialog.input;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.layouts.CommonLayouts;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.dialog.input.InputControlHandler;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.dialog.action.Action;
import net.minecraft.server.dialog.input.BooleanInput;
import net.minecraft.server.dialog.input.InputControl;
import net.minecraft.server.dialog.input.NumberRangeInput;
import net.minecraft.server.dialog.input.SingleOptionInput;
import net.minecraft.server.dialog.input.TextInput;
import org.slf4j.Logger;

public class InputControlHandlers {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<MapCodec<? extends InputControl>, InputControlHandler<?>> HANDLERS = new HashMap();

    private static <T extends InputControl> void register(MapCodec<T> p_425691_, InputControlHandler<? super T> p_426293_) {
        HANDLERS.put(p_425691_, p_426293_);
    }

    @Nullable
    private static <T extends InputControl> InputControlHandler<T> get(T p_426260_) {
        return HANDLERS.get(p_426260_.mapCodec());
    }

    public static <T extends InputControl> void createHandler(T p_426216_, Screen p_425515_, InputControlHandler.Output p_425712_) {
        InputControlHandler<T> $$3 = InputControlHandlers.get(p_426216_);
        if ($$3 == null) {
            LOGGER.warn("Unrecognized input control {}", p_426216_);
            return;
        }
        $$3.addControl(p_426216_, p_425515_, p_425712_);
    }

    public static void bootstrap() {
        InputControlHandlers.register(TextInput.MAP_CODEC, new TextInputHandler());
        InputControlHandlers.register(SingleOptionInput.MAP_CODEC, new SingleOptionHandler());
        InputControlHandlers.register(BooleanInput.MAP_CODEC, new BooleanHandler());
        InputControlHandlers.register(NumberRangeInput.MAP_CODEC, new NumberRangeHandler());
    }

    static class TextInputHandler
    implements InputControlHandler<TextInput> {
        TextInputHandler() {
        }

        @Override
        public void addControl(TextInput p_425780_, Screen p_425598_, InputControlHandler.Output p_425996_) {
            Supplier<String> $$11;
            EditBox $$10;
            Font $$3 = p_425598_.getFont();
            if (p_425780_.multiline().isPresent()) {
                TextInput.MultilineOptions $$4 = p_425780_.multiline().get();
                int $$5 = $$4.height().orElseGet(() -> {
                    int $$2 = $$4.maxLines().orElse(4);
                    return Math.min(p_428671_.lineHeight * $$2 + 8, 512);
                });
                MultiLineEditBox $$6 = MultiLineEditBox.builder().build($$3, p_425780_.width(), $$5, CommonComponents.EMPTY);
                $$6.setCharacterLimit(p_425780_.maxLength());
                $$4.maxLines().ifPresent($$6::setLineLimit);
                $$6.setValue(p_425780_.initial());
                MultiLineEditBox $$7 = $$6;
                Supplier<String> $$8 = $$6::getValue;
            } else {
                EditBox $$9 = new EditBox($$3, p_425780_.width(), 20, p_425780_.label());
                $$9.setMaxLength(p_425780_.maxLength());
                $$9.setValue(p_425780_.initial());
                $$10 = $$9;
                $$11 = $$9::getValue;
            }
            EditBox $$12 = p_425780_.labelVisible() ? CommonLayouts.labeledElement($$3, $$10, p_425780_.label()) : $$10;
            p_425996_.accept($$12, new Action.ValueGetter(){

                @Override
                public String asTemplateSubstitution() {
                    return StringTag.escapeWithoutQuotes((String)$$11.get());
                }

                @Override
                public Tag asTag() {
                    return StringTag.valueOf((String)$$11.get());
                }
            });
        }

        @Override
        public /* synthetic */ void addControl(InputControl inputControl, Screen screen, InputControlHandler.Output output) {
            this.addControl((TextInput)inputControl, screen, output);
        }
    }

    static class SingleOptionHandler
    implements InputControlHandler<SingleOptionInput> {
        SingleOptionHandler() {
        }

        @Override
        public void addControl(SingleOptionInput p_425545_, Screen p_425696_, InputControlHandler.Output p_426241_) {
            CycleButton.Builder<SingleOptionInput.Entry> $$3 = CycleButton.builder(SingleOptionInput.Entry::displayOrDefault).withValues((Collection<SingleOptionInput.Entry>)p_425545_.entries()).displayOnlyValue(!p_425545_.labelVisible());
            Optional<SingleOptionInput.Entry> $$4 = p_425545_.initial();
            if ($$4.isPresent()) {
                $$3 = $$3.withInitialValue($$4.get());
            }
            CycleButton<SingleOptionInput.Entry> $$5 = $$3.create(0, 0, p_425545_.width(), 20, p_425545_.label());
            p_426241_.accept($$5, Action.ValueGetter.of(() -> ((SingleOptionInput.Entry)$$5.getValue()).id()));
        }

        @Override
        public /* synthetic */ void addControl(InputControl inputControl, Screen screen, InputControlHandler.Output output) {
            this.addControl((SingleOptionInput)inputControl, screen, output);
        }
    }

    static class BooleanHandler
    implements InputControlHandler<BooleanInput> {
        BooleanHandler() {
        }

        @Override
        public void addControl(final BooleanInput p_426172_, Screen p_426214_, InputControlHandler.Output p_426199_) {
            Font $$3 = p_426214_.getFont();
            final Checkbox $$4 = Checkbox.builder(p_426172_.label(), $$3).selected(p_426172_.initial()).build();
            p_426199_.accept($$4, new Action.ValueGetter(){

                @Override
                public String asTemplateSubstitution() {
                    return $$4.selected() ? p_426172_.onTrue() : p_426172_.onFalse();
                }

                @Override
                public Tag asTag() {
                    return ByteTag.valueOf($$4.selected());
                }
            });
        }

        @Override
        public /* synthetic */ void addControl(InputControl inputControl, Screen screen, InputControlHandler.Output output) {
            this.addControl((BooleanInput)inputControl, screen, output);
        }
    }

    static class NumberRangeHandler
    implements InputControlHandler<NumberRangeInput> {
        NumberRangeHandler() {
        }

        @Override
        public void addControl(NumberRangeInput p_425719_, Screen p_426306_, InputControlHandler.Output p_425726_) {
            float $$3 = p_425719_.rangeInfo().initialSliderValue();
            final SliderImpl $$4 = new SliderImpl(p_425719_, $$3);
            p_425726_.accept($$4, new Action.ValueGetter(){

                @Override
                public String asTemplateSubstitution() {
                    return $$4.stringValueToSend();
                }

                @Override
                public Tag asTag() {
                    return FloatTag.valueOf($$4.floatValueToSend());
                }
            });
        }

        @Override
        public /* synthetic */ void addControl(InputControl inputControl, Screen screen, InputControlHandler.Output output) {
            this.addControl((NumberRangeInput)inputControl, screen, output);
        }

        static class SliderImpl
        extends AbstractSliderButton {
            private final NumberRangeInput input;

            SliderImpl(NumberRangeInput p_426229_, double p_426263_) {
                super(0, 0, p_426229_.width(), 20, SliderImpl.computeMessage(p_426229_, p_426263_), p_426263_);
                this.input = p_426229_;
            }

            @Override
            protected void updateMessage() {
                this.setMessage(SliderImpl.computeMessage(this.input, this.value));
            }

            @Override
            protected void applyValue() {
            }

            public String stringValueToSend() {
                return SliderImpl.sliderValueToString(this.input, this.value);
            }

            public float floatValueToSend() {
                return SliderImpl.scaledValue(this.input, this.value);
            }

            private static float scaledValue(NumberRangeInput p_428329_, double p_428472_) {
                return p_428329_.rangeInfo().computeScaledValue((float)p_428472_);
            }

            private static String sliderValueToString(NumberRangeInput p_426239_, double p_425642_) {
                return SliderImpl.valueToString(SliderImpl.scaledValue(p_426239_, p_425642_));
            }

            private static Component computeMessage(NumberRangeInput p_426318_, double p_426116_) {
                return p_426318_.computeLabel(SliderImpl.sliderValueToString(p_426318_, p_426116_));
            }

            private static String valueToString(float p_427421_) {
                int $$1 = (int)p_427421_;
                if ((float)$$1 == p_427421_) {
                    return Integer.toString($$1);
                }
                return Float.toString(p_427421_);
            }
        }
    }
}

