/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.advancements;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.advancements.AdvancementTab;
import net.minecraft.client.gui.screens.advancements.AdvancementWidget;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ServerboundSeenAdvancementsPacket;
import net.minecraft.resources.ResourceLocation;

public class AdvancementsScreen
extends Screen
implements ClientAdvancements.Listener {
    private static final ResourceLocation WINDOW_LOCATION = ResourceLocation.withDefaultNamespace("textures/gui/advancements/window.png");
    public static final int WINDOW_WIDTH = 252;
    public static final int WINDOW_HEIGHT = 140;
    private static final int WINDOW_INSIDE_X = 9;
    private static final int WINDOW_INSIDE_Y = 18;
    public static final int WINDOW_INSIDE_WIDTH = 234;
    public static final int WINDOW_INSIDE_HEIGHT = 113;
    private static final int WINDOW_TITLE_X = 8;
    private static final int WINDOW_TITLE_Y = 6;
    private static final int BACKGROUND_TEXTURE_WIDTH = 256;
    private static final int BACKGROUND_TEXTURE_HEIGHT = 256;
    public static final int BACKGROUND_TILE_WIDTH = 16;
    public static final int BACKGROUND_TILE_HEIGHT = 16;
    public static final int BACKGROUND_TILE_COUNT_X = 14;
    public static final int BACKGROUND_TILE_COUNT_Y = 7;
    private static final double SCROLL_SPEED = 16.0;
    private static final Component VERY_SAD_LABEL = Component.translatable("advancements.sad_label");
    private static final Component NO_ADVANCEMENTS_LABEL = Component.translatable("advancements.empty");
    private static final Component TITLE = Component.translatable("gui.advancements");
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout(this);
    @Nullable
    private final Screen lastScreen;
    private final ClientAdvancements advancements;
    private final Map<AdvancementHolder, AdvancementTab> tabs = Maps.newLinkedHashMap();
    @Nullable
    private AdvancementTab selectedTab;
    private boolean isScrolling;

    public AdvancementsScreen(ClientAdvancements p_97340_) {
        this(p_97340_, null);
    }

    public AdvancementsScreen(ClientAdvancements p_331393_, @Nullable Screen p_331693_) {
        super(TITLE);
        this.advancements = p_331393_;
        this.lastScreen = p_331693_;
    }

    @Override
    protected void init() {
        this.layout.addTitleHeader(TITLE, this.font);
        this.tabs.clear();
        this.selectedTab = null;
        this.advancements.setListener(this);
        if (this.selectedTab == null && !this.tabs.isEmpty()) {
            AdvancementTab $$0 = this.tabs.values().iterator().next();
            this.advancements.setSelectedTab($$0.getRootNode().holder(), true);
        } else {
            this.advancements.setSelectedTab(this.selectedTab == null ? null : this.selectedTab.getRootNode().holder(), true);
        }
        this.layout.addToFooter(Button.builder(CommonComponents.GUI_DONE, p_331557_ -> this.onClose()).width(200).build());
        this.layout.visitWidgets(p_332019_ -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget(p_332019_);
        });
        this.repositionElements();
    }

    @Override
    protected void repositionElements() {
        this.layout.arrangeElements();
    }

    @Override
    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }

    @Override
    public void removed() {
        this.advancements.setListener(null);
        ClientPacketListener $$0 = this.minecraft.getConnection();
        if ($$0 != null) {
            $$0.send(ServerboundSeenAdvancementsPacket.closedScreen());
        }
    }

    @Override
    public boolean mouseClicked(double p_97343_, double p_97344_, int p_97345_) {
        if (p_97345_ == 0) {
            int $$3 = (this.width - 252) / 2;
            int $$4 = (this.height - 140) / 2;
            for (AdvancementTab $$5 : this.tabs.values()) {
                if (!$$5.isMouseOver($$3, $$4, p_97343_, p_97344_)) continue;
                this.advancements.setSelectedTab($$5.getRootNode().holder(), true);
                break;
            }
        }
        return super.mouseClicked(p_97343_, p_97344_, p_97345_);
    }

    @Override
    public boolean keyPressed(int p_97353_, int p_97354_, int p_97355_) {
        if (this.minecraft.options.keyAdvancements.matches(p_97353_, p_97354_)) {
            this.minecraft.setScreen(null);
            this.minecraft.mouseHandler.grabMouse();
            return true;
        }
        return super.keyPressed(p_97353_, p_97354_, p_97355_);
    }

    @Override
    public void render(GuiGraphics p_282589_, int p_282255_, int p_283354_, float p_283123_) {
        super.render(p_282589_, p_282255_, p_283354_, p_283123_);
        int $$4 = (this.width - 252) / 2;
        int $$5 = (this.height - 140) / 2;
        p_282589_.nextStratum();
        this.renderInside(p_282589_, $$4, $$5);
        p_282589_.nextStratum();
        this.renderWindow(p_282589_, $$4, $$5);
        this.renderTooltips(p_282589_, p_282255_, p_283354_, $$4, $$5);
    }

    @Override
    public boolean mouseDragged(double p_97347_, double p_97348_, int p_97349_, double p_97350_, double p_97351_) {
        if (p_97349_ != 0) {
            this.isScrolling = false;
            return false;
        }
        if (!this.isScrolling) {
            this.isScrolling = true;
        } else if (this.selectedTab != null) {
            this.selectedTab.scroll(p_97350_, p_97351_);
        }
        return true;
    }

    @Override
    public boolean mouseScrolled(double p_295690_, double p_295286_, double p_295339_, double p_296270_) {
        if (this.selectedTab != null) {
            this.selectedTab.scroll(p_295339_ * 16.0, p_296270_ * 16.0);
            return true;
        }
        return false;
    }

    private void renderInside(GuiGraphics p_282012_, int p_97375_, int p_97376_) {
        AdvancementTab $$3 = this.selectedTab;
        if ($$3 == null) {
            p_282012_.fill(p_97375_ + 9, p_97376_ + 18, p_97375_ + 9 + 234, p_97376_ + 18 + 113, -16777216);
            int $$4 = p_97375_ + 9 + 117;
            p_282012_.drawCenteredString(this.font, NO_ADVANCEMENTS_LABEL, $$4, p_97376_ + 18 + 56 - this.font.lineHeight / 2, -1);
            p_282012_.drawCenteredString(this.font, VERY_SAD_LABEL, $$4, p_97376_ + 18 + 113 - this.font.lineHeight, -1);
            return;
        }
        $$3.drawContents(p_282012_, p_97375_ + 9, p_97376_ + 18);
    }

    public void renderWindow(GuiGraphics p_283395_, int p_281890_, int p_282532_) {
        p_283395_.blit(RenderPipelines.GUI_TEXTURED, WINDOW_LOCATION, p_281890_, p_282532_, 0.0f, 0.0f, 252, 140, 256, 256);
        if (this.tabs.size() > 1) {
            for (AdvancementTab $$3 : this.tabs.values()) {
                $$3.drawTab(p_283395_, p_281890_, p_282532_, $$3 == this.selectedTab);
            }
            for (AdvancementTab $$4 : this.tabs.values()) {
                $$4.drawIcon(p_283395_, p_281890_, p_282532_);
            }
        }
        p_283395_.drawString(this.font, this.selectedTab != null ? this.selectedTab.getTitle() : TITLE, p_281890_ + 8, p_282532_ + 6, -12566464, false);
    }

    private void renderTooltips(GuiGraphics p_282784_, int p_283556_, int p_282458_, int p_281519_, int p_283371_) {
        if (this.selectedTab != null) {
            p_282784_.pose().pushMatrix();
            p_282784_.pose().translate((float)(p_281519_ + 9), (float)(p_283371_ + 18));
            p_282784_.nextStratum();
            this.selectedTab.drawTooltips(p_282784_, p_283556_ - p_281519_ - 9, p_282458_ - p_283371_ - 18, p_281519_, p_283371_);
            p_282784_.pose().popMatrix();
        }
        if (this.tabs.size() > 1) {
            for (AdvancementTab $$5 : this.tabs.values()) {
                if (!$$5.isMouseOver(p_281519_, p_283371_, p_283556_, p_282458_)) continue;
                p_282784_.setTooltipForNextFrame(this.font, $$5.getTitle(), p_283556_, p_282458_);
            }
        }
    }

    @Override
    public void onAddAdvancementRoot(AdvancementNode p_301276_) {
        AdvancementTab $$1 = AdvancementTab.create(this.minecraft, this, this.tabs.size(), p_301276_);
        if ($$1 == null) {
            return;
        }
        this.tabs.put(p_301276_.holder(), $$1);
    }

    @Override
    public void onRemoveAdvancementRoot(AdvancementNode p_301028_) {
    }

    @Override
    public void onAddAdvancementTask(AdvancementNode p_301205_) {
        AdvancementTab $$1 = this.getTab(p_301205_);
        if ($$1 != null) {
            $$1.addAdvancement(p_301205_);
        }
    }

    @Override
    public void onRemoveAdvancementTask(AdvancementNode p_301004_) {
    }

    @Override
    public void onUpdateAdvancementProgress(AdvancementNode p_301161_, AdvancementProgress p_97369_) {
        AdvancementWidget $$2 = this.getAdvancementWidget(p_301161_);
        if ($$2 != null) {
            $$2.setProgress(p_97369_);
        }
    }

    @Override
    public void onSelectedTabChanged(@Nullable AdvancementHolder p_301084_) {
        this.selectedTab = this.tabs.get(p_301084_);
    }

    @Override
    public void onAdvancementsCleared() {
        this.tabs.clear();
        this.selectedTab = null;
    }

    @Nullable
    public AdvancementWidget getAdvancementWidget(AdvancementNode p_300894_) {
        AdvancementTab $$1 = this.getTab(p_300894_);
        return $$1 == null ? null : $$1.getWidget(p_300894_.holder());
    }

    @Nullable
    private AdvancementTab getTab(AdvancementNode p_301151_) {
        AdvancementNode $$1 = p_301151_.root();
        return this.tabs.get($$1.holder());
    }
}

