/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.advancements;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.advancements.AdvancementTab;
import net.minecraft.client.gui.screens.advancements.AdvancementWidgetType;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class AdvancementWidget {
    private static final ResourceLocation TITLE_BOX_SPRITE = ResourceLocation.withDefaultNamespace("advancements/title_box");
    private static final int HEIGHT = 26;
    private static final int BOX_X = 0;
    private static final int BOX_WIDTH = 200;
    private static final int FRAME_WIDTH = 26;
    private static final int ICON_X = 8;
    private static final int ICON_Y = 5;
    private static final int ICON_WIDTH = 26;
    private static final int TITLE_PADDING_LEFT = 3;
    private static final int TITLE_PADDING_RIGHT = 5;
    private static final int TITLE_X = 32;
    private static final int TITLE_PADDING_TOP = 9;
    private static final int TITLE_PADDING_BOTTOM = 8;
    private static final int TITLE_MAX_WIDTH = 163;
    private static final int TITLE_MIN_WIDTH = 80;
    private static final int[] TEST_SPLIT_OFFSETS = new int[]{0, 10, -10, 25, -25};
    private final AdvancementTab tab;
    private final AdvancementNode advancementNode;
    private final DisplayInfo display;
    private final List<FormattedCharSequence> titleLines;
    private final int width;
    private final List<FormattedCharSequence> description;
    private final Minecraft minecraft;
    @Nullable
    private AdvancementWidget parent;
    private final List<AdvancementWidget> children = Lists.newArrayList();
    @Nullable
    private AdvancementProgress progress;
    private final int x;
    private final int y;

    public AdvancementWidget(AdvancementTab p_97255_, Minecraft p_97256_, AdvancementNode p_300868_, DisplayInfo p_97258_) {
        this.tab = p_97255_;
        this.advancementNode = p_300868_;
        this.display = p_97258_;
        this.minecraft = p_97256_;
        this.titleLines = p_97256_.font.split(p_97258_.getTitle(), 163);
        this.x = Mth.floor(p_97258_.getX() * 28.0f);
        this.y = Mth.floor(p_97258_.getY() * 27.0f);
        int $$4 = Math.max(this.titleLines.stream().mapToInt(p_97256_.font::width).max().orElse(0), 80);
        int $$5 = this.getMaxProgressWidth();
        int $$6 = 29 + $$4 + $$5;
        this.description = Language.getInstance().getVisualOrder(this.findOptimalLines(ComponentUtils.mergeStyles(p_97258_.getDescription().copy(), Style.EMPTY.withColor(p_97258_.getType().getChatColor())), $$6));
        for (FormattedCharSequence $$7 : this.description) {
            $$6 = Math.max($$6, p_97256_.font.width($$7));
        }
        this.width = $$6 + 3 + 5;
    }

    private int getMaxProgressWidth() {
        int $$0 = this.advancementNode.advancement().requirements().size();
        if ($$0 <= 1) {
            return 0;
        }
        int $$1 = 8;
        MutableComponent $$2 = Component.translatable("advancements.progress", $$0, $$0);
        return this.minecraft.font.width($$2) + 8;
    }

    private static float getMaxWidth(StringSplitter p_97304_, List<FormattedText> p_97305_) {
        return (float)p_97305_.stream().mapToDouble(p_97304_::stringWidth).max().orElse(0.0);
    }

    private List<FormattedText> findOptimalLines(Component p_97309_, int p_97310_) {
        StringSplitter $$2 = this.minecraft.font.getSplitter();
        List<FormattedText> $$3 = null;
        float $$4 = Float.MAX_VALUE;
        for (int $$5 : TEST_SPLIT_OFFSETS) {
            List<FormattedText> $$6 = $$2.splitLines(p_97309_, p_97310_ - $$5, Style.EMPTY);
            float $$7 = Math.abs(AdvancementWidget.getMaxWidth($$2, $$6) - (float)p_97310_);
            if ($$7 <= 10.0f) {
                return $$6;
            }
            if (!($$7 < $$4)) continue;
            $$4 = $$7;
            $$3 = $$6;
        }
        return $$3;
    }

    @Nullable
    private AdvancementWidget getFirstVisibleParent(AdvancementNode p_301093_) {
        while ((p_301093_ = p_301093_.parent()) != null && p_301093_.advancement().display().isEmpty()) {
        }
        if (p_301093_ == null || p_301093_.advancement().display().isEmpty()) {
            return null;
        }
        return this.tab.getWidget(p_301093_.holder());
    }

    public void drawConnectivity(GuiGraphics p_281947_, int p_97300_, int p_97301_, boolean p_97302_) {
        if (this.parent != null) {
            int $$9;
            int $$4 = p_97300_ + this.parent.x + 13;
            int $$5 = p_97300_ + this.parent.x + 26 + 4;
            int $$6 = p_97301_ + this.parent.y + 13;
            int $$7 = p_97300_ + this.x + 13;
            int $$8 = p_97301_ + this.y + 13;
            int n = $$9 = p_97302_ ? -16777216 : -1;
            if (p_97302_) {
                p_281947_.hLine($$5, $$4, $$6 - 1, $$9);
                p_281947_.hLine($$5 + 1, $$4, $$6, $$9);
                p_281947_.hLine($$5, $$4, $$6 + 1, $$9);
                p_281947_.hLine($$7, $$5 - 1, $$8 - 1, $$9);
                p_281947_.hLine($$7, $$5 - 1, $$8, $$9);
                p_281947_.hLine($$7, $$5 - 1, $$8 + 1, $$9);
                p_281947_.vLine($$5 - 1, $$8, $$6, $$9);
                p_281947_.vLine($$5 + 1, $$8, $$6, $$9);
            } else {
                p_281947_.hLine($$5, $$4, $$6, $$9);
                p_281947_.hLine($$7, $$5, $$8, $$9);
                p_281947_.vLine($$5, $$8, $$6, $$9);
            }
        }
        for (AdvancementWidget $$10 : this.children) {
            $$10.drawConnectivity(p_281947_, p_97300_, p_97301_, p_97302_);
        }
    }

    public void draw(GuiGraphics p_281958_, int p_281323_, int p_283679_) {
        if (!this.display.isHidden() || this.progress != null && this.progress.isDone()) {
            AdvancementWidgetType $$5;
            float $$3;
            float f = $$3 = this.progress == null ? 0.0f : this.progress.getPercent();
            if ($$3 >= 1.0f) {
                AdvancementWidgetType $$4 = AdvancementWidgetType.OBTAINED;
            } else {
                $$5 = AdvancementWidgetType.UNOBTAINED;
            }
            p_281958_.blitSprite(RenderPipelines.GUI_TEXTURED, $$5.frameSprite(this.display.getType()), p_281323_ + this.x + 3, p_283679_ + this.y, 26, 26);
            p_281958_.renderFakeItem(this.display.getIcon(), p_281323_ + this.x + 8, p_283679_ + this.y + 5);
        }
        for (AdvancementWidget $$6 : this.children) {
            $$6.draw(p_281958_, p_281323_, p_283679_);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setProgress(AdvancementProgress p_97265_) {
        this.progress = p_97265_;
    }

    public void addChild(AdvancementWidget p_97307_) {
        this.children.add(p_97307_);
    }

    public void drawHover(GuiGraphics p_283068_, int p_281304_, int p_281253_, float p_281848_, int p_282097_, int p_281537_) {
        int $$32;
        AdvancementWidgetType $$29;
        AdvancementWidgetType $$28;
        AdvancementWidgetType $$27;
        Font $$6 = this.minecraft.font;
        int $$7 = $$6.lineHeight * this.titleLines.size() + 9 + 8;
        int $$8 = p_281253_ + this.y + (26 - $$7) / 2;
        int $$9 = $$8 + $$7;
        int $$10 = this.description.size() * $$6.lineHeight;
        int $$11 = 6 + $$10;
        boolean $$12 = p_282097_ + p_281304_ + this.x + this.width + 26 >= this.tab.getScreen().width;
        Component $$13 = this.progress == null ? null : this.progress.getProgressText();
        int $$14 = $$13 == null ? 0 : $$6.width($$13);
        boolean $$15 = $$9 + $$11 >= 113;
        float $$16 = this.progress == null ? 0.0f : this.progress.getPercent();
        int $$17 = Mth.floor($$16 * (float)this.width);
        if ($$16 >= 1.0f) {
            $$17 = this.width / 2;
            AdvancementWidgetType $$18 = AdvancementWidgetType.OBTAINED;
            AdvancementWidgetType $$19 = AdvancementWidgetType.OBTAINED;
            AdvancementWidgetType $$20 = AdvancementWidgetType.OBTAINED;
        } else if ($$17 < 2) {
            $$17 = this.width / 2;
            AdvancementWidgetType $$21 = AdvancementWidgetType.UNOBTAINED;
            AdvancementWidgetType $$22 = AdvancementWidgetType.UNOBTAINED;
            AdvancementWidgetType $$23 = AdvancementWidgetType.UNOBTAINED;
        } else if ($$17 > this.width - 2) {
            $$17 = this.width / 2;
            AdvancementWidgetType $$24 = AdvancementWidgetType.OBTAINED;
            AdvancementWidgetType $$25 = AdvancementWidgetType.OBTAINED;
            AdvancementWidgetType $$26 = AdvancementWidgetType.UNOBTAINED;
        } else {
            $$27 = AdvancementWidgetType.OBTAINED;
            $$28 = AdvancementWidgetType.UNOBTAINED;
            $$29 = AdvancementWidgetType.UNOBTAINED;
        }
        int $$30 = this.width - $$17;
        if ($$12) {
            int $$31 = p_281304_ + this.x - this.width + 26 + 6;
        } else {
            $$32 = p_281304_ + this.x;
        }
        int $$33 = $$7 + $$11;
        if (!this.description.isEmpty()) {
            if ($$15) {
                p_283068_.blitSprite(RenderPipelines.GUI_TEXTURED, TITLE_BOX_SPRITE, $$32, $$9 - $$33, this.width, $$33);
            } else {
                p_283068_.blitSprite(RenderPipelines.GUI_TEXTURED, TITLE_BOX_SPRITE, $$32, $$8, this.width, $$33);
            }
        }
        if ($$27 != $$28) {
            p_283068_.blitSprite(RenderPipelines.GUI_TEXTURED, $$27.boxSprite(), 200, $$7, 0, 0, $$32, $$8, $$17, $$7);
            p_283068_.blitSprite(RenderPipelines.GUI_TEXTURED, $$28.boxSprite(), 200, $$7, 200 - $$30, 0, $$32 + $$17, $$8, $$30, $$7);
        } else {
            p_283068_.blitSprite(RenderPipelines.GUI_TEXTURED, $$27.boxSprite(), $$32, $$8, this.width, $$7);
        }
        p_283068_.blitSprite(RenderPipelines.GUI_TEXTURED, $$29.frameSprite(this.display.getType()), p_281304_ + this.x + 3, p_281253_ + this.y, 26, 26);
        int $$34 = $$32 + 5;
        if ($$12) {
            this.drawMultilineText(p_283068_, this.titleLines, $$34, $$8 + 9, -1);
            if ($$13 != null) {
                p_283068_.drawString($$6, $$13, p_281304_ + this.x - $$14, $$8 + 9, -1);
            }
        } else {
            this.drawMultilineText(p_283068_, this.titleLines, p_281304_ + this.x + 32, $$8 + 9, -1);
            if ($$13 != null) {
                p_283068_.drawString($$6, $$13, p_281304_ + this.x + this.width - $$14 - 5, $$8 + 9, -1);
            }
        }
        if ($$15) {
            this.drawMultilineText(p_283068_, this.description, $$34, $$8 - $$10 + 1, -16711936);
        } else {
            this.drawMultilineText(p_283068_, this.description, $$34, $$9, -16711936);
        }
        p_283068_.renderFakeItem(this.display.getIcon(), p_281304_ + this.x + 8, p_281253_ + this.y + 5);
    }

    private void drawMultilineText(GuiGraphics p_382801_, List<FormattedCharSequence> p_382822_, int p_382842_, int p_383077_, int p_382892_) {
        Font $$5 = this.minecraft.font;
        for (int $$6 = 0; $$6 < p_382822_.size(); ++$$6) {
            p_382801_.drawString($$5, p_382822_.get($$6), p_382842_, p_383077_ + $$6 * $$5.lineHeight, p_382892_);
        }
    }

    public boolean isMouseOver(int p_97260_, int p_97261_, int p_97262_, int p_97263_) {
        if (this.display.isHidden() && (this.progress == null || !this.progress.isDone())) {
            return false;
        }
        int $$4 = p_97260_ + this.x;
        int $$5 = $$4 + 26;
        int $$6 = p_97261_ + this.y;
        int $$7 = $$6 + 26;
        return p_97262_ >= $$4 && p_97262_ <= $$5 && p_97263_ >= $$6 && p_97263_ <= $$7;
    }

    public void attachToParent() {
        if (this.parent == null && this.advancementNode.parent() != null) {
            this.parent = this.getFirstVisibleParent(this.advancementNode);
            if (this.parent != null) {
                this.parent.addChild(this);
            }
        }
    }

    public int getY() {
        return this.y;
    }

    public int getX() {
        return this.x;
    }
}

