/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.render.pip;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.GuiItemRenderState;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.gui.render.state.pip.OversizedItemRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.item.TrackingItemStackRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;

public class OversizedItemRenderer
extends PictureInPictureRenderer<OversizedItemRenderState> {
    private boolean usedOnThisFrame;
    @Nullable
    private Object modelOnTextureIdentity;

    public OversizedItemRenderer(MultiBufferSource.BufferSource p_428518_) {
        super(p_428518_);
    }

    public boolean usedOnThisFrame() {
        return this.usedOnThisFrame;
    }

    public void resetUsedOnThisFrame() {
        this.usedOnThisFrame = false;
    }

    public void invalidateTexture() {
        this.modelOnTextureIdentity = null;
    }

    @Override
    public Class<OversizedItemRenderState> getRenderStateClass() {
        return OversizedItemRenderState.class;
    }

    @Override
    protected void renderToTexture(OversizedItemRenderState p_428332_, PoseStack p_428499_) {
        boolean $$9;
        p_428499_.scale(1.0f, -1.0f, -1.0f);
        GuiItemRenderState $$2 = p_428332_.guiItemRenderState();
        ScreenRectangle $$3 = $$2.oversizedItemBounds();
        Objects.requireNonNull($$3);
        float $$4 = (float)($$3.left() + $$3.right()) / 2.0f;
        float $$5 = (float)($$3.top() + $$3.bottom()) / 2.0f;
        float $$6 = (float)$$2.x() + 8.0f;
        float $$7 = (float)$$2.y() + 8.0f;
        p_428499_.translate(($$6 - $$4) / 16.0f, ($$5 - $$7) / 16.0f, 0.0f);
        TrackingItemStackRenderState $$8 = $$2.itemStackRenderState();
        boolean bl = $$9 = !$$8.usesBlockLight();
        if ($$9) {
            Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ITEMS_FLAT);
        } else {
            Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ITEMS_3D);
        }
        $$8.render(p_428499_, this.bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY);
        this.modelOnTextureIdentity = $$8.getModelIdentity();
    }

    @Override
    public void blitTexture(OversizedItemRenderState p_428390_, GuiRenderState p_428372_) {
        super.blitTexture(p_428390_, p_428372_);
        this.usedOnThisFrame = true;
    }

    @Override
    public boolean textureIsReadyToBlit(OversizedItemRenderState p_428573_) {
        TrackingItemStackRenderState $$1 = p_428573_.guiItemRenderState().itemStackRenderState();
        return !$$1.isAnimated() && $$1.getModelIdentity().equals(this.modelOnTextureIdentity);
    }

    @Override
    protected float getTranslateY(int p_428340_, int p_428276_) {
        return (float)p_428340_ / 2.0f;
    }

    @Override
    protected String getTextureLabel() {
        return "oversized_item";
    }
}

