/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.render;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.pip.OversizedItemRenderer;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.BlitRenderState;
import net.minecraft.client.gui.render.state.GlyphEffectRenderState;
import net.minecraft.client.gui.render.state.GlyphRenderState;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.gui.render.state.GuiItemRenderState;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.gui.render.state.pip.OversizedItemRenderState;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.renderer.CachedOrthoProjectionMatrixBuffer;
import net.minecraft.client.renderer.MappableRingBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.item.TrackingItemStackRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.joml.Matrix3x2f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;

public class GuiRenderer
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final float MAX_GUI_Z = 10000.0f;
    private static final float MIN_GUI_Z = 0.0f;
    private static final float GUI_Z_NEAR = 1000.0f;
    public static final int GUI_3D_Z_FAR = 1000;
    public static final int GUI_3D_Z_NEAR = -1000;
    public static final int DEFAULT_ITEM_SIZE = 16;
    private static final int MINIMUM_ITEM_ATLAS_SIZE = 512;
    private static final int MAXIMUM_ITEM_ATLAS_SIZE = RenderSystem.getDevice().getMaxTextureSize();
    public static final int CLEAR_COLOR = 0;
    private static final Comparator<ScreenRectangle> SCISSOR_COMPARATOR = Comparator.nullsFirst(Comparator.comparing(ScreenRectangle::top).thenComparing(ScreenRectangle::bottom).thenComparing(ScreenRectangle::left).thenComparing(ScreenRectangle::right));
    private static final Comparator<TextureSetup> TEXTURE_COMPARATOR = Comparator.nullsFirst(Comparator.comparing(TextureSetup::getSortKey));
    private static final Comparator<GuiElementRenderState> ELEMENT_SORT_COMPARATOR = Comparator.comparing(GuiElementRenderState::scissorArea, SCISSOR_COMPARATOR).thenComparing(GuiElementRenderState::pipeline, Comparator.comparing(RenderPipeline::getSortKey)).thenComparing(GuiElementRenderState::textureSetup, TEXTURE_COMPARATOR);
    private final Map<Object, AtlasPosition> atlasPositions = new Object2ObjectOpenHashMap();
    private final Map<Object, OversizedItemRenderer> oversizedItemRenderers = new Object2ObjectOpenHashMap();
    final GuiRenderState renderState;
    private final List<Draw> draws = new ArrayList<Draw>();
    private final List<MeshToDraw> meshesToDraw = new ArrayList<MeshToDraw>();
    private final ByteBufferBuilder byteBufferBuilder = new ByteBufferBuilder(786432);
    private final Map<VertexFormat, MappableRingBuffer> vertexBuffers = new Object2ObjectOpenHashMap();
    private int firstDrawIndexAfterBlur = Integer.MAX_VALUE;
    private final CachedOrthoProjectionMatrixBuffer guiProjectionMatrixBuffer = new CachedOrthoProjectionMatrixBuffer("gui", 1000.0f, 11000.0f, true);
    private final CachedOrthoProjectionMatrixBuffer itemsProjectionMatrixBuffer = new CachedOrthoProjectionMatrixBuffer("items", -1000.0f, 1000.0f, true);
    private final MultiBufferSource.BufferSource bufferSource;
    private final Map<Class<? extends PictureInPictureRenderState>, PictureInPictureRenderer<?>> pictureInPictureRenderers;
    @Nullable
    private GpuTexture itemsAtlas;
    @Nullable
    private GpuTextureView itemsAtlasView;
    @Nullable
    private GpuTexture itemsAtlasDepth;
    @Nullable
    private GpuTextureView itemsAtlasDepthView;
    private int itemAtlasX;
    private int itemAtlasY;
    private int cachedGuiScale;
    private int frameNumber;
    @Nullable
    private ScreenRectangle previousScissorArea = null;
    @Nullable
    private RenderPipeline previousPipeline = null;
    @Nullable
    private TextureSetup previousTextureSetup = null;
    @Nullable
    private BufferBuilder bufferBuilder = null;

    public GuiRenderer(GuiRenderState p_416418_, MultiBufferSource.BufferSource p_415673_, List<PictureInPictureRenderer<?>> p_415849_) {
        this.renderState = p_416418_;
        this.bufferSource = p_415673_;
        ImmutableMap.Builder $$3 = ImmutableMap.builder();
        for (PictureInPictureRenderer<?> $$4 : p_415849_) {
            $$3.put($$4.getRenderStateClass(), $$4);
        }
        this.pictureInPictureRenderers = $$3.buildOrThrow();
    }

    public void incrementFrameNumber() {
        ++this.frameNumber;
    }

    public void render(GpuBufferSlice p_418236_) {
        this.prepare();
        this.draw(p_418236_);
        for (MappableRingBuffer $$1 : this.vertexBuffers.values()) {
            $$1.rotate();
        }
        this.draws.clear();
        this.meshesToDraw.clear();
        this.renderState.reset();
        this.firstDrawIndexAfterBlur = Integer.MAX_VALUE;
        this.clearUnusedOversizedItemRenderers();
    }

    private void clearUnusedOversizedItemRenderers() {
        Iterator<Map.Entry<Object, OversizedItemRenderer>> $$0 = this.oversizedItemRenderers.entrySet().iterator();
        while ($$0.hasNext()) {
            Map.Entry<Object, OversizedItemRenderer> $$1 = $$0.next();
            OversizedItemRenderer $$2 = $$1.getValue();
            if (!$$2.usedOnThisFrame()) {
                $$2.close();
                $$0.remove();
                continue;
            }
            $$2.resetUsedOnThisFrame();
        }
    }

    private void prepare() {
        this.bufferSource.endBatch();
        this.preparePictureInPicture();
        this.prepareItemElements();
        this.prepareText();
        this.renderState.sortElements(ELEMENT_SORT_COMPARATOR);
        this.addElementsToMeshes(GuiRenderState.TraverseRange.BEFORE_BLUR);
        this.firstDrawIndexAfterBlur = this.meshesToDraw.size();
        this.addElementsToMeshes(GuiRenderState.TraverseRange.AFTER_BLUR);
        this.recordDraws();
    }

    private void addElementsToMeshes(GuiRenderState.TraverseRange p_419768_) {
        this.previousScissorArea = null;
        this.previousPipeline = null;
        this.previousTextureSetup = null;
        this.bufferBuilder = null;
        this.renderState.forEachElement(this::addElementToMesh, p_419768_);
        if (this.bufferBuilder != null) {
            this.recordMesh(this.bufferBuilder, this.previousPipeline, this.previousTextureSetup, this.previousScissorArea);
        }
    }

    private void draw(GpuBufferSlice p_419894_) {
        if (this.draws.isEmpty()) {
            return;
        }
        Minecraft $$1 = Minecraft.getInstance();
        Window $$2 = $$1.getWindow();
        RenderSystem.setProjectionMatrix(this.guiProjectionMatrixBuffer.getBuffer((float)$$2.getWidth() / (float)$$2.getGuiScale(), (float)$$2.getHeight() / (float)$$2.getGuiScale()), ProjectionType.ORTHOGRAPHIC);
        RenderTarget $$3 = $$1.getMainRenderTarget();
        int $$4 = 0;
        for (Draw $$5 : this.draws) {
            if ($$5.indexCount <= $$4) continue;
            $$4 = $$5.indexCount;
        }
        RenderSystem.AutoStorageIndexBuffer $$6 = RenderSystem.getSequentialBuffer(VertexFormat.Mode.QUADS);
        GpuBuffer $$7 = $$6.getBuffer($$4);
        VertexFormat.IndexType $$8 = $$6.type();
        GpuBufferSlice $$9 = RenderSystem.getDynamicUniforms().writeTransform((Matrix4fc)new Matrix4f().setTranslation(0.0f, 0.0f, -11000.0f), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
        if (this.firstDrawIndexAfterBlur > 0) {
            this.executeDrawRange(() -> "GUI before blur", $$3, p_419894_, $$9, $$7, $$8, 0, Math.min(this.firstDrawIndexAfterBlur, this.draws.size()));
        }
        if (this.draws.size() <= this.firstDrawIndexAfterBlur) {
            return;
        }
        RenderSystem.getDevice().createCommandEncoder().clearDepthTexture($$3.getDepthTexture(), 1.0);
        $$1.gameRenderer.processBlurEffect();
        this.executeDrawRange(() -> "GUI after blur", $$3, p_419894_, $$9, $$7, $$8, this.firstDrawIndexAfterBlur, this.draws.size());
    }

    private void executeDrawRange(Supplier<String> p_420024_, RenderTarget p_419589_, GpuBufferSlice p_419814_, GpuBufferSlice p_419632_, GpuBuffer p_419743_, VertexFormat.IndexType p_419509_, int p_419798_, int p_419773_) {
        try (RenderPass $$8 = RenderSystem.getDevice().createCommandEncoder().createRenderPass(p_420024_, p_419589_.getColorTextureView(), OptionalInt.empty(), p_419589_.useDepth ? p_419589_.getDepthTextureView() : null, OptionalDouble.empty());){
            RenderSystem.bindDefaultUniforms($$8);
            $$8.setUniform("Fog", p_419814_);
            $$8.setUniform("DynamicTransforms", p_419632_);
            for (int $$9 = p_419798_; $$9 < p_419773_; ++$$9) {
                Draw $$10 = this.draws.get($$9);
                this.executeDraw($$10, $$8, p_419743_, p_419509_);
            }
        }
    }

    private void addElementToMesh(GuiElementRenderState p_419849_, int p_419994_) {
        RenderPipeline $$2 = p_419849_.pipeline();
        TextureSetup $$3 = p_419849_.textureSetup();
        ScreenRectangle $$4 = p_419849_.scissorArea();
        if ($$2 != this.previousPipeline || this.scissorChanged($$4, this.previousScissorArea) || !$$3.equals(this.previousTextureSetup)) {
            if (this.bufferBuilder != null) {
                this.recordMesh(this.bufferBuilder, this.previousPipeline, this.previousTextureSetup, this.previousScissorArea);
            }
            this.bufferBuilder = this.getBufferBuilder($$2);
            this.previousPipeline = $$2;
            this.previousTextureSetup = $$3;
            this.previousScissorArea = $$4;
        }
        p_419849_.buildVertices(this.bufferBuilder, 0.0f + (float)p_419994_);
    }

    private void prepareText() {
        this.renderState.forEachText(p_425133_ -> {
            final Matrix3x2f $$1 = p_425133_.pose;
            final ScreenRectangle $$2 = p_425133_.scissor;
            p_425133_.ensurePrepared().visit(new Font.GlyphVisitor(){

                @Override
                public void acceptGlyph(BakedGlyph.GlyphInstance p_426097_) {
                    if (p_426097_.glyph().textureView() != null) {
                        GuiRenderer.this.renderState.submitGlyphToCurrentLayer(new GlyphRenderState($$1, p_426097_, $$2));
                    }
                }

                @Override
                public void acceptEffect(BakedGlyph p_425758_, BakedGlyph.Effect p_426319_) {
                    if (p_425758_.textureView() != null) {
                        GuiRenderer.this.renderState.submitGlyphToCurrentLayer(new GlyphEffectRenderState($$1, p_425758_, p_426319_, $$2));
                    }
                }
            });
        });
    }

    private void prepareItemElements() {
        if (this.renderState.getItemModelIdentities().isEmpty()) {
            return;
        }
        int $$0 = this.getGuiScaleInvalidatingItemAtlasIfChanged();
        int $$1 = 16 * $$0;
        int $$2 = this.calculateAtlasSizeInPixels($$1);
        if (this.itemsAtlas == null) {
            this.createAtlasTextures($$2);
        }
        RenderSystem.outputColorTextureOverride = this.itemsAtlasView;
        RenderSystem.outputDepthTextureOverride = this.itemsAtlasDepthView;
        RenderSystem.setProjectionMatrix(this.itemsProjectionMatrixBuffer.getBuffer($$2, $$2), ProjectionType.ORTHOGRAPHIC);
        Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ITEMS_3D);
        PoseStack $$3 = new PoseStack();
        MutableBoolean $$4 = new MutableBoolean(false);
        MutableBoolean $$5 = new MutableBoolean(false);
        this.renderState.forEachItem(p_428048_ -> {
            int $$10;
            boolean $$8;
            if (p_428048_.oversizedItemBounds() != null) {
                $$5.setTrue();
                return;
            }
            TrackingItemStackRenderState $$6 = p_428048_.itemStackRenderState();
            AtlasPosition $$7 = this.atlasPositions.get($$6.getModelIdentity());
            if (!($$7 == null || $$6.isAnimated() && $$7.lastAnimatedOnFrame != this.frameNumber)) {
                this.submitBlitFromItemAtlas((GuiItemRenderState)p_428048_, $$7.u, $$7.v, $$1, $$2);
                return;
            }
            if (this.itemAtlasX + $$1 > $$2) {
                this.itemAtlasX = 0;
                this.itemAtlasY += $$1;
            }
            boolean bl = $$8 = $$6.isAnimated() && $$7 != null;
            if (!$$8 && this.itemAtlasY + $$1 > $$2) {
                if ($$4.isFalse()) {
                    LOGGER.warn("Trying to render too many items in GUI at the same time. Skipping some of them.");
                    $$4.setTrue();
                }
                return;
            }
            int $$9 = $$8 ? $$7.x : this.itemAtlasX;
            int n = $$10 = $$8 ? $$7.y : this.itemAtlasY;
            if ($$8) {
                RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(this.itemsAtlas, 0, this.itemsAtlasDepth, 1.0, $$9, $$2 - $$10 - $$1, $$1, $$1);
            }
            this.renderItemToAtlas($$6, $$3, $$9, $$10, $$1);
            float $$11 = (float)$$9 / (float)$$2;
            float $$12 = (float)($$2 - $$10) / (float)$$2;
            this.submitBlitFromItemAtlas((GuiItemRenderState)p_428048_, $$11, $$12, $$1, $$2);
            if ($$8) {
                $$7.lastAnimatedOnFrame = this.frameNumber;
            } else {
                this.atlasPositions.put(p_428048_.itemStackRenderState().getModelIdentity(), new AtlasPosition(this.itemAtlasX, this.itemAtlasY, $$11, $$12, this.frameNumber));
                this.itemAtlasX += $$1;
            }
        });
        RenderSystem.outputColorTextureOverride = null;
        RenderSystem.outputDepthTextureOverride = null;
        if ($$5.getValue().booleanValue()) {
            this.renderState.forEachItem(p_428050_ -> {
                if (p_428050_.oversizedItemBounds() != null) {
                    TrackingItemStackRenderState $$2 = p_428050_.itemStackRenderState();
                    OversizedItemRenderer $$3 = this.oversizedItemRenderers.computeIfAbsent($$2.getModelIdentity(), p_428051_ -> new OversizedItemRenderer(this.bufferSource));
                    ScreenRectangle $$4 = p_428050_.oversizedItemBounds();
                    OversizedItemRenderState $$5 = new OversizedItemRenderState((GuiItemRenderState)p_428050_, $$4.left(), $$4.top(), $$4.right(), $$4.bottom());
                    $$3.prepare($$5, this.renderState, $$0);
                }
            });
        }
    }

    private void preparePictureInPicture() {
        int $$0 = Minecraft.getInstance().getWindow().getGuiScale();
        this.renderState.forEachPictureInPicture(p_417621_ -> this.preparePictureInPictureState(p_417621_, $$0));
    }

    private <T extends PictureInPictureRenderState> void preparePictureInPictureState(T p_415554_, int p_415565_) {
        PictureInPictureRenderer<?> $$2 = this.pictureInPictureRenderers.get(p_415554_.getClass());
        if ($$2 != null) {
            $$2.prepare(p_415554_, this.renderState, p_415565_);
        }
    }

    private void renderItemToAtlas(TrackingItemStackRenderState p_428843_, PoseStack p_416703_, int p_416443_, int p_416400_, int p_416052_) {
        boolean $$5;
        p_416703_.pushPose();
        p_416703_.translate((float)p_416443_ + (float)p_416052_ / 2.0f, (float)p_416400_ + (float)p_416052_ / 2.0f, 0.0f);
        p_416703_.scale(p_416052_, -p_416052_, p_416052_);
        boolean bl = $$5 = !p_428843_.usesBlockLight();
        if ($$5) {
            Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ITEMS_FLAT);
        } else {
            Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ITEMS_3D);
        }
        RenderSystem.enableScissorForRenderTypeDraws(p_416443_, this.itemsAtlas.getHeight(0) - p_416400_ - p_416052_, p_416052_, p_416052_);
        p_428843_.render(p_416703_, this.bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY);
        this.bufferSource.endBatch();
        RenderSystem.disableScissorForRenderTypeDraws();
        p_416703_.popPose();
    }

    private void submitBlitFromItemAtlas(GuiItemRenderState p_416534_, float p_416284_, float p_416546_, int p_415743_, int p_416437_) {
        float $$5 = p_416284_ + (float)p_415743_ / (float)p_416437_;
        float $$6 = p_416546_ + (float)(-p_415743_) / (float)p_416437_;
        this.renderState.submitBlitToCurrentLayer(new BlitRenderState(RenderPipelines.GUI_TEXTURED_PREMULTIPLIED_ALPHA, TextureSetup.singleTexture(this.itemsAtlasView), p_416534_.pose(), p_416534_.x(), p_416534_.y(), p_416534_.x() + 16, p_416534_.y() + 16, p_416284_, $$5, p_416546_, $$6, -1, p_416534_.scissorArea(), null));
    }

    private void createAtlasTextures(int p_416115_) {
        GpuDevice $$1 = RenderSystem.getDevice();
        this.itemsAtlas = $$1.createTexture("UI items atlas", 12, TextureFormat.RGBA8, p_416115_, p_416115_, 1, 1);
        this.itemsAtlas.setTextureFilter(FilterMode.NEAREST, false);
        this.itemsAtlasView = $$1.createTextureView(this.itemsAtlas);
        this.itemsAtlasDepth = $$1.createTexture("UI items atlas depth", 8, TextureFormat.DEPTH32, p_416115_, p_416115_, 1, 1);
        this.itemsAtlasDepthView = $$1.createTextureView(this.itemsAtlasDepth);
        $$1.createCommandEncoder().clearColorAndDepthTextures(this.itemsAtlas, 0, this.itemsAtlasDepth, 1.0);
    }

    private int calculateAtlasSizeInPixels(int p_415560_) {
        int $$3;
        Set<Object> $$1 = this.renderState.getItemModelIdentities();
        if (this.atlasPositions.isEmpty()) {
            int $$2 = $$1.size();
        } else {
            $$3 = this.atlasPositions.size();
            for (Object $$4 : $$1) {
                if (this.atlasPositions.containsKey($$4)) continue;
                ++$$3;
            }
        }
        if (this.itemsAtlas != null) {
            int $$5 = this.itemsAtlas.getWidth(0) / p_415560_;
            int $$6 = $$5 * $$5;
            if ($$3 < $$6) {
                return this.itemsAtlas.getWidth(0);
            }
            this.invalidateItemAtlas();
        }
        int $$7 = $$1.size();
        int $$8 = Mth.smallestSquareSide($$7 + $$7 / 2);
        return Math.clamp((long)Mth.smallestEncompassingPowerOfTwo($$8 * p_415560_), 512, MAXIMUM_ITEM_ATLAS_SIZE);
    }

    private int getGuiScaleInvalidatingItemAtlasIfChanged() {
        int $$0 = Minecraft.getInstance().getWindow().getGuiScale();
        if ($$0 != this.cachedGuiScale) {
            this.invalidateItemAtlas();
            for (OversizedItemRenderer $$1 : this.oversizedItemRenderers.values()) {
                $$1.invalidateTexture();
            }
            this.cachedGuiScale = $$0;
        }
        return $$0;
    }

    private void invalidateItemAtlas() {
        this.itemAtlasX = 0;
        this.itemAtlasY = 0;
        this.atlasPositions.clear();
        if (this.itemsAtlas != null) {
            this.itemsAtlas.close();
            this.itemsAtlas = null;
        }
        if (this.itemsAtlasView != null) {
            this.itemsAtlasView.close();
            this.itemsAtlasView = null;
        }
        if (this.itemsAtlasDepth != null) {
            this.itemsAtlasDepth.close();
            this.itemsAtlasDepth = null;
        }
        if (this.itemsAtlasDepthView != null) {
            this.itemsAtlasDepthView.close();
            this.itemsAtlasDepthView = null;
        }
    }

    private void recordMesh(BufferBuilder p_419584_, RenderPipeline p_419793_, TextureSetup p_419987_, @Nullable ScreenRectangle p_419796_) {
        MeshData $$4 = p_419584_.buildOrThrow();
        this.meshesToDraw.add(new MeshToDraw($$4, p_419793_, p_419987_, p_419796_));
    }

    private void recordDraws() {
        this.ensureVertexBufferSizes();
        CommandEncoder $$0 = RenderSystem.getDevice().createCommandEncoder();
        Object2IntOpenHashMap $$1 = new Object2IntOpenHashMap();
        for (MeshToDraw $$2 : this.meshesToDraw) {
            MeshData $$3 = $$2.mesh;
            MeshData.DrawState $$4 = $$3.drawState();
            VertexFormat $$5 = $$4.format();
            MappableRingBuffer $$6 = this.vertexBuffers.get($$5);
            if (!$$1.containsKey((Object)$$5)) {
                $$1.put((Object)$$5, 0);
            }
            ByteBuffer $$7 = $$3.vertexBuffer();
            int $$8 = $$7.remaining();
            int $$9 = $$1.getInt((Object)$$5);
            try (GpuBuffer.MappedView $$10 = $$0.mapBuffer($$6.currentBuffer().slice($$9, $$8), false, true);){
                MemoryUtil.memCopy((ByteBuffer)$$7, (ByteBuffer)$$10.data());
            }
            $$1.put((Object)$$5, $$9 + $$8);
            this.draws.add(new Draw($$6.currentBuffer(), $$9 / $$5.getVertexSize(), $$4.mode(), $$4.indexCount(), $$2.pipeline, $$2.textureSetup, $$2.scissorArea));
            $$2.close();
        }
    }

    private void ensureVertexBufferSizes() {
        Object2IntMap<VertexFormat> $$0 = this.calculatedRequiredVertexBufferSizes();
        for (Object2IntMap.Entry $$1 : $$0.object2IntEntrySet()) {
            VertexFormat $$2 = (VertexFormat)$$1.getKey();
            int $$3 = $$1.getIntValue();
            MappableRingBuffer $$4 = this.vertexBuffers.get($$2);
            if ($$4 != null && $$4.size() >= $$3) continue;
            if ($$4 != null) {
                $$4.close();
            }
            this.vertexBuffers.put($$2, new MappableRingBuffer(() -> "GUI vertex buffer for " + String.valueOf($$2), 34, $$3));
        }
    }

    private Object2IntMap<VertexFormat> calculatedRequiredVertexBufferSizes() {
        Object2IntOpenHashMap $$0 = new Object2IntOpenHashMap();
        for (MeshToDraw $$1 : this.meshesToDraw) {
            MeshData.DrawState $$2 = $$1.mesh.drawState();
            VertexFormat $$3 = $$2.format();
            if (!$$0.containsKey((Object)$$3)) {
                $$0.put((Object)$$3, 0);
            }
            $$0.put((Object)$$3, $$0.getInt((Object)$$3) + $$2.vertexCount() * $$3.getVertexSize());
        }
        return $$0;
    }

    private void executeDraw(Draw p_416097_, RenderPass p_416119_, GpuBuffer p_416661_, VertexFormat.IndexType p_415757_) {
        RenderPipeline $$4 = p_416097_.pipeline();
        p_416119_.setPipeline($$4);
        p_416119_.setVertexBuffer(0, p_416097_.vertexBuffer);
        ScreenRectangle $$5 = p_416097_.scissorArea();
        if ($$5 != null) {
            this.enableScissor($$5, p_416119_);
        } else {
            p_416119_.disableScissor();
        }
        if (p_416097_.textureSetup.texure0() != null) {
            p_416119_.bindSampler("Sampler0", p_416097_.textureSetup.texure0());
        }
        if (p_416097_.textureSetup.texure1() != null) {
            p_416119_.bindSampler("Sampler1", p_416097_.textureSetup.texure1());
        }
        if (p_416097_.textureSetup.texure2() != null) {
            p_416119_.bindSampler("Sampler2", p_416097_.textureSetup.texure2());
        }
        p_416119_.setIndexBuffer(p_416661_, p_415757_);
        p_416119_.drawIndexed(p_416097_.baseVertex, 0, p_416097_.indexCount, 1);
    }

    private BufferBuilder getBufferBuilder(RenderPipeline p_416066_) {
        return new BufferBuilder(this.byteBufferBuilder, p_416066_.getVertexFormatMode(), p_416066_.getVertexFormat());
    }

    private boolean scissorChanged(@Nullable ScreenRectangle p_416356_, @Nullable ScreenRectangle p_416077_) {
        if (p_416356_ == p_416077_) {
            return false;
        }
        if (p_416356_ != null) {
            return !p_416356_.equals(p_416077_);
        }
        return true;
    }

    private void enableScissor(ScreenRectangle p_416458_, RenderPass p_416455_) {
        Window $$2 = Minecraft.getInstance().getWindow();
        int $$3 = $$2.getHeight();
        int $$4 = $$2.getGuiScale();
        double $$5 = p_416458_.left() * $$4;
        double $$6 = $$3 - p_416458_.bottom() * $$4;
        double $$7 = p_416458_.width() * $$4;
        double $$8 = p_416458_.height() * $$4;
        p_416455_.enableScissor((int)$$5, (int)$$6, Math.max(0, (int)$$7), Math.max(0, (int)$$8));
    }

    @Override
    public void close() {
        this.byteBufferBuilder.close();
        if (this.itemsAtlas != null) {
            this.itemsAtlas.close();
        }
        if (this.itemsAtlasView != null) {
            this.itemsAtlasView.close();
        }
        if (this.itemsAtlasDepth != null) {
            this.itemsAtlasDepth.close();
        }
        if (this.itemsAtlasDepthView != null) {
            this.itemsAtlasDepthView.close();
        }
        this.pictureInPictureRenderers.values().forEach(PictureInPictureRenderer::close);
        this.guiProjectionMatrixBuffer.close();
        this.itemsProjectionMatrixBuffer.close();
        for (MappableRingBuffer $$0 : this.vertexBuffers.values()) {
            $$0.close();
        }
        this.oversizedItemRenderers.values().forEach(PictureInPictureRenderer::close);
    }

    record Draw(GpuBuffer vertexBuffer, int baseVertex, VertexFormat.Mode mode, int indexCount, RenderPipeline pipeline, TextureSetup textureSetup, @Nullable ScreenRectangle scissorArea) {
    }

    record MeshToDraw(MeshData mesh, RenderPipeline pipeline, TextureSetup textureSetup, @Nullable ScreenRectangle scissorArea) implements AutoCloseable
    {
        @Override
        public void close() {
            this.mesh.close();
        }
    }

    static final class AtlasPosition {
        final int x;
        final int y;
        final float u;
        final float v;
        int lastAnimatedOnFrame;

        AtlasPosition(int p_415957_, int p_416084_, float p_416595_, float p_416485_, int p_415830_) {
            this.x = p_415957_;
            this.y = p_416084_;
            this.u = p_416595_;
            this.v = p_416485_;
            this.lastAnimatedOnFrame = p_415830_;
        }
    }
}

