/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.font;

import com.mojang.blaze3d.font.SheetGlyphInfo;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.TextureFormat;
import java.nio.file.Path;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.font.GlyphRenderTypes;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.Dumpable;
import net.minecraft.resources.ResourceLocation;

public class FontTexture
extends AbstractTexture
implements Dumpable {
    private static final int SIZE = 256;
    private final GlyphRenderTypes renderTypes;
    private final boolean colored;
    private final Node root;

    public FontTexture(Supplier<String> p_405523_, GlyphRenderTypes p_285000_, boolean p_285085_) {
        this.colored = p_285085_;
        this.root = new Node(0, 0, 256, 256);
        GpuDevice $$3 = RenderSystem.getDevice();
        this.texture = $$3.createTexture(p_405523_, 7, p_285085_ ? TextureFormat.RGBA8 : TextureFormat.RED8, 256, 256, 1, 1);
        this.texture.setTextureFilter(FilterMode.NEAREST, false);
        this.textureView = $$3.createTextureView(this.texture);
        this.renderTypes = p_285000_;
    }

    @Nullable
    public BakedGlyph add(SheetGlyphInfo p_232569_) {
        if (p_232569_.isColored() != this.colored) {
            return null;
        }
        Node $$1 = this.root.insert(p_232569_);
        if ($$1 != null && this.texture != null && this.textureView != null) {
            p_232569_.upload($$1.x, $$1.y, this.texture);
            float $$2 = 256.0f;
            float $$3 = 256.0f;
            float $$4 = 0.01f;
            return new BakedGlyph(this.renderTypes, this.textureView, ((float)$$1.x + 0.01f) / 256.0f, ((float)$$1.x - 0.01f + (float)p_232569_.getPixelWidth()) / 256.0f, ((float)$$1.y + 0.01f) / 256.0f, ((float)$$1.y - 0.01f + (float)p_232569_.getPixelHeight()) / 256.0f, p_232569_.getLeft(), p_232569_.getRight(), p_232569_.getTop(), p_232569_.getBottom());
        }
        return null;
    }

    @Override
    public void dumpContents(ResourceLocation p_285121_, Path p_285511_) {
        if (this.texture == null) {
            return;
        }
        String $$2 = p_285121_.toDebugFileName();
        TextureUtil.writeAsPNG(p_285511_, $$2, this.texture, 0, p_285145_ -> (p_285145_ & 0xFF000000) == 0 ? -16777216 : p_285145_);
    }

    static class Node {
        final int x;
        final int y;
        private final int width;
        private final int height;
        @Nullable
        private Node left;
        @Nullable
        private Node right;
        private boolean occupied;

        Node(int p_95113_, int p_95114_, int p_95115_, int p_95116_) {
            this.x = p_95113_;
            this.y = p_95114_;
            this.width = p_95115_;
            this.height = p_95116_;
        }

        @Nullable
        Node insert(SheetGlyphInfo p_232571_) {
            if (this.left != null && this.right != null) {
                Node $$1 = this.left.insert(p_232571_);
                if ($$1 == null) {
                    $$1 = this.right.insert(p_232571_);
                }
                return $$1;
            }
            if (this.occupied) {
                return null;
            }
            int $$2 = p_232571_.getPixelWidth();
            int $$3 = p_232571_.getPixelHeight();
            if ($$2 > this.width || $$3 > this.height) {
                return null;
            }
            if ($$2 == this.width && $$3 == this.height) {
                this.occupied = true;
                return this;
            }
            int $$4 = this.width - $$2;
            int $$5 = this.height - $$3;
            if ($$4 > $$5) {
                this.left = new Node(this.x, this.y, $$2, this.height);
                this.right = new Node(this.x + $$2 + 1, this.y, this.width - $$2 - 1, this.height);
            } else {
                this.left = new Node(this.x, this.y, this.width, $$3);
                this.right = new Node(this.x, this.y + $$3 + 1, this.width, this.height - $$3 - 1);
            }
            return this.left.insert(p_232571_);
        }
    }
}

