/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.contextualbar;

import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.contextualbar.ContextualBarRenderer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.WaypointStyle;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.waypoints.TrackedWaypoint;
import net.minecraft.world.waypoints.Waypoint;

public class LocatorBarRenderer
implements ContextualBarRenderer {
    private static final ResourceLocation LOCATOR_BAR_BACKGROUND = ResourceLocation.withDefaultNamespace("hud/locator_bar_background");
    private static final ResourceLocation LOCATOR_BAR_ARROW_UP = ResourceLocation.withDefaultNamespace("hud/locator_bar_arrow_up");
    private static final ResourceLocation LOCATOR_BAR_ARROW_DOWN = ResourceLocation.withDefaultNamespace("hud/locator_bar_arrow_down");
    private static final int DOT_SIZE = 9;
    private static final int VISIBLE_DEGREE_RANGE = 60;
    private static final int ARROW_WIDTH = 7;
    private static final int ARROW_HEIGHT = 5;
    private static final int ARROW_LEFT = 1;
    private static final int ARROW_PADDING = 1;
    private final Minecraft minecraft;

    public LocatorBarRenderer(Minecraft p_416558_) {
        this.minecraft = p_416558_;
    }

    @Override
    public void renderBackground(GuiGraphics p_416273_, DeltaTracker p_416318_) {
        p_416273_.blitSprite(RenderPipelines.GUI_TEXTURED, LOCATOR_BAR_BACKGROUND, this.left(this.minecraft.getWindow()), this.top(this.minecraft.getWindow()), 182, 5);
    }

    @Override
    public void render(GuiGraphics p_415579_, DeltaTracker p_416560_) {
        int $$2 = this.top(this.minecraft.getWindow());
        Level $$3 = this.minecraft.cameraEntity.level();
        this.minecraft.player.connection.getWaypointManager().forEachWaypoint(this.minecraft.cameraEntity, p_421276_ -> {
            if (p_421276_.id().left().map(p_416129_ -> p_416129_.equals(this.minecraft.cameraEntity.getUUID())).orElse(false).booleanValue()) {
                return;
            }
            double $$4 = p_421276_.yawAngleToCamera($$3, this.minecraft.gameRenderer.getMainCamera());
            if ($$4 <= -61.0 || $$4 > 60.0) {
                return;
            }
            int $$5 = Mth.ceil((float)(p_415579_.guiWidth() - 9) / 2.0f);
            Waypoint.Icon $$6 = p_421276_.icon();
            WaypointStyle $$7 = this.minecraft.getWaypointStyles().get($$6.style);
            float $$8 = Mth.sqrt((float)p_421276_.distanceSquared(this.minecraft.cameraEntity));
            ResourceLocation $$9 = $$7.sprite($$8);
            int $$10 = $$6.color.orElseGet(() -> (Integer)p_421276_.id().map(p_419413_ -> ARGB.setBrightness(ARGB.color(255, p_419413_.hashCode()), 0.9f), p_419414_ -> ARGB.setBrightness(ARGB.color(255, p_419414_.hashCode()), 0.9f)));
            int $$11 = (int)($$4 * 173.0 / 2.0 / 60.0);
            p_415579_.blitSprite(RenderPipelines.GUI_TEXTURED, $$9, $$5 + $$11, $$2 - 2, 9, 9, $$10);
            TrackedWaypoint.PitchDirection $$12 = p_421276_.pitchDirectionToCamera($$3, this.minecraft.gameRenderer);
            if ($$12 != TrackedWaypoint.PitchDirection.NONE) {
                ResourceLocation $$16;
                int $$15;
                if ($$12 == TrackedWaypoint.PitchDirection.DOWN) {
                    int $$13 = 6;
                    ResourceLocation $$14 = LOCATOR_BAR_ARROW_DOWN;
                } else {
                    $$15 = -6;
                    $$16 = LOCATOR_BAR_ARROW_UP;
                }
                p_415579_.blitSprite(RenderPipelines.GUI_TEXTURED, $$16, $$5 + $$11 + 1, $$2 + $$15, 7, 5);
            }
        });
    }
}

