/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.contextualbar;

import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.contextualbar.ContextualBarRenderer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.PlayerRideableJumping;

public class JumpableVehicleBarRenderer
implements ContextualBarRenderer {
    private static final ResourceLocation JUMP_BAR_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace("hud/jump_bar_background");
    private static final ResourceLocation JUMP_BAR_COOLDOWN_SPRITE = ResourceLocation.withDefaultNamespace("hud/jump_bar_cooldown");
    private static final ResourceLocation JUMP_BAR_PROGRESS_SPRITE = ResourceLocation.withDefaultNamespace("hud/jump_bar_progress");
    private final Minecraft minecraft;
    private final PlayerRideableJumping playerJumpableVehicle;

    public JumpableVehicleBarRenderer(Minecraft p_415664_) {
        this.minecraft = p_415664_;
        this.playerJumpableVehicle = Objects.requireNonNull(p_415664_.player).jumpableVehicle();
    }

    @Override
    public void renderBackground(GuiGraphics p_415798_, DeltaTracker p_415750_) {
        int $$2 = this.left(this.minecraft.getWindow());
        int $$3 = this.top(this.minecraft.getWindow());
        p_415798_.blitSprite(RenderPipelines.GUI_TEXTURED, JUMP_BAR_BACKGROUND_SPRITE, $$2, $$3, 182, 5);
        if (this.playerJumpableVehicle.getJumpCooldown() > 0) {
            p_415798_.blitSprite(RenderPipelines.GUI_TEXTURED, JUMP_BAR_COOLDOWN_SPRITE, $$2, $$3, 182, 5);
            return;
        }
        int $$4 = (int)(this.minecraft.player.getJumpRidingScale() * 183.0f);
        if ($$4 > 0) {
            p_415798_.blitSprite(RenderPipelines.GUI_TEXTURED, JUMP_BAR_PROGRESS_SPRITE, 182, 5, 0, 0, $$2, $$3, $$4, 5);
        }
    }

    @Override
    public void render(GuiGraphics p_415999_, DeltaTracker p_416653_) {
    }
}

