/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components.toasts;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class TutorialToast
implements Toast {
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace("toast/tutorial");
    public static final int PROGRESS_BAR_WIDTH = 154;
    public static final int PROGRESS_BAR_HEIGHT = 1;
    public static final int PROGRESS_BAR_X = 3;
    public static final int PROGRESS_BAR_MARGIN_BOTTOM = 4;
    private static final int PADDING_TOP = 7;
    private static final int PADDING_BOTTOM = 3;
    private static final int LINE_SPACING = 11;
    private static final int TEXT_LEFT = 30;
    private static final int TEXT_WIDTH = 126;
    private final Icons icon;
    private final List<FormattedCharSequence> lines;
    private Toast.Visibility visibility = Toast.Visibility.SHOW;
    private long lastSmoothingTime;
    private float smoothedProgress;
    private float progress;
    private final boolean progressable;
    private final int timeToDisplayMs;

    public TutorialToast(Font p_383078_, Icons p_365013_, Component p_363481_, @Nullable Component p_365235_, boolean p_365276_, int p_363245_) {
        this.icon = p_365013_;
        this.lines = new ArrayList<FormattedCharSequence>(2);
        this.lines.addAll(p_383078_.split(p_363481_.copy().withColor(-11534256), 126));
        if (p_365235_ != null) {
            this.lines.addAll(p_383078_.split(p_365235_, 126));
        }
        this.progressable = p_365276_;
        this.timeToDisplayMs = p_363245_;
    }

    public TutorialToast(Font p_382988_, Icons p_94958_, Component p_94959_, @Nullable Component p_94960_, boolean p_94961_) {
        this(p_382988_, p_94958_, p_94959_, p_94960_, p_94961_, 0);
    }

    @Override
    public Toast.Visibility getWantedVisibility() {
        return this.visibility;
    }

    @Override
    public void update(ToastManager p_361676_, long p_362771_) {
        if (this.timeToDisplayMs > 0) {
            this.smoothedProgress = this.progress = Math.min((float)p_362771_ / (float)this.timeToDisplayMs, 1.0f);
            this.lastSmoothingTime = p_362771_;
            if (p_362771_ > (long)this.timeToDisplayMs) {
                this.hide();
            }
        } else if (this.progressable) {
            this.smoothedProgress = Mth.clampedLerp(this.smoothedProgress, this.progress, (float)(p_362771_ - this.lastSmoothingTime) / 100.0f);
            this.lastSmoothingTime = p_362771_;
        }
    }

    @Override
    public int height() {
        return 7 + this.contentHeight() + 3;
    }

    private int contentHeight() {
        return Math.max(this.lines.size(), 2) * 11;
    }

    @Override
    public void render(GuiGraphics p_283197_, Font p_364452_, long p_281902_) {
        int $$3 = this.height();
        p_283197_.blitSprite(RenderPipelines.GUI_TEXTURED, BACKGROUND_SPRITE, 0, 0, this.width(), $$3);
        this.icon.render(p_283197_, 6, 6);
        int $$4 = this.lines.size() * 11;
        int $$5 = 7 + (this.contentHeight() - $$4) / 2;
        for (int $$6 = 0; $$6 < this.lines.size(); ++$$6) {
            p_283197_.drawString(p_364452_, this.lines.get($$6), 30, $$5 + $$6 * 11, -16777216, false);
        }
        if (this.progressable) {
            int $$9;
            int $$7 = $$3 - 4;
            p_283197_.fill(3, $$7, 157, $$7 + 1, -1);
            if (this.progress >= this.smoothedProgress) {
                int $$8 = -16755456;
            } else {
                $$9 = -11206656;
            }
            p_283197_.fill(3, $$7, (int)(3.0f + 154.0f * this.smoothedProgress), $$7 + 1, $$9);
        }
    }

    public void hide() {
        this.visibility = Toast.Visibility.HIDE;
    }

    public void updateProgress(float p_94963_) {
        this.progress = p_94963_;
    }

    public static enum Icons {
        MOVEMENT_KEYS(ResourceLocation.withDefaultNamespace("toast/movement_keys")),
        MOUSE(ResourceLocation.withDefaultNamespace("toast/mouse")),
        TREE(ResourceLocation.withDefaultNamespace("toast/tree")),
        RECIPE_BOOK(ResourceLocation.withDefaultNamespace("toast/recipe_book")),
        WOODEN_PLANKS(ResourceLocation.withDefaultNamespace("toast/wooden_planks")),
        SOCIAL_INTERACTIONS(ResourceLocation.withDefaultNamespace("toast/social_interactions")),
        RIGHT_CLICK(ResourceLocation.withDefaultNamespace("toast/right_click"));

        private final ResourceLocation sprite;

        private Icons(ResourceLocation p_295332_) {
            this.sprite = p_295332_;
        }

        public void render(GuiGraphics p_282818_, int p_283064_, int p_282765_) {
            p_282818_.blitSprite(RenderPipelines.GUI_TEXTURED, this.sprite, p_283064_, p_282765_, 20, 20);
        }
    }
}

