/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components.toasts;

import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.NowPlayingToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class ToastManager {
    private static final int SLOT_COUNT = 5;
    private static final int ALL_SLOTS_OCCUPIED = -1;
    final Minecraft minecraft;
    private final List<ToastInstance<?>> visibleToasts = new ArrayList();
    private final BitSet occupiedSlots = new BitSet(5);
    private final Deque<Toast> queued = Queues.newArrayDeque();
    private final Set<SoundEvent> playedToastSounds = new HashSet<SoundEvent>();
    @Nullable
    private ToastInstance<NowPlayingToast> nowPlayingToast;

    public ToastManager(Minecraft p_361363_, Options p_426003_) {
        this.minecraft = p_361363_;
        if (p_426003_.showNowPlayingToast().get().booleanValue()) {
            this.createNowPlayingToast();
        }
    }

    public void update() {
        MutableBoolean $$0 = new MutableBoolean(false);
        this.visibleToasts.removeIf(p_392505_ -> {
            Toast.Visibility $$2 = p_392505_.visibility;
            p_392505_.update();
            if (p_392505_.visibility != $$2 && $$0.isFalse()) {
                $$0.setTrue();
                p_392505_.visibility.playSound(this.minecraft.getSoundManager());
            }
            if (p_392505_.hasFinishedRendering()) {
                this.occupiedSlots.clear(p_392505_.firstSlotIndex, p_392505_.firstSlotIndex + p_392505_.occupiedSlotCount);
                return true;
            }
            return false;
        });
        if (!this.queued.isEmpty() && this.freeSlotCount() > 0) {
            this.queued.removeIf(p_392506_ -> {
                int $$1 = p_392506_.occcupiedSlotCount();
                int $$2 = this.findFreeSlotsIndex($$1);
                if ($$2 == -1) {
                    return false;
                }
                this.visibleToasts.add(new ToastInstance(this, p_392506_, $$2, $$1));
                this.occupiedSlots.set($$2, $$2 + $$1);
                SoundEvent $$3 = p_392506_.getSoundEvent();
                if ($$3 != null && this.playedToastSounds.add($$3)) {
                    this.minecraft.getSoundManager().play(SimpleSoundInstance.forUI($$3, 1.0f, 1.0f));
                }
                return true;
            });
        }
        this.playedToastSounds.clear();
        if (this.nowPlayingToast != null) {
            this.nowPlayingToast.update();
        }
    }

    public void render(GuiGraphics p_362571_) {
        if (this.minecraft.options.hideGui) {
            return;
        }
        int $$1 = p_362571_.guiWidth();
        if (!this.visibleToasts.isEmpty()) {
            p_362571_.nextStratum();
        }
        for (ToastInstance<?> $$2 : this.visibleToasts) {
            $$2.render(p_362571_, $$1);
        }
        if (this.minecraft.options.showNowPlayingToast().get().booleanValue() && this.nowPlayingToast != null && (this.minecraft.screen == null || !(this.minecraft.screen instanceof PauseScreen))) {
            this.nowPlayingToast.render(p_362571_, $$1);
        }
    }

    private int findFreeSlotsIndex(int p_362291_) {
        if (this.freeSlotCount() >= p_362291_) {
            int $$1 = 0;
            for (int $$2 = 0; $$2 < 5; ++$$2) {
                if (this.occupiedSlots.get($$2)) {
                    $$1 = 0;
                    continue;
                }
                if (++$$1 != p_362291_) continue;
                return $$2 + 1 - $$1;
            }
        }
        return -1;
    }

    private int freeSlotCount() {
        return 5 - this.occupiedSlots.cardinality();
    }

    @Nullable
    public <T extends Toast> T getToast(Class<? extends T> p_361311_, Object p_361989_) {
        for (ToastInstance<?> $$2 : this.visibleToasts) {
            if ($$2 == null || !p_361311_.isAssignableFrom($$2.getToast().getClass()) || !$$2.getToast().getToken().equals(p_361989_)) continue;
            return (T)$$2.getToast();
        }
        for (Toast $$3 : this.queued) {
            if (!p_361311_.isAssignableFrom($$3.getClass()) || !$$3.getToken().equals(p_361989_)) continue;
            return (T)$$3;
        }
        return null;
    }

    public void clear() {
        this.occupiedSlots.clear();
        this.visibleToasts.clear();
        this.queued.clear();
    }

    public void addToast(Toast p_362712_) {
        this.queued.add(p_362712_);
    }

    public void showNowPlayingToast() {
        if (this.nowPlayingToast != null) {
            this.nowPlayingToast.resetToast();
            this.nowPlayingToast.getToast().showToast(this.minecraft.options);
        }
    }

    public void hideNowPlayingToast() {
        if (this.nowPlayingToast != null) {
            this.nowPlayingToast.getToast().setWantedVisibility(Toast.Visibility.HIDE);
        }
    }

    public void createNowPlayingToast() {
        this.nowPlayingToast = new ToastInstance(this, (Toast)new NowPlayingToast(), 0, 0);
    }

    public void removeNowPlayingToast() {
        this.nowPlayingToast = null;
    }

    public Minecraft getMinecraft() {
        return this.minecraft;
    }

    public double getNotificationDisplayTimeMultiplier() {
        return this.minecraft.options.notificationDisplayTime().get();
    }

    class ToastInstance<T extends Toast> {
        private static final long SLIDE_ANIMATION_DURATION_MS = 600L;
        private final T toast;
        final int firstSlotIndex;
        final int occupiedSlotCount;
        private long animationStartTime;
        private long becameFullyVisibleAt;
        Toast.Visibility visibility;
        private long fullyVisibleFor;
        private float visiblePortion;
        protected boolean hasFinishedRendering;
        final /* synthetic */ ToastManager this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        ToastInstance(T p_365175_, int p_365347_, int p_361399_) {
            this.this$0 = (ToastManager)n;
            this.toast = p_365175_;
            this.firstSlotIndex = p_365347_;
            this.occupiedSlotCount = p_361399_;
            this.resetToast();
        }

        public T getToast() {
            return this.toast;
        }

        public void resetToast() {
            this.animationStartTime = -1L;
            this.becameFullyVisibleAt = -1L;
            this.visibility = Toast.Visibility.HIDE;
            this.fullyVisibleFor = 0L;
            this.visiblePortion = 0.0f;
            this.hasFinishedRendering = false;
        }

        public boolean hasFinishedRendering() {
            return this.hasFinishedRendering;
        }

        private void calculateVisiblePortion(long p_362492_) {
            float $$1 = Mth.clamp((float)(p_362492_ - this.animationStartTime) / 600.0f, 0.0f, 1.0f);
            $$1 *= $$1;
            this.visiblePortion = this.visibility == Toast.Visibility.HIDE ? 1.0f - $$1 : $$1;
        }

        public void update() {
            long $$0 = Util.getMillis();
            if (this.animationStartTime == -1L) {
                this.animationStartTime = $$0;
                this.visibility = Toast.Visibility.SHOW;
            }
            if (this.visibility == Toast.Visibility.SHOW && $$0 - this.animationStartTime <= 600L) {
                this.becameFullyVisibleAt = $$0;
            }
            this.fullyVisibleFor = $$0 - this.becameFullyVisibleAt;
            this.calculateVisiblePortion($$0);
            this.toast.update(this.this$0, this.fullyVisibleFor);
            Toast.Visibility $$1 = this.toast.getWantedVisibility();
            if ($$1 != this.visibility) {
                this.animationStartTime = $$0 - (long)((int)((1.0f - this.visiblePortion) * 600.0f));
                this.visibility = $$1;
            }
            boolean $$2 = this.hasFinishedRendering;
            boolean bl = this.hasFinishedRendering = this.visibility == Toast.Visibility.HIDE && $$0 - this.animationStartTime > 600L;
            if (this.hasFinishedRendering && !$$2) {
                this.toast.onFinishedRendering();
            }
        }

        public void render(GuiGraphics p_362825_, int p_361934_) {
            if (this.hasFinishedRendering) {
                return;
            }
            p_362825_.pose().pushMatrix();
            p_362825_.pose().translate(this.toast.xPos(p_361934_, this.visiblePortion), this.toast.yPos(this.firstSlotIndex));
            this.toast.render(p_362825_, this.this$0.minecraft.font, this.fullyVisibleFor);
            p_362825_.pose().popMatrix();
        }
    }
}

