/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components;

import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractTextAreaWidget;
import net.minecraft.client.gui.components.MultilineTextField;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringUtil;

public class MultiLineEditBox
extends AbstractTextAreaWidget {
    private static final int CURSOR_INSERT_WIDTH = 1;
    private static final int CURSOR_COLOR = -3092272;
    private static final String CURSOR_APPEND_CHARACTER = "_";
    private static final int TEXT_COLOR = -2039584;
    private static final int PLACEHOLDER_TEXT_COLOR = -857677600;
    private static final int CURSOR_BLINK_INTERVAL_MS = 300;
    private final Font font;
    private final Component placeholder;
    private final MultilineTextField textField;
    private final int textColor;
    private final boolean textShadow;
    private final int cursorColor;
    private long focusedTime = Util.getMillis();

    MultiLineEditBox(Font p_239008_, int p_239009_, int p_239010_, int p_239011_, int p_239012_, Component p_239013_, Component p_239014_, int p_421931_, boolean p_421976_, int p_422714_, boolean p_422534_, boolean p_422133_) {
        super(p_239009_, p_239010_, p_239011_, p_239012_, p_239014_, p_422534_, p_422133_);
        this.font = p_239008_;
        this.textShadow = p_421976_;
        this.textColor = p_421931_;
        this.cursorColor = p_422714_;
        this.placeholder = p_239013_;
        this.textField = new MultilineTextField(p_239008_, p_239011_ - this.totalInnerPadding());
        this.textField.setCursorListener(this::scrollToCursor);
    }

    public void setCharacterLimit(int p_239314_) {
        this.textField.setCharacterLimit(p_239314_);
    }

    public void setLineLimit(int p_422446_) {
        this.textField.setLineLimit(p_422446_);
    }

    public void setValueListener(Consumer<String> p_239274_) {
        this.textField.setValueListener(p_239274_);
    }

    public void setValue(String p_240160_) {
        this.setValue(p_240160_, false);
    }

    public void setValue(String p_428788_, boolean p_428789_) {
        this.textField.setValue(p_428788_, p_428789_);
    }

    public String getValue() {
        return this.textField.value();
    }

    @Override
    public void updateWidgetNarration(NarrationElementOutput p_259393_) {
        p_259393_.add(NarratedElementType.TITLE, (Component)Component.translatable("gui.narrate.editBox", this.getMessage(), this.getValue()));
    }

    @Override
    public void onClick(double p_388397_, double p_388871_) {
        this.textField.setSelecting(Screen.hasShiftDown());
        this.seekCursorScreen(p_388397_, p_388871_);
    }

    @Override
    protected void onDrag(double p_387147_, double p_387062_, double p_388546_, double p_388296_) {
        this.textField.setSelecting(true);
        this.seekCursorScreen(p_387147_, p_387062_);
        this.textField.setSelecting(Screen.hasShiftDown());
    }

    @Override
    public boolean keyPressed(int p_239433_, int p_239434_, int p_239435_) {
        return this.textField.keyPressed(p_239433_);
    }

    @Override
    public boolean charTyped(char p_239387_, int p_239388_) {
        if (!(this.visible && this.isFocused() && StringUtil.isAllowedChatCharacter(p_239387_))) {
            return false;
        }
        this.textField.insertText(Character.toString(p_239387_));
        return true;
    }

    @Override
    protected void renderContents(GuiGraphics p_283676_, int p_281538_, int p_283033_, float p_281767_) {
        String $$4 = this.textField.value();
        if ($$4.isEmpty() && !this.isFocused()) {
            p_283676_.drawWordWrap(this.font, this.placeholder, this.getInnerLeft(), this.getInnerTop(), this.width - this.totalInnerPadding(), -857677600);
            return;
        }
        int $$5 = this.textField.cursor();
        boolean $$6 = this.isFocused() && (Util.getMillis() - this.focusedTime) / 300L % 2L == 0L;
        boolean $$7 = $$5 < $$4.length();
        int $$8 = 0;
        int $$9 = 0;
        int $$10 = this.getInnerTop();
        for (MultilineTextField.StringView $$11 : this.textField.iterateLines()) {
            boolean $$12 = this.withinContentAreaTopBottom($$10, $$10 + this.font.lineHeight);
            int $$13 = this.getInnerLeft();
            if ($$6 && $$7 && $$5 >= $$11.beginIndex() && $$5 < $$11.endIndex()) {
                if ($$12) {
                    String $$14 = $$4.substring($$11.beginIndex(), $$5);
                    p_283676_.drawString(this.font, $$14, $$13, $$10, this.textColor, this.textShadow);
                    $$8 = $$13 + this.font.width($$14);
                    p_283676_.fill($$8, $$10 - 1, $$8 + 1, $$10 + 1 + this.font.lineHeight, this.cursorColor);
                    p_283676_.drawString(this.font, $$4.substring($$5, $$11.endIndex()), $$8, $$10, this.textColor, this.textShadow);
                }
            } else {
                if ($$12) {
                    String $$15 = $$4.substring($$11.beginIndex(), $$11.endIndex());
                    p_283676_.drawString(this.font, $$15, $$13, $$10, this.textColor, this.textShadow);
                    $$8 = $$13 + this.font.width($$15) - 1;
                }
                $$9 = $$10;
            }
            $$10 += this.font.lineHeight;
        }
        if ($$6 && !$$7 && this.withinContentAreaTopBottom($$9, $$9 + this.font.lineHeight)) {
            p_283676_.drawString(this.font, CURSOR_APPEND_CHARACTER, $$8, $$9, this.cursorColor, this.textShadow);
        }
        if (this.textField.hasSelection()) {
            MultilineTextField.StringView $$16 = this.textField.getSelected();
            int $$17 = this.getInnerLeft();
            $$10 = this.getInnerTop();
            for (MultilineTextField.StringView $$18 : this.textField.iterateLines()) {
                if ($$16.beginIndex() > $$18.endIndex()) {
                    $$10 += this.font.lineHeight;
                    continue;
                }
                if ($$18.beginIndex() > $$16.endIndex()) break;
                if (this.withinContentAreaTopBottom($$10, $$10 + this.font.lineHeight)) {
                    int $$21;
                    int $$19 = this.font.width($$4.substring($$18.beginIndex(), Math.max($$16.beginIndex(), $$18.beginIndex())));
                    if ($$16.endIndex() > $$18.endIndex()) {
                        int $$20 = this.width - this.innerPadding();
                    } else {
                        $$21 = this.font.width($$4.substring($$18.beginIndex(), $$16.endIndex()));
                    }
                    p_283676_.textHighlight($$17 + $$19, $$10, $$17 + $$21, $$10 + this.font.lineHeight);
                }
                $$10 += this.font.lineHeight;
            }
        }
    }

    @Override
    protected void renderDecorations(GuiGraphics p_282551_) {
        super.renderDecorations(p_282551_);
        if (this.textField.hasCharacterLimit()) {
            int $$1 = this.textField.characterLimit();
            MutableComponent $$2 = Component.translatable("gui.multiLineEditBox.character_limit", this.textField.value().length(), $$1);
            p_282551_.drawString(this.font, $$2, this.getX() + this.width - this.font.width($$2), this.getY() + this.height + 4, -6250336);
        }
    }

    @Override
    public int getInnerHeight() {
        return this.font.lineHeight * this.textField.getLineCount();
    }

    @Override
    protected double scrollRate() {
        return (double)this.font.lineHeight / 2.0;
    }

    private void scrollToCursor() {
        double $$0 = this.scrollAmount();
        MultilineTextField.StringView $$1 = this.textField.getLineView((int)($$0 / (double)this.font.lineHeight));
        if (this.textField.cursor() <= $$1.beginIndex()) {
            $$0 = this.textField.getLineAtCursor() * this.font.lineHeight;
        } else {
            MultilineTextField.StringView $$2 = this.textField.getLineView((int)(($$0 + (double)this.height) / (double)this.font.lineHeight) - 1);
            if (this.textField.cursor() > $$2.endIndex()) {
                $$0 = this.textField.getLineAtCursor() * this.font.lineHeight - this.height + this.font.lineHeight + this.totalInnerPadding();
            }
        }
        this.setScrollAmount($$0);
    }

    private void seekCursorScreen(double p_239276_, double p_239277_) {
        double $$2 = p_239276_ - (double)this.getX() - (double)this.innerPadding();
        double $$3 = p_239277_ - (double)this.getY() - (double)this.innerPadding() + this.scrollAmount();
        this.textField.seekCursorToPoint($$2, $$3);
    }

    @Override
    public void setFocused(boolean p_295271_) {
        super.setFocused(p_295271_);
        if (p_295271_) {
            this.focusedTime = Util.getMillis();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int x;
        private int y;
        private Component placeholder = CommonComponents.EMPTY;
        private int textColor = -2039584;
        private boolean textShadow = true;
        private int cursorColor = -3092272;
        private boolean showBackground = true;
        private boolean showDecorations = true;

        public Builder setX(int p_422436_) {
            this.x = p_422436_;
            return this;
        }

        public Builder setY(int p_421818_) {
            this.y = p_421818_;
            return this;
        }

        public Builder setPlaceholder(Component p_421698_) {
            this.placeholder = p_421698_;
            return this;
        }

        public Builder setTextColor(int p_421781_) {
            this.textColor = p_421781_;
            return this;
        }

        public Builder setTextShadow(boolean p_421479_) {
            this.textShadow = p_421479_;
            return this;
        }

        public Builder setCursorColor(int p_421764_) {
            this.cursorColor = p_421764_;
            return this;
        }

        public Builder setShowBackground(boolean p_422685_) {
            this.showBackground = p_422685_;
            return this;
        }

        public Builder setShowDecorations(boolean p_422439_) {
            this.showDecorations = p_422439_;
            return this;
        }

        public MultiLineEditBox build(Font p_421794_, int p_422029_, int p_422516_, Component p_422409_) {
            return new MultiLineEditBox(p_421794_, this.x, this.y, p_422029_, p_422516_, this.placeholder, p_422409_, this.textColor, this.textShadow, this.cursorColor, this.showBackground, this.showDecorations);
        }
    }
}

