/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.mojang.blaze3d.platform.Window;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Optionull;
import net.minecraft.Util;
import net.minecraft.client.AttackIndicatorStatus;
import net.minecraft.client.CameraType;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.BossHealthOverlay;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import net.minecraft.client.gui.components.PlayerTabOverlay;
import net.minecraft.client.gui.components.SubtitleOverlay;
import net.minecraft.client.gui.components.spectator.SpectatorGui;
import net.minecraft.client.gui.contextualbar.ContextualBarRenderer;
import net.minecraft.client.gui.contextualbar.ExperienceBarRenderer;
import net.minecraft.client.gui.contextualbar.JumpableVehicleBarRenderer;
import net.minecraft.client.gui.contextualbar.LocatorBarRenderer;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.StyledFormat;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringUtil;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerScoreEntry;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import org.apache.commons.lang3.tuple.Pair;

public class Gui {
    private static final ResourceLocation CROSSHAIR_SPRITE = ResourceLocation.withDefaultNamespace("hud/crosshair");
    private static final ResourceLocation CROSSHAIR_ATTACK_INDICATOR_FULL_SPRITE = ResourceLocation.withDefaultNamespace("hud/crosshair_attack_indicator_full");
    private static final ResourceLocation CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace("hud/crosshair_attack_indicator_background");
    private static final ResourceLocation CROSSHAIR_ATTACK_INDICATOR_PROGRESS_SPRITE = ResourceLocation.withDefaultNamespace("hud/crosshair_attack_indicator_progress");
    private static final ResourceLocation EFFECT_BACKGROUND_AMBIENT_SPRITE = ResourceLocation.withDefaultNamespace("hud/effect_background_ambient");
    private static final ResourceLocation EFFECT_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace("hud/effect_background");
    private static final ResourceLocation HOTBAR_SPRITE = ResourceLocation.withDefaultNamespace("hud/hotbar");
    private static final ResourceLocation HOTBAR_SELECTION_SPRITE = ResourceLocation.withDefaultNamespace("hud/hotbar_selection");
    private static final ResourceLocation HOTBAR_OFFHAND_LEFT_SPRITE = ResourceLocation.withDefaultNamespace("hud/hotbar_offhand_left");
    private static final ResourceLocation HOTBAR_OFFHAND_RIGHT_SPRITE = ResourceLocation.withDefaultNamespace("hud/hotbar_offhand_right");
    private static final ResourceLocation HOTBAR_ATTACK_INDICATOR_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace("hud/hotbar_attack_indicator_background");
    private static final ResourceLocation HOTBAR_ATTACK_INDICATOR_PROGRESS_SPRITE = ResourceLocation.withDefaultNamespace("hud/hotbar_attack_indicator_progress");
    private static final ResourceLocation ARMOR_EMPTY_SPRITE = ResourceLocation.withDefaultNamespace("hud/armor_empty");
    private static final ResourceLocation ARMOR_HALF_SPRITE = ResourceLocation.withDefaultNamespace("hud/armor_half");
    private static final ResourceLocation ARMOR_FULL_SPRITE = ResourceLocation.withDefaultNamespace("hud/armor_full");
    private static final ResourceLocation FOOD_EMPTY_HUNGER_SPRITE = ResourceLocation.withDefaultNamespace("hud/food_empty_hunger");
    private static final ResourceLocation FOOD_HALF_HUNGER_SPRITE = ResourceLocation.withDefaultNamespace("hud/food_half_hunger");
    private static final ResourceLocation FOOD_FULL_HUNGER_SPRITE = ResourceLocation.withDefaultNamespace("hud/food_full_hunger");
    private static final ResourceLocation FOOD_EMPTY_SPRITE = ResourceLocation.withDefaultNamespace("hud/food_empty");
    private static final ResourceLocation FOOD_HALF_SPRITE = ResourceLocation.withDefaultNamespace("hud/food_half");
    private static final ResourceLocation FOOD_FULL_SPRITE = ResourceLocation.withDefaultNamespace("hud/food_full");
    private static final ResourceLocation AIR_SPRITE = ResourceLocation.withDefaultNamespace("hud/air");
    private static final ResourceLocation AIR_POPPING_SPRITE = ResourceLocation.withDefaultNamespace("hud/air_bursting");
    private static final ResourceLocation AIR_EMPTY_SPRITE = ResourceLocation.withDefaultNamespace("hud/air_empty");
    private static final ResourceLocation HEART_VEHICLE_CONTAINER_SPRITE = ResourceLocation.withDefaultNamespace("hud/heart/vehicle_container");
    private static final ResourceLocation HEART_VEHICLE_FULL_SPRITE = ResourceLocation.withDefaultNamespace("hud/heart/vehicle_full");
    private static final ResourceLocation HEART_VEHICLE_HALF_SPRITE = ResourceLocation.withDefaultNamespace("hud/heart/vehicle_half");
    private static final ResourceLocation VIGNETTE_LOCATION = ResourceLocation.withDefaultNamespace("textures/misc/vignette.png");
    public static final ResourceLocation NAUSEA_LOCATION = ResourceLocation.withDefaultNamespace("textures/misc/nausea.png");
    private static final ResourceLocation SPYGLASS_SCOPE_LOCATION = ResourceLocation.withDefaultNamespace("textures/misc/spyglass_scope.png");
    private static final ResourceLocation POWDER_SNOW_OUTLINE_LOCATION = ResourceLocation.withDefaultNamespace("textures/misc/powder_snow_outline.png");
    private static final Comparator<PlayerScoreEntry> SCORE_DISPLAY_ORDER = Comparator.comparing(PlayerScoreEntry::value).reversed().thenComparing(PlayerScoreEntry::owner, String.CASE_INSENSITIVE_ORDER);
    private static final Component DEMO_EXPIRED_TEXT = Component.translatable("demo.demoExpired");
    private static final Component SAVING_TEXT = Component.translatable("menu.savingLevel");
    private static final float MIN_CROSSHAIR_ATTACK_SPEED = 5.0f;
    private static final int EXPERIENCE_BAR_DISPLAY_TICKS = 100;
    private static final int NUM_HEARTS_PER_ROW = 10;
    private static final int LINE_HEIGHT = 10;
    private static final String SPACER = ": ";
    private static final float PORTAL_OVERLAY_ALPHA_MIN = 0.2f;
    private static final int HEART_SIZE = 9;
    private static final int HEART_SEPARATION = 8;
    private static final int NUM_AIR_BUBBLES = 10;
    private static final int AIR_BUBBLE_SIZE = 9;
    private static final int AIR_BUBBLE_SEPERATION = 8;
    private static final int AIR_BUBBLE_POPPING_DURATION = 2;
    private static final int EMPTY_AIR_BUBBLE_DELAY_DURATION = 1;
    private static final float AIR_BUBBLE_POP_SOUND_VOLUME_BASE = 0.5f;
    private static final float AIR_BUBBLE_POP_SOUND_VOLUME_INCREMENT = 0.1f;
    private static final float AIR_BUBBLE_POP_SOUND_PITCH_BASE = 1.0f;
    private static final float AIR_BUBBLE_POP_SOUND_PITCH_INCREMENT = 0.1f;
    private static final int NUM_AIR_BUBBLE_POPPED_BEFORE_SOUND_VOLUME_INCREASE = 3;
    private static final int NUM_AIR_BUBBLE_POPPED_BEFORE_SOUND_PITCH_INCREASE = 5;
    private static final float AUTOSAVE_FADE_SPEED_FACTOR = 0.2f;
    private static final int SAVING_INDICATOR_WIDTH_PADDING_RIGHT = 5;
    private static final int SAVING_INDICATOR_HEIGHT_PADDING_BOTTOM = 5;
    private final RandomSource random = RandomSource.create();
    private final Minecraft minecraft;
    private final ChatComponent chat;
    private int tickCount;
    @Nullable
    private Component overlayMessageString;
    private int overlayMessageTime;
    private boolean animateOverlayMessageColor;
    private boolean chatDisabledByPlayerShown;
    public float vignetteBrightness = 1.0f;
    private int toolHighlightTimer;
    private ItemStack lastToolHighlight = ItemStack.EMPTY;
    private final DebugScreenOverlay debugOverlay;
    private final SubtitleOverlay subtitleOverlay;
    private final SpectatorGui spectatorGui;
    private final PlayerTabOverlay tabList;
    private final BossHealthOverlay bossOverlay;
    private int titleTime;
    @Nullable
    private Component title;
    @Nullable
    private Component subtitle;
    private int titleFadeInTime;
    private int titleStayTime;
    private int titleFadeOutTime;
    private int lastHealth;
    private int displayHealth;
    private long lastHealthTime;
    private long healthBlinkTime;
    private int lastBubblePopSoundPlayed;
    private float autosaveIndicatorValue;
    private float lastAutosaveIndicatorValue;
    private Pair<ContextualInfo, ContextualBarRenderer> contextualInfoBar = Pair.of((Object)((Object)ContextualInfo.EMPTY), (Object)ContextualBarRenderer.EMPTY);
    private final Map<ContextualInfo, Supplier<ContextualBarRenderer>> contextualInfoBarRenderers;
    private float scopeScale;

    public Gui(Minecraft p_232355_) {
        this.minecraft = p_232355_;
        this.debugOverlay = new DebugScreenOverlay(p_232355_);
        this.spectatorGui = new SpectatorGui(p_232355_);
        this.chat = new ChatComponent(p_232355_);
        this.tabList = new PlayerTabOverlay(p_232355_, this);
        this.bossOverlay = new BossHealthOverlay(p_232355_);
        this.subtitleOverlay = new SubtitleOverlay(p_232355_);
        this.contextualInfoBarRenderers = ImmutableMap.of((Object)((Object)ContextualInfo.EMPTY), () -> ContextualBarRenderer.EMPTY, (Object)((Object)ContextualInfo.EXPERIENCE), () -> new ExperienceBarRenderer(p_232355_), (Object)((Object)ContextualInfo.LOCATOR), () -> new LocatorBarRenderer(p_232355_), (Object)((Object)ContextualInfo.JUMPABLE_VEHICLE), () -> new JumpableVehicleBarRenderer(p_232355_));
        this.resetTitleTimes();
    }

    public void resetTitleTimes() {
        this.titleFadeInTime = 10;
        this.titleStayTime = 70;
        this.titleFadeOutTime = 20;
    }

    public void render(GuiGraphics p_282884_, DeltaTracker p_348630_) {
        if (this.minecraft.screen != null && this.minecraft.screen instanceof ReceivingLevelScreen) {
            return;
        }
        if (!this.minecraft.options.hideGui) {
            this.renderCameraOverlays(p_282884_, p_348630_);
            this.renderCrosshair(p_282884_, p_348630_);
            p_282884_.nextStratum();
            this.renderHotbarAndDecorations(p_282884_, p_348630_);
            this.renderEffects(p_282884_, p_348630_);
            this.renderBossOverlay(p_282884_, p_348630_);
        }
        this.renderSleepOverlay(p_282884_, p_348630_);
        if (!this.minecraft.options.hideGui) {
            this.renderDemoOverlay(p_282884_, p_348630_);
            this.renderDebugOverlay(p_282884_, p_348630_);
            this.renderScoreboardSidebar(p_282884_, p_348630_);
            this.renderOverlayMessage(p_282884_, p_348630_);
            this.renderTitle(p_282884_, p_348630_);
            this.renderChat(p_282884_, p_348630_);
            this.renderTabList(p_282884_, p_348630_);
            this.renderSubtitleOverlay(p_282884_, p_348630_);
        }
    }

    private void renderBossOverlay(GuiGraphics p_416128_, DeltaTracker p_416660_) {
        this.bossOverlay.render(p_416128_);
    }

    private void renderDebugOverlay(GuiGraphics p_415535_, DeltaTracker p_416260_) {
        if (this.debugOverlay.showDebugScreen()) {
            p_415535_.nextStratum();
            this.debugOverlay.render(p_415535_);
        }
    }

    private void renderSubtitleOverlay(GuiGraphics p_415796_, DeltaTracker p_416669_) {
        this.subtitleOverlay.render(p_415796_);
    }

    private void renderCameraOverlays(GuiGraphics p_316735_, DeltaTracker p_348538_) {
        float $$10;
        if (Minecraft.useFancyGraphics()) {
            this.renderVignette(p_316735_, this.minecraft.getCameraEntity());
        }
        LocalPlayer $$2 = this.minecraft.player;
        float $$3 = p_348538_.getGameTimeDeltaTicks();
        this.scopeScale = Mth.lerp(0.5f * $$3, this.scopeScale, 1.125f);
        if (this.minecraft.options.getCameraType().isFirstPerson()) {
            if ($$2.isScoping()) {
                this.renderSpyglassOverlay(p_316735_, this.scopeScale);
            } else {
                this.scopeScale = 0.5f;
                for (EquipmentSlot $$4 : EquipmentSlot.values()) {
                    ItemStack $$5 = $$2.getItemBySlot($$4);
                    Equippable $$6 = $$5.get(DataComponents.EQUIPPABLE);
                    if ($$6 == null || $$6.slot() != $$4 || !$$6.cameraOverlay().isPresent()) continue;
                    this.renderTextureOverlay(p_316735_, $$6.cameraOverlay().get().withPath(p_380782_ -> "textures/" + p_380782_ + ".png"), 1.0f);
                }
            }
        }
        if ($$2.getTicksFrozen() > 0) {
            this.renderTextureOverlay(p_316735_, POWDER_SNOW_OUTLINE_LOCATION, $$2.getPercentFrozen());
        }
        float $$7 = p_348538_.getGameTimeDeltaPartialTick(false);
        float $$8 = Mth.lerp($$7, $$2.oPortalEffectIntensity, $$2.portalEffectIntensity);
        float $$9 = $$2.getEffectBlendFactor(MobEffects.NAUSEA, $$7);
        if ($$8 > 0.0f) {
            this.renderPortalOverlay(p_316735_, $$8);
        } else if ($$9 > 0.0f && ($$10 = this.minecraft.options.screenEffectScale().get().floatValue()) < 1.0f) {
            float $$11 = $$9 * (1.0f - $$10);
            this.renderConfusionOverlay(p_316735_, $$11);
        }
    }

    private void renderSleepOverlay(GuiGraphics p_316466_, DeltaTracker p_348533_) {
        if (this.minecraft.player.getSleepTimer() <= 0) {
            return;
        }
        Profiler.get().push("sleep");
        p_316466_.nextStratum();
        float $$2 = this.minecraft.player.getSleepTimer();
        float $$3 = $$2 / 100.0f;
        if ($$3 > 1.0f) {
            $$3 = 1.0f - ($$2 - 100.0f) / 10.0f;
        }
        int $$4 = (int)(220.0f * $$3) << 24 | 0x101020;
        p_316466_.fill(0, 0, p_316466_.guiWidth(), p_316466_.guiHeight(), $$4);
        Profiler.get().pop();
    }

    private void renderOverlayMessage(GuiGraphics p_316291_, DeltaTracker p_348653_) {
        Font $$2 = this.getFont();
        if (this.overlayMessageString == null || this.overlayMessageTime <= 0) {
            return;
        }
        Profiler.get().push("overlayMessage");
        float $$3 = (float)this.overlayMessageTime - p_348653_.getGameTimeDeltaPartialTick(false);
        int $$4 = (int)($$3 * 255.0f / 20.0f);
        if ($$4 > 255) {
            $$4 = 255;
        }
        if ($$4 > 0) {
            int $$6;
            p_316291_.nextStratum();
            p_316291_.pose().pushMatrix();
            p_316291_.pose().translate((float)(p_316291_.guiWidth() / 2), (float)(p_316291_.guiHeight() - 68));
            if (this.animateOverlayMessageColor) {
                int $$5 = Mth.hsvToArgb($$3 / 50.0f, 0.7f, 0.6f, $$4);
            } else {
                $$6 = ARGB.color($$4, -1);
            }
            int $$7 = $$2.width(this.overlayMessageString);
            p_316291_.drawStringWithBackdrop($$2, this.overlayMessageString, -$$7 / 2, -4, $$7, $$6);
            p_316291_.pose().popMatrix();
        }
        Profiler.get().pop();
    }

    private void renderTitle(GuiGraphics p_316629_, DeltaTracker p_348613_) {
        if (this.title == null || this.titleTime <= 0) {
            return;
        }
        Font $$2 = this.getFont();
        Profiler.get().push("titleAndSubtitle");
        float $$3 = (float)this.titleTime - p_348613_.getGameTimeDeltaPartialTick(false);
        int $$4 = 255;
        if (this.titleTime > this.titleFadeOutTime + this.titleStayTime) {
            float $$5 = (float)(this.titleFadeInTime + this.titleStayTime + this.titleFadeOutTime) - $$3;
            $$4 = (int)($$5 * 255.0f / (float)this.titleFadeInTime);
        }
        if (this.titleTime <= this.titleFadeOutTime) {
            $$4 = (int)($$3 * 255.0f / (float)this.titleFadeOutTime);
        }
        if (($$4 = Mth.clamp($$4, 0, 255)) > 0) {
            p_316629_.nextStratum();
            p_316629_.pose().pushMatrix();
            p_316629_.pose().translate((float)(p_316629_.guiWidth() / 2), (float)(p_316629_.guiHeight() / 2));
            p_316629_.pose().pushMatrix();
            p_316629_.pose().scale(4.0f, 4.0f);
            int $$6 = $$2.width(this.title);
            int $$7 = ARGB.color($$4, -1);
            p_316629_.drawStringWithBackdrop($$2, this.title, -$$6 / 2, -10, $$6, $$7);
            p_316629_.pose().popMatrix();
            if (this.subtitle != null) {
                p_316629_.pose().pushMatrix();
                p_316629_.pose().scale(2.0f, 2.0f);
                int $$8 = $$2.width(this.subtitle);
                p_316629_.drawStringWithBackdrop($$2, this.subtitle, -$$8 / 2, 5, $$8, $$7);
                p_316629_.pose().popMatrix();
            }
            p_316629_.pose().popMatrix();
        }
        Profiler.get().pop();
    }

    private void renderChat(GuiGraphics p_316307_, DeltaTracker p_348631_) {
        if (!this.chat.isChatFocused()) {
            Window $$2 = this.minecraft.getWindow();
            int $$3 = Mth.floor(this.minecraft.mouseHandler.getScaledXPos($$2));
            int $$4 = Mth.floor(this.minecraft.mouseHandler.getScaledYPos($$2));
            p_316307_.nextStratum();
            this.chat.render(p_316307_, this.tickCount, $$3, $$4, false);
        }
    }

    private void renderScoreboardSidebar(GuiGraphics p_316834_, DeltaTracker p_348514_) {
        Objective $$6;
        DisplaySlot $$5;
        Scoreboard $$2 = this.minecraft.level.getScoreboard();
        Objective $$3 = null;
        PlayerTeam $$4 = $$2.getPlayersTeam(this.minecraft.player.getScoreboardName());
        if ($$4 != null && ($$5 = DisplaySlot.teamColorToSlot($$4.getColor())) != null) {
            $$3 = $$2.getDisplayObjective($$5);
        }
        Objective objective = $$6 = $$3 != null ? $$3 : $$2.getDisplayObjective(DisplaySlot.SIDEBAR);
        if ($$6 != null) {
            p_316834_.nextStratum();
            this.displayScoreboardSidebar(p_316834_, $$6);
        }
    }

    private void renderTabList(GuiGraphics p_316182_, DeltaTracker p_348611_) {
        Scoreboard $$2 = this.minecraft.level.getScoreboard();
        Objective $$3 = $$2.getDisplayObjective(DisplaySlot.LIST);
        if (this.minecraft.options.keyPlayerList.isDown() && (!this.minecraft.isLocalServer() || this.minecraft.player.connection.getListedOnlinePlayers().size() > 1 || $$3 != null)) {
            this.tabList.setVisible(true);
            p_316182_.nextStratum();
            this.tabList.render(p_316182_, p_316182_.guiWidth(), $$2, $$3);
        } else {
            this.tabList.setVisible(false);
        }
    }

    private void renderCrosshair(GuiGraphics p_282828_, DeltaTracker p_348625_) {
        Options $$2 = this.minecraft.options;
        if (!$$2.getCameraType().isFirstPerson()) {
            return;
        }
        if (this.minecraft.gameMode.getPlayerMode() == GameType.SPECTATOR && !this.canRenderCrosshairForSpectator(this.minecraft.hitResult)) {
            return;
        }
        if (!this.shouldRenderDebugCrosshair()) {
            p_282828_.nextStratum();
            int $$3 = 15;
            p_282828_.blitSprite(RenderPipelines.CROSSHAIR, CROSSHAIR_SPRITE, (p_282828_.guiWidth() - 15) / 2, (p_282828_.guiHeight() - 15) / 2, 15, 15);
            if (this.minecraft.options.attackIndicator().get() == AttackIndicatorStatus.CROSSHAIR) {
                float $$4 = this.minecraft.player.getAttackStrengthScale(0.0f);
                boolean $$5 = false;
                if (this.minecraft.crosshairPickEntity != null && this.minecraft.crosshairPickEntity instanceof LivingEntity && $$4 >= 1.0f) {
                    $$5 = this.minecraft.player.getCurrentItemAttackStrengthDelay() > 5.0f;
                    $$5 &= this.minecraft.crosshairPickEntity.isAlive();
                }
                int $$6 = p_282828_.guiHeight() / 2 - 7 + 16;
                int $$7 = p_282828_.guiWidth() / 2 - 8;
                if ($$5) {
                    p_282828_.blitSprite(RenderPipelines.CROSSHAIR, CROSSHAIR_ATTACK_INDICATOR_FULL_SPRITE, $$7, $$6, 16, 16);
                } else if ($$4 < 1.0f) {
                    int $$8 = (int)($$4 * 17.0f);
                    p_282828_.blitSprite(RenderPipelines.CROSSHAIR, CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_SPRITE, $$7, $$6, 16, 4);
                    p_282828_.blitSprite(RenderPipelines.CROSSHAIR, CROSSHAIR_ATTACK_INDICATOR_PROGRESS_SPRITE, 16, 4, 0, 0, $$7, $$6, $$8, 4);
                }
            }
        }
    }

    public boolean shouldRenderDebugCrosshair() {
        return this.debugOverlay.showDebugScreen() && this.minecraft.options.getCameraType() == CameraType.FIRST_PERSON && !this.minecraft.player.isReducedDebugInfo() && this.minecraft.options.reducedDebugInfo().get() == false;
    }

    private boolean canRenderCrosshairForSpectator(@Nullable HitResult p_93025_) {
        if (p_93025_ == null) {
            return false;
        }
        if (p_93025_.getType() == HitResult.Type.ENTITY) {
            return ((EntityHitResult)p_93025_).getEntity() instanceof MenuProvider;
        }
        if (p_93025_.getType() == HitResult.Type.BLOCK) {
            ClientLevel $$2 = this.minecraft.level;
            BlockPos $$1 = ((BlockHitResult)p_93025_).getBlockPos();
            return $$2.getBlockState($$1).getMenuProvider($$2, $$1) != null;
        }
        return false;
    }

    private void renderEffects(GuiGraphics p_282812_, DeltaTracker p_348654_) {
        Collection<MobEffectInstance> $$2 = this.minecraft.player.getActiveEffects();
        if ($$2.isEmpty() || this.minecraft.screen != null && this.minecraft.screen.showsActiveEffects()) {
            return;
        }
        int $$3 = 0;
        int $$4 = 0;
        for (MobEffectInstance $$5 : Ordering.natural().reverse().sortedCopy($$2)) {
            Holder<MobEffect> $$6 = $$5.getEffect();
            if (!$$5.showIcon()) continue;
            int $$7 = p_282812_.guiWidth();
            int $$8 = 1;
            if (this.minecraft.isDemo()) {
                $$8 += 15;
            }
            if ($$6.value().isBeneficial()) {
                $$7 -= 25 * ++$$3;
            } else {
                $$7 -= 25 * ++$$4;
                $$8 += 26;
            }
            float $$9 = 1.0f;
            if ($$5.isAmbient()) {
                p_282812_.blitSprite(RenderPipelines.GUI_TEXTURED, EFFECT_BACKGROUND_AMBIENT_SPRITE, $$7, $$8, 24, 24);
            } else {
                p_282812_.blitSprite(RenderPipelines.GUI_TEXTURED, EFFECT_BACKGROUND_SPRITE, $$7, $$8, 24, 24);
                if ($$5.endsWithin(200)) {
                    int $$10 = $$5.getDuration();
                    int $$11 = 10 - $$10 / 20;
                    $$9 = Mth.clamp((float)$$10 / 10.0f / 5.0f * 0.5f, 0.0f, 0.5f) + Mth.cos((float)$$10 * (float)Math.PI / 5.0f) * Mth.clamp((float)$$11 / 10.0f * 0.25f, 0.0f, 0.25f);
                    $$9 = Mth.clamp($$9, 0.0f, 1.0f);
                }
            }
            p_282812_.blitSprite(RenderPipelines.GUI_TEXTURED, Gui.getMobEffectSprite($$6), $$7 + 3, $$8 + 3, 18, 18, ARGB.white($$9));
        }
    }

    public static ResourceLocation getMobEffectSprite(Holder<MobEffect> p_423602_) {
        return p_423602_.unwrapKey().map(ResourceKey::location).map(p_423152_ -> p_423152_.withPrefix("mob_effect/")).orElseGet(MissingTextureAtlasSprite::getLocation);
    }

    private void renderHotbarAndDecorations(GuiGraphics p_316628_, DeltaTracker p_348543_) {
        if (this.minecraft.gameMode.getPlayerMode() == GameType.SPECTATOR) {
            this.spectatorGui.renderHotbar(p_316628_);
        } else {
            this.renderItemHotbar(p_316628_, p_348543_);
        }
        if (this.minecraft.gameMode.canHurtPlayer()) {
            this.renderPlayerHealth(p_316628_);
        }
        this.renderVehicleHealth(p_316628_);
        ContextualInfo $$2 = this.nextContextualInfoState();
        if ($$2 != this.contextualInfoBar.getKey()) {
            this.contextualInfoBar = Pair.of((Object)((Object)$$2), (Object)this.contextualInfoBarRenderers.get((Object)$$2).get());
        }
        ((ContextualBarRenderer)this.contextualInfoBar.getValue()).renderBackground(p_316628_, p_348543_);
        if (this.minecraft.gameMode.hasExperience() && this.minecraft.player.experienceLevel > 0) {
            ContextualBarRenderer.renderExperienceLevel(p_316628_, this.minecraft.font, this.minecraft.player.experienceLevel);
        }
        ((ContextualBarRenderer)this.contextualInfoBar.getValue()).render(p_316628_, p_348543_);
        if (this.minecraft.gameMode.getPlayerMode() != GameType.SPECTATOR) {
            this.renderSelectedItemName(p_316628_);
        } else if (this.minecraft.player.isSpectator()) {
            this.spectatorGui.renderAction(p_316628_);
        }
    }

    private void renderItemHotbar(GuiGraphics p_316896_, DeltaTracker p_348464_) {
        float $$13;
        Player $$2 = this.getCameraPlayer();
        if ($$2 == null) {
            return;
        }
        ItemStack $$3 = $$2.getOffhandItem();
        HumanoidArm $$4 = $$2.getMainArm().getOpposite();
        int $$5 = p_316896_.guiWidth() / 2;
        int $$6 = 182;
        int $$7 = 91;
        p_316896_.blitSprite(RenderPipelines.GUI_TEXTURED, HOTBAR_SPRITE, $$5 - 91, p_316896_.guiHeight() - 22, 182, 22);
        p_316896_.blitSprite(RenderPipelines.GUI_TEXTURED, HOTBAR_SELECTION_SPRITE, $$5 - 91 - 1 + $$2.getInventory().getSelectedSlot() * 20, p_316896_.guiHeight() - 22 - 1, 24, 23);
        if (!$$3.isEmpty()) {
            if ($$4 == HumanoidArm.LEFT) {
                p_316896_.blitSprite(RenderPipelines.GUI_TEXTURED, HOTBAR_OFFHAND_LEFT_SPRITE, $$5 - 91 - 29, p_316896_.guiHeight() - 23, 29, 24);
            } else {
                p_316896_.blitSprite(RenderPipelines.GUI_TEXTURED, HOTBAR_OFFHAND_RIGHT_SPRITE, $$5 + 91, p_316896_.guiHeight() - 23, 29, 24);
            }
        }
        int $$8 = 1;
        for (int $$9 = 0; $$9 < 9; ++$$9) {
            int $$10 = $$5 - 90 + $$9 * 20 + 2;
            int $$11 = p_316896_.guiHeight() - 16 - 3;
            this.renderSlot(p_316896_, $$10, $$11, p_348464_, $$2, $$2.getInventory().getItem($$9), $$8++);
        }
        if (!$$3.isEmpty()) {
            int $$12 = p_316896_.guiHeight() - 16 - 3;
            if ($$4 == HumanoidArm.LEFT) {
                this.renderSlot(p_316896_, $$5 - 91 - 26, $$12, p_348464_, $$2, $$3, $$8++);
            } else {
                this.renderSlot(p_316896_, $$5 + 91 + 10, $$12, p_348464_, $$2, $$3, $$8++);
            }
        }
        if (this.minecraft.options.attackIndicator().get() == AttackIndicatorStatus.HOTBAR && ($$13 = this.minecraft.player.getAttackStrengthScale(0.0f)) < 1.0f) {
            int $$14 = p_316896_.guiHeight() - 20;
            int $$15 = $$5 + 91 + 6;
            if ($$4 == HumanoidArm.RIGHT) {
                $$15 = $$5 - 91 - 22;
            }
            int $$16 = (int)($$13 * 19.0f);
            p_316896_.blitSprite(RenderPipelines.GUI_TEXTURED, HOTBAR_ATTACK_INDICATOR_BACKGROUND_SPRITE, $$15, $$14, 18, 18);
            p_316896_.blitSprite(RenderPipelines.GUI_TEXTURED, HOTBAR_ATTACK_INDICATOR_PROGRESS_SPRITE, 18, 18, 0, 18 - $$16, $$15, $$14 + 18 - $$16, 18, $$16);
        }
    }

    private void renderSelectedItemName(GuiGraphics p_283501_) {
        Profiler.get().push("selectedItemName");
        if (this.toolHighlightTimer > 0 && !this.lastToolHighlight.isEmpty()) {
            int $$5;
            MutableComponent $$1 = Component.empty().append(this.lastToolHighlight.getHoverName()).withStyle(this.lastToolHighlight.getRarity().color());
            if (this.lastToolHighlight.has(DataComponents.CUSTOM_NAME)) {
                $$1.withStyle(ChatFormatting.ITALIC);
            }
            int $$2 = this.getFont().width($$1);
            int $$3 = (p_283501_.guiWidth() - $$2) / 2;
            int $$4 = p_283501_.guiHeight() - 59;
            if (!this.minecraft.gameMode.canHurtPlayer()) {
                $$4 += 14;
            }
            if (($$5 = (int)((float)this.toolHighlightTimer * 256.0f / 10.0f)) > 255) {
                $$5 = 255;
            }
            if ($$5 > 0) {
                p_283501_.drawStringWithBackdrop(this.getFont(), $$1, $$3, $$4, $$2, ARGB.color($$5, -1));
            }
        }
        Profiler.get().pop();
    }

    private void renderDemoOverlay(GuiGraphics p_281825_, DeltaTracker p_348679_) {
        MutableComponent $$3;
        if (!this.minecraft.isDemo()) {
            return;
        }
        Profiler.get().push("demo");
        p_281825_.nextStratum();
        if (this.minecraft.level.getGameTime() >= 120500L) {
            Component $$2 = DEMO_EXPIRED_TEXT;
        } else {
            $$3 = Component.translatable("demo.remainingTime", StringUtil.formatTickDuration((int)(120500L - this.minecraft.level.getGameTime()), this.minecraft.level.tickRateManager().tickrate()));
        }
        int $$4 = this.getFont().width($$3);
        int $$5 = p_281825_.guiWidth() - $$4 - 10;
        int $$6 = 5;
        p_281825_.drawStringWithBackdrop(this.getFont(), $$3, $$5, 5, $$4, -1);
        Profiler.get().pop();
    }

    private void displayScoreboardSidebar(GuiGraphics p_282008_, Objective p_283455_) {
        int $$6;
        Scoreboard $$2 = p_283455_.getScoreboard();
        NumberFormat $$3 = p_283455_.numberFormatOrDefault(StyledFormat.SIDEBAR_DEFAULT);
        record DisplayEntry(Component name, Component score, int scoreWidth) {
        }
        DisplayEntry[] $$4 = (DisplayEntry[])$$2.listPlayerScores(p_283455_).stream().filter(p_313419_ -> !p_313419_.isHidden()).sorted(SCORE_DISPLAY_ORDER).limit(15L).map(p_313418_ -> {
            PlayerTeam $$3 = $$2.getPlayersTeam(p_313418_.owner());
            Component $$4 = p_313418_.ownerName();
            MutableComponent $$5 = PlayerTeam.formatNameForTeam($$3, $$4);
            MutableComponent $$6 = p_313418_.formatValue($$3);
            int $$7 = this.getFont().width($$6);
            return new DisplayEntry($$5, $$6, $$7);
        }).toArray(p_313425_ -> new DisplayEntry[p_313425_]);
        Component $$5 = p_283455_.getDisplayName();
        int $$7 = $$6 = this.getFont().width($$5);
        int $$8 = this.getFont().width(SPACER);
        for (DisplayEntry $$9 : $$4) {
            $$7 = Math.max($$7, this.getFont().width($$9.name) + ($$9.scoreWidth > 0 ? $$8 + $$9.scoreWidth : 0));
        }
        int $$10 = $$7;
        int $$11 = $$4.length;
        int $$12 = $$11 * this.getFont().lineHeight;
        int $$13 = p_282008_.guiHeight() / 2 + $$12 / 3;
        int $$14 = 3;
        int $$15 = p_282008_.guiWidth() - $$10 - 3;
        int $$16 = p_282008_.guiWidth() - 3 + 2;
        int $$17 = this.minecraft.options.getBackgroundColor(0.3f);
        int $$18 = this.minecraft.options.getBackgroundColor(0.4f);
        int $$19 = $$13 - $$11 * this.getFont().lineHeight;
        p_282008_.fill($$15 - 2, $$19 - this.getFont().lineHeight - 1, $$16, $$19 - 1, $$18);
        p_282008_.fill($$15 - 2, $$19 - 1, $$16, $$13, $$17);
        p_282008_.drawString(this.getFont(), $$5, $$15 + $$10 / 2 - $$6 / 2, $$19 - this.getFont().lineHeight, -1, false);
        for (int $$20 = 0; $$20 < $$11; ++$$20) {
            DisplayEntry $$21 = $$4[$$20];
            int $$22 = $$13 - ($$11 - $$20) * this.getFont().lineHeight;
            p_282008_.drawString(this.getFont(), $$21.name, $$15, $$22, -1, false);
            p_282008_.drawString(this.getFont(), $$21.score, $$16 - $$21.scoreWidth, $$22, -1, false);
        }
    }

    @Nullable
    private Player getCameraPlayer() {
        Player $$0;
        Entity entity = this.minecraft.getCameraEntity();
        return entity instanceof Player ? ($$0 = (Player)entity) : null;
    }

    @Nullable
    private LivingEntity getPlayerVehicleWithHealth() {
        Player $$0 = this.getCameraPlayer();
        if ($$0 != null) {
            Entity $$1 = $$0.getVehicle();
            if ($$1 == null) {
                return null;
            }
            if ($$1 instanceof LivingEntity) {
                return (LivingEntity)$$1;
            }
        }
        return null;
    }

    private int getVehicleMaxHearts(@Nullable LivingEntity p_93023_) {
        if (p_93023_ == null || !p_93023_.showVehicleHealth()) {
            return 0;
        }
        float $$1 = p_93023_.getMaxHealth();
        int $$2 = (int)($$1 + 0.5f) / 2;
        if ($$2 > 30) {
            $$2 = 30;
        }
        return $$2;
    }

    private int getVisibleVehicleHeartRows(int p_93013_) {
        return (int)Math.ceil((double)p_93013_ / 10.0);
    }

    private void renderPlayerHealth(GuiGraphics p_283143_) {
        Player $$1 = this.getCameraPlayer();
        if ($$1 == null) {
            return;
        }
        int $$2 = Mth.ceil($$1.getHealth());
        boolean $$3 = this.healthBlinkTime > (long)this.tickCount && (this.healthBlinkTime - (long)this.tickCount) / 3L % 2L == 1L;
        long $$4 = Util.getMillis();
        if ($$2 < this.lastHealth && $$1.invulnerableTime > 0) {
            this.lastHealthTime = $$4;
            this.healthBlinkTime = this.tickCount + 20;
        } else if ($$2 > this.lastHealth && $$1.invulnerableTime > 0) {
            this.lastHealthTime = $$4;
            this.healthBlinkTime = this.tickCount + 10;
        }
        if ($$4 - this.lastHealthTime > 1000L) {
            this.displayHealth = $$2;
            this.lastHealthTime = $$4;
        }
        this.lastHealth = $$2;
        int $$5 = this.displayHealth;
        this.random.setSeed(this.tickCount * 312871);
        int $$6 = p_283143_.guiWidth() / 2 - 91;
        int $$7 = p_283143_.guiWidth() / 2 + 91;
        int $$8 = p_283143_.guiHeight() - 39;
        float $$9 = Math.max((float)$$1.getAttributeValue(Attributes.MAX_HEALTH), (float)Math.max($$5, $$2));
        int $$10 = Mth.ceil($$1.getAbsorptionAmount());
        int $$11 = Mth.ceil(($$9 + (float)$$10) / 2.0f / 10.0f);
        int $$12 = Math.max(10 - ($$11 - 2), 3);
        int $$13 = $$8 - 10;
        int $$14 = -1;
        if ($$1.hasEffect(MobEffects.REGENERATION)) {
            $$14 = this.tickCount % Mth.ceil($$9 + 5.0f);
        }
        Profiler.get().push("armor");
        Gui.renderArmor(p_283143_, $$1, $$8, $$11, $$12, $$6);
        Profiler.get().popPush("health");
        this.renderHearts(p_283143_, $$1, $$6, $$8, $$12, $$14, $$9, $$2, $$5, $$10, $$3);
        LivingEntity $$15 = this.getPlayerVehicleWithHealth();
        int $$16 = this.getVehicleMaxHearts($$15);
        if ($$16 == 0) {
            Profiler.get().popPush("food");
            this.renderFood(p_283143_, $$1, $$8, $$7);
            $$13 -= 10;
        }
        Profiler.get().popPush("air");
        this.renderAirBubbles(p_283143_, $$1, $$16, $$13, $$7);
        Profiler.get().pop();
    }

    private static void renderArmor(GuiGraphics p_335393_, Player p_335672_, int p_335452_, int p_335846_, int p_335778_, int p_335859_) {
        int $$6 = p_335672_.getArmorValue();
        if ($$6 <= 0) {
            return;
        }
        int $$7 = p_335452_ - (p_335846_ - 1) * p_335778_ - 10;
        for (int $$8 = 0; $$8 < 10; ++$$8) {
            int $$9 = p_335859_ + $$8 * 8;
            if ($$8 * 2 + 1 < $$6) {
                p_335393_.blitSprite(RenderPipelines.GUI_TEXTURED, ARMOR_FULL_SPRITE, $$9, $$7, 9, 9);
            }
            if ($$8 * 2 + 1 == $$6) {
                p_335393_.blitSprite(RenderPipelines.GUI_TEXTURED, ARMOR_HALF_SPRITE, $$9, $$7, 9, 9);
            }
            if ($$8 * 2 + 1 <= $$6) continue;
            p_335393_.blitSprite(RenderPipelines.GUI_TEXTURED, ARMOR_EMPTY_SPRITE, $$9, $$7, 9, 9);
        }
    }

    private void renderHearts(GuiGraphics p_282497_, Player p_168690_, int p_168691_, int p_168692_, int p_168693_, int p_168694_, float p_168695_, int p_168696_, int p_168697_, int p_168698_, boolean p_168699_) {
        HeartType $$11 = HeartType.forPlayer(p_168690_);
        boolean $$12 = p_168690_.level().getLevelData().isHardcore();
        int $$13 = Mth.ceil((double)p_168695_ / 2.0);
        int $$14 = Mth.ceil((double)p_168698_ / 2.0);
        int $$15 = $$13 * 2;
        for (int $$16 = $$13 + $$14 - 1; $$16 >= 0; --$$16) {
            int $$23;
            boolean $$22;
            int $$17 = $$16 / 10;
            int $$18 = $$16 % 10;
            int $$19 = p_168691_ + $$18 * 8;
            int $$20 = p_168692_ - $$17 * p_168693_;
            if (p_168696_ + p_168698_ <= 4) {
                $$20 += this.random.nextInt(2);
            }
            if ($$16 < $$13 && $$16 == p_168694_) {
                $$20 -= 2;
            }
            this.renderHeart(p_282497_, HeartType.CONTAINER, $$19, $$20, $$12, p_168699_, false);
            int $$21 = $$16 * 2;
            boolean bl = $$22 = $$16 >= $$13;
            if ($$22 && ($$23 = $$21 - $$15) < p_168698_) {
                boolean $$24 = $$23 + 1 == p_168698_;
                this.renderHeart(p_282497_, $$11 == HeartType.WITHERED ? $$11 : HeartType.ABSORBING, $$19, $$20, $$12, false, $$24);
            }
            if (p_168699_ && $$21 < p_168697_) {
                boolean $$25 = $$21 + 1 == p_168697_;
                this.renderHeart(p_282497_, $$11, $$19, $$20, $$12, true, $$25);
            }
            if ($$21 >= p_168696_) continue;
            boolean $$26 = $$21 + 1 == p_168696_;
            this.renderHeart(p_282497_, $$11, $$19, $$20, $$12, false, $$26);
        }
    }

    private void renderHeart(GuiGraphics p_283024_, HeartType p_281393_, int p_283636_, int p_283279_, boolean p_283440_, boolean p_282496_, boolean p_294129_) {
        p_283024_.blitSprite(RenderPipelines.GUI_TEXTURED, p_281393_.getSprite(p_283440_, p_294129_, p_282496_), p_283636_, p_283279_, 9, 9);
    }

    private void renderAirBubbles(GuiGraphics p_381066_, Player p_380979_, int p_380967_, int p_381100_, int p_381034_) {
        int $$5 = p_380979_.getMaxAirSupply();
        int $$6 = Math.clamp((long)p_380979_.getAirSupply(), 0, $$5);
        boolean $$7 = p_380979_.isEyeInFluid(FluidTags.WATER);
        if ($$7 || $$6 < $$5) {
            boolean $$11;
            p_381100_ = this.getAirBubbleYLine(p_380967_, p_381100_);
            int $$8 = Gui.getCurrentAirSupplyBubble($$6, $$5, -2);
            int $$9 = Gui.getCurrentAirSupplyBubble($$6, $$5, 0);
            int $$10 = 10 - Gui.getCurrentAirSupplyBubble($$6, $$5, Gui.getEmptyBubbleDelayDuration($$6, $$7));
            boolean bl = $$11 = $$8 != $$9;
            if (!$$7) {
                this.lastBubblePopSoundPlayed = 0;
            }
            for (int $$12 = 1; $$12 <= 10; ++$$12) {
                int $$13 = p_381034_ - ($$12 - 1) * 8 - 9;
                if ($$12 <= $$8) {
                    p_381066_.blitSprite(RenderPipelines.GUI_TEXTURED, AIR_SPRITE, $$13, p_381100_, 9, 9);
                    continue;
                }
                if ($$11 && $$12 == $$9 && $$7) {
                    p_381066_.blitSprite(RenderPipelines.GUI_TEXTURED, AIR_POPPING_SPRITE, $$13, p_381100_, 9, 9);
                    this.playAirBubblePoppedSound($$12, p_380979_, $$10);
                    continue;
                }
                if ($$12 <= 10 - $$10) continue;
                int $$14 = $$10 == 10 && this.tickCount % 2 == 0 ? this.random.nextInt(2) : 0;
                p_381066_.blitSprite(RenderPipelines.GUI_TEXTURED, AIR_EMPTY_SPRITE, $$13, p_381100_ + $$14, 9, 9);
            }
        }
    }

    private int getAirBubbleYLine(int p_381118_, int p_380948_) {
        int $$2 = this.getVisibleVehicleHeartRows(p_381118_) - 1;
        return p_380948_ -= $$2 * 10;
    }

    private static int getCurrentAirSupplyBubble(int p_381135_, int p_381127_, int p_381060_) {
        return Mth.ceil((float)((p_381135_ + p_381060_) * 10) / (float)p_381127_);
    }

    private static int getEmptyBubbleDelayDuration(int p_381083_, boolean p_381137_) {
        return p_381083_ == 0 || !p_381137_ ? 0 : 1;
    }

    private void playAirBubblePoppedSound(int p_381005_, Player p_380939_, int p_381115_) {
        if (this.lastBubblePopSoundPlayed != p_381005_) {
            float $$3 = 0.5f + 0.1f * (float)Math.max(0, p_381115_ - 3 + 1);
            float $$4 = 1.0f + 0.1f * (float)Math.max(0, p_381115_ - 5 + 1);
            p_380939_.playSound(SoundEvents.BUBBLE_POP, $$3, $$4);
            this.lastBubblePopSoundPlayed = p_381005_;
        }
    }

    private void renderFood(GuiGraphics p_335615_, Player p_336082_, int p_335399_, int p_335589_) {
        FoodData $$4 = p_336082_.getFoodData();
        int $$5 = $$4.getFoodLevel();
        for (int $$6 = 0; $$6 < 10; ++$$6) {
            ResourceLocation $$13;
            ResourceLocation $$12;
            ResourceLocation $$11;
            int $$7 = p_335399_;
            if (p_336082_.hasEffect(MobEffects.HUNGER)) {
                ResourceLocation $$8 = FOOD_EMPTY_HUNGER_SPRITE;
                ResourceLocation $$9 = FOOD_HALF_HUNGER_SPRITE;
                ResourceLocation $$10 = FOOD_FULL_HUNGER_SPRITE;
            } else {
                $$11 = FOOD_EMPTY_SPRITE;
                $$12 = FOOD_HALF_SPRITE;
                $$13 = FOOD_FULL_SPRITE;
            }
            if (p_336082_.getFoodData().getSaturationLevel() <= 0.0f && this.tickCount % ($$5 * 3 + 1) == 0) {
                $$7 += this.random.nextInt(3) - 1;
            }
            int $$14 = p_335589_ - $$6 * 8 - 9;
            p_335615_.blitSprite(RenderPipelines.GUI_TEXTURED, $$11, $$14, $$7, 9, 9);
            if ($$6 * 2 + 1 < $$5) {
                p_335615_.blitSprite(RenderPipelines.GUI_TEXTURED, $$13, $$14, $$7, 9, 9);
            }
            if ($$6 * 2 + 1 != $$5) continue;
            p_335615_.blitSprite(RenderPipelines.GUI_TEXTURED, $$12, $$14, $$7, 9, 9);
        }
    }

    private void renderVehicleHealth(GuiGraphics p_283368_) {
        LivingEntity $$1 = this.getPlayerVehicleWithHealth();
        if ($$1 == null) {
            return;
        }
        int $$2 = this.getVehicleMaxHearts($$1);
        if ($$2 == 0) {
            return;
        }
        int $$3 = (int)Math.ceil($$1.getHealth());
        Profiler.get().popPush("mountHealth");
        int $$4 = p_283368_.guiHeight() - 39;
        int $$5 = p_283368_.guiWidth() / 2 + 91;
        int $$6 = $$4;
        int $$7 = 0;
        while ($$2 > 0) {
            int $$8 = Math.min($$2, 10);
            $$2 -= $$8;
            for (int $$9 = 0; $$9 < $$8; ++$$9) {
                int $$10 = $$5 - $$9 * 8 - 9;
                p_283368_.blitSprite(RenderPipelines.GUI_TEXTURED, HEART_VEHICLE_CONTAINER_SPRITE, $$10, $$6, 9, 9);
                if ($$9 * 2 + 1 + $$7 < $$3) {
                    p_283368_.blitSprite(RenderPipelines.GUI_TEXTURED, HEART_VEHICLE_FULL_SPRITE, $$10, $$6, 9, 9);
                }
                if ($$9 * 2 + 1 + $$7 != $$3) continue;
                p_283368_.blitSprite(RenderPipelines.GUI_TEXTURED, HEART_VEHICLE_HALF_SPRITE, $$10, $$6, 9, 9);
            }
            $$6 -= 10;
            $$7 += 20;
        }
    }

    private void renderTextureOverlay(GuiGraphics p_282304_, ResourceLocation p_281622_, float p_281504_) {
        int $$3 = ARGB.white(p_281504_);
        p_282304_.blit(RenderPipelines.GUI_TEXTURED, p_281622_, 0, 0, 0.0f, 0.0f, p_282304_.guiWidth(), p_282304_.guiHeight(), p_282304_.guiWidth(), p_282304_.guiHeight(), $$3);
    }

    private void renderSpyglassOverlay(GuiGraphics p_282069_, float p_283442_) {
        float $$2;
        float $$3 = $$2 = (float)Math.min(p_282069_.guiWidth(), p_282069_.guiHeight());
        float $$4 = Math.min((float)p_282069_.guiWidth() / $$2, (float)p_282069_.guiHeight() / $$3) * p_283442_;
        int $$5 = Mth.floor($$2 * $$4);
        int $$6 = Mth.floor($$3 * $$4);
        int $$7 = (p_282069_.guiWidth() - $$5) / 2;
        int $$8 = (p_282069_.guiHeight() - $$6) / 2;
        int $$9 = $$7 + $$5;
        int $$10 = $$8 + $$6;
        p_282069_.blit(RenderPipelines.GUI_TEXTURED, SPYGLASS_SCOPE_LOCATION, $$7, $$8, 0.0f, 0.0f, $$5, $$6, $$5, $$6);
        p_282069_.fill(RenderPipelines.GUI, 0, $$10, p_282069_.guiWidth(), p_282069_.guiHeight(), -16777216);
        p_282069_.fill(RenderPipelines.GUI, 0, 0, p_282069_.guiWidth(), $$8, -16777216);
        p_282069_.fill(RenderPipelines.GUI, 0, $$8, $$7, $$10, -16777216);
        p_282069_.fill(RenderPipelines.GUI, $$9, $$8, p_282069_.guiWidth(), $$10, -16777216);
    }

    private void updateVignetteBrightness(Entity p_93021_) {
        BlockPos $$1 = BlockPos.containing(p_93021_.getX(), p_93021_.getEyeY(), p_93021_.getZ());
        float $$2 = LightTexture.getBrightness(p_93021_.level().dimensionType(), p_93021_.level().getMaxLocalRawBrightness($$1));
        float $$3 = Mth.clamp(1.0f - $$2, 0.0f, 1.0f);
        this.vignetteBrightness += ($$3 - this.vignetteBrightness) * 0.01f;
    }

    private void renderVignette(GuiGraphics p_283063_, @Nullable Entity p_283439_) {
        int $$9;
        WorldBorder $$2 = this.minecraft.level.getWorldBorder();
        float $$3 = 0.0f;
        if (p_283439_ != null) {
            float $$4 = (float)$$2.getDistanceToBorder(p_283439_);
            double $$5 = Math.min($$2.getLerpSpeed() * (double)$$2.getWarningTime() * 1000.0, Math.abs($$2.getLerpTarget() - $$2.getSize()));
            double $$6 = Math.max((double)$$2.getWarningBlocks(), $$5);
            if ((double)$$4 < $$6) {
                $$3 = 1.0f - (float)((double)$$4 / $$6);
            }
        }
        if ($$3 > 0.0f) {
            $$3 = Mth.clamp($$3, 0.0f, 1.0f);
            int $$7 = ARGB.colorFromFloat(1.0f, 0.0f, $$3, $$3);
        } else {
            float $$8 = this.vignetteBrightness;
            $$8 = Mth.clamp($$8, 0.0f, 1.0f);
            $$9 = ARGB.colorFromFloat(1.0f, $$8, $$8, $$8);
        }
        p_283063_.blit(RenderPipelines.VIGNETTE, VIGNETTE_LOCATION, 0, 0, 0.0f, 0.0f, p_283063_.guiWidth(), p_283063_.guiHeight(), p_283063_.guiWidth(), p_283063_.guiHeight(), $$9);
    }

    private void renderPortalOverlay(GuiGraphics p_283375_, float p_283296_) {
        if (p_283296_ < 1.0f) {
            p_283296_ *= p_283296_;
            p_283296_ *= p_283296_;
            p_283296_ = p_283296_ * 0.8f + 0.2f;
        }
        int $$2 = ARGB.white(p_283296_);
        TextureAtlasSprite $$3 = this.minecraft.getBlockRenderer().getBlockModelShaper().getParticleIcon(Blocks.NETHER_PORTAL.defaultBlockState());
        p_283375_.blitSprite(RenderPipelines.GUI_TEXTURED, $$3, 0, 0, p_283375_.guiWidth(), p_283375_.guiHeight(), $$2);
    }

    private void renderConfusionOverlay(GuiGraphics p_361440_, float p_363322_) {
        int $$2 = p_361440_.guiWidth();
        int $$3 = p_361440_.guiHeight();
        p_361440_.pose().pushMatrix();
        float $$4 = Mth.lerp(p_363322_, 2.0f, 1.0f);
        p_361440_.pose().translate((float)$$2 / 2.0f, (float)$$3 / 2.0f);
        p_361440_.pose().scale($$4, $$4);
        p_361440_.pose().translate((float)(-$$2) / 2.0f, (float)(-$$3) / 2.0f);
        float $$5 = 0.2f * p_363322_;
        float $$6 = 0.4f * p_363322_;
        float $$7 = 0.2f * p_363322_;
        p_361440_.blit(RenderPipelines.GUI_NAUSEA_OVERLAY, NAUSEA_LOCATION, 0, 0, 0.0f, 0.0f, $$2, $$3, $$2, $$3, ARGB.colorFromFloat(1.0f, $$5, $$6, $$7));
        p_361440_.pose().popMatrix();
    }

    private void renderSlot(GuiGraphics p_283283_, int p_283213_, int p_281301_, DeltaTracker p_348541_, Player p_283644_, ItemStack p_283317_, int p_283261_) {
        if (p_283317_.isEmpty()) {
            return;
        }
        float $$7 = (float)p_283317_.getPopTime() - p_348541_.getGameTimeDeltaPartialTick(false);
        if ($$7 > 0.0f) {
            float $$8 = 1.0f + $$7 / 5.0f;
            p_283283_.pose().pushMatrix();
            p_283283_.pose().translate((float)(p_283213_ + 8), (float)(p_281301_ + 12));
            p_283283_.pose().scale(1.0f / $$8, ($$8 + 1.0f) / 2.0f);
            p_283283_.pose().translate((float)(-(p_283213_ + 8)), (float)(-(p_281301_ + 12)));
        }
        p_283283_.renderItem(p_283644_, p_283317_, p_283213_, p_281301_, p_283261_);
        if ($$7 > 0.0f) {
            p_283283_.pose().popMatrix();
        }
        p_283283_.renderItemDecorations(this.minecraft.font, p_283317_, p_283213_, p_281301_);
    }

    public void tick(boolean p_193833_) {
        this.tickAutosaveIndicator();
        if (!p_193833_) {
            this.tick();
        }
    }

    private void tick() {
        if (this.overlayMessageTime > 0) {
            --this.overlayMessageTime;
        }
        if (this.titleTime > 0) {
            --this.titleTime;
            if (this.titleTime <= 0) {
                this.title = null;
                this.subtitle = null;
            }
        }
        ++this.tickCount;
        Entity $$0 = this.minecraft.getCameraEntity();
        if ($$0 != null) {
            this.updateVignetteBrightness($$0);
        }
        if (this.minecraft.player != null) {
            ItemStack $$1 = this.minecraft.player.getInventory().getSelectedItem();
            if ($$1.isEmpty()) {
                this.toolHighlightTimer = 0;
            } else if (this.lastToolHighlight.isEmpty() || !$$1.is(this.lastToolHighlight.getItem()) || !$$1.getHoverName().equals(this.lastToolHighlight.getHoverName())) {
                this.toolHighlightTimer = (int)(40.0 * this.minecraft.options.notificationDisplayTime().get());
            } else if (this.toolHighlightTimer > 0) {
                --this.toolHighlightTimer;
            }
            this.lastToolHighlight = $$1;
        }
        this.chat.tick();
    }

    private void tickAutosaveIndicator() {
        IntegratedServer $$0 = this.minecraft.getSingleplayerServer();
        boolean $$1 = $$0 != null && $$0.isCurrentlySaving();
        this.lastAutosaveIndicatorValue = this.autosaveIndicatorValue;
        this.autosaveIndicatorValue = Mth.lerp(0.2f, this.autosaveIndicatorValue, $$1 ? 1.0f : 0.0f);
    }

    public void setNowPlaying(Component p_93056_) {
        MutableComponent $$1 = Component.translatable("record.nowPlaying", p_93056_);
        this.setOverlayMessage($$1, true);
        this.minecraft.getNarrator().saySystemNow($$1);
    }

    public void setOverlayMessage(Component p_93064_, boolean p_93065_) {
        this.setChatDisabledByPlayerShown(false);
        this.overlayMessageString = p_93064_;
        this.overlayMessageTime = 60;
        this.animateOverlayMessageColor = p_93065_;
    }

    public void setChatDisabledByPlayerShown(boolean p_238398_) {
        this.chatDisabledByPlayerShown = p_238398_;
    }

    public boolean isShowingChatDisabledByPlayer() {
        return this.chatDisabledByPlayerShown && this.overlayMessageTime > 0;
    }

    public void setTimes(int p_168685_, int p_168686_, int p_168687_) {
        if (p_168685_ >= 0) {
            this.titleFadeInTime = p_168685_;
        }
        if (p_168686_ >= 0) {
            this.titleStayTime = p_168686_;
        }
        if (p_168687_ >= 0) {
            this.titleFadeOutTime = p_168687_;
        }
        if (this.titleTime > 0) {
            this.titleTime = this.titleFadeInTime + this.titleStayTime + this.titleFadeOutTime;
        }
    }

    public void setSubtitle(Component p_168712_) {
        this.subtitle = p_168712_;
    }

    public void setTitle(Component p_168715_) {
        this.title = p_168715_;
        this.titleTime = this.titleFadeInTime + this.titleStayTime + this.titleFadeOutTime;
    }

    public void clearTitles() {
        this.title = null;
        this.subtitle = null;
        this.titleTime = 0;
    }

    public ChatComponent getChat() {
        return this.chat;
    }

    public int getGuiTicks() {
        return this.tickCount;
    }

    public Font getFont() {
        return this.minecraft.font;
    }

    public SpectatorGui getSpectatorGui() {
        return this.spectatorGui;
    }

    public PlayerTabOverlay getTabList() {
        return this.tabList;
    }

    public void onDisconnected() {
        this.tabList.reset();
        this.bossOverlay.reset();
        this.minecraft.getToastManager().clear();
        this.debugOverlay.reset();
        this.chat.clearMessages(true);
        this.clearTitles();
        this.resetTitleTimes();
    }

    public BossHealthOverlay getBossOverlay() {
        return this.bossOverlay;
    }

    public DebugScreenOverlay getDebugOverlay() {
        return this.debugOverlay;
    }

    public void clearCache() {
        this.debugOverlay.clearChunkCache();
    }

    public void renderSavingIndicator(GuiGraphics p_282761_, DeltaTracker p_348592_) {
        int $$2;
        if (this.minecraft.options.showAutosaveIndicator().get().booleanValue() && (this.autosaveIndicatorValue > 0.0f || this.lastAutosaveIndicatorValue > 0.0f) && ($$2 = Mth.floor(255.0f * Mth.clamp(Mth.lerp(p_348592_.getRealtimeDeltaTicks(), this.lastAutosaveIndicatorValue, this.autosaveIndicatorValue), 0.0f, 1.0f))) > 0) {
            Font $$3 = this.getFont();
            int $$4 = $$3.width(SAVING_TEXT);
            int $$5 = ARGB.color($$2, -1);
            int $$6 = p_282761_.guiWidth() - $$4 - 5;
            int $$7 = p_282761_.guiHeight() - $$3.lineHeight - 5;
            p_282761_.nextStratum();
            p_282761_.drawStringWithBackdrop($$3, SAVING_TEXT, $$6, $$7, $$4, $$5);
        }
    }

    private boolean willPrioritizeExperienceInfo() {
        return this.minecraft.player.experienceDisplayStartTick + 100 > this.minecraft.player.tickCount;
    }

    private boolean willPrioritizeJumpInfo() {
        return this.minecraft.player.getJumpRidingScale() > 0.0f || Optionull.mapOrDefault(this.minecraft.player.jumpableVehicle(), PlayerRideableJumping::getJumpCooldown, 0) > 0;
    }

    private ContextualInfo nextContextualInfoState() {
        boolean $$0 = this.minecraft.player.connection.getWaypointManager().hasWaypoints();
        boolean $$1 = this.minecraft.player.jumpableVehicle() != null;
        boolean $$2 = this.minecraft.gameMode.hasExperience();
        if ($$0) {
            if ($$1 && this.willPrioritizeJumpInfo()) {
                return ContextualInfo.JUMPABLE_VEHICLE;
            }
            if ($$2 && this.willPrioritizeExperienceInfo()) {
                return ContextualInfo.EXPERIENCE;
            }
            return ContextualInfo.LOCATOR;
        }
        if ($$1) {
            return ContextualInfo.JUMPABLE_VEHICLE;
        }
        if ($$2) {
            return ContextualInfo.EXPERIENCE;
        }
        return ContextualInfo.EMPTY;
    }

    static enum ContextualInfo {
        EMPTY,
        EXPERIENCE,
        LOCATOR,
        JUMPABLE_VEHICLE;

    }

    static enum HeartType {
        CONTAINER(ResourceLocation.withDefaultNamespace("hud/heart/container"), ResourceLocation.withDefaultNamespace("hud/heart/container_blinking"), ResourceLocation.withDefaultNamespace("hud/heart/container"), ResourceLocation.withDefaultNamespace("hud/heart/container_blinking"), ResourceLocation.withDefaultNamespace("hud/heart/container_hardcore"), ResourceLocation.withDefaultNamespace("hud/heart/container_hardcore_blinking"), ResourceLocation.withDefaultNamespace("hud/heart/container_hardcore"), ResourceLocation.withDefaultNamespace("hud/heart/container_hardcore_blinking")),
        NORMAL(ResourceLocation.withDefaultNamespace("hud/heart/full"), ResourceLocation.withDefaultNamespace("hud/heart/full_blinking"), ResourceLocation.withDefaultNamespace("hud/heart/half"), ResourceLocation.withDefaultNamespace("hud/heart/half_blinking"), ResourceLocation.withDefaultNamespace("hud/heart/hardcore_full"), ResourceLocation.withDefaultNamespace("hud/heart/hardcore_full_blinking"), ResourceLocation.withDefaultNamespace("hud/heart/hardcore_half"), ResourceLocation.withDefaultNamespace("hud/heart/hardcore_half_blinking")),
        POISIONED(ResourceLocation.withDefaultNamespace("hud/heart/poisoned_full"), ResourceLocation.withDefaultNamespace("hud/heart/poisoned_full_blinking"), ResourceLocation.withDefaultNamespace("hud/heart/poisoned_half"), ResourceLocation.withDefaultNamespace("hud/heart/poisoned_half_blinking"), ResourceLocation.withDefaultNamespace("hud/heart/poisoned_hardcore_full"), ResourceLocation.withDefaultNamespace("hud/heart/poisoned_hardcore_full_blinking"), ResourceLocation.withDefaultNamespace("hud/heart/poisoned_hardcore_half"), ResourceLocation.withDefaultNamespace("hud/heart/poisoned_hardcore_half_blinking")),
        WITHERED(ResourceLocation.withDefaultNamespace("hud/heart/withered_full"), ResourceLocation.withDefaultNamespace("hud/heart/withered_full_blinking"), ResourceLocation.withDefaultNamespace("hud/heart/withered_half"), ResourceLocation.withDefaultNamespace("hud/heart/withered_half_blinking"), ResourceLocation.withDefaultNamespace("hud/heart/withered_hardcore_full"), ResourceLocation.withDefaultNamespace("hud/heart/withered_hardcore_full_blinking"), ResourceLocation.withDefaultNamespace("hud/heart/withered_hardcore_half"), ResourceLocation.withDefaultNamespace("hud/heart/withered_hardcore_half_blinking")),
        ABSORBING(ResourceLocation.withDefaultNamespace("hud/heart/absorbing_full"), ResourceLocation.withDefaultNamespace("hud/heart/absorbing_full_blinking"), ResourceLocation.withDefaultNamespace("hud/heart/absorbing_half"), ResourceLocation.withDefaultNamespace("hud/heart/absorbing_half_blinking"), ResourceLocation.withDefaultNamespace("hud/heart/absorbing_hardcore_full"), ResourceLocation.withDefaultNamespace("hud/heart/absorbing_hardcore_full_blinking"), ResourceLocation.withDefaultNamespace("hud/heart/absorbing_hardcore_half"), ResourceLocation.withDefaultNamespace("hud/heart/absorbing_hardcore_half_blinking")),
        FROZEN(ResourceLocation.withDefaultNamespace("hud/heart/frozen_full"), ResourceLocation.withDefaultNamespace("hud/heart/frozen_full_blinking"), ResourceLocation.withDefaultNamespace("hud/heart/frozen_half"), ResourceLocation.withDefaultNamespace("hud/heart/frozen_half_blinking"), ResourceLocation.withDefaultNamespace("hud/heart/frozen_hardcore_full"), ResourceLocation.withDefaultNamespace("hud/heart/frozen_hardcore_full_blinking"), ResourceLocation.withDefaultNamespace("hud/heart/frozen_hardcore_half"), ResourceLocation.withDefaultNamespace("hud/heart/frozen_hardcore_half_blinking"));

        private final ResourceLocation full;
        private final ResourceLocation fullBlinking;
        private final ResourceLocation half;
        private final ResourceLocation halfBlinking;
        private final ResourceLocation hardcoreFull;
        private final ResourceLocation hardcoreFullBlinking;
        private final ResourceLocation hardcoreHalf;
        private final ResourceLocation hardcoreHalfBlinking;

        private HeartType(ResourceLocation p_294435_, ResourceLocation p_294438_, ResourceLocation p_295036_, ResourceLocation p_295439_, ResourceLocation p_296249_, ResourceLocation p_295479_, ResourceLocation p_296219_, ResourceLocation p_296437_) {
            this.full = p_294435_;
            this.fullBlinking = p_294438_;
            this.half = p_295036_;
            this.halfBlinking = p_295439_;
            this.hardcoreFull = p_296249_;
            this.hardcoreFullBlinking = p_295479_;
            this.hardcoreHalf = p_296219_;
            this.hardcoreHalfBlinking = p_296437_;
        }

        public ResourceLocation getSprite(boolean p_295909_, boolean p_295387_, boolean p_294486_) {
            if (!p_295909_) {
                if (p_295387_) {
                    return p_294486_ ? this.halfBlinking : this.half;
                }
                return p_294486_ ? this.fullBlinking : this.full;
            }
            if (p_295387_) {
                return p_294486_ ? this.hardcoreHalfBlinking : this.hardcoreHalf;
            }
            return p_294486_ ? this.hardcoreFullBlinking : this.hardcoreFull;
        }

        static HeartType forPlayer(Player p_168733_) {
            HeartType $$4;
            if (p_168733_.hasEffect(MobEffects.POISON)) {
                HeartType $$1 = POISIONED;
            } else if (p_168733_.hasEffect(MobEffects.WITHER)) {
                HeartType $$2 = WITHERED;
            } else if (p_168733_.isFullyFrozen()) {
                HeartType $$3 = FROZEN;
            } else {
                $$4 = NORMAL;
            }
            return $$4;
        }
    }

    public static interface RenderFunction {
        public void render(GuiGraphics var1, DeltaTracker var2);
    }
}

