/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.ScrollWheelHandler;
import net.minecraft.client.gui.ItemSlotMouseAction;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.game.ServerboundSelectBundleItemPacket;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector2i;

public class BundleMouseActions
implements ItemSlotMouseAction {
    private final Minecraft minecraft;
    private final ScrollWheelHandler scrollWheelHandler;

    public BundleMouseActions(Minecraft p_361400_) {
        this.minecraft = p_361400_;
        this.scrollWheelHandler = new ScrollWheelHandler();
    }

    @Override
    public boolean matches(Slot p_360559_) {
        return p_360559_.getItem().is(ItemTags.BUNDLES);
    }

    @Override
    public boolean onMouseScrolled(double p_360390_, double p_362650_, int p_363161_, ItemStack p_364763_) {
        int $$8;
        int $$7;
        int $$6;
        int $$4 = BundleItem.getNumberOfItemsToShow(p_364763_);
        if ($$4 == 0) {
            return false;
        }
        Vector2i $$5 = this.scrollWheelHandler.onMouseScroll(p_360390_, p_362650_);
        int n = $$6 = $$5.y == 0 ? -$$5.x : $$5.y;
        if ($$6 != 0 && ($$7 = BundleItem.getSelectedItem(p_364763_)) != ($$8 = ScrollWheelHandler.getNextScrollWheelSelection($$6, $$7, $$4))) {
            this.toggleSelectedBundleItem(p_364763_, p_363161_, $$8);
        }
        return true;
    }

    @Override
    public void onStopHovering(Slot p_363289_) {
        this.unselectedBundleItem(p_363289_.getItem(), p_363289_.index);
    }

    @Override
    public void onSlotClicked(Slot p_372932_, ClickType p_372800_) {
        if (p_372800_ == ClickType.QUICK_MOVE || p_372800_ == ClickType.SWAP) {
            this.unselectedBundleItem(p_372932_.getItem(), p_372932_.index);
        }
    }

    private void toggleSelectedBundleItem(ItemStack p_364573_, int p_364078_, int p_365257_) {
        if (this.minecraft.getConnection() != null && p_365257_ < BundleItem.getNumberOfItemsToShow(p_364573_)) {
            ClientPacketListener $$3 = this.minecraft.getConnection();
            BundleItem.toggleSelectedItem(p_364573_, p_365257_);
            $$3.send(new ServerboundSelectBundleItemPacket(p_364078_, p_365257_));
        }
    }

    public void unselectedBundleItem(ItemStack p_365339_, int p_363847_) {
        this.toggleSelectedBundleItem(p_365339_, p_363847_, -1);
    }
}

