/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.data;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.renderer.MaterialMapper;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BellRenderer;
import net.minecraft.client.renderer.blockentity.ConduitRenderer;
import net.minecraft.client.renderer.blockentity.EnchantTableRenderer;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSources;
import net.minecraft.client.renderer.texture.atlas.sources.DirectoryLister;
import net.minecraft.client.renderer.texture.atlas.sources.PalettedPermutations;
import net.minecraft.client.renderer.texture.atlas.sources.SingleFile;
import net.minecraft.client.resources.model.AtlasIds;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.equipment.trim.MaterialAssetGroup;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.item.equipment.trim.TrimPatterns;

public class AtlasProvider
implements DataProvider {
    private static final ResourceLocation TRIM_PALETTE_KEY = ResourceLocation.withDefaultNamespace("trims/color_palettes/trim_palette");
    private static final Map<String, ResourceLocation> TRIM_PALETTE_VALUES = AtlasProvider.extractAllMaterialAssets().collect(Collectors.toMap(MaterialAssetGroup.AssetInfo::suffix, p_400184_ -> ResourceLocation.withDefaultNamespace("trims/color_palettes/" + p_400184_.suffix())));
    private static final List<ResourceKey<TrimPattern>> VANILLA_PATTERNS = List.of(TrimPatterns.SENTRY, TrimPatterns.DUNE, TrimPatterns.COAST, TrimPatterns.WILD, TrimPatterns.WARD, TrimPatterns.EYE, TrimPatterns.VEX, TrimPatterns.TIDE, TrimPatterns.SNOUT, TrimPatterns.RIB, TrimPatterns.SPIRE, TrimPatterns.WAYFINDER, TrimPatterns.SHAPER, TrimPatterns.SILENCE, TrimPatterns.RAISER, TrimPatterns.HOST, TrimPatterns.FLOW, TrimPatterns.BOLT);
    private static final List<EquipmentClientInfo.LayerType> HUMANOID_LAYERS = List.of(EquipmentClientInfo.LayerType.HUMANOID, EquipmentClientInfo.LayerType.HUMANOID_LEGGINGS);
    private final PackOutput.PathProvider pathProvider;

    public AtlasProvider(PackOutput p_400091_) {
        this.pathProvider = p_400091_.createPathProvider(PackOutput.Target.RESOURCE_PACK, "atlases");
    }

    private static List<ResourceLocation> patternTextures() {
        ArrayList<ResourceLocation> $$0 = new ArrayList<ResourceLocation>(VANILLA_PATTERNS.size() * HUMANOID_LAYERS.size());
        for (ResourceKey<TrimPattern> $$1 : VANILLA_PATTERNS) {
            ResourceLocation $$2 = TrimPatterns.defaultAssetId($$1);
            for (EquipmentClientInfo.LayerType $$3 : HUMANOID_LAYERS) {
                $$0.add($$2.withPath(p_399824_ -> $$3.trimAssetPrefix() + "/" + p_399824_));
            }
        }
        return $$0;
    }

    private static SpriteSource forMaterial(Material p_399538_) {
        return new SingleFile(p_399538_.texture());
    }

    private static SpriteSource forMapper(MaterialMapper p_400274_) {
        return new DirectoryLister(p_400274_.prefix(), p_400274_.prefix() + "/");
    }

    private static List<SpriteSource> simpleMapper(MaterialMapper p_399878_) {
        return List.of(AtlasProvider.forMapper(p_399878_));
    }

    private static List<SpriteSource> noPrefixMapper(String p_400275_) {
        return List.of(new DirectoryLister(p_400275_, ""));
    }

    private static Stream<MaterialAssetGroup.AssetInfo> extractAllMaterialAssets() {
        return ItemModelGenerators.TRIM_MATERIAL_MODELS.stream().map(ItemModelGenerators.TrimMaterialData::assets).flatMap(p_400261_ -> Stream.concat(Stream.of(p_400261_.base()), p_400261_.overrides().values().stream())).sorted(Comparator.comparing(MaterialAssetGroup.AssetInfo::suffix));
    }

    private static List<SpriteSource> armorTrims() {
        return List.of(new PalettedPermutations(AtlasProvider.patternTextures(), TRIM_PALETTE_KEY, TRIM_PALETTE_VALUES));
    }

    private static List<SpriteSource> blocksList() {
        return List.of(AtlasProvider.forMapper(Sheets.BLOCKS_MAPPER), AtlasProvider.forMapper(Sheets.ITEMS_MAPPER), AtlasProvider.forMapper(ConduitRenderer.MAPPER), AtlasProvider.forMaterial(BellRenderer.BELL_RESOURCE_LOCATION), AtlasProvider.forMaterial(Sheets.DECORATED_POT_SIDE), AtlasProvider.forMaterial(EnchantTableRenderer.BOOK_LOCATION), new PalettedPermutations(List.of(ItemModelGenerators.TRIM_PREFIX_HELMET, ItemModelGenerators.TRIM_PREFIX_CHESTPLATE, ItemModelGenerators.TRIM_PREFIX_LEGGINGS, ItemModelGenerators.TRIM_PREFIX_BOOTS), TRIM_PALETTE_KEY, TRIM_PALETTE_VALUES));
    }

    private static List<SpriteSource> bannerPatterns() {
        return List.of(AtlasProvider.forMaterial(ModelBakery.BANNER_BASE), AtlasProvider.forMapper(Sheets.BANNER_MAPPER));
    }

    private static List<SpriteSource> shieldPatterns() {
        return List.of(AtlasProvider.forMaterial(ModelBakery.SHIELD_BASE), AtlasProvider.forMaterial(ModelBakery.NO_PATTERN_SHIELD), AtlasProvider.forMapper(Sheets.SHIELD_MAPPER));
    }

    private static List<SpriteSource> guiSprites() {
        return List.of(new DirectoryLister("gui/sprites", ""), new DirectoryLister("mob_effect", "mob_effect/"));
    }

    @Override
    public CompletableFuture<?> run(CachedOutput p_400189_) {
        return CompletableFuture.allOf(this.storeAtlas(p_400189_, AtlasIds.ARMOR_TRIMS, AtlasProvider.armorTrims()), this.storeAtlas(p_400189_, AtlasIds.BANNER_PATTERNS, AtlasProvider.bannerPatterns()), this.storeAtlas(p_400189_, AtlasIds.BEDS, AtlasProvider.simpleMapper(Sheets.BED_MAPPER)), this.storeAtlas(p_400189_, AtlasIds.BLOCKS, AtlasProvider.blocksList()), this.storeAtlas(p_400189_, AtlasIds.CHESTS, AtlasProvider.simpleMapper(Sheets.CHEST_MAPPER)), this.storeAtlas(p_400189_, AtlasIds.DECORATED_POT, AtlasProvider.simpleMapper(Sheets.DECORATED_POT_MAPPER)), this.storeAtlas(p_400189_, AtlasIds.GUI, AtlasProvider.guiSprites()), this.storeAtlas(p_400189_, AtlasIds.MAP_DECORATIONS, AtlasProvider.noPrefixMapper("map/decorations")), this.storeAtlas(p_400189_, AtlasIds.PAINTINGS, AtlasProvider.noPrefixMapper("painting")), this.storeAtlas(p_400189_, AtlasIds.PARTICLES, AtlasProvider.noPrefixMapper("particle")), this.storeAtlas(p_400189_, AtlasIds.SHIELD_PATTERNS, AtlasProvider.shieldPatterns()), this.storeAtlas(p_400189_, AtlasIds.SHULKER_BOXES, AtlasProvider.simpleMapper(Sheets.SHULKER_MAPPER)), this.storeAtlas(p_400189_, AtlasIds.SIGNS, AtlasProvider.simpleMapper(Sheets.SIGN_MAPPER)));
    }

    private CompletableFuture<?> storeAtlas(CachedOutput p_399787_, ResourceLocation p_399960_, List<SpriteSource> p_399735_) {
        return DataProvider.saveStable(p_399787_, SpriteSources.FILE_CODEC, p_399735_, this.pathProvider.json(p_399960_));
    }

    @Override
    public String getName() {
        return "Atlas Definitions";
    }
}

