/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.color;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;

public class ColorLerper {
    public static final DyeColor[] MUSIC_NOTE_COLORS = new DyeColor[]{DyeColor.WHITE, DyeColor.LIGHT_GRAY, DyeColor.LIGHT_BLUE, DyeColor.BLUE, DyeColor.CYAN, DyeColor.GREEN, DyeColor.LIME, DyeColor.YELLOW, DyeColor.ORANGE, DyeColor.PINK, DyeColor.RED, DyeColor.MAGENTA};

    public static int getLerpedColor(Type p_425899_, float p_425551_) {
        int $$2 = Mth.floor(p_425551_);
        int $$3 = $$2 / p_425899_.colorDuration;
        int $$4 = p_425899_.colors.length;
        int $$5 = $$3 % $$4;
        int $$6 = ($$3 + 1) % $$4;
        float $$7 = ((float)($$2 % p_425899_.colorDuration) + Mth.frac(p_425551_)) / (float)p_425899_.colorDuration;
        int $$8 = p_425899_.getColor(p_425899_.colors[$$5]);
        int $$9 = p_425899_.getColor(p_425899_.colors[$$6]);
        return ARGB.lerp($$7, $$8, $$9);
    }

    static int getModifiedColor(DyeColor p_426206_, float p_425908_) {
        if (p_426206_ == DyeColor.WHITE) {
            return -1644826;
        }
        int $$2 = p_426206_.getTextureDiffuseColor();
        return ARGB.color(255, Mth.floor((float)ARGB.red($$2) * p_425908_), Mth.floor((float)ARGB.green($$2) * p_425908_), Mth.floor((float)ARGB.blue($$2) * p_425908_));
    }

    public static enum Type {
        SHEEP(25, DyeColor.values(), 0.75f),
        MUSIC_NOTE(30, MUSIC_NOTE_COLORS, 1.25f);

        final int colorDuration;
        private final Map<DyeColor, Integer> colorByDye;
        final DyeColor[] colors;

        private Type(int p_425636_, DyeColor[] p_425741_, float p_426017_) {
            this.colorDuration = p_425636_;
            this.colorByDye = Maps.newHashMap(Arrays.stream(p_425741_).collect(Collectors.toMap(p_426174_ -> p_426174_, p_426111_ -> ColorLerper.getModifiedColor(p_426111_, p_426017_))));
            this.colors = p_425741_;
        }

        public final int getColor(DyeColor p_425757_) {
            return this.colorByDye.get(p_425757_);
        }
    }
}

