/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.mojang.logging.LogUtils;
import com.mojang.text2speech.Narrator;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.NarratorStatus;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.main.SilentInitException;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import org.slf4j.Logger;

public class GameNarrator {
    public static final Component NO_TITLE = CommonComponents.EMPTY;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Minecraft minecraft;
    private final Narrator narrator = Narrator.getNarrator();

    public GameNarrator(Minecraft p_240577_) {
        this.minecraft = p_240577_;
    }

    public void sayChatQueued(Component p_416158_) {
        if (this.getStatus().shouldNarrateChat()) {
            this.narrateNotInterruptingMessage(p_416158_);
        }
    }

    public void saySystemChatQueued(Component p_415662_) {
        if (this.getStatus().shouldNarrateSystemOrChat()) {
            this.narrateNotInterruptingMessage(p_415662_);
        }
    }

    public void saySystemQueued(Component p_415589_) {
        if (this.getStatus().shouldNarrateSystem()) {
            this.narrateNotInterruptingMessage(p_415589_);
        }
    }

    private void narrateNotInterruptingMessage(Component p_416450_) {
        String $$1 = p_416450_.getString();
        if (!$$1.isEmpty()) {
            this.logNarratedMessage($$1);
            this.narrateMessage($$1, false);
        }
    }

    public void saySystemNow(Component p_416329_) {
        this.saySystemNow(p_416329_.getString());
    }

    public void saySystemNow(String p_93320_) {
        if (this.getStatus().shouldNarrateSystem() && !p_93320_.isEmpty()) {
            this.logNarratedMessage(p_93320_);
            if (this.narrator.active()) {
                this.narrator.clear();
                this.narrateMessage(p_93320_, true);
            }
        }
    }

    private void narrateMessage(String p_394162_, boolean p_394666_) {
        this.narrator.say(p_394162_, p_394666_, this.minecraft.options.getSoundSourceVolume(SoundSource.VOICE) * this.minecraft.options.getSoundSourceVolume(SoundSource.MASTER));
    }

    private NarratorStatus getStatus() {
        return this.minecraft.options.narrator().get();
    }

    private void logNarratedMessage(String p_168788_) {
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            LOGGER.debug("Narrating: {}", (Object)p_168788_.replaceAll("\n", "\\\\n"));
        }
    }

    public void updateNarratorStatus(NarratorStatus p_93318_) {
        this.clear();
        this.narrateMessage(Component.translatable("options.narrator").append(" : ").append(p_93318_.getName()).getString(), true);
        ToastManager $$1 = Minecraft.getInstance().getToastManager();
        if (this.narrator.active()) {
            if (p_93318_ == NarratorStatus.OFF) {
                SystemToast.addOrUpdate($$1, SystemToast.SystemToastId.NARRATOR_TOGGLE, Component.translatable("narrator.toast.disabled"), null);
            } else {
                SystemToast.addOrUpdate($$1, SystemToast.SystemToastId.NARRATOR_TOGGLE, Component.translatable("narrator.toast.enabled"), p_93318_.getName());
            }
        } else {
            SystemToast.addOrUpdate($$1, SystemToast.SystemToastId.NARRATOR_TOGGLE, Component.translatable("narrator.toast.disabled"), Component.translatable("options.narrator.notavailable"));
        }
    }

    public boolean isActive() {
        return this.narrator.active();
    }

    public void clear() {
        if (this.getStatus() == NarratorStatus.OFF || !this.narrator.active()) {
            return;
        }
        this.narrator.clear();
    }

    public void destroy() {
        this.narrator.destroy();
    }

    public void checkStatus(boolean p_289016_) {
        if (p_289016_ && !this.isActive() && !TinyFileDialogs.tinyfd_messageBox((CharSequence)"Minecraft", (CharSequence)"Failed to initialize text-to-speech library. Do you want to continue?\nIf this problem persists, please report it at bugs.mojang.com", (CharSequence)"yesno", (CharSequence)"error", (boolean)true)) {
            throw new NarratorInitException("Narrator library is not active");
        }
    }

    public static class NarratorInitException
    extends SilentInitException {
        public NarratorInitException(String p_288985_) {
            super(p_288985_);
        }
    }
}

