/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.entity.vehicle.NewMinecartBehavior;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.waypoints.TrackedWaypoint;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Camera
implements TrackedWaypoint.Camera {
    private static final float DEFAULT_CAMERA_DISTANCE = 4.0f;
    private static final Vector3f FORWARDS = new Vector3f(0.0f, 0.0f, -1.0f);
    private static final Vector3f UP = new Vector3f(0.0f, 1.0f, 0.0f);
    private static final Vector3f LEFT = new Vector3f(-1.0f, 0.0f, 0.0f);
    private boolean initialized;
    private BlockGetter level;
    private Entity entity;
    private Vec3 position = Vec3.ZERO;
    private final BlockPos.MutableBlockPos blockPosition = new BlockPos.MutableBlockPos();
    private final Vector3f forwards = new Vector3f((Vector3fc)FORWARDS);
    private final Vector3f up = new Vector3f((Vector3fc)UP);
    private final Vector3f left = new Vector3f((Vector3fc)LEFT);
    private float xRot;
    private float yRot;
    private final Quaternionf rotation = new Quaternionf();
    private boolean detached;
    private float eyeHeight;
    private float eyeHeightOld;
    private float partialTickTime;
    public static final float FOG_DISTANCE_SCALE = 0.083333336f;

    public void setup(BlockGetter p_90576_, Entity p_90577_, boolean p_90578_, boolean p_90579_, float p_90580_) {
        NewMinecartBehavior $$6;
        Minecart $$5;
        Object object;
        this.initialized = true;
        this.level = p_90576_;
        this.entity = p_90577_;
        this.detached = p_90578_;
        this.partialTickTime = p_90580_;
        if (p_90577_.isPassenger() && (object = p_90577_.getVehicle()) instanceof Minecart && (object = ($$5 = (Minecart)object).getBehavior()) instanceof NewMinecartBehavior && ($$6 = (NewMinecartBehavior)object).cartHasPosRotLerp()) {
            Vec3 $$7 = $$5.getPassengerRidingPosition(p_90577_).subtract($$5.position()).subtract(p_90577_.getVehicleAttachmentPoint($$5)).add(new Vec3(0.0, Mth.lerp(p_90580_, this.eyeHeightOld, this.eyeHeight), 0.0));
            this.setRotation(p_90577_.getViewYRot(p_90580_), p_90577_.getViewXRot(p_90580_));
            this.setPosition($$6.getCartLerpPosition(p_90580_).add($$7));
        } else {
            this.setRotation(p_90577_.getViewYRot(p_90580_), p_90577_.getViewXRot(p_90580_));
            this.setPosition(Mth.lerp((double)p_90580_, p_90577_.xo, p_90577_.getX()), Mth.lerp((double)p_90580_, p_90577_.yo, p_90577_.getY()) + (double)Mth.lerp(p_90580_, this.eyeHeightOld, this.eyeHeight), Mth.lerp((double)p_90580_, p_90577_.zo, p_90577_.getZ()));
        }
        if (p_90578_) {
            Entity entity;
            if (p_90579_) {
                this.setRotation(this.yRot + 180.0f, -this.xRot);
            }
            float $$8 = 4.0f;
            float $$9 = 1.0f;
            if (p_90577_ instanceof LivingEntity) {
                LivingEntity $$10 = (LivingEntity)p_90577_;
                $$9 = $$10.getScale();
                $$8 = (float)$$10.getAttributeValue(Attributes.CAMERA_DISTANCE);
            }
            float $$11 = $$9;
            float $$12 = $$8;
            if (p_90577_.isPassenger() && (entity = p_90577_.getVehicle()) instanceof LivingEntity) {
                LivingEntity $$13 = (LivingEntity)entity;
                $$11 = $$13.getScale();
                $$12 = (float)$$13.getAttributeValue(Attributes.CAMERA_DISTANCE);
            }
            this.move(-this.getMaxZoom(Math.max($$9 * $$8, $$11 * $$12)), 0.0f, 0.0f);
        } else if (p_90577_ instanceof LivingEntity && ((LivingEntity)p_90577_).isSleeping()) {
            Direction $$14 = ((LivingEntity)p_90577_).getBedOrientation();
            this.setRotation($$14 != null ? $$14.toYRot() - 180.0f : 0.0f, 0.0f);
            this.move(0.0f, 0.3f, 0.0f);
        }
    }

    public void tick() {
        if (this.entity != null) {
            this.eyeHeightOld = this.eyeHeight;
            this.eyeHeight += (this.entity.getEyeHeight() - this.eyeHeight) * 0.5f;
        }
    }

    private float getMaxZoom(float p_350335_) {
        float $$1 = 0.1f;
        for (int $$2 = 0; $$2 < 8; ++$$2) {
            float $$9;
            Vec3 $$7;
            float $$3 = ($$2 & 1) * 2 - 1;
            float $$4 = ($$2 >> 1 & 1) * 2 - 1;
            float $$5 = ($$2 >> 2 & 1) * 2 - 1;
            Vec3 $$6 = this.position.add($$3 * 0.1f, $$4 * 0.1f, $$5 * 0.1f);
            BlockHitResult $$8 = this.level.clip(new ClipContext($$6, $$7 = $$6.add(new Vec3(this.forwards).scale(-p_350335_)), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, this.entity));
            if (((HitResult)$$8).getType() == HitResult.Type.MISS || !(($$9 = (float)$$8.getLocation().distanceToSqr(this.position)) < Mth.square(p_350335_))) continue;
            p_350335_ = Mth.sqrt($$9);
        }
        return p_350335_;
    }

    protected void move(float p_351037_, float p_351008_, float p_350869_) {
        Vector3f $$3 = new Vector3f(p_350869_, p_351008_, -p_351037_).rotate((Quaternionfc)this.rotation);
        this.setPosition(new Vec3(this.position.x + (double)$$3.x, this.position.y + (double)$$3.y, this.position.z + (double)$$3.z));
    }

    protected void setRotation(float p_90573_, float p_90574_) {
        this.xRot = p_90574_;
        this.yRot = p_90573_;
        this.rotation.rotationYXZ((float)Math.PI - p_90573_ * ((float)Math.PI / 180), -p_90574_ * ((float)Math.PI / 180), 0.0f);
        FORWARDS.rotate((Quaternionfc)this.rotation, this.forwards);
        UP.rotate((Quaternionfc)this.rotation, this.up);
        LEFT.rotate((Quaternionfc)this.rotation, this.left);
    }

    protected void setPosition(double p_90585_, double p_90586_, double p_90587_) {
        this.setPosition(new Vec3(p_90585_, p_90586_, p_90587_));
    }

    protected void setPosition(Vec3 p_90582_) {
        this.position = p_90582_;
        this.blockPosition.set(p_90582_.x, p_90582_.y, p_90582_.z);
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public BlockPos getBlockPosition() {
        return this.blockPosition;
    }

    public float getXRot() {
        return this.xRot;
    }

    public float getYRot() {
        return this.yRot;
    }

    public Quaternionf rotation() {
        return this.rotation;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isDetached() {
        return this.detached;
    }

    public NearPlane getNearPlane() {
        Minecraft $$0 = Minecraft.getInstance();
        double $$1 = (double)$$0.getWindow().getWidth() / (double)$$0.getWindow().getHeight();
        double $$2 = Math.tan((double)((float)$$0.options.fov().get().intValue() * ((float)Math.PI / 180)) / 2.0) * (double)0.05f;
        double $$3 = $$2 * $$1;
        Vec3 $$4 = new Vec3(this.forwards).scale(0.05f);
        Vec3 $$5 = new Vec3(this.left).scale($$3);
        Vec3 $$6 = new Vec3(this.up).scale($$2);
        return new NearPlane($$4, $$5, $$6);
    }

    public FogType getFluidInCamera() {
        if (!this.initialized) {
            return FogType.NONE;
        }
        FluidState $$0 = this.level.getFluidState(this.blockPosition);
        if ($$0.is(FluidTags.WATER) && this.position.y < (double)((float)this.blockPosition.getY() + $$0.getHeight(this.level, this.blockPosition))) {
            return FogType.WATER;
        }
        NearPlane $$1 = this.getNearPlane();
        List<Vec3> $$2 = Arrays.asList($$1.forward, $$1.getTopLeft(), $$1.getTopRight(), $$1.getBottomLeft(), $$1.getBottomRight());
        for (Vec3 $$3 : $$2) {
            Vec3 $$4 = this.position.add($$3);
            BlockPos $$5 = BlockPos.containing($$4);
            FluidState $$6 = this.level.getFluidState($$5);
            if ($$6.is(FluidTags.LAVA)) {
                if (!($$4.y <= (double)($$6.getHeight(this.level, $$5) + (float)$$5.getY()))) continue;
                return FogType.LAVA;
            }
            BlockState $$7 = this.level.getBlockState($$5);
            if (!$$7.is(Blocks.POWDER_SNOW)) continue;
            return FogType.POWDER_SNOW;
        }
        return FogType.NONE;
    }

    public final Vector3f getLookVector() {
        return this.forwards;
    }

    public final Vector3f getUpVector() {
        return this.up;
    }

    public final Vector3f getLeftVector() {
        return this.left;
    }

    public void reset() {
        this.level = null;
        this.entity = null;
        this.initialized = false;
    }

    public float getPartialTickTime() {
        return this.partialTickTime;
    }

    @Override
    public float yaw() {
        return Mth.wrapDegrees(this.getYRot());
    }

    @Override
    public Vec3 position() {
        return this.getPosition();
    }

    public static class NearPlane {
        final Vec3 forward;
        private final Vec3 left;
        private final Vec3 up;

        NearPlane(Vec3 p_167691_, Vec3 p_167692_, Vec3 p_167693_) {
            this.forward = p_167691_;
            this.left = p_167692_;
            this.up = p_167693_;
        }

        public Vec3 getTopLeft() {
            return this.forward.add(this.up).add(this.left);
        }

        public Vec3 getTopRight() {
            return this.forward.add(this.up).subtract(this.left);
        }

        public Vec3 getBottomLeft() {
            return this.forward.subtract(this.up).add(this.left);
        }

        public Vec3 getBottomRight() {
            return this.forward.subtract(this.up).subtract(this.left);
        }

        public Vec3 getPointOnPlane(float p_167696_, float p_167697_) {
            return this.forward.add(this.up.scale(p_167697_)).subtract(this.left.scale(p_167696_));
        }
    }
}

