/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;

public class PlayerInteractTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @Override
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer p_61495_, ItemStack p_61496_, Entity p_61497_) {
        LootContext $$3 = EntityPredicate.createContext(p_61495_, p_61497_);
        this.trigger(p_61495_, p_61501_ -> p_61501_.matches(p_61496_, $$3));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ItemPredicate> item, Optional<ContextAwarePredicate> entity) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(p_337387_ -> p_337387_.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ItemPredicate.CODEC.optionalFieldOf("item").forGetter(TriggerInstance::item), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("entity").forGetter(TriggerInstance::entity)).apply((Applicative)p_337387_, TriggerInstance::new));

        public static Criterion<TriggerInstance> itemUsedOnEntity(Optional<ContextAwarePredicate> p_299056_, ItemPredicate.Builder p_286289_, Optional<ContextAwarePredicate> p_301218_) {
            return CriteriaTriggers.PLAYER_INTERACTED_WITH_ENTITY.createCriterion(new TriggerInstance(p_299056_, Optional.of(p_286289_.build()), p_301218_));
        }

        public static Criterion<TriggerInstance> equipmentSheared(Optional<ContextAwarePredicate> p_428763_, ItemPredicate.Builder p_428765_, Optional<ContextAwarePredicate> p_428769_) {
            return CriteriaTriggers.PLAYER_SHEARED_EQUIPMENT.createCriterion(new TriggerInstance(p_428763_, Optional.of(p_428765_.build()), p_428769_));
        }

        public static Criterion<TriggerInstance> equipmentSheared(ItemPredicate.Builder p_428766_, Optional<ContextAwarePredicate> p_428762_) {
            return CriteriaTriggers.PLAYER_SHEARED_EQUIPMENT.createCriterion(new TriggerInstance(Optional.empty(), Optional.of(p_428766_.build()), p_428762_));
        }

        public static Criterion<TriggerInstance> itemUsedOnEntity(ItemPredicate.Builder p_286235_, Optional<ContextAwarePredicate> p_298893_) {
            return TriggerInstance.itemUsedOnEntity(Optional.empty(), p_286235_, p_298893_);
        }

        public boolean matches(ItemStack p_61522_, LootContext p_61523_) {
            if (this.item.isPresent() && !this.item.get().test(p_61522_)) {
                return false;
            }
            return this.entity.isEmpty() || this.entity.get().matches(p_61523_);
        }

        @Override
        public void validate(CriterionValidator p_312461_) {
            SimpleCriterionTrigger.SimpleInstance.super.validate(p_312461_);
            p_312461_.validateEntity(this.entity, "entity");
        }
    }
}

