/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class FishingRodHookedTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @Override
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer p_40417_, ItemStack p_40418_, FishingHook p_40419_, Collection<ItemStack> p_40420_) {
        LootContext $$4 = EntityPredicate.createContext(p_40417_, p_40419_.getHookedIn() != null ? p_40419_.getHookedIn() : p_40419_);
        this.trigger(p_40417_, p_40425_ -> p_40425_.matches(p_40418_, $$4, p_40420_));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ItemPredicate> rod, Optional<ContextAwarePredicate> entity, Optional<ItemPredicate> item) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(p_337365_ -> p_337365_.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ItemPredicate.CODEC.optionalFieldOf("rod").forGetter(TriggerInstance::rod), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("entity").forGetter(TriggerInstance::entity), (App)ItemPredicate.CODEC.optionalFieldOf("item").forGetter(TriggerInstance::item)).apply((Applicative)p_337365_, TriggerInstance::new));

        public static Criterion<TriggerInstance> fishedItem(Optional<ItemPredicate> p_298233_, Optional<EntityPredicate> p_298660_, Optional<ItemPredicate> p_298847_) {
            return CriteriaTriggers.FISHING_ROD_HOOKED.createCriterion(new TriggerInstance(Optional.empty(), p_298233_, EntityPredicate.wrap(p_298660_), p_298847_));
        }

        public boolean matches(ItemStack p_40444_, LootContext p_40445_, Collection<ItemStack> p_40446_) {
            if (this.rod.isPresent() && !this.rod.get().test(p_40444_)) {
                return false;
            }
            if (this.entity.isPresent() && !this.entity.get().matches(p_40445_)) {
                return false;
            }
            if (this.item.isPresent()) {
                boolean $$3 = false;
                Entity $$4 = p_40445_.getOptionalParameter(LootContextParams.THIS_ENTITY);
                if ($$4 instanceof ItemEntity) {
                    ItemEntity $$5 = (ItemEntity)$$4;
                    if (this.item.get().test($$5.getItem())) {
                        $$3 = true;
                    }
                }
                for (ItemStack $$6 : p_40446_) {
                    if (!this.item.get().test($$6)) continue;
                    $$3 = true;
                    break;
                }
                if (!$$3) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void validate(CriterionValidator p_312572_) {
            SimpleCriterionTrigger.SimpleInstance.super.validate(p_312572_);
            p_312572_.validateEntity(this.entity, "entity");
        }
    }
}

