/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.MovementPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.SlotsPredicate;
import net.minecraft.core.HolderGetter;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;

public record EntityPredicate(Optional<EntityTypePredicate> entityType, Optional<DistancePredicate> distanceToPlayer, Optional<MovementPredicate> movement, LocationWrapper location, Optional<MobEffectsPredicate> effects, Optional<NbtPredicate> nbt, Optional<EntityFlagsPredicate> flags, Optional<EntityEquipmentPredicate> equipment, Optional<EntitySubPredicate> subPredicate, Optional<Integer> periodicTick, Optional<EntityPredicate> vehicle, Optional<EntityPredicate> passenger, Optional<EntityPredicate> targetedEntity, Optional<String> team, Optional<SlotsPredicate> slots, DataComponentMatchers components) {
    public static final Codec<EntityPredicate> CODEC = Codec.recursive((String)"EntityPredicate", p_297888_ -> RecordCodecBuilder.create(p_348088_ -> p_348088_.group((App)EntityTypePredicate.CODEC.optionalFieldOf("type").forGetter(EntityPredicate::entityType), (App)DistancePredicate.CODEC.optionalFieldOf("distance").forGetter(EntityPredicate::distanceToPlayer), (App)MovementPredicate.CODEC.optionalFieldOf("movement").forGetter(EntityPredicate::movement), (App)LocationWrapper.CODEC.forGetter(EntityPredicate::location), (App)MobEffectsPredicate.CODEC.optionalFieldOf("effects").forGetter(EntityPredicate::effects), (App)NbtPredicate.CODEC.optionalFieldOf("nbt").forGetter(EntityPredicate::nbt), (App)EntityFlagsPredicate.CODEC.optionalFieldOf("flags").forGetter(EntityPredicate::flags), (App)EntityEquipmentPredicate.CODEC.optionalFieldOf("equipment").forGetter(EntityPredicate::equipment), (App)EntitySubPredicate.CODEC.optionalFieldOf("type_specific").forGetter(EntityPredicate::subPredicate), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("periodic_tick").forGetter(EntityPredicate::periodicTick), (App)p_297888_.optionalFieldOf("vehicle").forGetter(EntityPredicate::vehicle), (App)p_297888_.optionalFieldOf("passenger").forGetter(EntityPredicate::passenger), (App)p_297888_.optionalFieldOf("targeted_entity").forGetter(EntityPredicate::targetedEntity), (App)Codec.STRING.optionalFieldOf("team").forGetter(EntityPredicate::team), (App)SlotsPredicate.CODEC.optionalFieldOf("slots").forGetter(EntityPredicate::slots), (App)DataComponentMatchers.CODEC.forGetter(EntityPredicate::components)).apply((Applicative)p_348088_, EntityPredicate::new)));
    public static final Codec<ContextAwarePredicate> ADVANCEMENT_CODEC = Codec.withAlternative(ContextAwarePredicate.CODEC, CODEC, EntityPredicate::wrap);

    public static ContextAwarePredicate wrap(Builder p_298222_) {
        return EntityPredicate.wrap(p_298222_.build());
    }

    public static Optional<ContextAwarePredicate> wrap(Optional<EntityPredicate> p_298604_) {
        return p_298604_.map(EntityPredicate::wrap);
    }

    public static List<ContextAwarePredicate> wrap(Builder ... p_298584_) {
        return Stream.of(p_298584_).map(EntityPredicate::wrap).toList();
    }

    public static ContextAwarePredicate wrap(EntityPredicate p_286570_) {
        LootItemCondition $$1 = LootItemEntityPropertyCondition.hasProperties(LootContext.EntityTarget.THIS, p_286570_).build();
        return new ContextAwarePredicate(List.of($$1));
    }

    public boolean matches(ServerPlayer p_36612_, @Nullable Entity p_36613_) {
        return this.matches(p_36612_.level(), p_36612_.position(), p_36613_);
    }

    public boolean matches(ServerLevel p_36608_, @Nullable Vec3 p_36609_, @Nullable Entity p_36610_) {
        PlayerTeam $$7;
        if (p_36610_ == null) {
            return false;
        }
        if (this.entityType.isPresent() && !this.entityType.get().matches(p_36610_.getType())) {
            return false;
        }
        if (p_36609_ == null ? this.distanceToPlayer.isPresent() : this.distanceToPlayer.isPresent() && !this.distanceToPlayer.get().matches(p_36609_.x, p_36609_.y, p_36609_.z, p_36610_.getX(), p_36610_.getY(), p_36610_.getZ())) {
            return false;
        }
        if (this.movement.isPresent()) {
            Vec3 $$3 = p_36610_.getKnownMovement();
            Vec3 $$4 = $$3.scale(20.0);
            if (!this.movement.get().matches($$4.x, $$4.y, $$4.z, p_36610_.fallDistance)) {
                return false;
            }
        }
        if (this.location.located.isPresent() && !this.location.located.get().matches(p_36608_, p_36610_.getX(), p_36610_.getY(), p_36610_.getZ())) {
            return false;
        }
        if (this.location.steppingOn.isPresent()) {
            Vec3 $$5 = Vec3.atCenterOf(p_36610_.getOnPos());
            if (!p_36610_.onGround() || !this.location.steppingOn.get().matches(p_36608_, $$5.x(), $$5.y(), $$5.z())) {
                return false;
            }
        }
        if (this.location.affectsMovement.isPresent()) {
            Vec3 $$6 = Vec3.atCenterOf(p_36610_.getBlockPosBelowThatAffectsMyMovement());
            if (!this.location.affectsMovement.get().matches(p_36608_, $$6.x(), $$6.y(), $$6.z())) {
                return false;
            }
        }
        if (this.effects.isPresent() && !this.effects.get().matches(p_36610_)) {
            return false;
        }
        if (this.flags.isPresent() && !this.flags.get().matches(p_36610_)) {
            return false;
        }
        if (this.equipment.isPresent() && !this.equipment.get().matches(p_36610_)) {
            return false;
        }
        if (this.subPredicate.isPresent() && !this.subPredicate.get().matches(p_36610_, p_36608_, p_36609_)) {
            return false;
        }
        if (this.vehicle.isPresent() && !this.vehicle.get().matches(p_36608_, p_36609_, p_36610_.getVehicle())) {
            return false;
        }
        if (this.passenger.isPresent() && p_36610_.getPassengers().stream().noneMatch(p_297893_ -> this.passenger.get().matches(p_36608_, p_36609_, (Entity)p_297893_))) {
            return false;
        }
        if (this.targetedEntity.isPresent() && !this.targetedEntity.get().matches(p_36608_, p_36609_, p_36610_ instanceof Mob ? ((Mob)p_36610_).getTarget() : null)) {
            return false;
        }
        if (this.periodicTick.isPresent() && p_36610_.tickCount % this.periodicTick.get() != 0) {
            return false;
        }
        if (this.team.isPresent() && (($$7 = p_36610_.getTeam()) == null || !this.team.get().equals(((Team)$$7).getName()))) {
            return false;
        }
        if (this.slots.isPresent() && !this.slots.get().matches(p_36610_)) {
            return false;
        }
        if (!this.components.test(p_36610_)) {
            return false;
        }
        return this.nbt.isEmpty() || this.nbt.get().matches(p_36610_);
    }

    public static LootContext createContext(ServerPlayer p_36617_, Entity p_36618_) {
        LootParams $$2 = new LootParams.Builder(p_36617_.level()).withParameter(LootContextParams.THIS_ENTITY, p_36618_).withParameter(LootContextParams.ORIGIN, p_36617_.position()).create(LootContextParamSets.ADVANCEMENT_ENTITY);
        return new LootContext.Builder($$2).create(Optional.empty());
    }

    public record LocationWrapper(Optional<LocationPredicate> located, Optional<LocationPredicate> steppingOn, Optional<LocationPredicate> affectsMovement) {
        public static final MapCodec<LocationWrapper> CODEC = RecordCodecBuilder.mapCodec(p_348475_ -> p_348475_.group((App)LocationPredicate.CODEC.optionalFieldOf("location").forGetter(LocationWrapper::located), (App)LocationPredicate.CODEC.optionalFieldOf("stepping_on").forGetter(LocationWrapper::steppingOn), (App)LocationPredicate.CODEC.optionalFieldOf("movement_affected_by").forGetter(LocationWrapper::affectsMovement)).apply((Applicative)p_348475_, LocationWrapper::new));
    }

    public static class Builder {
        private Optional<EntityTypePredicate> entityType = Optional.empty();
        private Optional<DistancePredicate> distanceToPlayer = Optional.empty();
        private Optional<MovementPredicate> movement = Optional.empty();
        private Optional<LocationPredicate> located = Optional.empty();
        private Optional<LocationPredicate> steppingOnLocation = Optional.empty();
        private Optional<LocationPredicate> movementAffectedBy = Optional.empty();
        private Optional<MobEffectsPredicate> effects = Optional.empty();
        private Optional<NbtPredicate> nbt = Optional.empty();
        private Optional<EntityFlagsPredicate> flags = Optional.empty();
        private Optional<EntityEquipmentPredicate> equipment = Optional.empty();
        private Optional<EntitySubPredicate> subPredicate = Optional.empty();
        private Optional<Integer> periodicTick = Optional.empty();
        private Optional<EntityPredicate> vehicle = Optional.empty();
        private Optional<EntityPredicate> passenger = Optional.empty();
        private Optional<EntityPredicate> targetedEntity = Optional.empty();
        private Optional<String> team = Optional.empty();
        private Optional<SlotsPredicate> slots = Optional.empty();
        private DataComponentMatchers components = DataComponentMatchers.ANY;

        public static Builder entity() {
            return new Builder();
        }

        public Builder of(HolderGetter<EntityType<?>> p_363006_, EntityType<?> p_36637_) {
            this.entityType = Optional.of(EntityTypePredicate.of(p_363006_, p_36637_));
            return this;
        }

        public Builder of(HolderGetter<EntityType<?>> p_364646_, TagKey<EntityType<?>> p_204078_) {
            this.entityType = Optional.of(EntityTypePredicate.of(p_364646_, p_204078_));
            return this;
        }

        public Builder entityType(EntityTypePredicate p_36647_) {
            this.entityType = Optional.of(p_36647_);
            return this;
        }

        public Builder distance(DistancePredicate p_36639_) {
            this.distanceToPlayer = Optional.of(p_36639_);
            return this;
        }

        public Builder moving(MovementPredicate p_346088_) {
            this.movement = Optional.of(p_346088_);
            return this;
        }

        public Builder located(LocationPredicate.Builder p_298230_) {
            this.located = Optional.of(p_298230_.build());
            return this;
        }

        public Builder steppingOn(LocationPredicate.Builder p_298232_) {
            this.steppingOnLocation = Optional.of(p_298232_.build());
            return this;
        }

        public Builder movementAffectedBy(LocationPredicate.Builder p_348473_) {
            this.movementAffectedBy = Optional.of(p_348473_.build());
            return this;
        }

        public Builder effects(MobEffectsPredicate.Builder p_298981_) {
            this.effects = p_298981_.build();
            return this;
        }

        public Builder nbt(NbtPredicate p_36655_) {
            this.nbt = Optional.of(p_36655_);
            return this;
        }

        public Builder flags(EntityFlagsPredicate.Builder p_298456_) {
            this.flags = Optional.of(p_298456_.build());
            return this;
        }

        public Builder equipment(EntityEquipmentPredicate.Builder p_299134_) {
            this.equipment = Optional.of(p_299134_.build());
            return this;
        }

        public Builder equipment(EntityEquipmentPredicate p_36641_) {
            this.equipment = Optional.of(p_36641_);
            return this;
        }

        public Builder subPredicate(EntitySubPredicate p_218801_) {
            this.subPredicate = Optional.of(p_218801_);
            return this;
        }

        public Builder periodicTick(int p_345599_) {
            this.periodicTick = Optional.of(p_345599_);
            return this;
        }

        public Builder vehicle(Builder p_299103_) {
            this.vehicle = Optional.of(p_299103_.build());
            return this;
        }

        public Builder passenger(Builder p_298577_) {
            this.passenger = Optional.of(p_298577_.build());
            return this;
        }

        public Builder targetedEntity(Builder p_299292_) {
            this.targetedEntity = Optional.of(p_299292_.build());
            return this;
        }

        public Builder team(String p_36659_) {
            this.team = Optional.of(p_36659_);
            return this;
        }

        public Builder slots(SlotsPredicate p_332780_) {
            this.slots = Optional.of(p_332780_);
            return this;
        }

        public Builder components(DataComponentMatchers p_411097_) {
            this.components = p_411097_;
            return this;
        }

        public EntityPredicate build() {
            return new EntityPredicate(this.entityType, this.distanceToPlayer, this.movement, new LocationWrapper(this.located, this.steppingOnLocation, this.movementAffectedBy), this.effects, this.nbt, this.flags, this.equipment, this.subPredicate, this.periodicTick, this.vehicle, this.passenger, this.targetedEntity, this.team, this.slots, this.components);
        }
    }
}

