/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class AnyBlockInteractionTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @Override
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer p_319979_, BlockPos p_320093_, ItemStack p_320553_) {
        ServerLevel $$3 = p_319979_.level();
        BlockState $$4 = $$3.getBlockState(p_320093_);
        LootParams $$5 = new LootParams.Builder($$3).withParameter(LootContextParams.ORIGIN, p_320093_.getCenter()).withParameter(LootContextParams.THIS_ENTITY, p_319979_).withParameter(LootContextParams.BLOCK_STATE, $$4).withParameter(LootContextParams.TOOL, p_320553_).create(LootContextParamSets.ADVANCEMENT_LOCATION);
        LootContext $$6 = new LootContext.Builder($$5).create(Optional.empty());
        this.trigger(p_319979_, p_320901_ -> p_320901_.matches($$6));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> location) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(p_337340_ -> p_337340_.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ContextAwarePredicate.CODEC.optionalFieldOf("location").forGetter(TriggerInstance::location)).apply((Applicative)p_337340_, TriggerInstance::new));

        public boolean matches(LootContext p_320453_) {
            return this.location.isEmpty() || this.location.get().matches(p_320453_);
        }

        @Override
        public void validate(CriterionValidator p_319820_) {
            SimpleCriterionTrigger.SimpleInstance.super.validate(p_319820_);
            this.location.ifPresent(p_380777_ -> p_319820_.validate((ContextAwarePredicate)p_380777_, LootContextParamSets.ADVANCEMENT_LOCATION, "location"));
        }
    }
}

