/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens.configuration;

import com.google.common.collect.Lists;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.WorldTemplate;
import com.mojang.realmsclient.gui.RealmsWorldSlotButton;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.gui.screens.RealmsPopups;
import com.mojang.realmsclient.gui.screens.RealmsResetWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsSelectWorldTemplateScreen;
import com.mojang.realmsclient.gui.screens.configuration.RealmsBackupScreen;
import com.mojang.realmsclient.gui.screens.configuration.RealmsConfigurationTab;
import com.mojang.realmsclient.gui.screens.configuration.RealmsConfigureWorldScreen;
import com.mojang.realmsclient.gui.screens.configuration.RealmsSlotOptionsScreen;
import com.mojang.realmsclient.util.task.SwitchMinigameTask;
import com.mojang.realmsclient.util.task.SwitchSlotTask;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.tabs.GridLayoutTab;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.network.chat.Component;

class RealmsWorldsTab
extends GridLayoutTab
implements RealmsConfigurationTab {
    static final Component TITLE = Component.translatable("mco.configure.worlds.title");
    private final RealmsConfigureWorldScreen configurationScreen;
    private final Minecraft minecraft;
    private RealmsServer serverData;
    private final Button optionsButton;
    private final Button backupButton;
    private final Button resetWorldButton;
    private final List<RealmsWorldSlotButton> slotButtonList = Lists.newArrayList();

    RealmsWorldsTab(RealmsConfigureWorldScreen p_419690_, Minecraft p_419536_, RealmsServer p_419476_) {
        super(TITLE);
        this.configurationScreen = p_419690_;
        this.minecraft = p_419536_;
        this.serverData = p_419476_;
        GridLayout.RowHelper $$3 = this.layout.spacing(20).createRowHelper(1);
        GridLayout.RowHelper $$4 = new GridLayout().spacing(16).createRowHelper(4);
        this.slotButtonList.clear();
        for (int $$5 = 1; $$5 < 5; ++$$5) {
            this.slotButtonList.add($$4.addChild(this.createSlotButton($$5), LayoutSettings.defaults().alignVerticallyBottom()));
        }
        $$3.addChild($$4.getGrid());
        GridLayout.RowHelper $$6 = new GridLayout().spacing(8).createRowHelper(1);
        this.optionsButton = $$6.addChild(Button.builder(Component.translatable("mco.configure.world.buttons.options"), p_420075_ -> p_419536_.setScreen(new RealmsSlotOptionsScreen(p_419690_, p_419615_.slots.get(p_419615_.activeSlot).clone(), p_419615_.worldType, p_419615_.activeSlot))).bounds(0, 0, 150, 20).build());
        this.backupButton = $$6.addChild(Button.builder(Component.translatable("mco.configure.world.backup"), p_419786_ -> p_419536_.setScreen(new RealmsBackupScreen(p_419690_, p_419476_.clone(), p_419953_.activeSlot))).bounds(0, 0, 150, 20).build());
        this.resetWorldButton = $$6.addChild(Button.builder(Component.empty(), p_419578_ -> this.resetButtonPressed()).bounds(0, 0, 150, 20).build());
        $$3.addChild($$6.getGrid(), LayoutSettings.defaults().alignHorizontallyCenter());
        this.backupButton.active = true;
        this.updateData(p_419476_);
    }

    private void resetButtonPressed() {
        if (this.isMinigame()) {
            this.minecraft.setScreen(new RealmsSelectWorldTemplateScreen(Component.translatable("mco.template.title.minigame"), this::templateSelectionCallback, RealmsServer.WorldType.MINIGAME));
        } else {
            this.minecraft.setScreen(RealmsResetWorldScreen.forResetSlot(this.configurationScreen, this.serverData.clone(), () -> this.minecraft.execute(() -> this.minecraft.setScreen(this.configurationScreen.getNewScreen()))));
        }
    }

    private void templateSelectionCallback(@Nullable WorldTemplate p_419847_) {
        if (p_419847_ != null && WorldTemplate.WorldTemplateType.MINIGAME == p_419847_.type) {
            this.configurationScreen.stateChanged();
            RealmsConfigureWorldScreen $$1 = this.configurationScreen.getNewScreen();
            this.minecraft.setScreen(new RealmsLongRunningMcoTaskScreen($$1, new SwitchMinigameTask(this.serverData.id, p_419847_, $$1)));
        } else {
            this.minecraft.setScreen(this.configurationScreen);
        }
    }

    private boolean isMinigame() {
        return this.serverData.isMinigameActive();
    }

    @Override
    public void onSelected(RealmsServer p_420061_) {
        this.updateData(p_420061_);
    }

    @Override
    public void updateData(RealmsServer p_419949_) {
        this.serverData = p_419949_;
        this.optionsButton.active = !p_419949_.expired && !this.isMinigame();
        boolean bl = this.resetWorldButton.active = !p_419949_.expired;
        if (this.isMinigame()) {
            this.resetWorldButton.setMessage(Component.translatable("mco.configure.world.buttons.switchminigame"));
        } else {
            boolean $$1;
            boolean bl2 = $$1 = p_419949_.slots.containsKey(p_419949_.activeSlot) && p_419949_.slots.get((Object)Integer.valueOf((int)p_419949_.activeSlot)).options.empty;
            if ($$1) {
                this.resetWorldButton.setMessage(Component.translatable("mco.configure.world.buttons.newworld"));
            } else {
                this.resetWorldButton.setMessage(Component.translatable("mco.configure.world.buttons.resetworld"));
            }
        }
        this.backupButton.active = !this.isMinigame();
        for (RealmsWorldSlotButton $$2 : this.slotButtonList) {
            RealmsWorldSlotButton.State $$3 = $$2.setServerData(p_419949_);
            if ($$3.activeSlot) {
                $$2.setSize(80, 80);
                continue;
            }
            $$2.setSize(50, 50);
        }
    }

    private RealmsWorldSlotButton createSlotButton(int p_419555_) {
        return new RealmsWorldSlotButton(0, 0, 80, 80, p_419555_, this.serverData, p_419905_ -> {
            RealmsWorldSlotButton.State $$2 = ((RealmsWorldSlotButton)p_419905_).getState();
            switch ($$2.action) {
                case NOTHING: {
                    break;
                }
                case SWITCH_SLOT: {
                    if ($$2.minigame) {
                        this.switchToMinigame();
                        break;
                    }
                    if ($$2.empty) {
                        this.switchToEmptySlot(p_419555_, this.serverData);
                        break;
                    }
                    this.switchToFullSlot(p_419555_, this.serverData);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown action " + String.valueOf((Object)$$2.action));
                }
            }
        });
    }

    private void switchToMinigame() {
        RealmsSelectWorldTemplateScreen $$0 = new RealmsSelectWorldTemplateScreen(Component.translatable("mco.template.title.minigame"), this::templateSelectionCallback, RealmsServer.WorldType.MINIGAME);
        $$0.setWarning(Component.translatable("mco.minigame.world.info.line1"), Component.translatable("mco.minigame.world.info.line2"));
        this.minecraft.setScreen($$0);
    }

    private void switchToFullSlot(int p_420013_, RealmsServer p_419511_) {
        this.minecraft.setScreen(RealmsPopups.infoPopupScreen(this.configurationScreen, Component.translatable("mco.configure.world.slot.switch.question.line1"), p_428669_ -> {
            RealmsConfigureWorldScreen $$3 = this.configurationScreen.getNewScreen();
            this.configurationScreen.stateChanged();
            this.minecraft.setScreen(new RealmsLongRunningMcoTaskScreen($$3, new SwitchSlotTask(p_428667_.id, p_420013_, () -> this.minecraft.execute(() -> this.minecraft.setScreen($$3)))));
        }));
    }

    private void switchToEmptySlot(int p_419735_, RealmsServer p_419505_) {
        this.minecraft.setScreen(RealmsPopups.infoPopupScreen(this.configurationScreen, Component.translatable("mco.configure.world.slot.switch.question.line1"), p_419876_ -> {
            this.configurationScreen.stateChanged();
            RealmsResetWorldScreen $$3 = RealmsResetWorldScreen.forEmptySlot(this.configurationScreen, p_419735_, p_419505_, () -> this.minecraft.execute(() -> this.minecraft.setScreen(this.configurationScreen.getNewScreen())));
            this.minecraft.setScreen($$3);
        }));
    }
}

