/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.mojang.realmsclient.RealmsAvailability;
import com.mojang.realmsclient.dto.RealmsNews;
import com.mojang.realmsclient.dto.RealmsNotification;
import com.mojang.realmsclient.gui.RealmsDataFetcher;
import com.mojang.realmsclient.gui.task.DataFetcher;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.resources.ResourceLocation;

public class RealmsNotificationsScreen
extends RealmsScreen {
    private static final ResourceLocation UNSEEN_NOTIFICATION_SPRITE = ResourceLocation.withDefaultNamespace("icon/unseen_notification");
    private static final ResourceLocation NEWS_SPRITE = ResourceLocation.withDefaultNamespace("icon/news");
    private static final ResourceLocation INVITE_SPRITE = ResourceLocation.withDefaultNamespace("icon/invite");
    private static final ResourceLocation TRIAL_AVAILABLE_SPRITE = ResourceLocation.withDefaultNamespace("icon/trial_available");
    private final CompletableFuture<Boolean> validClient = RealmsAvailability.get().thenApply(p_293571_ -> p_293571_.type() == RealmsAvailability.Type.SUCCESS);
    @Nullable
    private DataFetcher.Subscription realmsDataSubscription;
    @Nullable
    private DataFetcherConfiguration currentConfiguration;
    private volatile int numberOfPendingInvites;
    private static boolean trialAvailable;
    private static boolean hasUnreadNews;
    private static boolean hasUnseenNotifications;
    private final DataFetcherConfiguration showAll = new DataFetcherConfiguration(){

        @Override
        public DataFetcher.Subscription initDataFetcher(RealmsDataFetcher p_294752_) {
            DataFetcher.Subscription $$1 = p_294752_.dataFetcher.createSubscription();
            RealmsNotificationsScreen.this.addNewsAndInvitesSubscriptions(p_294752_, $$1);
            RealmsNotificationsScreen.this.addNotificationsSubscriptions(p_294752_, $$1);
            return $$1;
        }

        @Override
        public boolean showOldNotifications() {
            return true;
        }
    };
    private final DataFetcherConfiguration onlyNotifications = new DataFetcherConfiguration(){

        @Override
        public DataFetcher.Subscription initDataFetcher(RealmsDataFetcher p_275318_) {
            DataFetcher.Subscription $$1 = p_275318_.dataFetcher.createSubscription();
            RealmsNotificationsScreen.this.addNotificationsSubscriptions(p_275318_, $$1);
            return $$1;
        }

        @Override
        public boolean showOldNotifications() {
            return false;
        }
    };

    public RealmsNotificationsScreen() {
        super(GameNarrator.NO_TITLE);
    }

    @Override
    public void init() {
        if (this.realmsDataSubscription != null) {
            this.realmsDataSubscription.forceUpdate();
        }
    }

    @Override
    public void added() {
        super.added();
        this.minecraft.realmsDataFetcher().notificationsTask.reset();
    }

    @Nullable
    private DataFetcherConfiguration getConfiguration() {
        boolean $$0;
        boolean bl = $$0 = this.inTitleScreen() && this.validClient.getNow(false) != false;
        if (!$$0) {
            return null;
        }
        return this.getRealmsNotificationsEnabled() ? this.showAll : this.onlyNotifications;
    }

    @Override
    public void tick() {
        DataFetcherConfiguration $$0 = this.getConfiguration();
        if (!Objects.equals(this.currentConfiguration, $$0)) {
            this.currentConfiguration = $$0;
            this.realmsDataSubscription = this.currentConfiguration != null ? this.currentConfiguration.initDataFetcher(this.minecraft.realmsDataFetcher()) : null;
        }
        if (this.realmsDataSubscription != null) {
            this.realmsDataSubscription.tick();
        }
    }

    private boolean getRealmsNotificationsEnabled() {
        return this.minecraft.options.realmsNotifications().get();
    }

    private boolean inTitleScreen() {
        return this.minecraft.screen instanceof TitleScreen;
    }

    @Override
    public void render(GuiGraphics p_282587_, int p_282992_, int p_283028_, float p_281605_) {
        super.render(p_282587_, p_282992_, p_283028_, p_281605_);
        if (this.validClient.getNow(false).booleanValue()) {
            this.drawIcons(p_282587_);
        }
    }

    @Override
    public void renderBackground(GuiGraphics p_294179_, int p_294689_, int p_294445_, float p_294874_) {
    }

    private void drawIcons(GuiGraphics p_282966_) {
        int $$1 = this.numberOfPendingInvites;
        int $$2 = 24;
        int $$3 = this.height / 4 + 48;
        int $$4 = this.width / 2 + 100;
        int $$5 = $$3 + 48 + 2;
        int $$6 = $$4 - 3;
        if (hasUnseenNotifications) {
            p_282966_.blitSprite(RenderPipelines.GUI_TEXTURED, UNSEEN_NOTIFICATION_SPRITE, $$6 - 12, $$5 + 3, 10, 10);
            $$6 -= 16;
        }
        if (this.currentConfiguration != null && this.currentConfiguration.showOldNotifications()) {
            if (hasUnreadNews) {
                p_282966_.blitSprite(RenderPipelines.GUI_TEXTURED, NEWS_SPRITE, $$6 - 14, $$5 + 1, 14, 14);
                $$6 -= 16;
            }
            if ($$1 != 0) {
                p_282966_.blitSprite(RenderPipelines.GUI_TEXTURED, INVITE_SPRITE, $$6 - 14, $$5 + 1, 14, 14);
                $$6 -= 16;
            }
            if (trialAvailable) {
                p_282966_.blitSprite(RenderPipelines.GUI_TEXTURED, TRIAL_AVAILABLE_SPRITE, $$6 - 10, $$5 + 4, 8, 8);
            }
        }
    }

    void addNewsAndInvitesSubscriptions(RealmsDataFetcher p_275490_, DataFetcher.Subscription p_275623_) {
        p_275623_.subscribe(p_275490_.pendingInvitesTask, p_239521_ -> {
            this.numberOfPendingInvites = p_239521_;
        });
        p_275623_.subscribe(p_275490_.trialAvailabilityTask, p_239494_ -> {
            trialAvailable = p_239494_;
        });
        p_275623_.subscribe(p_275490_.newsTask, p_238946_ -> {
            p_238945_.newsManager.updateUnreadNews((RealmsNews)p_238946_);
            hasUnreadNews = p_238945_.newsManager.hasUnreadNews();
        });
    }

    void addNotificationsSubscriptions(RealmsDataFetcher p_275619_, DataFetcher.Subscription p_275628_) {
        p_275628_.subscribe(p_275619_.notificationsTask, p_274637_ -> {
            hasUnseenNotifications = false;
            for (RealmsNotification $$1 : p_274637_) {
                if ($$1.seen()) continue;
                hasUnseenNotifications = true;
                break;
            }
        });
    }

    static interface DataFetcherConfiguration {
        public DataFetcher.Subscription initDataFetcher(RealmsDataFetcher var1);

        public boolean showOldNotifications();
    }
}

