/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.dto;

import com.google.gson.annotations.SerializedName;
import com.mojang.realmsclient.dto.GuardedSerializer;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.ReflectionBasedSerialization;
import com.mojang.realmsclient.dto.ValueObject;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.util.StringUtil;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelSettings;

public class RealmsWorldOptions
extends ValueObject
implements ReflectionBasedSerialization {
    @SerializedName(value="pvp")
    public boolean pvp = true;
    @SerializedName(value="spawnMonsters")
    public boolean spawnMonsters = true;
    @SerializedName(value="spawnProtection")
    public int spawnProtection = 0;
    @SerializedName(value="commandBlocks")
    public boolean commandBlocks = false;
    @SerializedName(value="forceGameMode")
    public boolean forceGameMode = false;
    @SerializedName(value="difficulty")
    public int difficulty = 2;
    @SerializedName(value="gameMode")
    public int gameMode = 0;
    @SerializedName(value="slotName")
    private String slotName = "";
    @SerializedName(value="version")
    public String version = "";
    @SerializedName(value="compatibility")
    public RealmsServer.Compatibility compatibility = RealmsServer.Compatibility.UNVERIFIABLE;
    @SerializedName(value="worldTemplateId")
    public long templateId = -1L;
    @Nullable
    @SerializedName(value="worldTemplateImage")
    public String templateImage = null;
    public boolean empty;

    private RealmsWorldOptions() {
    }

    public RealmsWorldOptions(boolean p_419614_, boolean p_419751_, int p_420018_, boolean p_419704_, int p_419836_, int p_419763_, boolean p_419498_, String p_420038_, String p_419539_, RealmsServer.Compatibility p_419813_) {
        this.pvp = p_419614_;
        this.spawnMonsters = p_419751_;
        this.spawnProtection = p_420018_;
        this.commandBlocks = p_419704_;
        this.difficulty = p_419836_;
        this.gameMode = p_419763_;
        this.forceGameMode = p_419498_;
        this.slotName = p_420038_;
        this.version = p_419539_;
        this.compatibility = p_419813_;
    }

    public static RealmsWorldOptions createDefaults() {
        return new RealmsWorldOptions();
    }

    public static RealmsWorldOptions createDefaultsWith(GameType p_374295_, boolean p_374405_, Difficulty p_374163_, boolean p_394628_, String p_374283_, String p_374182_) {
        RealmsWorldOptions $$6 = RealmsWorldOptions.createDefaults();
        $$6.commandBlocks = p_374405_;
        $$6.difficulty = p_374163_.getId();
        $$6.gameMode = p_374295_.getId();
        $$6.slotName = p_374182_;
        $$6.version = p_374283_;
        return $$6;
    }

    public static RealmsWorldOptions createFromSettings(LevelSettings p_374279_, boolean p_394495_, String p_374533_) {
        return RealmsWorldOptions.createDefaultsWith(p_374279_.gameType(), p_394495_, p_374279_.difficulty(), p_374279_.hardcore(), p_374533_, p_374279_.levelName());
    }

    public static RealmsWorldOptions createEmptyDefaults() {
        RealmsWorldOptions $$0 = RealmsWorldOptions.createDefaults();
        $$0.setEmpty(true);
        return $$0;
    }

    public void setEmpty(boolean p_87631_) {
        this.empty = p_87631_;
    }

    public static RealmsWorldOptions parse(GuardedSerializer p_419639_, String p_419547_) {
        RealmsWorldOptions $$2 = p_419639_.fromJson(p_419547_, RealmsWorldOptions.class);
        if ($$2 == null) {
            return RealmsWorldOptions.createDefaults();
        }
        RealmsWorldOptions.finalize($$2);
        return $$2;
    }

    private static void finalize(RealmsWorldOptions p_419806_) {
        if (p_419806_.slotName == null) {
            p_419806_.slotName = "";
        }
        if (p_419806_.version == null) {
            p_419806_.version = "";
        }
        if (p_419806_.compatibility == null) {
            p_419806_.compatibility = RealmsServer.Compatibility.UNVERIFIABLE;
        }
    }

    public String getSlotName(int p_87627_) {
        if (StringUtil.isBlank(this.slotName)) {
            if (this.empty) {
                return I18n.get("mco.configure.world.slot.empty", new Object[0]);
            }
            return this.getDefaultSlotName(p_87627_);
        }
        return this.slotName;
    }

    public String getDefaultSlotName(int p_87634_) {
        return I18n.get("mco.configure.world.slot", p_87634_);
    }

    public RealmsWorldOptions clone() {
        return new RealmsWorldOptions(this.pvp, this.spawnMonsters, this.spawnProtection, this.commandBlocks, this.difficulty, this.gameMode, this.forceGameMode, this.slotName, this.version, this.compatibility);
    }

    public /* synthetic */ Object clone() throws CloneNotSupportedException {
        return this.clone();
    }
}

