/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.dto;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.dto.Exclude;
import com.mojang.realmsclient.dto.GuardedSerializer;
import com.mojang.realmsclient.dto.PlayerInfo;
import com.mojang.realmsclient.dto.RealmsSlot;
import com.mojang.realmsclient.dto.ReflectionBasedSerialization;
import com.mojang.realmsclient.dto.RegionSelectionPreferenceDto;
import com.mojang.realmsclient.dto.ValueObject;
import com.mojang.util.UUIDTypeAdapter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.slf4j.Logger;

public class RealmsServer
extends ValueObject
implements ReflectionBasedSerialization {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int NO_VALUE = -1;
    public static final Component WORLD_CLOSED_COMPONENT = Component.translatable("mco.play.button.realm.closed");
    @SerializedName(value="id")
    public long id = -1L;
    @Nullable
    @SerializedName(value="remoteSubscriptionId")
    public String remoteSubscriptionId;
    @Nullable
    @SerializedName(value="name")
    public String name;
    @SerializedName(value="motd")
    public String motd = "";
    @SerializedName(value="state")
    public State state = State.CLOSED;
    @Nullable
    @SerializedName(value="owner")
    public String owner;
    @SerializedName(value="ownerUUID")
    @JsonAdapter(value=UUIDTypeAdapter.class)
    public UUID ownerUUID = Util.NIL_UUID;
    @SerializedName(value="players")
    public List<PlayerInfo> players = Lists.newArrayList();
    @SerializedName(value="slots")
    private List<RealmsSlot> slotList = RealmsServer.createEmptySlots();
    @Exclude
    public Map<Integer, RealmsSlot> slots = new HashMap<Integer, RealmsSlot>();
    @SerializedName(value="expired")
    public boolean expired;
    @SerializedName(value="expiredTrial")
    public boolean expiredTrial = false;
    @SerializedName(value="daysLeft")
    public int daysLeft;
    @SerializedName(value="worldType")
    public WorldType worldType = WorldType.NORMAL;
    @SerializedName(value="isHardcore")
    public boolean isHardcore = false;
    @SerializedName(value="gameMode")
    public int gameMode = -1;
    @SerializedName(value="activeSlot")
    public int activeSlot = -1;
    @Nullable
    @SerializedName(value="minigameName")
    public String minigameName;
    @SerializedName(value="minigameId")
    public int minigameId = -1;
    @Nullable
    @SerializedName(value="minigameImage")
    public String minigameImage;
    @SerializedName(value="parentWorldId")
    public long parentRealmId = -1L;
    @Nullable
    @SerializedName(value="parentWorldName")
    public String parentWorldName;
    @SerializedName(value="activeVersion")
    public String activeVersion = "";
    @SerializedName(value="compatibility")
    public Compatibility compatibility = Compatibility.UNVERIFIABLE;
    @Nullable
    @SerializedName(value="regionSelectionPreference")
    public RegionSelectionPreferenceDto regionSelectionPreference;

    public String getDescription() {
        return this.motd;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getMinigameName() {
        return this.minigameName;
    }

    public void setName(String p_87509_) {
        this.name = p_87509_;
    }

    public void setDescription(String p_87516_) {
        this.motd = p_87516_;
    }

    public static RealmsServer parse(GuardedSerializer p_419772_, String p_419625_) {
        try {
            RealmsServer $$2 = p_419772_.fromJson(p_419625_, RealmsServer.class);
            if ($$2 == null) {
                LOGGER.error("Could not parse McoServer: {}", (Object)p_419625_);
                return new RealmsServer();
            }
            RealmsServer.finalize($$2);
            return $$2;
        }
        catch (Exception $$3) {
            LOGGER.error("Could not parse McoServer: {}", (Object)$$3.getMessage());
            return new RealmsServer();
        }
    }

    public static void finalize(RealmsServer p_419489_) {
        if (p_419489_.players == null) {
            p_419489_.players = Lists.newArrayList();
        }
        if (p_419489_.slotList == null) {
            p_419489_.slotList = RealmsServer.createEmptySlots();
        }
        if (p_419489_.slots == null) {
            p_419489_.slots = new HashMap<Integer, RealmsSlot>();
        }
        if (p_419489_.worldType == null) {
            p_419489_.worldType = WorldType.NORMAL;
        }
        if (p_419489_.activeVersion == null) {
            p_419489_.activeVersion = "";
        }
        if (p_419489_.compatibility == null) {
            p_419489_.compatibility = Compatibility.UNVERIFIABLE;
        }
        if (p_419489_.regionSelectionPreference == null) {
            p_419489_.regionSelectionPreference = RegionSelectionPreferenceDto.DEFAULT;
        }
        RealmsServer.sortInvited(p_419489_);
        RealmsServer.finalizeSlots(p_419489_);
    }

    private static void sortInvited(RealmsServer p_87505_) {
        p_87505_.players.sort((p_87502_, p_87503_) -> ComparisonChain.start().compareFalseFirst(p_87503_.getAccepted(), p_87502_.getAccepted()).compare((Comparable)((Object)p_87502_.getName().toLowerCase(Locale.ROOT)), (Comparable)((Object)p_87503_.getName().toLowerCase(Locale.ROOT))).result());
    }

    private static void finalizeSlots(RealmsServer p_419934_) {
        p_419934_.slotList.forEach(p_419400_ -> p_419399_.slots.put(p_419400_.slotId, (RealmsSlot)p_419400_));
        for (int $$1 = 1; $$1 <= 3; ++$$1) {
            if (p_419934_.slots.containsKey($$1)) continue;
            p_419934_.slots.put($$1, RealmsSlot.defaults($$1));
        }
    }

    private static List<RealmsSlot> createEmptySlots() {
        ArrayList<RealmsSlot> $$0 = new ArrayList<RealmsSlot>();
        $$0.add(RealmsSlot.defaults(1));
        $$0.add(RealmsSlot.defaults(2));
        $$0.add(RealmsSlot.defaults(3));
        return $$0;
    }

    public boolean isCompatible() {
        return this.compatibility.isCompatible();
    }

    public boolean needsUpgrade() {
        return this.compatibility.needsUpgrade();
    }

    public boolean needsDowngrade() {
        return this.compatibility.needsDowngrade();
    }

    public boolean shouldPlayButtonBeActive() {
        boolean $$0 = !this.expired && this.state == State.OPEN;
        return $$0 && (this.isCompatible() || this.needsUpgrade() || this.isSelfOwnedServer());
    }

    private boolean isSelfOwnedServer() {
        return Minecraft.getInstance().isLocalPlayer(this.ownerUUID);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.motd, this.state, this.owner, this.expired});
    }

    public boolean equals(Object p_87528_) {
        if (p_87528_ == null) {
            return false;
        }
        if (p_87528_ == this) {
            return true;
        }
        if (p_87528_.getClass() != this.getClass()) {
            return false;
        }
        RealmsServer $$1 = (RealmsServer)p_87528_;
        return new EqualsBuilder().append(this.id, $$1.id).append((Object)this.name, (Object)$$1.name).append((Object)this.motd, (Object)$$1.motd).append((Object)this.state, (Object)$$1.state).append((Object)this.owner, (Object)$$1.owner).append(this.expired, $$1.expired).append((Object)this.worldType, (Object)this.worldType).isEquals();
    }

    public RealmsServer clone() {
        RealmsServer $$0 = new RealmsServer();
        $$0.id = this.id;
        $$0.remoteSubscriptionId = this.remoteSubscriptionId;
        $$0.name = this.name;
        $$0.motd = this.motd;
        $$0.state = this.state;
        $$0.owner = this.owner;
        $$0.players = this.players;
        $$0.slotList = this.slotList.stream().map(RealmsSlot::clone).toList();
        $$0.slots = this.cloneSlots(this.slots);
        $$0.expired = this.expired;
        $$0.expiredTrial = this.expiredTrial;
        $$0.daysLeft = this.daysLeft;
        $$0.worldType = this.worldType;
        $$0.isHardcore = this.isHardcore;
        $$0.gameMode = this.gameMode;
        $$0.ownerUUID = this.ownerUUID;
        $$0.minigameName = this.minigameName;
        $$0.activeSlot = this.activeSlot;
        $$0.minigameId = this.minigameId;
        $$0.minigameImage = this.minigameImage;
        $$0.parentWorldName = this.parentWorldName;
        $$0.parentRealmId = this.parentRealmId;
        $$0.activeVersion = this.activeVersion;
        $$0.compatibility = this.compatibility;
        $$0.regionSelectionPreference = this.regionSelectionPreference != null ? this.regionSelectionPreference.clone() : null;
        return $$0;
    }

    public Map<Integer, RealmsSlot> cloneSlots(Map<Integer, RealmsSlot> p_87511_) {
        HashMap $$1 = Maps.newHashMap();
        for (Map.Entry<Integer, RealmsSlot> $$2 : p_87511_.entrySet()) {
            $$1.put($$2.getKey(), new RealmsSlot($$2.getKey(), $$2.getValue().options.clone(), $$2.getValue().settings));
        }
        return $$1;
    }

    public boolean isSnapshotRealm() {
        return this.parentRealmId != -1L;
    }

    public boolean isMinigameActive() {
        return this.worldType == WorldType.MINIGAME;
    }

    public String getWorldName(int p_87496_) {
        if (this.name == null) {
            return this.slots.get((Object)Integer.valueOf((int)p_87496_)).options.getSlotName(p_87496_);
        }
        return this.name + " (" + this.slots.get((Object)Integer.valueOf((int)p_87496_)).options.getSlotName(p_87496_) + ")";
    }

    public ServerData toServerData(String p_87523_) {
        return new ServerData(Objects.requireNonNullElse(this.name, "unknown server"), p_87523_, ServerData.Type.REALM);
    }

    public /* synthetic */ Object clone() throws CloneNotSupportedException {
        return this.clone();
    }

    public static enum State {
        CLOSED,
        OPEN,
        UNINITIALIZED;

    }

    public static enum WorldType {
        NORMAL,
        MINIGAME,
        ADVENTUREMAP,
        EXPERIENCE,
        INSPIRATION;

    }

    public static enum Compatibility {
        UNVERIFIABLE,
        INCOMPATIBLE,
        RELEASE_TYPE_INCOMPATIBLE,
        NEEDS_DOWNGRADE,
        NEEDS_UPGRADE,
        COMPATIBLE;


        public boolean isCompatible() {
            return this == COMPATIBLE;
        }

        public boolean needsUpgrade() {
            return this == NEEDS_UPGRADE;
        }

        public boolean needsDowngrade() {
            return this == NEEDS_DOWNGRADE;
        }
    }

    public static class McoServerComparator
    implements Comparator<RealmsServer> {
        private final String refOwner;

        public McoServerComparator(String p_87534_) {
            this.refOwner = p_87534_;
        }

        @Override
        public int compare(RealmsServer p_87536_, RealmsServer p_87537_) {
            return ComparisonChain.start().compareTrueFirst(p_87536_.isSnapshotRealm(), p_87537_.isSnapshotRealm()).compareTrueFirst(p_87536_.state == State.UNINITIALIZED, p_87537_.state == State.UNINITIALIZED).compareTrueFirst(p_87536_.expiredTrial, p_87537_.expiredTrial).compareTrueFirst(Objects.equals(p_87536_.owner, this.refOwner), Objects.equals(p_87537_.owner, this.refOwner)).compareFalseFirst(p_87536_.expired, p_87537_.expired).compareTrueFirst(p_87536_.state == State.OPEN, p_87537_.state == State.OPEN).compare(p_87536_.id, p_87537_.id).result();
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.compare((RealmsServer)object, (RealmsServer)object2);
        }
    }
}

