/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.vertex;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.DontObfuscate;
import com.mojang.blaze3d.GraphicsWorkarounds;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;

@DontObfuscate
public class VertexFormat {
    public static final int UNKNOWN_ELEMENT = -1;
    private static final boolean USE_STAGING_BUFFER_WORKAROUND = Util.getPlatform() == Util.OS.WINDOWS && Util.isAarch64();
    @Nullable
    private static GpuBuffer UPLOAD_STAGING_BUFFER;
    private final List<VertexFormatElement> elements;
    private final List<String> names;
    private final int vertexSize;
    private final int elementsMask;
    private final int[] offsetsByElement = new int[32];
    @Nullable
    private GpuBuffer immediateDrawVertexBuffer;
    @Nullable
    private GpuBuffer immediateDrawIndexBuffer;

    VertexFormat(List<VertexFormatElement> p_350393_, List<String> p_350887_, IntList p_350817_, int p_350310_) {
        this.elements = p_350393_;
        this.names = p_350887_;
        this.vertexSize = p_350310_;
        this.elementsMask = p_350393_.stream().mapToInt(VertexFormatElement::mask).reduce(0, (p_350941_, p_350570_) -> p_350941_ | p_350570_);
        for (int $$4 = 0; $$4 < this.offsetsByElement.length; ++$$4) {
            VertexFormatElement $$5 = VertexFormatElement.byId($$4);
            int $$6 = $$5 != null ? p_350393_.indexOf($$5) : -1;
            this.offsetsByElement[$$4] = $$6 != -1 ? p_350817_.getInt($$6) : -1;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "VertexFormat" + String.valueOf(this.names);
    }

    public int getVertexSize() {
        return this.vertexSize;
    }

    public List<VertexFormatElement> getElements() {
        return this.elements;
    }

    public List<String> getElementAttributeNames() {
        return this.names;
    }

    public int[] getOffsetsByElement() {
        return this.offsetsByElement;
    }

    public int getOffset(VertexFormatElement p_350713_) {
        return this.offsetsByElement[p_350713_.id()];
    }

    public boolean contains(VertexFormatElement p_351022_) {
        return (this.elementsMask & p_351022_.mask()) != 0;
    }

    public int getElementsMask() {
        return this.elementsMask;
    }

    public String getElementName(VertexFormatElement p_350904_) {
        int $$1 = this.elements.indexOf(p_350904_);
        if ($$1 == -1) {
            throw new IllegalArgumentException(String.valueOf(p_350904_) + " is not contained in format");
        }
        return this.names.get($$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object p_86026_) {
        if (this == p_86026_) {
            return true;
        }
        if (!(p_86026_ instanceof VertexFormat)) return false;
        VertexFormat $$1 = (VertexFormat)p_86026_;
        if (this.elementsMask != $$1.elementsMask) return false;
        if (this.vertexSize != $$1.vertexSize) return false;
        if (!this.names.equals($$1.names)) return false;
        if (!Arrays.equals(this.offsetsByElement, $$1.offsetsByElement)) return false;
        return true;
    }

    public int hashCode() {
        return this.elementsMask * 31 + Arrays.hashCode(this.offsetsByElement);
    }

    private static GpuBuffer uploadToBuffer(@Nullable GpuBuffer p_428839_, ByteBuffer p_428844_, int p_428826_, Supplier<String> p_428833_) {
        GpuDevice $$4 = RenderSystem.getDevice();
        if (p_428839_ == null) {
            p_428839_ = $$4.createBuffer(p_428833_, p_428826_, p_428844_);
        } else {
            CommandEncoder $$5 = $$4.createCommandEncoder();
            if (p_428839_.size() < p_428844_.remaining()) {
                p_428839_.close();
                p_428839_ = $$4.createBuffer(p_428833_, p_428826_, p_428844_);
            } else {
                $$5.writeToBuffer(p_428839_.slice(), p_428844_);
            }
        }
        return p_428839_;
    }

    private GpuBuffer uploadToBufferWithWorkaround(@Nullable GpuBuffer p_428850_, ByteBuffer p_428822_, int p_428845_, Supplier<String> p_428834_) {
        GpuDevice $$4 = RenderSystem.getDevice();
        if (USE_STAGING_BUFFER_WORKAROUND) {
            if (p_428850_ == null) {
                p_428850_ = $$4.createBuffer(p_428834_, p_428845_, p_428822_);
            } else {
                CommandEncoder $$5 = $$4.createCommandEncoder();
                if (p_428850_.size() < p_428822_.remaining()) {
                    p_428850_.close();
                    p_428850_ = $$4.createBuffer(p_428834_, p_428845_, p_428822_);
                } else {
                    UPLOAD_STAGING_BUFFER = VertexFormat.uploadToBuffer(UPLOAD_STAGING_BUFFER, p_428822_, p_428845_, p_428834_);
                    $$5.copyToBuffer(UPLOAD_STAGING_BUFFER.slice(0, p_428822_.remaining()), p_428850_.slice(0, p_428822_.remaining()));
                }
            }
            return p_428850_;
        }
        if (GraphicsWorkarounds.get($$4).alwaysCreateFreshImmediateBuffer()) {
            if (p_428850_ != null) {
                p_428850_.close();
            }
            return $$4.createBuffer(p_428834_, p_428845_, p_428822_);
        }
        return VertexFormat.uploadToBuffer(p_428850_, p_428822_, p_428845_, p_428834_);
    }

    public GpuBuffer uploadImmediateVertexBuffer(ByteBuffer p_410477_) {
        this.immediateDrawVertexBuffer = this.uploadToBufferWithWorkaround(this.immediateDrawVertexBuffer, p_410477_, 40, () -> "Immediate vertex buffer for " + String.valueOf(this));
        return this.immediateDrawVertexBuffer;
    }

    public GpuBuffer uploadImmediateIndexBuffer(ByteBuffer p_410562_) {
        this.immediateDrawIndexBuffer = this.uploadToBufferWithWorkaround(this.immediateDrawIndexBuffer, p_410562_, 72, () -> "Immediate index buffer for " + String.valueOf(this));
        return this.immediateDrawIndexBuffer;
    }

    @DontObfuscate
    public static class Builder {
        private final ImmutableMap.Builder<String, VertexFormatElement> elements = ImmutableMap.builder();
        private final IntList offsets = new IntArrayList();
        private int offset;

        Builder() {
        }

        public Builder add(String p_350281_, VertexFormatElement p_350956_) {
            this.elements.put((Object)p_350281_, (Object)p_350956_);
            this.offsets.add(this.offset);
            this.offset += p_350956_.byteSize();
            return this;
        }

        public Builder padding(int p_351055_) {
            this.offset += p_351055_;
            return this;
        }

        public VertexFormat build() {
            ImmutableMap $$0 = this.elements.buildOrThrow();
            ImmutableList $$1 = $$0.values().asList();
            ImmutableList $$2 = $$0.keySet().asList();
            return new VertexFormat((List<VertexFormatElement>)$$1, (List<String>)$$2, this.offsets, this.offset);
        }
    }

    public static enum Mode {
        LINES(2, 2, false),
        LINE_STRIP(2, 1, true),
        DEBUG_LINES(2, 2, false),
        DEBUG_LINE_STRIP(2, 1, true),
        TRIANGLES(3, 3, false),
        TRIANGLE_STRIP(3, 1, true),
        TRIANGLE_FAN(3, 1, true),
        QUADS(4, 4, false);

        public final int primitiveLength;
        public final int primitiveStride;
        public final boolean connectedPrimitives;

        private Mode(int p_231238_, int p_231239_, boolean p_231241_) {
            this.primitiveLength = p_231238_;
            this.primitiveStride = p_231239_;
            this.connectedPrimitives = p_231241_;
        }

        public int indexCount(int p_166959_) {
            int $$3;
            switch (this.ordinal()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    int $$1 = p_166959_;
                    break;
                }
                case 0: 
                case 7: {
                    int $$2 = p_166959_ / 4 * 6;
                    break;
                }
                default: {
                    $$3 = 0;
                }
            }
            return $$3;
        }
    }

    public static enum IndexType {
        SHORT(2),
        INT(4);

        public final int bytes;

        private IndexType(int p_166930_) {
            this.bytes = p_166930_;
        }

        public static IndexType least(int p_166934_) {
            if ((p_166934_ & 0xFFFF0000) != 0) {
                return INT;
            }
            return SHORT;
        }
    }
}

