/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.systems;

import com.mojang.blaze3d.DontObfuscate;
import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.TracyFrameCapture;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.buffers.GpuFence;
import com.mojang.blaze3d.buffers.Std140SizeCalculator;
import com.mojang.blaze3d.opengl.GlDevice;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.shaders.ShaderType;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.ScissorState;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.DynamicUniforms;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ArrayListDeque;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeSource;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;

@DontObfuscate
public class RenderSystem {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final int MINIMUM_ATLAS_TEXTURE_SIZE = 1024;
    public static final int PROJECTION_MATRIX_UBO_SIZE = new Std140SizeCalculator().putMat4f().get();
    @Nullable
    private static Thread renderThread;
    @Nullable
    private static GpuDevice DEVICE;
    private static double lastDrawTime;
    private static final AutoStorageIndexBuffer sharedSequential;
    private static final AutoStorageIndexBuffer sharedSequentialQuad;
    private static final AutoStorageIndexBuffer sharedSequentialLines;
    private static ProjectionType projectionType;
    private static ProjectionType savedProjectionType;
    private static final Matrix4fStack modelViewStack;
    private static Matrix4f textureMatrix;
    public static final int TEXTURE_COUNT = 12;
    private static final GpuTextureView[] shaderTextures;
    @Nullable
    private static GpuBufferSlice shaderFog;
    @Nullable
    private static GpuBufferSlice shaderLightDirections;
    @Nullable
    private static GpuBufferSlice projectionMatrixBuffer;
    @Nullable
    private static GpuBufferSlice savedProjectionMatrixBuffer;
    private static final Vector3f modelOffset;
    private static float shaderLineWidth;
    private static String apiDescription;
    private static final AtomicLong pollEventsWaitStart;
    private static final AtomicBoolean pollingEvents;
    @Nullable
    private static GpuBuffer QUAD_VERTEX_BUFFER;
    private static final ArrayListDeque<GpuAsyncTask> PENDING_FENCES;
    @Nullable
    public static GpuTextureView outputColorTextureOverride;
    @Nullable
    public static GpuTextureView outputDepthTextureOverride;
    @Nullable
    private static GpuBuffer globalSettingsUniform;
    @Nullable
    private static DynamicUniforms dynamicUniforms;
    private static ScissorState scissorStateForRenderTypeDraws;

    public static void initRenderThread() {
        if (renderThread != null) {
            throw new IllegalStateException("Could not initialize render thread");
        }
        renderThread = Thread.currentThread();
    }

    public static boolean isOnRenderThread() {
        return Thread.currentThread() == renderThread;
    }

    public static void assertOnRenderThread() {
        if (!RenderSystem.isOnRenderThread()) {
            throw RenderSystem.constructThreadException();
        }
    }

    private static IllegalStateException constructThreadException() {
        return new IllegalStateException("Rendersystem called from wrong thread");
    }

    private static void pollEvents() {
        pollEventsWaitStart.set(Util.getMillis());
        pollingEvents.set(true);
        GLFW.glfwPollEvents();
        pollingEvents.set(false);
    }

    public static boolean isFrozenAtPollEvents() {
        return pollingEvents.get() && Util.getMillis() - pollEventsWaitStart.get() > 200L;
    }

    public static void flipFrame(long p_69496_, @Nullable TracyFrameCapture p_372841_) {
        RenderSystem.pollEvents();
        Tesselator.getInstance().clear();
        GLFW.glfwSwapBuffers((long)p_69496_);
        if (p_372841_ != null) {
            p_372841_.endFrame();
        }
        dynamicUniforms.reset();
        Minecraft.getInstance().levelRenderer.endFrame();
        RenderSystem.pollEvents();
    }

    public static void limitDisplayFPS(int p_69831_) {
        double $$1 = lastDrawTime + 1.0 / (double)p_69831_;
        double $$2 = GLFW.glfwGetTime();
        while ($$2 < $$1) {
            GLFW.glfwWaitEventsTimeout((double)($$1 - $$2));
            $$2 = GLFW.glfwGetTime();
        }
        lastDrawTime = $$2;
    }

    public static void setShaderFog(GpuBufferSlice p_418490_) {
        shaderFog = p_418490_;
    }

    @Nullable
    public static GpuBufferSlice getShaderFog() {
        return shaderFog;
    }

    public static void setShaderLights(GpuBufferSlice p_418388_) {
        shaderLightDirections = p_418388_;
    }

    @Nullable
    public static GpuBufferSlice getShaderLights() {
        return shaderLightDirections;
    }

    public static void lineWidth(float p_69833_) {
        RenderSystem.assertOnRenderThread();
        shaderLineWidth = p_69833_;
    }

    public static float getShaderLineWidth() {
        RenderSystem.assertOnRenderThread();
        return shaderLineWidth;
    }

    public static void enableScissorForRenderTypeDraws(int p_428564_, int p_428412_, int p_428568_, int p_428211_) {
        scissorStateForRenderTypeDraws.enable(p_428564_, p_428412_, p_428568_, p_428211_);
    }

    public static void disableScissorForRenderTypeDraws() {
        scissorStateForRenderTypeDraws.disable();
    }

    public static ScissorState getScissorStateForRenderTypeDraws() {
        return scissorStateForRenderTypeDraws;
    }

    public static String getBackendDescription() {
        return String.format(Locale.ROOT, "LWJGL version %s", GLX._getLWJGLVersion());
    }

    public static String getApiDescription() {
        return apiDescription;
    }

    public static TimeSource.NanoTimeSource initBackendSystem() {
        return GLX._initGlfw()::getAsLong;
    }

    public static void initRenderer(long p_409720_, int p_69581_, boolean p_69582_, BiFunction<ResourceLocation, ShaderType, String> p_410113_, boolean p_410401_) {
        DEVICE = new GlDevice(p_409720_, p_69581_, p_69582_, p_410113_, p_410401_);
        apiDescription = RenderSystem.getDevice().getImplementationInformation();
        dynamicUniforms = new DynamicUniforms();
        try (ByteBufferBuilder $$5 = ByteBufferBuilder.exactlySized(DefaultVertexFormat.POSITION.getVertexSize() * 4);){
            BufferBuilder $$6 = new BufferBuilder($$5, VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
            $$6.addVertex(0.0f, 0.0f, 0.0f);
            $$6.addVertex(1.0f, 0.0f, 0.0f);
            $$6.addVertex(1.0f, 1.0f, 0.0f);
            $$6.addVertex(0.0f, 1.0f, 0.0f);
            try (MeshData $$7 = $$6.buildOrThrow();){
                QUAD_VERTEX_BUFFER = RenderSystem.getDevice().createBuffer(() -> "Quad", 32, $$7.vertexBuffer());
            }
        }
    }

    public static void setErrorCallback(GLFWErrorCallbackI p_69901_) {
        GLX._setGlfwErrorCallback(p_69901_);
    }

    public static void setupDefaultState() {
        modelViewStack.clear();
        textureMatrix.identity();
    }

    public static void setupOverlayColor(@Nullable GpuTextureView p_423477_) {
        RenderSystem.assertOnRenderThread();
        RenderSystem.setShaderTexture(1, p_423477_);
    }

    public static void teardownOverlayColor() {
        RenderSystem.assertOnRenderThread();
        RenderSystem.setShaderTexture(1, null);
    }

    public static void setShaderTexture(int p_157454_, @Nullable GpuTextureView p_423563_) {
        RenderSystem.assertOnRenderThread();
        if (p_157454_ >= 0 && p_157454_ < shaderTextures.length) {
            RenderSystem.shaderTextures[p_157454_] = p_423563_;
        }
    }

    @Nullable
    public static GpuTextureView getShaderTexture(int p_157204_) {
        RenderSystem.assertOnRenderThread();
        if (p_157204_ >= 0 && p_157204_ < shaderTextures.length) {
            return shaderTextures[p_157204_];
        }
        return null;
    }

    public static void setProjectionMatrix(GpuBufferSlice p_418326_, ProjectionType p_381637_) {
        RenderSystem.assertOnRenderThread();
        projectionMatrixBuffer = p_418326_;
        projectionType = p_381637_;
    }

    public static void setTextureMatrix(Matrix4f p_254081_) {
        RenderSystem.assertOnRenderThread();
        textureMatrix = new Matrix4f((Matrix4fc)p_254081_);
    }

    public static void resetTextureMatrix() {
        RenderSystem.assertOnRenderThread();
        textureMatrix.identity();
    }

    public static void backupProjectionMatrix() {
        RenderSystem.assertOnRenderThread();
        savedProjectionMatrixBuffer = projectionMatrixBuffer;
        savedProjectionType = projectionType;
    }

    public static void restoreProjectionMatrix() {
        RenderSystem.assertOnRenderThread();
        projectionMatrixBuffer = savedProjectionMatrixBuffer;
        projectionType = savedProjectionType;
    }

    @Nullable
    public static GpuBufferSlice getProjectionMatrixBuffer() {
        RenderSystem.assertOnRenderThread();
        return projectionMatrixBuffer;
    }

    public static Matrix4f getModelViewMatrix() {
        RenderSystem.assertOnRenderThread();
        return modelViewStack;
    }

    public static Matrix4fStack getModelViewStack() {
        RenderSystem.assertOnRenderThread();
        return modelViewStack;
    }

    public static Matrix4f getTextureMatrix() {
        RenderSystem.assertOnRenderThread();
        return textureMatrix;
    }

    public static AutoStorageIndexBuffer getSequentialBuffer(VertexFormat.Mode p_221942_) {
        RenderSystem.assertOnRenderThread();
        return switch (p_221942_) {
            case VertexFormat.Mode.QUADS -> sharedSequentialQuad;
            case VertexFormat.Mode.LINES -> sharedSequentialLines;
            default -> sharedSequential;
        };
    }

    public static void setGlobalSettingsUniform(GpuBuffer p_418439_) {
        globalSettingsUniform = p_418439_;
    }

    @Nullable
    public static GpuBuffer getGlobalSettingsUniform() {
        return globalSettingsUniform;
    }

    public static ProjectionType getProjectionType() {
        RenderSystem.assertOnRenderThread();
        return projectionType;
    }

    public static GpuBuffer getQuadVertexBuffer() {
        if (QUAD_VERTEX_BUFFER == null) {
            throw new IllegalStateException("Can't getQuadVertexBuffer() before renderer was initialized");
        }
        return QUAD_VERTEX_BUFFER;
    }

    public static void setModelOffset(float p_401762_, float p_401844_, float p_401774_) {
        RenderSystem.assertOnRenderThread();
        modelOffset.set(p_401762_, p_401844_, p_401774_);
    }

    public static void resetModelOffset() {
        RenderSystem.assertOnRenderThread();
        modelOffset.set(0.0f, 0.0f, 0.0f);
    }

    public static Vector3f getModelOffset() {
        RenderSystem.assertOnRenderThread();
        return modelOffset;
    }

    public static void queueFencedTask(Runnable p_406359_) {
        PENDING_FENCES.addLast(new GpuAsyncTask(p_406359_, RenderSystem.getDevice().createCommandEncoder().createFence()));
    }

    public static void executePendingTasks() {
        GpuAsyncTask $$0 = PENDING_FENCES.peekFirst();
        while ($$0 != null) {
            if ($$0.fence.awaitCompletion(0L)) {
                try {
                    $$0.callback.run();
                }
                finally {
                    $$0.fence.close();
                }
                PENDING_FENCES.removeFirst();
                $$0 = PENDING_FENCES.peekFirst();
                continue;
            }
            return;
        }
    }

    public static GpuDevice getDevice() {
        if (DEVICE == null) {
            throw new IllegalStateException("Can't getDevice() before it was initialized");
        }
        return DEVICE;
    }

    @Nullable
    public static GpuDevice tryGetDevice() {
        return DEVICE;
    }

    public static DynamicUniforms getDynamicUniforms() {
        if (dynamicUniforms == null) {
            throw new IllegalStateException("Can't getDynamicUniforms() before device was initialized");
        }
        return dynamicUniforms;
    }

    public static void bindDefaultUniforms(RenderPass p_418212_) {
        GpuBufferSlice $$4;
        GpuBuffer $$3;
        GpuBufferSlice $$2;
        GpuBufferSlice $$1 = RenderSystem.getProjectionMatrixBuffer();
        if ($$1 != null) {
            p_418212_.setUniform("Projection", $$1);
        }
        if (($$2 = RenderSystem.getShaderFog()) != null) {
            p_418212_.setUniform("Fog", $$2);
        }
        if (($$3 = RenderSystem.getGlobalSettingsUniform()) != null) {
            p_418212_.setUniform("Globals", $$3);
        }
        if (($$4 = RenderSystem.getShaderLights()) != null) {
            p_418212_.setUniform("Lighting", $$4);
        }
    }

    static {
        lastDrawTime = Double.MIN_VALUE;
        sharedSequential = new AutoStorageIndexBuffer(1, 1, java.util.function.IntConsumer::accept);
        sharedSequentialQuad = new AutoStorageIndexBuffer(4, 6, (p_403829_, p_403830_) -> {
            p_403829_.accept(p_403830_);
            p_403829_.accept(p_403830_ + 1);
            p_403829_.accept(p_403830_ + 2);
            p_403829_.accept(p_403830_ + 2);
            p_403829_.accept(p_403830_ + 3);
            p_403829_.accept(p_403830_);
        });
        sharedSequentialLines = new AutoStorageIndexBuffer(4, 6, (p_403827_, p_403828_) -> {
            p_403827_.accept(p_403828_);
            p_403827_.accept(p_403828_ + 1);
            p_403827_.accept(p_403828_ + 2);
            p_403827_.accept(p_403828_ + 3);
            p_403827_.accept(p_403828_ + 2);
            p_403827_.accept(p_403828_ + 1);
        });
        projectionType = ProjectionType.PERSPECTIVE;
        savedProjectionType = ProjectionType.PERSPECTIVE;
        modelViewStack = new Matrix4fStack(16);
        textureMatrix = new Matrix4f();
        shaderTextures = new GpuTextureView[12];
        shaderFog = null;
        modelOffset = new Vector3f();
        shaderLineWidth = 1.0f;
        apiDescription = "Unknown";
        pollEventsWaitStart = new AtomicLong();
        pollingEvents = new AtomicBoolean(false);
        PENDING_FENCES = new ArrayListDeque();
        scissorStateForRenderTypeDraws = new ScissorState();
    }

    public static final class AutoStorageIndexBuffer {
        private final int vertexStride;
        private final int indexStride;
        private final IndexGenerator generator;
        @Nullable
        private GpuBuffer buffer;
        private VertexFormat.IndexType type = VertexFormat.IndexType.SHORT;
        private int indexCount;

        AutoStorageIndexBuffer(int p_157472_, int p_157473_, IndexGenerator p_157474_) {
            this.vertexStride = p_157472_;
            this.indexStride = p_157473_;
            this.generator = p_157474_;
        }

        public boolean hasStorage(int p_221945_) {
            return p_221945_ <= this.indexCount;
        }

        public GpuBuffer getBuffer(int p_410107_) {
            this.ensureStorage(p_410107_);
            return this.buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensureStorage(int p_157477_) {
            if (this.hasStorage(p_157477_)) {
                return;
            }
            p_157477_ = Mth.roundToward(p_157477_ * 2, this.indexStride);
            LOGGER.debug("Growing IndexBuffer: Old limit {}, new limit {}.", (Object)this.indexCount, (Object)p_157477_);
            int $$1 = p_157477_ / this.indexStride;
            int $$2 = $$1 * this.vertexStride;
            VertexFormat.IndexType $$3 = VertexFormat.IndexType.least($$2);
            int $$4 = Mth.roundToward(p_157477_ * $$3.bytes, 4);
            ByteBuffer $$5 = MemoryUtil.memAlloc((int)$$4);
            try {
                this.type = $$3;
                IntConsumer $$6 = this.intConsumer($$5);
                for (int $$7 = 0; $$7 < p_157477_; $$7 += this.indexStride) {
                    this.generator.accept($$6, $$7 * this.vertexStride / this.indexStride);
                }
                $$5.flip();
                if (this.buffer != null) {
                    this.buffer.close();
                }
                this.buffer = RenderSystem.getDevice().createBuffer(() -> "Auto Storage index buffer", 64, $$5);
            }
            finally {
                MemoryUtil.memFree((Buffer)$$5);
            }
            this.indexCount = p_157477_;
        }

        private IntConsumer intConsumer(ByteBuffer p_157479_) {
            switch (this.type) {
                case SHORT: {
                    return p_157482_ -> p_157479_.putShort((short)p_157482_);
                }
            }
            return p_157479_::putInt;
        }

        public VertexFormat.IndexType type() {
            return this.type;
        }

        static interface IndexGenerator {
            public void accept(IntConsumer var1, int var2);
        }
    }

    record GpuAsyncTask(Runnable callback, GpuFence fence) {
    }
}

