/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.resource;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.resource.ResourceDescriptor;
import com.mojang.blaze3d.systems.RenderSystem;

public record RenderTargetDescriptor(int width, int height, boolean useDepth, int clearColor) implements ResourceDescriptor<RenderTarget>
{
    @Override
    public RenderTarget allocate() {
        return new TextureTarget(null, this.width, this.height, this.useDepth);
    }

    @Override
    public void prepare(RenderTarget p_393765_) {
        if (this.useDepth) {
            RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(p_393765_.getColorTexture(), this.clearColor, p_393765_.getDepthTexture(), 1.0);
        } else {
            RenderSystem.getDevice().createCommandEncoder().clearColorTexture(p_393765_.getColorTexture(), this.clearColor);
        }
    }

    @Override
    public void free(RenderTarget p_363223_) {
        p_363223_.destroyBuffers();
    }

    @Override
    public boolean canUsePhysicalResource(ResourceDescriptor<?> p_394237_) {
        if (p_394237_ instanceof RenderTargetDescriptor) {
            RenderTargetDescriptor $$1 = (RenderTargetDescriptor)p_394237_;
            return this.width == $$1.width && this.height == $$1.height && this.useDepth == $$1.useDepth;
        }
        return false;
    }

    @Override
    public /* synthetic */ void free(Object object) {
        this.free((RenderTarget)object);
    }

    @Override
    public /* synthetic */ void prepare(Object object) {
        this.prepare((RenderTarget)object);
    }

    @Override
    public /* synthetic */ Object allocate() {
        return this.allocate();
    }
}

