/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.resource;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.blaze3d.resource.GraphicsResourceAllocator;
import com.mojang.blaze3d.resource.ResourceDescriptor;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;

public class CrossFrameResourcePool
implements GraphicsResourceAllocator,
AutoCloseable {
    private final int framesToKeepResource;
    private final Deque<ResourceEntry<?>> pool = new ArrayDeque();

    public CrossFrameResourcePool(int p_360291_) {
        this.framesToKeepResource = p_360291_;
    }

    public void endFrame() {
        Iterator<ResourceEntry<?>> $$0 = this.pool.iterator();
        while ($$0.hasNext()) {
            ResourceEntry<?> $$1 = $$0.next();
            if ($$1.framesToLive-- != 0) continue;
            $$1.close();
            $$0.remove();
        }
    }

    @Override
    public <T> T acquire(ResourceDescriptor<T> p_365509_) {
        T $$1 = this.acquireWithoutPreparing(p_365509_);
        p_365509_.prepare($$1);
        return $$1;
    }

    private <T> T acquireWithoutPreparing(ResourceDescriptor<T> p_394528_) {
        Iterator<ResourceEntry<?>> $$1 = this.pool.iterator();
        while ($$1.hasNext()) {
            ResourceEntry<?> $$2 = $$1.next();
            if (!p_394528_.canUsePhysicalResource($$2.descriptor)) continue;
            $$1.remove();
            return $$2.value;
        }
        return p_394528_.allocate();
    }

    @Override
    public <T> void release(ResourceDescriptor<T> p_360929_, T p_364526_) {
        this.pool.addFirst(new ResourceEntry<T>(p_360929_, p_364526_, this.framesToKeepResource));
    }

    public void clear() {
        this.pool.forEach(ResourceEntry::close);
        this.pool.clear();
    }

    @Override
    public void close() {
        this.clear();
    }

    @VisibleForTesting
    protected Collection<ResourceEntry<?>> entries() {
        return this.pool;
    }

    @VisibleForTesting
    protected static final class ResourceEntry<T>
    implements AutoCloseable {
        final ResourceDescriptor<T> descriptor;
        final T value;
        int framesToLive;

        ResourceEntry(ResourceDescriptor<T> p_362044_, T p_364798_, int p_362012_) {
            this.descriptor = p_362044_;
            this.value = p_364798_;
            this.framesToLive = p_362012_;
        }

        @Override
        public void close() {
            this.descriptor.free(this.value);
        }
    }
}

