/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.mojang.blaze3d.TracyFrameCapture;
import com.mojang.blaze3d.platform.DisplayData;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.IconSet;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.MacosUtil;
import com.mojang.blaze3d.platform.Monitor;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.ScreenManager;
import com.mojang.blaze3d.platform.VideoMode;
import com.mojang.blaze3d.platform.WindowEventHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.main.SilentInitException;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.IoSupplier;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWWindowCloseCallback;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import org.slf4j.Logger;

public final class Window
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int BASE_WIDTH = 320;
    public static final int BASE_HEIGHT = 240;
    private final GLFWErrorCallback defaultErrorCallback = GLFWErrorCallback.create(this::defaultErrorCallback);
    private final WindowEventHandler eventHandler;
    private final ScreenManager screenManager;
    private final long window;
    private int windowedX;
    private int windowedY;
    private int windowedWidth;
    private int windowedHeight;
    private Optional<VideoMode> preferredFullscreenVideoMode;
    private boolean fullscreen;
    private boolean actuallyFullscreen;
    private int x;
    private int y;
    private int width;
    private int height;
    private int framebufferWidth;
    private int framebufferHeight;
    private int guiScaledWidth;
    private int guiScaledHeight;
    private int guiScale;
    private String errorSection = "";
    private boolean dirty;
    private boolean vsync;
    private boolean iconified;
    private boolean minimized;

    public Window(WindowEventHandler p_85372_, ScreenManager p_85373_, DisplayData p_85374_, @Nullable String p_85375_, String p_85376_) {
        this.screenManager = p_85373_;
        this.setBootErrorCallback();
        this.setErrorSection("Pre startup");
        this.eventHandler = p_85372_;
        Optional<VideoMode> $$5 = VideoMode.read(p_85375_);
        this.preferredFullscreenVideoMode = $$5.isPresent() ? $$5 : (p_85374_.fullscreenWidth().isPresent() && p_85374_.fullscreenHeight().isPresent() ? Optional.of(new VideoMode(p_85374_.fullscreenWidth().getAsInt(), p_85374_.fullscreenHeight().getAsInt(), 8, 8, 8, 60)) : Optional.empty());
        this.actuallyFullscreen = this.fullscreen = p_85374_.isFullscreen();
        Monitor $$6 = p_85373_.getMonitor(GLFW.glfwGetPrimaryMonitor());
        this.windowedWidth = this.width = Math.max(p_85374_.width(), 1);
        this.windowedHeight = this.height = Math.max(p_85374_.height(), 1);
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)139265, (int)196609);
        GLFW.glfwWindowHint((int)139275, (int)221185);
        GLFW.glfwWindowHint((int)139266, (int)3);
        GLFW.glfwWindowHint((int)139267, (int)2);
        GLFW.glfwWindowHint((int)139272, (int)204801);
        GLFW.glfwWindowHint((int)139270, (int)1);
        this.window = GLFW.glfwCreateWindow((int)this.width, (int)this.height, (CharSequence)p_85376_, (long)(this.fullscreen && $$6 != null ? $$6.getMonitor() : 0L), (long)0L);
        if ($$6 != null) {
            VideoMode $$7 = $$6.getPreferredVidMode(this.fullscreen ? this.preferredFullscreenVideoMode : Optional.empty());
            this.windowedX = this.x = $$6.getX() + $$7.getWidth() / 2 - this.width / 2;
            this.windowedY = this.y = $$6.getY() + $$7.getHeight() / 2 - this.height / 2;
        } else {
            int[] $$8 = new int[1];
            int[] $$9 = new int[1];
            GLFW.glfwGetWindowPos((long)this.window, (int[])$$8, (int[])$$9);
            this.windowedX = this.x = $$8[0];
            this.windowedY = this.y = $$9[0];
        }
        this.setMode();
        this.refreshFramebufferSize();
        GLFW.glfwSetFramebufferSizeCallback((long)this.window, this::onFramebufferResize);
        GLFW.glfwSetWindowPosCallback((long)this.window, this::onMove);
        GLFW.glfwSetWindowSizeCallback((long)this.window, this::onResize);
        GLFW.glfwSetWindowFocusCallback((long)this.window, this::onFocus);
        GLFW.glfwSetCursorEnterCallback((long)this.window, this::onEnter);
        GLFW.glfwSetWindowIconifyCallback((long)this.window, this::onIconify);
    }

    public static String getPlatform() {
        int $$0 = GLFW.glfwGetPlatform();
        return switch ($$0) {
            case 0 -> "<error>";
            case 393217 -> "win32";
            case 393218 -> "cocoa";
            case 393219 -> "wayland";
            case 393220 -> "x11";
            case 393221 -> "null";
            default -> String.format(Locale.ROOT, "unknown (%08X)", $$0);
        };
    }

    public int getRefreshRate() {
        RenderSystem.assertOnRenderThread();
        return GLX._getRefreshRate(this);
    }

    public boolean shouldClose() {
        return GLX._shouldClose(this);
    }

    public static void checkGlfwError(BiConsumer<Integer, String> p_85408_) {
        try (MemoryStack $$1 = MemoryStack.stackPush();){
            PointerBuffer $$2 = $$1.mallocPointer(1);
            int $$3 = GLFW.glfwGetError((PointerBuffer)$$2);
            if ($$3 != 0) {
                long $$4 = $$2.get();
                String $$5 = $$4 == 0L ? "" : MemoryUtil.memUTF8((long)$$4);
                p_85408_.accept($$3, $$5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIcon(PackResources p_281860_, IconSet p_282155_) throws IOException {
        int $$2 = GLFW.glfwGetPlatform();
        switch ($$2) {
            case 393217: 
            case 393220: {
                List<IoSupplier<InputStream>> $$3 = p_282155_.getStandardIcons(p_281860_);
                ArrayList<ByteBuffer> $$4 = new ArrayList<ByteBuffer>($$3.size());
                try (MemoryStack $$5 = MemoryStack.stackPush();){
                    GLFWImage.Buffer $$6 = GLFWImage.malloc((int)$$3.size(), (MemoryStack)$$5);
                    for (int $$7 = 0; $$7 < $$3.size(); ++$$7) {
                        try (NativeImage $$8 = NativeImage.read($$3.get($$7).get());){
                            ByteBuffer $$9 = MemoryUtil.memAlloc((int)($$8.getWidth() * $$8.getHeight() * 4));
                            $$4.add($$9);
                            $$9.asIntBuffer().put($$8.getPixelsABGR());
                            $$6.position($$7);
                            $$6.width($$8.getWidth());
                            $$6.height($$8.getHeight());
                            $$6.pixels($$9);
                            continue;
                        }
                    }
                    GLFW.glfwSetWindowIcon((long)this.window, (GLFWImage.Buffer)((GLFWImage.Buffer)$$6.position(0)));
                    break;
                }
                finally {
                    $$4.forEach(MemoryUtil::memFree);
                }
            }
            case 393218: {
                MacosUtil.loadIcon(p_282155_.getMacIcon(p_281860_));
                break;
            }
            case 393219: 
            case 393221: {
                break;
            }
            default: {
                LOGGER.warn("Not setting icon for unrecognized platform: {}", (Object)$$2);
            }
        }
    }

    public void setErrorSection(String p_85404_) {
        this.errorSection = p_85404_;
    }

    private void setBootErrorCallback() {
        GLFW.glfwSetErrorCallback(Window::bootCrash);
    }

    private static void bootCrash(int p_85413_, long p_85414_) {
        String $$2 = "GLFW error " + p_85413_ + ": " + MemoryUtil.memUTF8((long)p_85414_);
        TinyFileDialogs.tinyfd_messageBox((CharSequence)"Minecraft", (CharSequence)($$2 + ".\n\nPlease make sure you have up-to-date drivers (see aka.ms/mcdriver for instructions)."), (CharSequence)"ok", (CharSequence)"error", (boolean)false);
        throw new WindowInitFailed($$2);
    }

    public void defaultErrorCallback(int p_85383_, long p_85384_) {
        RenderSystem.assertOnRenderThread();
        String $$2 = MemoryUtil.memUTF8((long)p_85384_);
        LOGGER.error("########## GL ERROR ##########");
        LOGGER.error("@ {}", (Object)this.errorSection);
        LOGGER.error("{}: {}", (Object)p_85383_, (Object)$$2);
    }

    public void setDefaultErrorCallback() {
        GLFWErrorCallback $$0 = GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)this.defaultErrorCallback);
        if ($$0 != null) {
            $$0.free();
        }
    }

    public void updateVsync(boolean p_85410_) {
        RenderSystem.assertOnRenderThread();
        this.vsync = p_85410_;
        GLFW.glfwSwapInterval((int)(p_85410_ ? 1 : 0));
    }

    @Override
    public void close() {
        RenderSystem.assertOnRenderThread();
        Callbacks.glfwFreeCallbacks((long)this.window);
        this.defaultErrorCallback.close();
        GLFW.glfwDestroyWindow((long)this.window);
        GLFW.glfwTerminate();
    }

    private void onMove(long p_85389_, int p_85390_, int p_85391_) {
        this.x = p_85390_;
        this.y = p_85391_;
    }

    private void onFramebufferResize(long p_85416_, int p_85417_, int p_85418_) {
        if (p_85416_ != this.window) {
            return;
        }
        int $$3 = this.getWidth();
        int $$4 = this.getHeight();
        if (p_85417_ == 0 || p_85418_ == 0) {
            this.minimized = true;
            return;
        }
        this.minimized = false;
        this.framebufferWidth = p_85417_;
        this.framebufferHeight = p_85418_;
        if (this.getWidth() != $$3 || this.getHeight() != $$4) {
            try {
                this.eventHandler.resizeDisplay();
            }
            catch (Exception $$5) {
                CrashReport $$6 = CrashReport.forThrowable($$5, "Window resize");
                CrashReportCategory $$7 = $$6.addCategory("Window Dimensions");
                $$7.setDetail("Old", $$3 + "x" + $$4);
                $$7.setDetail("New", p_85417_ + "x" + p_85418_);
                throw new ReportedException($$6);
            }
        }
    }

    private void refreshFramebufferSize() {
        int[] $$0 = new int[1];
        int[] $$1 = new int[1];
        GLFW.glfwGetFramebufferSize((long)this.window, (int[])$$0, (int[])$$1);
        this.framebufferWidth = $$0[0] > 0 ? $$0[0] : 1;
        this.framebufferHeight = $$1[0] > 0 ? $$1[0] : 1;
    }

    private void onResize(long p_85428_, int p_85429_, int p_85430_) {
        this.width = p_85429_;
        this.height = p_85430_;
    }

    private void onFocus(long p_85393_, boolean p_85394_) {
        if (p_85393_ == this.window) {
            this.eventHandler.setWindowActive(p_85394_);
        }
    }

    private void onEnter(long p_85420_, boolean p_85421_) {
        if (p_85421_) {
            this.eventHandler.cursorEntered();
        }
    }

    private void onIconify(long p_361196_, boolean p_363700_) {
        this.iconified = p_363700_;
    }

    public void updateDisplay(@Nullable TracyFrameCapture p_373098_) {
        RenderSystem.flipFrame(this.window, p_373098_);
        if (this.fullscreen != this.actuallyFullscreen) {
            this.actuallyFullscreen = this.fullscreen;
            this.updateFullscreen(this.vsync, p_373098_);
        }
    }

    public Optional<VideoMode> getPreferredFullscreenVideoMode() {
        return this.preferredFullscreenVideoMode;
    }

    public void setPreferredFullscreenVideoMode(Optional<VideoMode> p_85406_) {
        boolean $$1 = !p_85406_.equals(this.preferredFullscreenVideoMode);
        this.preferredFullscreenVideoMode = p_85406_;
        if ($$1) {
            this.dirty = true;
        }
    }

    public void changeFullscreenVideoMode() {
        if (this.fullscreen && this.dirty) {
            this.dirty = false;
            this.setMode();
            this.eventHandler.resizeDisplay();
        }
    }

    private void setMode() {
        boolean $$0;
        boolean bl = $$0 = GLFW.glfwGetWindowMonitor((long)this.window) != 0L;
        if (this.fullscreen) {
            Monitor $$1 = this.screenManager.findBestMonitor(this);
            if ($$1 == null) {
                LOGGER.warn("Failed to find suitable monitor for fullscreen mode");
                this.fullscreen = false;
            } else {
                if (MacosUtil.IS_MACOS) {
                    MacosUtil.exitNativeFullscreen(this.window);
                }
                VideoMode $$2 = $$1.getPreferredVidMode(this.preferredFullscreenVideoMode);
                if (!$$0) {
                    this.windowedX = this.x;
                    this.windowedY = this.y;
                    this.windowedWidth = this.width;
                    this.windowedHeight = this.height;
                }
                this.x = 0;
                this.y = 0;
                this.width = $$2.getWidth();
                this.height = $$2.getHeight();
                GLFW.glfwSetWindowMonitor((long)this.window, (long)$$1.getMonitor(), (int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)$$2.getRefreshRate());
                if (MacosUtil.IS_MACOS) {
                    MacosUtil.clearResizableBit(this.window);
                }
            }
        } else {
            this.x = this.windowedX;
            this.y = this.windowedY;
            this.width = this.windowedWidth;
            this.height = this.windowedHeight;
            GLFW.glfwSetWindowMonitor((long)this.window, (long)0L, (int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)-1);
        }
    }

    public void toggleFullScreen() {
        this.fullscreen = !this.fullscreen;
    }

    public void setWindowed(int p_166448_, int p_166449_) {
        this.windowedWidth = p_166448_;
        this.windowedHeight = p_166449_;
        this.fullscreen = false;
        this.setMode();
    }

    private void updateFullscreen(boolean p_85432_, @Nullable TracyFrameCapture p_373070_) {
        RenderSystem.assertOnRenderThread();
        try {
            this.setMode();
            this.eventHandler.resizeDisplay();
            this.updateVsync(p_85432_);
            this.updateDisplay(p_373070_);
        }
        catch (Exception $$2) {
            LOGGER.error("Couldn't toggle fullscreen", (Throwable)$$2);
        }
    }

    public int calculateScale(int p_85386_, boolean p_85387_) {
        int $$2;
        for ($$2 = 1; $$2 != p_85386_ && $$2 < this.framebufferWidth && $$2 < this.framebufferHeight && this.framebufferWidth / ($$2 + 1) >= 320 && this.framebufferHeight / ($$2 + 1) >= 240; ++$$2) {
        }
        if (p_85387_ && $$2 % 2 != 0) {
            ++$$2;
        }
        return $$2;
    }

    public void setGuiScale(int p_415540_) {
        this.guiScale = p_415540_;
        double $$1 = p_415540_;
        int $$2 = (int)((double)this.framebufferWidth / $$1);
        this.guiScaledWidth = (double)this.framebufferWidth / $$1 > (double)$$2 ? $$2 + 1 : $$2;
        int $$3 = (int)((double)this.framebufferHeight / $$1);
        this.guiScaledHeight = (double)this.framebufferHeight / $$1 > (double)$$3 ? $$3 + 1 : $$3;
    }

    public void setTitle(String p_85423_) {
        GLFW.glfwSetWindowTitle((long)this.window, (CharSequence)p_85423_);
    }

    public long getWindow() {
        return this.window;
    }

    public boolean isFullscreen() {
        return this.fullscreen;
    }

    public boolean isIconified() {
        return this.iconified;
    }

    public int getWidth() {
        return this.framebufferWidth;
    }

    public int getHeight() {
        return this.framebufferHeight;
    }

    public void setWidth(int p_166451_) {
        this.framebufferWidth = p_166451_;
    }

    public void setHeight(int p_166453_) {
        this.framebufferHeight = p_166453_;
    }

    public int getScreenWidth() {
        return this.width;
    }

    public int getScreenHeight() {
        return this.height;
    }

    public int getGuiScaledWidth() {
        return this.guiScaledWidth;
    }

    public int getGuiScaledHeight() {
        return this.guiScaledHeight;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getGuiScale() {
        return this.guiScale;
    }

    @Nullable
    public Monitor findBestMonitor() {
        return this.screenManager.findBestMonitor(this);
    }

    public void updateRawMouseInput(boolean p_85425_) {
        InputConstants.updateRawMouseInput(this.window, p_85425_);
    }

    public void setWindowCloseCallback(Runnable p_361232_) {
        GLFWWindowCloseCallback $$1 = GLFW.glfwSetWindowCloseCallback((long)this.window, p_365115_ -> p_361232_.run());
        if ($$1 != null) {
            $$1.free();
        }
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public static class WindowInitFailed
    extends SilentInitException {
        WindowInitFailed(String p_85455_) {
            super(p_85455_);
        }
    }
}

