/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.pipeline;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.AddressMode;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderPipelines;

public abstract class RenderTarget {
    private static int UNNAMED_RENDER_TARGETS = 0;
    public int width;
    public int height;
    public int viewWidth;
    public int viewHeight;
    protected final String label;
    public final boolean useDepth;
    @Nullable
    protected GpuTexture colorTexture;
    @Nullable
    protected GpuTextureView colorTextureView;
    @Nullable
    protected GpuTexture depthTexture;
    @Nullable
    protected GpuTextureView depthTextureView;
    public FilterMode filterMode;

    public RenderTarget(@Nullable String p_405387_, boolean p_166199_) {
        this.label = p_405387_ == null ? "FBO " + UNNAMED_RENDER_TARGETS++ : p_405387_;
        this.useDepth = p_166199_;
    }

    public void resize(int p_83942_, int p_83943_) {
        RenderSystem.assertOnRenderThread();
        this.destroyBuffers();
        this.createBuffers(p_83942_, p_83943_);
    }

    public void destroyBuffers() {
        RenderSystem.assertOnRenderThread();
        if (this.depthTexture != null) {
            this.depthTexture.close();
            this.depthTexture = null;
        }
        if (this.depthTextureView != null) {
            this.depthTextureView.close();
            this.depthTextureView = null;
        }
        if (this.colorTexture != null) {
            this.colorTexture.close();
            this.colorTexture = null;
        }
        if (this.colorTextureView != null) {
            this.colorTextureView.close();
            this.colorTextureView = null;
        }
    }

    public void copyDepthFrom(RenderTarget p_83946_) {
        RenderSystem.assertOnRenderThread();
        if (this.depthTexture == null) {
            throw new IllegalStateException("Trying to copy depth texture to a RenderTarget without a depth texture");
        }
        if (p_83946_.depthTexture == null) {
            throw new IllegalStateException("Trying to copy depth texture from a RenderTarget without a depth texture");
        }
        RenderSystem.getDevice().createCommandEncoder().copyTextureToTexture(p_83946_.depthTexture, this.depthTexture, 0, 0, 0, 0, 0, this.width, this.height);
    }

    public void createBuffers(int p_83951_, int p_83952_) {
        RenderSystem.assertOnRenderThread();
        GpuDevice $$2 = RenderSystem.getDevice();
        int $$3 = $$2.getMaxTextureSize();
        if (p_83951_ <= 0 || p_83951_ > $$3 || p_83952_ <= 0 || p_83952_ > $$3) {
            throw new IllegalArgumentException("Window " + p_83951_ + "x" + p_83952_ + " size out of bounds (max. size: " + $$3 + ")");
        }
        this.viewWidth = p_83951_;
        this.viewHeight = p_83952_;
        this.width = p_83951_;
        this.height = p_83952_;
        if (this.useDepth) {
            this.depthTexture = $$2.createTexture(() -> this.label + " / Depth", 15, TextureFormat.DEPTH32, p_83951_, p_83952_, 1, 1);
            this.depthTextureView = $$2.createTextureView(this.depthTexture);
            this.depthTexture.setTextureFilter(FilterMode.NEAREST, false);
            this.depthTexture.setAddressMode(AddressMode.CLAMP_TO_EDGE);
        }
        this.colorTexture = $$2.createTexture(() -> this.label + " / Color", 15, TextureFormat.RGBA8, p_83951_, p_83952_, 1, 1);
        this.colorTextureView = $$2.createTextureView(this.colorTexture);
        this.colorTexture.setAddressMode(AddressMode.CLAMP_TO_EDGE);
        this.setFilterMode(FilterMode.NEAREST, true);
    }

    public void setFilterMode(FilterMode p_404671_) {
        this.setFilterMode(p_404671_, false);
    }

    private void setFilterMode(FilterMode p_404975_, boolean p_333775_) {
        if (this.colorTexture == null) {
            throw new IllegalStateException("Can't change filter mode, color texture doesn't exist yet");
        }
        if (p_333775_ || p_404975_ != this.filterMode) {
            this.filterMode = p_404975_;
            this.colorTexture.setTextureFilter(p_404975_, false);
        }
    }

    public void blitToScreen() {
        if (this.colorTexture == null) {
            throw new IllegalStateException("Can't blit to screen, color texture doesn't exist yet");
        }
        RenderSystem.getDevice().createCommandEncoder().presentTexture(this.colorTextureView);
    }

    public void blitAndBlendToTexture(GpuTextureView p_423552_) {
        RenderSystem.assertOnRenderThread();
        RenderSystem.AutoStorageIndexBuffer $$1 = RenderSystem.getSequentialBuffer(VertexFormat.Mode.QUADS);
        GpuBuffer $$2 = $$1.getBuffer(6);
        GpuBuffer $$3 = RenderSystem.getQuadVertexBuffer();
        try (RenderPass $$4 = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Blit render target", p_423552_, OptionalInt.empty());){
            $$4.setPipeline(RenderPipelines.ENTITY_OUTLINE_BLIT);
            RenderSystem.bindDefaultUniforms($$4);
            $$4.setVertexBuffer(0, $$3);
            $$4.setIndexBuffer($$2, $$1.type());
            $$4.bindSampler("InSampler", this.colorTextureView);
            $$4.drawIndexed(0, 0, 6, 1);
        }
    }

    @Nullable
    public GpuTexture getColorTexture() {
        return this.colorTexture;
    }

    @Nullable
    public GpuTextureView getColorTextureView() {
        return this.colorTextureView;
    }

    @Nullable
    public GpuTexture getDepthTexture() {
        return this.depthTexture;
    }

    @Nullable
    public GpuTextureView getDepthTextureView() {
        return this.depthTextureView;
    }
}

