/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.opengl;

import com.mojang.blaze3d.opengl.GlBuffer;
import com.mojang.blaze3d.opengl.GlDevice;
import com.mojang.blaze3d.opengl.GlProgram;
import com.mojang.blaze3d.opengl.GlShaderModule;
import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.opengl.VertexArrayCache;
import com.mojang.logging.LogUtils;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.util.StringUtil;
import org.lwjgl.opengl.EXTDebugLabel;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.KHRDebug;
import org.slf4j.Logger;

public abstract class GlDebugLabel {
    private static final Logger LOGGER = LogUtils.getLogger();

    public void applyLabel(GlBuffer p_409842_) {
    }

    public void applyLabel(GlTexture p_410098_) {
    }

    public void applyLabel(GlShaderModule p_410275_) {
    }

    public void applyLabel(GlProgram p_410337_) {
    }

    public void applyLabel(VertexArrayCache.VertexArray p_410821_) {
    }

    public void pushDebugGroup(Supplier<String> p_419723_) {
    }

    public void popDebugGroup() {
    }

    public static GlDebugLabel create(GLCapabilities p_409769_, boolean p_410806_, Set<String> p_411081_) {
        if (p_410806_) {
            if (p_409769_.GL_KHR_debug && GlDevice.USE_GL_KHR_debug) {
                p_411081_.add("GL_KHR_debug");
                return new Core();
            }
            if (p_409769_.GL_EXT_debug_label && GlDevice.USE_GL_EXT_debug_label) {
                p_411081_.add("GL_EXT_debug_label");
                return new Ext();
            }
            LOGGER.warn("Debug labels unavailable: neither KHR_debug nor EXT_debug_label are supported");
        }
        return new Empty();
    }

    public boolean exists() {
        return false;
    }

    static class Core
    extends GlDebugLabel {
        private final int maxLabelLength = GL11.glGetInteger((int)33512);

        Core() {
        }

        @Override
        public void applyLabel(GlBuffer p_410733_) {
            Supplier<String> $$1 = p_410733_.label;
            if ($$1 != null) {
                KHRDebug.glObjectLabel((int)33504, (int)p_410733_.handle, (CharSequence)StringUtil.truncateStringIfNecessary($$1.get(), this.maxLabelLength, true));
            }
        }

        @Override
        public void applyLabel(GlTexture p_410170_) {
            KHRDebug.glObjectLabel((int)5890, (int)p_410170_.id, (CharSequence)StringUtil.truncateStringIfNecessary(p_410170_.getLabel(), this.maxLabelLength, true));
        }

        @Override
        public void applyLabel(GlShaderModule p_410868_) {
            KHRDebug.glObjectLabel((int)33505, (int)p_410868_.getShaderId(), (CharSequence)StringUtil.truncateStringIfNecessary(p_410868_.getDebugLabel(), this.maxLabelLength, true));
        }

        @Override
        public void applyLabel(GlProgram p_409865_) {
            KHRDebug.glObjectLabel((int)33506, (int)p_409865_.getProgramId(), (CharSequence)StringUtil.truncateStringIfNecessary(p_409865_.getDebugLabel(), this.maxLabelLength, true));
        }

        @Override
        public void applyLabel(VertexArrayCache.VertexArray p_410688_) {
            KHRDebug.glObjectLabel((int)32884, (int)p_410688_.id, (CharSequence)StringUtil.truncateStringIfNecessary(p_410688_.format.toString(), this.maxLabelLength, true));
        }

        @Override
        public void pushDebugGroup(Supplier<String> p_420037_) {
            KHRDebug.glPushDebugGroup((int)33354, (int)0, (CharSequence)p_420037_.get());
        }

        @Override
        public void popDebugGroup() {
            KHRDebug.glPopDebugGroup();
        }

        @Override
        public boolean exists() {
            return true;
        }
    }

    static class Ext
    extends GlDebugLabel {
        Ext() {
        }

        @Override
        public void applyLabel(GlBuffer p_410006_) {
            Supplier<String> $$1 = p_410006_.label;
            if ($$1 != null) {
                EXTDebugLabel.glLabelObjectEXT((int)37201, (int)p_410006_.handle, (CharSequence)StringUtil.truncateStringIfNecessary($$1.get(), 256, true));
            }
        }

        @Override
        public void applyLabel(GlTexture p_410324_) {
            EXTDebugLabel.glLabelObjectEXT((int)5890, (int)p_410324_.id, (CharSequence)StringUtil.truncateStringIfNecessary(p_410324_.getLabel(), 256, true));
        }

        @Override
        public void applyLabel(GlShaderModule p_410674_) {
            EXTDebugLabel.glLabelObjectEXT((int)35656, (int)p_410674_.getShaderId(), (CharSequence)StringUtil.truncateStringIfNecessary(p_410674_.getDebugLabel(), 256, true));
        }

        @Override
        public void applyLabel(GlProgram p_409850_) {
            EXTDebugLabel.glLabelObjectEXT((int)35648, (int)p_409850_.getProgramId(), (CharSequence)StringUtil.truncateStringIfNecessary(p_409850_.getDebugLabel(), 256, true));
        }

        @Override
        public void applyLabel(VertexArrayCache.VertexArray p_409615_) {
            EXTDebugLabel.glLabelObjectEXT((int)32884, (int)p_409615_.id, (CharSequence)StringUtil.truncateStringIfNecessary(p_409615_.format.toString(), 256, true));
        }

        @Override
        public boolean exists() {
            return true;
        }
    }

    static class Empty
    extends GlDebugLabel {
        Empty() {
        }
    }
}

