/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.opengl;

import com.mojang.blaze3d.opengl.GlConst;
import com.mojang.blaze3d.opengl.GlDevice;
import com.mojang.blaze3d.opengl.GlStateManager;
import java.nio.ByteBuffer;
import java.util.Set;
import javax.annotation.Nullable;
import org.lwjgl.opengl.ARBBufferStorage;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;
import org.lwjgl.opengl.GLCapabilities;

public abstract class DirectStateAccess {
    public static DirectStateAccess create(GLCapabilities p_412632_, Set<String> p_412533_) {
        if (p_412632_.GL_ARB_direct_state_access && GlDevice.USE_GL_ARB_direct_state_access) {
            p_412533_.add("GL_ARB_direct_state_access");
            return new Core();
        }
        return new Emulated();
    }

    abstract int createBuffer();

    abstract void bufferData(int var1, long var2, int var4);

    abstract void bufferData(int var1, ByteBuffer var2, int var3);

    abstract void bufferSubData(int var1, int var2, ByteBuffer var3);

    abstract void bufferStorage(int var1, long var2, int var4);

    abstract void bufferStorage(int var1, ByteBuffer var2, int var3);

    @Nullable
    abstract ByteBuffer mapBufferRange(int var1, int var2, int var3, int var4);

    abstract void unmapBuffer(int var1);

    abstract int createFrameBufferObject();

    abstract void bindFrameBufferTextures(int var1, int var2, int var3, int var4, int var5);

    abstract void blitFrameBuffers(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    abstract void flushMappedBufferRange(int var1, int var2, int var3);

    abstract void copyBufferSubData(int var1, int var2, int var3, int var4, int var5);

    static class Core
    extends DirectStateAccess {
        Core() {
        }

        @Override
        int createBuffer() {
            return ARBDirectStateAccess.glCreateBuffers();
        }

        @Override
        void bufferData(int p_418123_, long p_418371_, int p_418160_) {
            ARBDirectStateAccess.glNamedBufferData((int)p_418123_, (long)p_418371_, (int)p_418160_);
        }

        @Override
        void bufferData(int p_418280_, ByteBuffer p_418007_, int p_418178_) {
            ARBDirectStateAccess.glNamedBufferData((int)p_418280_, (ByteBuffer)p_418007_, (int)p_418178_);
        }

        @Override
        void bufferSubData(int p_418076_, int p_418299_, ByteBuffer p_418117_) {
            ARBDirectStateAccess.glNamedBufferSubData((int)p_418076_, (long)p_418299_, (ByteBuffer)p_418117_);
        }

        @Override
        void bufferStorage(int p_418428_, long p_418019_, int p_418289_) {
            ARBDirectStateAccess.glNamedBufferStorage((int)p_418428_, (long)p_418019_, (int)p_418289_);
        }

        @Override
        void bufferStorage(int p_418345_, ByteBuffer p_418031_, int p_418465_) {
            ARBDirectStateAccess.glNamedBufferStorage((int)p_418345_, (ByteBuffer)p_418031_, (int)p_418465_);
        }

        @Override
        @Nullable
        ByteBuffer mapBufferRange(int p_418027_, int p_418408_, int p_418310_, int p_418214_) {
            return ARBDirectStateAccess.glMapNamedBufferRange((int)p_418027_, (long)p_418408_, (long)p_418310_, (int)p_418214_);
        }

        @Override
        void unmapBuffer(int p_418046_) {
            ARBDirectStateAccess.glUnmapNamedBuffer((int)p_418046_);
        }

        @Override
        public int createFrameBufferObject() {
            return ARBDirectStateAccess.glCreateFramebuffers();
        }

        @Override
        public void bindFrameBufferTextures(int p_412474_, int p_412101_, int p_412181_, int p_412742_, int p_412591_) {
            ARBDirectStateAccess.glNamedFramebufferTexture((int)p_412474_, (int)36064, (int)p_412101_, (int)p_412742_);
            ARBDirectStateAccess.glNamedFramebufferTexture((int)p_412474_, (int)36096, (int)p_412181_, (int)p_412742_);
            if (p_412591_ != 0) {
                GlStateManager._glBindFramebuffer(p_412591_, p_412474_);
            }
        }

        @Override
        public void blitFrameBuffers(int p_412346_, int p_412174_, int p_412752_, int p_412365_, int p_412477_, int p_412615_, int p_412700_, int p_412178_, int p_412260_, int p_412584_, int p_412685_, int p_412482_) {
            ARBDirectStateAccess.glBlitNamedFramebuffer((int)p_412346_, (int)p_412174_, (int)p_412752_, (int)p_412365_, (int)p_412477_, (int)p_412615_, (int)p_412700_, (int)p_412178_, (int)p_412260_, (int)p_412584_, (int)p_412685_, (int)p_412482_);
        }

        @Override
        void flushMappedBufferRange(int p_418135_, int p_418262_, int p_418080_) {
            ARBDirectStateAccess.glFlushMappedNamedBufferRange((int)p_418135_, (long)p_418262_, (long)p_418080_);
        }

        @Override
        void copyBufferSubData(int p_428836_, int p_428841_, int p_428817_, int p_428818_, int p_428819_) {
            ARBDirectStateAccess.glCopyNamedBufferSubData((int)p_428836_, (int)p_428841_, (long)p_428817_, (long)p_428818_, (long)p_428819_);
        }
    }

    static class Emulated
    extends DirectStateAccess {
        Emulated() {
        }

        @Override
        int createBuffer() {
            return GlStateManager._glGenBuffers();
        }

        @Override
        void bufferData(int p_418415_, long p_418240_, int p_418204_) {
            GlStateManager._glBindBuffer(36663, p_418415_);
            GlStateManager._glBufferData(36663, p_418240_, GlConst.bufferUsageToGlEnum(p_418204_));
            GlStateManager._glBindBuffer(36663, 0);
        }

        @Override
        void bufferData(int p_418504_, ByteBuffer p_418319_, int p_418033_) {
            GlStateManager._glBindBuffer(36663, p_418504_);
            GlStateManager._glBufferData(36663, p_418319_, GlConst.bufferUsageToGlEnum(p_418033_));
            GlStateManager._glBindBuffer(36663, 0);
        }

        @Override
        void bufferSubData(int p_418332_, int p_418165_, ByteBuffer p_418268_) {
            GlStateManager._glBindBuffer(36663, p_418332_);
            GlStateManager._glBufferSubData(36663, p_418165_, p_418268_);
            GlStateManager._glBindBuffer(36663, 0);
        }

        @Override
        void bufferStorage(int p_418279_, long p_418194_, int p_418045_) {
            GlStateManager._glBindBuffer(36663, p_418279_);
            ARBBufferStorage.glBufferStorage((int)36663, (long)p_418194_, (int)p_418045_);
            GlStateManager._glBindBuffer(36663, 0);
        }

        @Override
        void bufferStorage(int p_418284_, ByteBuffer p_418011_, int p_418406_) {
            GlStateManager._glBindBuffer(36663, p_418284_);
            ARBBufferStorage.glBufferStorage((int)36663, (ByteBuffer)p_418011_, (int)p_418406_);
            GlStateManager._glBindBuffer(36663, 0);
        }

        @Override
        @Nullable
        ByteBuffer mapBufferRange(int p_418226_, int p_418017_, int p_418092_, int p_418512_) {
            GlStateManager._glBindBuffer(36663, p_418226_);
            ByteBuffer $$4 = GlStateManager._glMapBufferRange(36663, p_418017_, p_418092_, p_418512_);
            GlStateManager._glBindBuffer(36663, 0);
            return $$4;
        }

        @Override
        void unmapBuffer(int p_418235_) {
            GlStateManager._glBindBuffer(36663, p_418235_);
            GlStateManager._glUnmapBuffer(36663);
            GlStateManager._glBindBuffer(36663, 0);
        }

        @Override
        void flushMappedBufferRange(int p_418330_, int p_418325_, int p_418530_) {
            GlStateManager._glBindBuffer(36663, p_418330_);
            GL30.glFlushMappedBufferRange((int)36663, (long)p_418325_, (long)p_418530_);
            GlStateManager._glBindBuffer(36663, 0);
        }

        @Override
        void copyBufferSubData(int p_428853_, int p_428827_, int p_428852_, int p_428847_, int p_428825_) {
            GlStateManager._glBindBuffer(36662, p_428853_);
            GlStateManager._glBindBuffer(36663, p_428827_);
            GL31.glCopyBufferSubData((int)36662, (int)36663, (long)p_428852_, (long)p_428847_, (long)p_428825_);
            GlStateManager._glBindBuffer(36662, 0);
            GlStateManager._glBindBuffer(36663, 0);
        }

        @Override
        public int createFrameBufferObject() {
            return GlStateManager.glGenFramebuffers();
        }

        @Override
        public void bindFrameBufferTextures(int p_412192_, int p_412614_, int p_412332_, int p_412295_, int p_412775_) {
            int $$5 = p_412775_ == 0 ? 36009 : p_412775_;
            int $$6 = GlStateManager.getFrameBuffer($$5);
            GlStateManager._glBindFramebuffer($$5, p_412192_);
            GlStateManager._glFramebufferTexture2D($$5, 36064, 3553, p_412614_, p_412295_);
            GlStateManager._glFramebufferTexture2D($$5, 36096, 3553, p_412332_, p_412295_);
            if (p_412775_ == 0) {
                GlStateManager._glBindFramebuffer($$5, $$6);
            }
        }

        @Override
        public void blitFrameBuffers(int p_412705_, int p_412256_, int p_412077_, int p_412762_, int p_412738_, int p_412701_, int p_412455_, int p_412525_, int p_412252_, int p_412684_, int p_412520_, int p_412585_) {
            int $$12 = GlStateManager.getFrameBuffer(36008);
            int $$13 = GlStateManager.getFrameBuffer(36009);
            GlStateManager._glBindFramebuffer(36008, p_412705_);
            GlStateManager._glBindFramebuffer(36009, p_412256_);
            GlStateManager._glBlitFrameBuffer(p_412077_, p_412762_, p_412738_, p_412701_, p_412455_, p_412525_, p_412252_, p_412684_, p_412520_, p_412585_);
            GlStateManager._glBindFramebuffer(36008, $$12);
            GlStateManager._glBindFramebuffer(36009, $$13);
        }
    }
}

