/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.font;

import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.font.GlyphProvider;
import com.mojang.blaze3d.font.SheetGlyphInfo;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Locale;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.gui.font.CodepointMap;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.gui.font.providers.FreeTypeUtil;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.freetype.FT_Bitmap;
import org.lwjgl.util.freetype.FT_Face;
import org.lwjgl.util.freetype.FT_GlyphSlot;
import org.lwjgl.util.freetype.FT_Vector;
import org.lwjgl.util.freetype.FreeType;

public class TrueTypeGlyphProvider
implements GlyphProvider {
    @Nullable
    private ByteBuffer fontMemory;
    @Nullable
    private FT_Face face;
    final float oversample;
    private final CodepointMap<GlyphEntry> glyphs = new CodepointMap(GlyphEntry[]::new, p_359012_ -> new GlyphEntry[p_359012_][]);

    public TrueTypeGlyphProvider(ByteBuffer p_83846_, FT_Face p_320481_, float p_83848_, float p_83849_, float p_83850_, float p_83851_, String p_83852_) {
        this.fontMemory = p_83846_;
        this.face = p_320481_;
        this.oversample = p_83849_;
        IntArraySet $$7 = new IntArraySet();
        p_83852_.codePoints().forEach(arg_0 -> ((IntSet)$$7).add(arg_0));
        int $$8 = Math.round(p_83848_ * p_83849_);
        FreeType.FT_Set_Pixel_Sizes((FT_Face)p_320481_, (int)$$8, (int)$$8);
        float $$9 = p_83850_ * p_83849_;
        float $$10 = -p_83851_ * p_83849_;
        try (MemoryStack $$11 = MemoryStack.stackPush();){
            int $$15;
            FT_Vector $$12 = FreeTypeUtil.setVector(FT_Vector.malloc((MemoryStack)$$11), $$9, $$10);
            FreeType.FT_Set_Transform((FT_Face)p_320481_, null, (FT_Vector)$$12);
            IntBuffer $$13 = $$11.mallocInt(1);
            int $$14 = (int)FreeType.FT_Get_First_Char((FT_Face)p_320481_, (IntBuffer)$$13);
            while (($$15 = $$13.get(0)) != 0) {
                if (!$$7.contains($$14)) {
                    this.glyphs.put($$14, new GlyphEntry($$15));
                }
                $$14 = (int)FreeType.FT_Get_Next_Char((FT_Face)p_320481_, (long)$$14, (IntBuffer)$$13);
            }
        }
    }

    @Override
    @Nullable
    public GlyphInfo getGlyph(int p_231116_) {
        GlyphEntry $$1 = this.glyphs.get(p_231116_);
        return $$1 != null ? this.getOrLoadGlyphInfo(p_231116_, $$1) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GlyphInfo getOrLoadGlyphInfo(int p_365358_, GlyphEntry p_360879_) {
        GlyphInfo $$2 = p_360879_.glyph;
        if ($$2 == null) {
            FT_Face $$3;
            FT_Face fT_Face = $$3 = this.validateFontOpen();
            synchronized (fT_Face) {
                $$2 = p_360879_.glyph;
                if ($$2 == null) {
                    p_360879_.glyph = $$2 = this.loadGlyph(p_365358_, $$3, p_360879_.index);
                }
            }
        }
        return $$2;
    }

    private GlyphInfo loadGlyph(int p_361822_, FT_Face p_360350_, int p_362748_) {
        FT_GlyphSlot $$4;
        int $$3 = FreeType.FT_Load_Glyph((FT_Face)p_360350_, (int)p_362748_, (int)0x400008);
        if ($$3 != 0) {
            FreeTypeUtil.assertError($$3, String.format(Locale.ROOT, "Loading glyph U+%06X", p_361822_));
        }
        if (($$4 = p_360350_.glyph()) == null) {
            throw new NullPointerException(String.format(Locale.ROOT, "Glyph U+%06X not initialized", p_361822_));
        }
        float $$5 = FreeTypeUtil.x($$4.advance());
        FT_Bitmap $$6 = $$4.bitmap();
        int $$7 = $$4.bitmap_left();
        int $$8 = $$4.bitmap_top();
        int $$9 = $$6.width();
        int $$10 = $$6.rows();
        if ($$9 <= 0 || $$10 <= 0) {
            return () -> $$5 / this.oversample;
        }
        return new Glyph($$7, $$8, $$9, $$10, $$5, p_362748_);
    }

    FT_Face validateFontOpen() {
        if (this.fontMemory == null || this.face == null) {
            throw new IllegalStateException("Provider already closed");
        }
        return this.face;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.face != null) {
            Object object = FreeTypeUtil.LIBRARY_LOCK;
            synchronized (object) {
                FreeTypeUtil.checkError(FreeType.FT_Done_Face((FT_Face)this.face), "Deleting face");
            }
            this.face = null;
        }
        MemoryUtil.memFree((Buffer)this.fontMemory);
        this.fontMemory = null;
    }

    @Override
    public IntSet getSupportedGlyphs() {
        return this.glyphs.keySet();
    }

    static class GlyphEntry {
        final int index;
        @Nullable
        volatile GlyphInfo glyph;

        GlyphEntry(int p_360519_) {
            this.index = p_360519_;
        }
    }

    class Glyph
    implements GlyphInfo {
        final int width;
        final int height;
        final float bearingX;
        final float bearingY;
        private final float advance;
        final int index;

        Glyph(float p_83886_, float p_83887_, int p_83882_, int p_83883_, float p_320408_, int p_83884_) {
            this.width = p_83882_;
            this.height = p_83883_;
            this.advance = p_320408_ / TrueTypeGlyphProvider.this.oversample;
            this.bearingX = p_83886_ / TrueTypeGlyphProvider.this.oversample;
            this.bearingY = p_83887_ / TrueTypeGlyphProvider.this.oversample;
            this.index = p_83884_;
        }

        @Override
        public float getAdvance() {
            return this.advance;
        }

        @Override
        public BakedGlyph bake(Function<SheetGlyphInfo, BakedGlyph> p_231120_) {
            return p_231120_.apply(new SheetGlyphInfo(){

                @Override
                public int getPixelWidth() {
                    return Glyph.this.width;
                }

                @Override
                public int getPixelHeight() {
                    return Glyph.this.height;
                }

                @Override
                public float getOversample() {
                    return TrueTypeGlyphProvider.this.oversample;
                }

                @Override
                public float getBearingLeft() {
                    return Glyph.this.bearingX;
                }

                @Override
                public float getBearingTop() {
                    return Glyph.this.bearingY;
                }

                @Override
                public void upload(int p_231126_, int p_231127_, GpuTexture p_405861_) {
                    FT_Face $$3 = TrueTypeGlyphProvider.this.validateFontOpen();
                    try (NativeImage $$4 = new NativeImage(NativeImage.Format.LUMINANCE, Glyph.this.width, Glyph.this.height, false);){
                        if ($$4.copyFromFont($$3, Glyph.this.index)) {
                            RenderSystem.getDevice().createCommandEncoder().writeToTexture(p_405861_, $$4, 0, 0, p_231126_, p_231127_, Glyph.this.width, Glyph.this.height, 0, 0);
                        }
                    }
                }

                @Override
                public boolean isColored() {
                    return false;
                }
            });
        }
    }
}

