/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.resource;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.ServerFunctionLibrary;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.crafting.RecipeManager;
import net.neoforged.neoforge.common.util.VanillaClassToKey;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class VanillaServerListeners {
    private static final Map<Class<?>, ResourceLocation> KNOWN_CLASSES = new LinkedHashMap();
    public static final ResourceLocation RECIPES = VanillaServerListeners.key(RecipeManager.class);
    public static final ResourceLocation FUNCTIONS = VanillaServerListeners.key(ServerFunctionLibrary.class);
    public static final ResourceLocation ADVANCEMENTS = VanillaServerListeners.key(ServerAdvancementManager.class);
    public static final ResourceLocation FIRST = RECIPES;
    public static final ResourceLocation LAST = ADVANCEMENTS;

    private static ResourceLocation key(Class<? extends PreparableReloadListener> cls) {
        if (KNOWN_CLASSES.containsKey(cls)) {
            throw new UnsupportedOperationException("Attempted to create two keys for the same class");
        }
        ResourceLocation key = VanillaClassToKey.convert(cls);
        KNOWN_CLASSES.put(cls, key);
        return key;
    }

    @Nullable
    @ApiStatus.Internal
    public static ResourceLocation getNameForClass(Class<? extends PreparableReloadListener> cls) {
        return KNOWN_CLASSES.get(cls);
    }
}

