/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.ticks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.Hash;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraft.world.ticks.TickPriority;

public record SavedTick<T>(T type, BlockPos pos, int delay, TickPriority priority) {
    public static final Hash.Strategy<SavedTick<?>> UNIQUE_TICK_HASH = new Hash.Strategy<SavedTick<?>>(){

        public int hashCode(SavedTick<?> p_193364_) {
            return 31 * p_193364_.pos().hashCode() + p_193364_.type().hashCode();
        }

        public boolean equals(@Nullable SavedTick<?> p_193366_, @Nullable SavedTick<?> p_193367_) {
            if (p_193366_ == p_193367_) {
                return true;
            }
            return p_193366_ != null && p_193367_ != null ? p_193366_.type() == p_193367_.type() && p_193366_.pos().equals(p_193367_.pos()) : false;
        }
    };

    public static <T> Codec<SavedTick<T>> codec(Codec<T> p_405158_) {
        MapCodec mapcodec = RecordCodecBuilder.mapCodec(p_404625_ -> p_404625_.group((App)Codec.INT.fieldOf("x").forGetter(Vec3i::getX), (App)Codec.INT.fieldOf("y").forGetter(Vec3i::getY), (App)Codec.INT.fieldOf("z").forGetter(Vec3i::getZ)).apply((Applicative)p_404625_, BlockPos::new));
        return RecordCodecBuilder.create(p_404628_ -> p_404628_.group((App)p_405158_.fieldOf("i").forGetter(SavedTick::type), (App)mapcodec.forGetter(SavedTick::pos), (App)Codec.INT.fieldOf("t").forGetter(SavedTick::delay), (App)TickPriority.CODEC.fieldOf("p").forGetter(SavedTick::priority)).apply((Applicative)p_404628_, SavedTick::new));
    }

    public static <T> List<SavedTick<T>> filterTickListForChunk(List<SavedTick<T>> p_405515_, ChunkPos p_405037_) {
        long i = p_405037_.toLong();
        return p_405515_.stream().filter(p_404630_ -> ChunkPos.asLong(p_404630_.pos()) == i).toList();
    }

    public ScheduledTick<T> unpack(long p_193329_, long p_193330_) {
        return new ScheduledTick<T>(this.type, this.pos, p_193329_ + (long)this.delay, this.priority, p_193330_);
    }

    public static <T> SavedTick<T> probe(T p_193336_, BlockPos p_193337_) {
        return new SavedTick<T>(p_193336_, p_193337_, 0, TickPriority.NORMAL);
    }
}

