/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerScoreEntry;
import net.minecraft.world.scores.PlayerScores;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

public class Scoreboard {
    public static final String HIDDEN_SCORE_PREFIX = "#";
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Object2ObjectMap<String, Objective> objectivesByName = new Object2ObjectOpenHashMap(16, 0.5f);
    private final Reference2ObjectMap<ObjectiveCriteria, List<Objective>> objectivesByCriteria = new Reference2ObjectOpenHashMap();
    private final Map<String, PlayerScores> playerScores = new Object2ObjectOpenHashMap(16, 0.5f);
    private final Map<DisplaySlot, Objective> displayObjectives = new EnumMap<DisplaySlot, Objective>(DisplaySlot.class);
    private final Object2ObjectMap<String, PlayerTeam> teamsByName = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, PlayerTeam> teamsByPlayer = new Object2ObjectOpenHashMap();

    @Nullable
    public Objective getObjective(@Nullable String p_83478_) {
        return (Objective)this.objectivesByName.get((Object)p_83478_);
    }

    public Objective addObjective(String p_83437_, ObjectiveCriteria p_83438_, Component p_83439_, ObjectiveCriteria.RenderType p_83440_, boolean p_313815_, @Nullable NumberFormat p_313909_) {
        if (this.objectivesByName.containsKey((Object)p_83437_)) {
            throw new IllegalArgumentException("An objective with the name '" + p_83437_ + "' already exists!");
        }
        Objective objective = new Objective(this, p_83437_, p_83438_, p_83439_, p_83440_, p_313815_, p_313909_);
        ((List)this.objectivesByCriteria.computeIfAbsent((Object)p_83438_, p_314722_ -> Lists.newArrayList())).add(objective);
        this.objectivesByName.put((Object)p_83437_, (Object)objective);
        this.onObjectiveAdded(objective);
        return objective;
    }

    public final void forAllObjectives(ObjectiveCriteria p_83428_, ScoreHolder p_313805_, Consumer<ScoreAccess> p_83430_) {
        ((List)this.objectivesByCriteria.getOrDefault((Object)p_83428_, Collections.emptyList())).forEach(p_313676_ -> p_83430_.accept(this.getOrCreatePlayerScore(p_313805_, (Objective)p_313676_, true)));
    }

    private PlayerScores getOrCreatePlayerInfo(String p_313892_) {
        return this.playerScores.computeIfAbsent(p_313892_, p_313683_ -> new PlayerScores());
    }

    public ScoreAccess getOrCreatePlayerScore(ScoreHolder p_313714_, Objective p_313948_) {
        return this.getOrCreatePlayerScore(p_313714_, p_313948_, false);
    }

    public ScoreAccess getOrCreatePlayerScore(final ScoreHolder p_313717_, final Objective p_83473_, boolean p_313939_) {
        final boolean flag = p_313939_ || !p_83473_.getCriteria().isReadOnly();
        PlayerScores playerscores = this.getOrCreatePlayerInfo(p_313717_.getScoreboardName());
        final MutableBoolean mutableboolean = new MutableBoolean();
        final Score score = playerscores.getOrCreate(p_83473_, p_313682_ -> mutableboolean.setTrue());
        return new ScoreAccess(){

            @Override
            public int get() {
                return score.value();
            }

            @Override
            public void set(int p_313831_) {
                Component component;
                if (!flag) {
                    throw new IllegalStateException("Cannot modify read-only score");
                }
                boolean flag1 = mutableboolean.isTrue();
                if (p_83473_.displayAutoUpdate() && (component = p_313717_.getDisplayName()) != null && !component.equals(score.display())) {
                    score.display(component);
                    flag1 = true;
                }
                if (p_313831_ != score.value()) {
                    score.value(p_313831_);
                    flag1 = true;
                }
                if (flag1) {
                    this.sendScoreToPlayers();
                }
            }

            @Override
            @Nullable
            public Component display() {
                return score.display();
            }

            @Override
            public void display(@Nullable Component p_313826_) {
                if (mutableboolean.isTrue() || !Objects.equals(p_313826_, score.display())) {
                    score.display(p_313826_);
                    this.sendScoreToPlayers();
                }
            }

            @Override
            public void numberFormatOverride(@Nullable NumberFormat p_313875_) {
                score.numberFormat(p_313875_);
                this.sendScoreToPlayers();
            }

            @Override
            public boolean locked() {
                return score.isLocked();
            }

            @Override
            public void unlock() {
                this.setLocked(false);
            }

            @Override
            public void lock() {
                this.setLocked(true);
            }

            private void setLocked(boolean p_313822_) {
                score.setLocked(p_313822_);
                if (mutableboolean.isTrue()) {
                    this.sendScoreToPlayers();
                }
                Scoreboard.this.onScoreLockChanged(p_313717_, p_83473_);
            }

            private void sendScoreToPlayers() {
                Scoreboard.this.onScoreChanged(p_313717_, p_83473_, score);
                mutableboolean.setFalse();
            }
        };
    }

    @Nullable
    public ReadOnlyScoreInfo getPlayerScoreInfo(ScoreHolder p_313711_, Objective p_313813_) {
        PlayerScores playerscores = this.playerScores.get(p_313711_.getScoreboardName());
        return playerscores != null ? playerscores.get(p_313813_) : null;
    }

    public Collection<PlayerScoreEntry> listPlayerScores(Objective p_313802_) {
        ArrayList<PlayerScoreEntry> list = new ArrayList<PlayerScoreEntry>();
        this.playerScores.forEach((p_313669_, p_313670_) -> {
            Score score = p_313670_.get(p_313802_);
            if (score != null) {
                list.add(new PlayerScoreEntry((String)p_313669_, score.value(), score.display(), score.numberFormat()));
            }
        });
        return list;
    }

    public Collection<Objective> getObjectives() {
        return this.objectivesByName.values();
    }

    public Collection<String> getObjectiveNames() {
        return this.objectivesByName.keySet();
    }

    public Collection<ScoreHolder> getTrackedPlayers() {
        return this.playerScores.keySet().stream().map(ScoreHolder::forNameOnly).toList();
    }

    public void resetAllPlayerScores(ScoreHolder p_313823_) {
        PlayerScores playerscores = this.playerScores.remove(p_313823_.getScoreboardName());
        if (playerscores != null) {
            this.onPlayerRemoved(p_313823_);
        }
    }

    public void resetSinglePlayerScore(ScoreHolder p_313783_, Objective p_313928_) {
        PlayerScores playerscores = this.playerScores.get(p_313783_.getScoreboardName());
        if (playerscores != null) {
            boolean flag = playerscores.remove(p_313928_);
            if (!playerscores.hasScores()) {
                PlayerScores playerscores1 = this.playerScores.remove(p_313783_.getScoreboardName());
                if (playerscores1 != null) {
                    this.onPlayerRemoved(p_313783_);
                }
            } else if (flag) {
                this.onPlayerScoreRemoved(p_313783_, p_313928_);
            }
        }
    }

    public Object2IntMap<Objective> listPlayerScores(ScoreHolder p_313893_) {
        PlayerScores playerscores = this.playerScores.get(p_313893_.getScoreboardName());
        return playerscores != null ? playerscores.listScores() : Object2IntMaps.emptyMap();
    }

    public void removeObjective(Objective p_83503_) {
        this.objectivesByName.remove((Object)p_83503_.getName());
        for (DisplaySlot displayslot : DisplaySlot.values()) {
            if (this.getDisplayObjective(displayslot) != p_83503_) continue;
            this.setDisplayObjective(displayslot, null);
        }
        List list = (List)this.objectivesByCriteria.get((Object)p_83503_.getCriteria());
        if (list != null) {
            list.remove(p_83503_);
        }
        for (PlayerScores playerscores : this.playerScores.values()) {
            playerscores.remove(p_83503_);
        }
        this.onObjectiveRemoved(p_83503_);
    }

    public void setDisplayObjective(DisplaySlot p_296205_, @Nullable Objective p_83419_) {
        this.displayObjectives.put(p_296205_, p_83419_);
    }

    @Nullable
    public Objective getDisplayObjective(DisplaySlot p_295165_) {
        return this.displayObjectives.get(p_295165_);
    }

    @Nullable
    public PlayerTeam getPlayerTeam(String p_83490_) {
        return (PlayerTeam)this.teamsByName.get((Object)p_83490_);
    }

    public PlayerTeam addPlayerTeam(String p_83493_) {
        PlayerTeam playerteam = this.getPlayerTeam(p_83493_);
        if (playerteam != null) {
            LOGGER.warn("Requested creation of existing team '{}'", (Object)p_83493_);
            return playerteam;
        }
        playerteam = new PlayerTeam(this, p_83493_);
        this.teamsByName.put((Object)p_83493_, (Object)playerteam);
        this.onTeamAdded(playerteam);
        return playerteam;
    }

    public void removePlayerTeam(PlayerTeam p_83476_) {
        this.teamsByName.remove((Object)p_83476_.getName());
        for (String s : p_83476_.getPlayers()) {
            this.teamsByPlayer.remove((Object)s);
        }
        this.onTeamRemoved(p_83476_);
    }

    public boolean addPlayerToTeam(String p_83434_, PlayerTeam p_83435_) {
        if (this.getPlayersTeam(p_83434_) != null) {
            this.removePlayerFromTeam(p_83434_);
        }
        this.teamsByPlayer.put((Object)p_83434_, (Object)p_83435_);
        return p_83435_.getPlayers().add(p_83434_);
    }

    public boolean removePlayerFromTeam(String p_83496_) {
        PlayerTeam playerteam = this.getPlayersTeam(p_83496_);
        if (playerteam != null) {
            this.removePlayerFromTeam(p_83496_, playerteam);
            return true;
        }
        return false;
    }

    public void removePlayerFromTeam(String p_83464_, PlayerTeam p_83465_) {
        if (this.getPlayersTeam(p_83464_) != p_83465_) {
            throw new IllegalStateException("Player is either on another team or not on any team. Cannot remove from team '" + p_83465_.getName() + "'.");
        }
        this.teamsByPlayer.remove((Object)p_83464_);
        p_83465_.getPlayers().remove(p_83464_);
    }

    public Collection<String> getTeamNames() {
        return this.teamsByName.keySet();
    }

    public Collection<PlayerTeam> getPlayerTeams() {
        return this.teamsByName.values();
    }

    @Nullable
    public PlayerTeam getPlayersTeam(String p_83501_) {
        return (PlayerTeam)this.teamsByPlayer.get((Object)p_83501_);
    }

    public void onObjectiveAdded(Objective p_83422_) {
    }

    public void onObjectiveChanged(Objective p_83455_) {
    }

    public void onObjectiveRemoved(Objective p_83467_) {
    }

    protected void onScoreChanged(ScoreHolder p_313729_, Objective p_313930_, Score p_83424_) {
    }

    protected void onScoreLockChanged(ScoreHolder p_313727_, Objective p_313708_) {
    }

    public void onPlayerRemoved(ScoreHolder p_313917_) {
    }

    public void onPlayerScoreRemoved(ScoreHolder p_313899_, Objective p_83433_) {
    }

    public void onTeamAdded(PlayerTeam p_83423_) {
    }

    public void onTeamChanged(PlayerTeam p_83456_) {
    }

    public void onTeamRemoved(PlayerTeam p_83468_) {
    }

    public void entityRemoved(Entity p_83421_) {
        if (!(p_83421_ instanceof Player) && !p_83421_.isAlive()) {
            this.resetAllPlayerScores(p_83421_);
            this.removePlayerFromTeam(p_83421_.getScoreboardName());
        }
    }

    protected List<PackedScore> packPlayerScores() {
        return this.playerScores.entrySet().stream().flatMap(p_400991_ -> {
            String s = (String)p_400991_.getKey();
            return ((PlayerScores)p_400991_.getValue()).listRawScores().entrySet().stream().map(p_400993_ -> new PackedScore(s, ((Objective)p_400993_.getKey()).getName(), (Score)p_400993_.getValue()));
        }).toList();
    }

    protected void loadPlayerScore(PackedScore p_401360_) {
        Objective objective = this.getObjective(p_401360_.objective);
        if (objective == null) {
            LOGGER.error("Unknown objective {} for name {}, ignoring", (Object)p_401360_.objective, (Object)p_401360_.owner);
        } else {
            this.getOrCreatePlayerInfo(p_401360_.owner).setScore(objective, p_401360_.score);
        }
    }

    protected void loadPlayerTeam(PlayerTeam.Packed p_401125_) {
        PlayerTeam playerteam = this.addPlayerTeam(p_401125_.name());
        p_401125_.displayName().ifPresent(playerteam::setDisplayName);
        p_401125_.color().ifPresent(playerteam::setColor);
        playerteam.setAllowFriendlyFire(p_401125_.allowFriendlyFire());
        playerteam.setSeeFriendlyInvisibles(p_401125_.seeFriendlyInvisibles());
        playerteam.setPlayerPrefix(p_401125_.memberNamePrefix());
        playerteam.setPlayerSuffix(p_401125_.memberNameSuffix());
        playerteam.setNameTagVisibility(p_401125_.nameTagVisibility());
        playerteam.setDeathMessageVisibility(p_401125_.deathMessageVisibility());
        playerteam.setCollisionRule(p_401125_.collisionRule());
        for (String s : p_401125_.players()) {
            this.addPlayerToTeam(s, playerteam);
        }
    }

    protected void loadObjective(Objective.Packed p_401060_) {
        this.addObjective(p_401060_.name(), p_401060_.criteria(), p_401060_.displayName(), p_401060_.renderType(), p_401060_.displayAutoUpdate(), p_401060_.numberFormat().orElse(null));
    }

    public record PackedScore(String owner, String objective, Score score) {
        public static final Codec<PackedScore> CODEC = RecordCodecBuilder.create(p_401229_ -> p_401229_.group((App)Codec.STRING.fieldOf("Name").forGetter(PackedScore::owner), (App)Codec.STRING.fieldOf("Objective").forGetter(PackedScore::objective), (App)Score.MAP_CODEC.forGetter(PackedScore::score)).apply((Applicative)p_401229_, PackedScore::new));
    }
}

