/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import com.mojang.authlib.GameProfile;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;

public interface ScoreHolder {
    public static final String WILDCARD_NAME = "*";
    public static final ScoreHolder WILDCARD = new ScoreHolder(){

        @Override
        public String getScoreboardName() {
            return ScoreHolder.WILDCARD_NAME;
        }
    };

    public String getScoreboardName();

    @Nullable
    default public Component getDisplayName() {
        return null;
    }

    default public Component getFeedbackDisplayName() {
        Component component = this.getDisplayName();
        return component != null ? component.copy().withStyle(p_393460_ -> p_393460_.withHoverEvent(new HoverEvent.ShowText(Component.literal(this.getScoreboardName())))) : Component.literal(this.getScoreboardName());
    }

    public static ScoreHolder forNameOnly(final String p_313803_) {
        if (p_313803_.equals(WILDCARD_NAME)) {
            return WILDCARD;
        }
        final MutableComponent component = Component.literal(p_313803_);
        return new ScoreHolder(){

            @Override
            public String getScoreboardName() {
                return p_313803_;
            }

            @Override
            public Component getFeedbackDisplayName() {
                return component;
            }
        };
    }

    public static ScoreHolder fromGameProfile(GameProfile p_313755_) {
        final String s = p_313755_.getName();
        return new ScoreHolder(){

            @Override
            public String getScoreboardName() {
                return s;
            }
        };
    }
}

