/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.math.DoubleMath;
import com.google.common.math.IntMath;
import com.mojang.math.OctahedralGroup;
import com.mojang.math.Quadrant;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.AxisCycle;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.ArrayVoxelShape;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CubePointRange;
import net.minecraft.world.phys.shapes.CubeVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteCubeMerger;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.IdenticalMerger;
import net.minecraft.world.phys.shapes.IndexMerger;
import net.minecraft.world.phys.shapes.IndirectMerger;
import net.minecraft.world.phys.shapes.NonOverlappingMerger;
import net.minecraft.world.phys.shapes.SliceShape;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class Shapes {
    public static final double EPSILON = 1.0E-7;
    public static final double BIG_EPSILON = 1.0E-6;
    private static final VoxelShape BLOCK = Util.make(() -> {
        BitSetDiscreteVoxelShape discretevoxelshape = new BitSetDiscreteVoxelShape(1, 1, 1);
        ((DiscreteVoxelShape)discretevoxelshape).fill(0, 0, 0);
        return new CubeVoxelShape(discretevoxelshape);
    });
    private static final Vec3 BLOCK_CENTER = new Vec3(0.5, 0.5, 0.5);
    public static final VoxelShape INFINITY = Shapes.box(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private static final VoxelShape EMPTY = new ArrayVoxelShape((DiscreteVoxelShape)new BitSetDiscreteVoxelShape(0, 0, 0), (DoubleList)new DoubleArrayList(new double[]{0.0}), (DoubleList)new DoubleArrayList(new double[]{0.0}), (DoubleList)new DoubleArrayList(new double[]{0.0}));

    public static VoxelShape empty() {
        return EMPTY;
    }

    public static VoxelShape block() {
        return BLOCK;
    }

    public static VoxelShape box(double p_83049_, double p_83050_, double p_83051_, double p_83052_, double p_83053_, double p_83054_) {
        if (!(p_83049_ > p_83052_ || p_83050_ > p_83053_ || p_83051_ > p_83054_)) {
            return Shapes.create(p_83049_, p_83050_, p_83051_, p_83052_, p_83053_, p_83054_);
        }
        throw new IllegalArgumentException("The min values need to be smaller or equals to the max values");
    }

    public static VoxelShape create(double p_166050_, double p_166051_, double p_166052_, double p_166053_, double p_166054_, double p_166055_) {
        if (!(p_166053_ - p_166050_ < 1.0E-7 || p_166054_ - p_166051_ < 1.0E-7 || p_166055_ - p_166052_ < 1.0E-7)) {
            int i = Shapes.findBits(p_166050_, p_166053_);
            int j = Shapes.findBits(p_166051_, p_166054_);
            int k = Shapes.findBits(p_166052_, p_166055_);
            if (i < 0 || j < 0 || k < 0) {
                return new ArrayVoxelShape(Shapes.BLOCK.shape, (DoubleList)DoubleArrayList.wrap((double[])new double[]{p_166050_, p_166053_}), (DoubleList)DoubleArrayList.wrap((double[])new double[]{p_166051_, p_166054_}), (DoubleList)DoubleArrayList.wrap((double[])new double[]{p_166052_, p_166055_}));
            }
            if (i == 0 && j == 0 && k == 0) {
                return Shapes.block();
            }
            int l = 1 << i;
            int i1 = 1 << j;
            int j1 = 1 << k;
            BitSetDiscreteVoxelShape bitsetdiscretevoxelshape = BitSetDiscreteVoxelShape.withFilledBounds(l, i1, j1, (int)Math.round(p_166050_ * (double)l), (int)Math.round(p_166051_ * (double)i1), (int)Math.round(p_166052_ * (double)j1), (int)Math.round(p_166053_ * (double)l), (int)Math.round(p_166054_ * (double)i1), (int)Math.round(p_166055_ * (double)j1));
            return new CubeVoxelShape(bitsetdiscretevoxelshape);
        }
        return Shapes.empty();
    }

    public static VoxelShape create(AABB p_83065_) {
        return Shapes.create(p_83065_.minX, p_83065_.minY, p_83065_.minZ, p_83065_.maxX, p_83065_.maxY, p_83065_.maxZ);
    }

    @VisibleForTesting
    protected static int findBits(double p_83042_, double p_83043_) {
        if (!(p_83042_ < -1.0E-7) && !(p_83043_ > 1.0000001)) {
            for (int i = 0; i <= 3; ++i) {
                boolean flag1;
                int j = 1 << i;
                double d0 = p_83042_ * (double)j;
                double d1 = p_83043_ * (double)j;
                boolean flag = Math.abs(d0 - (double)Math.round(d0)) < 1.0E-7 * (double)j;
                boolean bl = flag1 = Math.abs(d1 - (double)Math.round(d1)) < 1.0E-7 * (double)j;
                if (!flag || !flag1) continue;
                return i;
            }
            return -1;
        }
        return -1;
    }

    protected static long lcm(int p_83056_, int p_83057_) {
        return (long)p_83056_ * (long)(p_83057_ / IntMath.gcd((int)p_83056_, (int)p_83057_));
    }

    public static VoxelShape or(VoxelShape p_83111_, VoxelShape p_83112_) {
        return Shapes.join(p_83111_, p_83112_, BooleanOp.OR);
    }

    public static VoxelShape or(VoxelShape p_83125_, VoxelShape ... p_83126_) {
        return Arrays.stream(p_83126_).reduce(p_83125_, Shapes::or);
    }

    public static VoxelShape join(VoxelShape p_83114_, VoxelShape p_83115_, BooleanOp p_83116_) {
        return Shapes.joinUnoptimized(p_83114_, p_83115_, p_83116_).optimize();
    }

    public static VoxelShape joinUnoptimized(VoxelShape p_83149_, VoxelShape p_83150_, BooleanOp p_83151_) {
        if (p_83151_.apply(false, false)) {
            throw Util.pauseInIde(new IllegalArgumentException());
        }
        if (p_83149_ == p_83150_) {
            return p_83151_.apply(true, true) ? p_83149_ : Shapes.empty();
        }
        boolean flag = p_83151_.apply(true, false);
        boolean flag1 = p_83151_.apply(false, true);
        if (p_83149_.isEmpty()) {
            return flag1 ? p_83150_ : Shapes.empty();
        }
        if (p_83150_.isEmpty()) {
            return flag ? p_83149_ : Shapes.empty();
        }
        IndexMerger indexmerger = Shapes.createIndexMerger(1, p_83149_.getCoords(Direction.Axis.X), p_83150_.getCoords(Direction.Axis.X), flag, flag1);
        IndexMerger indexmerger1 = Shapes.createIndexMerger(indexmerger.size() - 1, p_83149_.getCoords(Direction.Axis.Y), p_83150_.getCoords(Direction.Axis.Y), flag, flag1);
        IndexMerger indexmerger2 = Shapes.createIndexMerger((indexmerger.size() - 1) * (indexmerger1.size() - 1), p_83149_.getCoords(Direction.Axis.Z), p_83150_.getCoords(Direction.Axis.Z), flag, flag1);
        BitSetDiscreteVoxelShape bitsetdiscretevoxelshape = BitSetDiscreteVoxelShape.join(p_83149_.shape, p_83150_.shape, indexmerger, indexmerger1, indexmerger2, p_83151_);
        return indexmerger instanceof DiscreteCubeMerger && indexmerger1 instanceof DiscreteCubeMerger && indexmerger2 instanceof DiscreteCubeMerger ? new CubeVoxelShape(bitsetdiscretevoxelshape) : new ArrayVoxelShape((DiscreteVoxelShape)bitsetdiscretevoxelshape, indexmerger.getList(), indexmerger1.getList(), indexmerger2.getList());
    }

    public static boolean joinIsNotEmpty(VoxelShape p_83158_, VoxelShape p_83159_, BooleanOp p_83160_) {
        if (p_83160_.apply(false, false)) {
            throw Util.pauseInIde(new IllegalArgumentException());
        }
        boolean flag = p_83158_.isEmpty();
        boolean flag1 = p_83159_.isEmpty();
        if (!flag && !flag1) {
            if (p_83158_ == p_83159_) {
                return p_83160_.apply(true, true);
            }
            boolean flag2 = p_83160_.apply(true, false);
            boolean flag3 = p_83160_.apply(false, true);
            for (Direction.Axis direction$axis : AxisCycle.AXIS_VALUES) {
                if (p_83158_.max(direction$axis) < p_83159_.min(direction$axis) - 1.0E-7) {
                    return flag2 || flag3;
                }
                if (!(p_83159_.max(direction$axis) < p_83158_.min(direction$axis) - 1.0E-7)) continue;
                return flag2 || flag3;
            }
            IndexMerger indexmerger = Shapes.createIndexMerger(1, p_83158_.getCoords(Direction.Axis.X), p_83159_.getCoords(Direction.Axis.X), flag2, flag3);
            IndexMerger indexmerger1 = Shapes.createIndexMerger(indexmerger.size() - 1, p_83158_.getCoords(Direction.Axis.Y), p_83159_.getCoords(Direction.Axis.Y), flag2, flag3);
            IndexMerger indexmerger2 = Shapes.createIndexMerger((indexmerger.size() - 1) * (indexmerger1.size() - 1), p_83158_.getCoords(Direction.Axis.Z), p_83159_.getCoords(Direction.Axis.Z), flag2, flag3);
            return Shapes.joinIsNotEmpty(indexmerger, indexmerger1, indexmerger2, p_83158_.shape, p_83159_.shape, p_83160_);
        }
        return p_83160_.apply(!flag, !flag1);
    }

    private static boolean joinIsNotEmpty(IndexMerger p_83104_, IndexMerger p_83105_, IndexMerger p_83106_, DiscreteVoxelShape p_83107_, DiscreteVoxelShape p_83108_, BooleanOp p_83109_) {
        return !p_83104_.forMergedIndexes((p_83100_, p_83101_, p_83102_) -> p_83105_.forMergedIndexes((p_166046_, p_166047_, p_166048_) -> p_83106_.forMergedIndexes((p_166036_, p_166037_, p_166038_) -> !p_83109_.apply(p_83107_.isFullWide(p_83100_, p_166046_, p_166036_), p_83108_.isFullWide(p_83101_, p_166047_, p_166037_)))));
    }

    public static double collide(Direction.Axis p_193136_, AABB p_193137_, Iterable<VoxelShape> p_193138_, double p_193139_) {
        for (VoxelShape voxelshape : p_193138_) {
            if (Math.abs(p_193139_) < 1.0E-7) {
                return 0.0;
            }
            p_193139_ = voxelshape.collide(p_193136_, p_193137_, p_193139_);
        }
        return p_193139_;
    }

    public static boolean blockOccludes(VoxelShape p_83118_, VoxelShape p_83119_, Direction p_83120_) {
        if (p_83118_ == Shapes.block() && p_83119_ == Shapes.block()) {
            return true;
        }
        if (p_83119_.isEmpty()) {
            return false;
        }
        Direction.Axis direction$axis = p_83120_.getAxis();
        Direction.AxisDirection direction$axisdirection = p_83120_.getAxisDirection();
        VoxelShape voxelshape = direction$axisdirection == Direction.AxisDirection.POSITIVE ? p_83118_ : p_83119_;
        VoxelShape voxelshape1 = direction$axisdirection == Direction.AxisDirection.POSITIVE ? p_83119_ : p_83118_;
        BooleanOp booleanop = direction$axisdirection == Direction.AxisDirection.POSITIVE ? BooleanOp.ONLY_FIRST : BooleanOp.ONLY_SECOND;
        return DoubleMath.fuzzyEquals((double)voxelshape.max(direction$axis), (double)1.0, (double)1.0E-7) && DoubleMath.fuzzyEquals((double)voxelshape1.min(direction$axis), (double)0.0, (double)1.0E-7) && !Shapes.joinIsNotEmpty(new SliceShape(voxelshape, direction$axis, voxelshape.shape.getSize(direction$axis) - 1), new SliceShape(voxelshape1, direction$axis, 0), booleanop);
    }

    public static boolean mergedFaceOccludes(VoxelShape p_83153_, VoxelShape p_83154_, Direction p_83155_) {
        if (p_83153_ != Shapes.block() && p_83154_ != Shapes.block()) {
            VoxelShape voxelshape1;
            Direction.Axis direction$axis = p_83155_.getAxis();
            Direction.AxisDirection direction$axisdirection = p_83155_.getAxisDirection();
            VoxelShape voxelshape = direction$axisdirection == Direction.AxisDirection.POSITIVE ? p_83153_ : p_83154_;
            VoxelShape voxelShape = voxelshape1 = direction$axisdirection == Direction.AxisDirection.POSITIVE ? p_83154_ : p_83153_;
            if (!DoubleMath.fuzzyEquals((double)voxelshape.max(direction$axis), (double)1.0, (double)1.0E-7)) {
                voxelshape = Shapes.empty();
            }
            if (!DoubleMath.fuzzyEquals((double)voxelshape1.min(direction$axis), (double)0.0, (double)1.0E-7)) {
                voxelshape1 = Shapes.empty();
            }
            return !Shapes.joinIsNotEmpty(Shapes.block(), Shapes.joinUnoptimized(new SliceShape(voxelshape, direction$axis, voxelshape.shape.getSize(direction$axis) - 1), new SliceShape(voxelshape1, direction$axis, 0), BooleanOp.OR), BooleanOp.ONLY_FIRST);
        }
        return true;
    }

    public static boolean faceShapeOccludes(VoxelShape p_83146_, VoxelShape p_83147_) {
        if (p_83146_ == Shapes.block() || p_83147_ == Shapes.block()) {
            return true;
        }
        return p_83146_.isEmpty() && p_83147_.isEmpty() ? false : !Shapes.joinIsNotEmpty(Shapes.block(), Shapes.joinUnoptimized(p_83146_, p_83147_, BooleanOp.OR), BooleanOp.ONLY_FIRST);
    }

    @VisibleForTesting
    protected static IndexMerger createIndexMerger(int p_83059_, DoubleList p_83060_, DoubleList p_83061_, boolean p_83062_, boolean p_83063_) {
        long k;
        int i = p_83060_.size() - 1;
        int j = p_83061_.size() - 1;
        if (p_83060_ instanceof CubePointRange && p_83061_ instanceof CubePointRange && (long)p_83059_ * (k = Shapes.lcm(i, j)) <= 256L) {
            return new DiscreteCubeMerger(i, j);
        }
        if (p_83060_.getDouble(i) < p_83061_.getDouble(0) - 1.0E-7) {
            return new NonOverlappingMerger(p_83060_, p_83061_, false);
        }
        if (p_83061_.getDouble(j) < p_83060_.getDouble(0) - 1.0E-7) {
            return new NonOverlappingMerger(p_83061_, p_83060_, true);
        }
        return i == j && Objects.equals(p_83060_, p_83061_) ? new IdenticalMerger(p_83060_) : new IndirectMerger(p_83060_, p_83061_, p_83062_, p_83063_);
    }

    public static VoxelShape rotate(VoxelShape p_393610_, OctahedralGroup p_393964_) {
        return Shapes.rotate(p_393610_, p_393964_, BLOCK_CENTER);
    }

    public static VoxelShape rotate(VoxelShape p_394159_, OctahedralGroup p_393775_, Vec3 p_393709_) {
        if (p_393775_ == OctahedralGroup.IDENTITY) {
            return p_394159_;
        }
        DiscreteVoxelShape discretevoxelshape = p_394159_.shape.rotate(p_393775_);
        if (p_394159_ instanceof CubeVoxelShape && BLOCK_CENTER.equals(p_393709_)) {
            return new CubeVoxelShape(discretevoxelshape);
        }
        Direction.Axis direction$axis = p_393775_.permute(Direction.Axis.X);
        Direction.Axis direction$axis1 = p_393775_.permute(Direction.Axis.Y);
        Direction.Axis direction$axis2 = p_393775_.permute(Direction.Axis.Z);
        DoubleList doublelist = p_394159_.getCoords(direction$axis);
        DoubleList doublelist1 = p_394159_.getCoords(direction$axis1);
        DoubleList doublelist2 = p_394159_.getCoords(direction$axis2);
        boolean flag = p_393775_.inverts(direction$axis);
        boolean flag1 = p_393775_.inverts(direction$axis1);
        boolean flag2 = p_393775_.inverts(direction$axis2);
        boolean flag3 = direction$axis.choose(flag, flag1, flag2);
        boolean flag4 = direction$axis1.choose(flag, flag1, flag2);
        boolean flag5 = direction$axis2.choose(flag, flag1, flag2);
        return new ArrayVoxelShape(discretevoxelshape, Shapes.makeAxis(doublelist, flag3, p_393709_.get(direction$axis), p_393709_.x), Shapes.makeAxis(doublelist1, flag4, p_393709_.get(direction$axis1), p_393709_.y), Shapes.makeAxis(doublelist2, flag5, p_393709_.get(direction$axis2), p_393709_.z));
    }

    @VisibleForTesting
    static DoubleList makeAxis(DoubleList p_394476_, boolean p_393672_, double p_393636_, double p_394608_) {
        int k;
        if (!p_393672_ && p_393636_ == p_394608_) {
            return p_394476_;
        }
        int i = p_394476_.size();
        DoubleArrayList doublelist = new DoubleArrayList(i);
        int j = p_393672_ ? -1 : 1;
        int n = k = p_393672_ ? i - 1 : 0;
        while (k >= 0 && k < i) {
            doublelist.add(p_394608_ + (double)j * (p_394476_.getDouble(k) - p_393636_));
            k += j;
        }
        return doublelist;
    }

    public static boolean equal(VoxelShape p_394565_, VoxelShape p_393940_) {
        return !Shapes.joinIsNotEmpty(p_394565_, p_393940_, BooleanOp.NOT_SAME);
    }

    public static Map<Direction.Axis, VoxelShape> rotateHorizontalAxis(VoxelShape p_394394_) {
        return Shapes.rotateHorizontalAxis(p_394394_, BLOCK_CENTER);
    }

    public static Map<Direction.Axis, VoxelShape> rotateHorizontalAxis(VoxelShape p_393683_, Vec3 p_394313_) {
        return Maps.newEnumMap(Map.of(Direction.Axis.Z, p_393683_, Direction.Axis.X, Shapes.rotate(p_393683_, OctahedralGroup.fromXYAngles(Quadrant.R0, Quadrant.R90), p_394313_)));
    }

    public static Map<Direction.Axis, VoxelShape> rotateAllAxis(VoxelShape p_394319_) {
        return Shapes.rotateAllAxis(p_394319_, BLOCK_CENTER);
    }

    public static Map<Direction.Axis, VoxelShape> rotateAllAxis(VoxelShape p_393798_, Vec3 p_393985_) {
        return Maps.newEnumMap(Map.of(Direction.Axis.Z, p_393798_, Direction.Axis.X, Shapes.rotate(p_393798_, OctahedralGroup.fromXYAngles(Quadrant.R0, Quadrant.R90), p_393985_), Direction.Axis.Y, Shapes.rotate(p_393798_, OctahedralGroup.fromXYAngles(Quadrant.R90, Quadrant.R0), p_393985_)));
    }

    public static Map<Direction, VoxelShape> rotateHorizontal(VoxelShape p_393618_) {
        return Shapes.rotateHorizontal(p_393618_, BLOCK_CENTER);
    }

    public static Map<Direction, VoxelShape> rotateHorizontal(VoxelShape p_394145_, Vec3 p_393544_) {
        return Maps.newEnumMap(Map.of(Direction.NORTH, p_394145_, Direction.EAST, Shapes.rotate(p_394145_, OctahedralGroup.fromXYAngles(Quadrant.R0, Quadrant.R90), p_393544_), Direction.SOUTH, Shapes.rotate(p_394145_, OctahedralGroup.fromXYAngles(Quadrant.R0, Quadrant.R180), p_393544_), Direction.WEST, Shapes.rotate(p_394145_, OctahedralGroup.fromXYAngles(Quadrant.R0, Quadrant.R270), p_393544_)));
    }

    public static Map<Direction, VoxelShape> rotateAll(VoxelShape p_394480_) {
        return Shapes.rotateAll(p_394480_, BLOCK_CENTER);
    }

    public static Map<Direction, VoxelShape> rotateAll(VoxelShape p_394143_, Vec3 p_394280_) {
        return Maps.newEnumMap(Map.of(Direction.NORTH, p_394143_, Direction.EAST, Shapes.rotate(p_394143_, OctahedralGroup.fromXYAngles(Quadrant.R0, Quadrant.R90), p_394280_), Direction.SOUTH, Shapes.rotate(p_394143_, OctahedralGroup.fromXYAngles(Quadrant.R0, Quadrant.R180), p_394280_), Direction.WEST, Shapes.rotate(p_394143_, OctahedralGroup.fromXYAngles(Quadrant.R0, Quadrant.R270), p_394280_), Direction.UP, Shapes.rotate(p_394143_, OctahedralGroup.fromXYAngles(Quadrant.R270, Quadrant.R0), p_394280_), Direction.DOWN, Shapes.rotate(p_394143_, OctahedralGroup.fromXYAngles(Quadrant.R90, Quadrant.R0), p_394280_)));
    }

    public static Map<AttachFace, Map<Direction, VoxelShape>> rotateAttachFace(VoxelShape p_394129_) {
        return Map.of(AttachFace.WALL, Shapes.rotateHorizontal(p_394129_), AttachFace.FLOOR, Shapes.rotateHorizontal(Shapes.rotate(p_394129_, OctahedralGroup.fromXYAngles(Quadrant.R270, Quadrant.R0))), AttachFace.CEILING, Shapes.rotateHorizontal(Shapes.rotate(p_394129_, OctahedralGroup.fromXYAngles(Quadrant.R90, Quadrant.R180))));
    }

    public static interface DoubleLineConsumer {
        public void consume(double var1, double var3, double var5, double var7, double var9, double var11);
    }
}

