/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EntityCollisionContext
implements CollisionContext {
    protected static final CollisionContext EMPTY = new EntityCollisionContext(false, false, -1.7976931348623157E308, ItemStack.EMPTY, p_205118_ -> false, null){

        @Override
        public boolean isAbove(VoxelShape p_82898_, BlockPos p_82899_, boolean p_82900_) {
            return p_82900_;
        }
    };
    private final boolean descending;
    private final double entityBottom;
    private final boolean placement;
    private final ItemStack heldItem;
    private final Predicate<FluidState> canStandOnFluid;
    @Nullable
    private final Entity entity;

    protected EntityCollisionContext(boolean p_361032_, boolean p_405496_, double p_405803_, ItemStack p_404927_, Predicate<FluidState> p_405766_, @Nullable Entity p_82872_) {
        this.descending = p_361032_;
        this.placement = p_405496_;
        this.entityBottom = p_405803_;
        this.heldItem = p_404927_;
        this.canStandOnFluid = p_405766_;
        this.entity = p_82872_;
    }

    @Deprecated
    protected EntityCollisionContext(Entity p_198920_, boolean p_198916_, boolean p_404752_) {
        Predicate<FluidState> predicate;
        ItemStack itemStack;
        boolean bl = p_198920_.isDescending();
        double d = p_198920_.getY();
        if (p_198920_ instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)p_198920_;
            itemStack = livingentity.getMainHandItem();
        } else {
            itemStack = ItemStack.EMPTY;
        }
        if (p_198916_) {
            predicate = p_360273_ -> true;
        } else if (p_198920_ instanceof LivingEntity) {
            LivingEntity livingentity1 = (LivingEntity)p_198920_;
            predicate = p_404624_ -> livingentity1.canStandOnFluid((FluidState)p_404624_);
        } else {
            predicate = p_205113_ -> false;
        }
        this(bl, p_404752_, d, itemStack, predicate, p_198920_);
    }

    @Override
    public boolean isHoldingItem(Item p_82879_) {
        return this.heldItem.is(p_82879_);
    }

    @Override
    public boolean canStandOnFluid(FluidState p_205115_, FluidState p_205116_) {
        return this.canStandOnFluid.test(p_205116_) && !p_205115_.getType().isSame(p_205116_.getType());
    }

    @Override
    public VoxelShape getCollisionShape(BlockState p_366423_, CollisionGetter p_366608_, BlockPos p_366445_) {
        return p_366423_.getCollisionShape(p_366608_, p_366445_, this);
    }

    @Override
    public boolean isDescending() {
        return this.descending;
    }

    @Override
    public boolean isAbove(VoxelShape p_82886_, BlockPos p_82887_, boolean p_82888_) {
        return this.entityBottom > (double)p_82887_.getY() + p_82886_.max(Direction.Axis.Y) - (double)1.0E-5f;
    }

    @Nullable
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public boolean isPlacement() {
        return this.placement;
    }
}

