/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.MinecartCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface CollisionContext {
    public static CollisionContext empty() {
        return EntityCollisionContext.EMPTY;
    }

    public static CollisionContext of(Entity p_82751_) {
        Entity entity = p_82751_;
        Objects.requireNonNull(entity);
        Entity entity2 = entity;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AbstractMinecart.class}, (Object)entity2, n)) {
            case 0 -> {
                AbstractMinecart abstractminecart = (AbstractMinecart)entity2;
                if (AbstractMinecart.useExperimentalMovement(abstractminecart.level())) {
                    yield new MinecartCollisionContext(abstractminecart, false);
                }
                yield new EntityCollisionContext(p_82751_, false, false);
            }
            default -> new EntityCollisionContext(p_82751_, false, false);
        };
    }

    public static CollisionContext of(Entity p_363326_, boolean p_364344_) {
        return new EntityCollisionContext(p_363326_, p_364344_, false);
    }

    public static CollisionContext placementContext(@Nullable Player p_422168_) {
        return new EntityCollisionContext(p_422168_ != null ? p_422168_.isDescending() : false, true, p_422168_ != null ? p_422168_.getY() : -1.7976931348623157E308, p_422168_ instanceof LivingEntity ? p_422168_.getMainHandItem() : ItemStack.EMPTY, p_422168_ instanceof LivingEntity ? p_404827_ -> p_422168_.canStandOnFluid((FluidState)p_404827_) : p_405865_ -> false, p_422168_);
    }

    public static CollisionContext withPosition(@Nullable Entity p_405836_, double p_422096_) {
        Predicate<FluidState> predicate;
        ItemStack itemStack;
        boolean bl = p_405836_ != null ? p_405836_.isDescending() : false;
        double d = p_405836_ != null ? p_422096_ : -1.7976931348623157E308;
        if (p_405836_ instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)p_405836_;
            itemStack = livingentity.getMainHandItem();
        } else {
            itemStack = ItemStack.EMPTY;
        }
        if (p_405836_ instanceof LivingEntity) {
            LivingEntity livingentity1 = (LivingEntity)p_405836_;
            predicate = p_421474_ -> livingentity1.canStandOnFluid((FluidState)p_421474_);
        } else {
            predicate = p_421475_ -> false;
        }
        return new EntityCollisionContext(bl, true, d, itemStack, predicate, p_405836_);
    }

    public boolean isDescending();

    public boolean isAbove(VoxelShape var1, BlockPos var2, boolean var3);

    public boolean isHoldingItem(Item var1);

    public boolean canStandOnFluid(FluidState var1, FluidState var2);

    public VoxelShape getCollisionShape(BlockState var1, CollisionGetter var2, BlockPos var3);

    default public boolean isPlacement() {
        return false;
    }
}

