/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import org.slf4j.Logger;

public record ConditionReference(ResourceKey<LootItemCondition> name) implements LootItemCondition
{
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<ConditionReference> CODEC = RecordCodecBuilder.mapCodec(p_335367_ -> p_335367_.group((App)ResourceKey.codec(Registries.PREDICATE).fieldOf("name").forGetter(ConditionReference::name)).apply((Applicative)p_335367_, ConditionReference::new));

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.REFERENCE;
    }

    @Override
    public void validate(ValidationContext p_81560_) {
        if (!p_81560_.allowsReferences()) {
            p_81560_.reportProblem(new ValidationContext.ReferenceNotAllowedProblem(this.name));
        } else if (p_81560_.hasVisitedElement(this.name)) {
            p_81560_.reportProblem(new ValidationContext.RecursiveReferenceProblem(this.name));
        } else {
            LootItemCondition.super.validate(p_81560_);
            p_81560_.resolver().get(this.name).ifPresentOrElse(p_421472_ -> ((LootItemCondition)p_421472_.value()).validate(p_81560_.enterElement(new ProblemReporter.ElementReferencePathElement(this.name), this.name)), () -> p_81560_.reportProblem(new ValidationContext.MissingReferenceProblem(this.name)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test(LootContext p_81558_) {
        LootItemCondition lootitemcondition = p_81558_.getResolver().get(this.name).map(Holder.Reference::value).orElse(null);
        if (lootitemcondition == null) {
            LOGGER.warn("Tried using unknown condition table called {}", (Object)this.name.location());
            return false;
        }
        LootContext.VisitedEntry<LootItemCondition> visitedentry = LootContext.createVisitedEntry(lootitemcondition);
        if (p_81558_.pushVisitedElement(visitedentry)) {
            boolean flag;
            try {
                flag = lootitemcondition.test(p_81558_);
            }
            finally {
                p_81558_.popVisitedElement(visitedentry);
            }
            return flag;
        }
        LOGGER.warn("Detected infinite loop in loot tables");
        return false;
    }

    public static LootItemCondition.Builder conditionReference(ResourceKey<LootItemCondition> p_335879_) {
        return () -> new ConditionReference(p_335879_);
    }
}

