/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class SmeltItemFunction
extends LootItemConditionalFunction {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<SmeltItemFunction> CODEC = RecordCodecBuilder.mapCodec(p_298746_ -> SmeltItemFunction.commonFields(p_298746_).apply((Applicative)p_298746_, SmeltItemFunction::new));

    private SmeltItemFunction(List<LootItemCondition> p_299162_) {
        super(p_299162_);
    }

    public LootItemFunctionType<SmeltItemFunction> getType() {
        return LootItemFunctions.FURNACE_SMELT;
    }

    @Override
    public ItemStack run(ItemStack p_81268_, LootContext p_81269_) {
        ItemStack itemstack;
        if (p_81268_.isEmpty()) {
            return p_81268_;
        }
        SingleRecipeInput singlerecipeinput = new SingleRecipeInput(p_81268_);
        Optional<RecipeHolder<SmeltingRecipe>> optional = p_81269_.getLevel().recipeAccess().getRecipeFor(RecipeType.SMELTING, singlerecipeinput, p_81269_.getLevel());
        if (optional.isPresent() && !(itemstack = optional.get().value().assemble(singlerecipeinput, (HolderLookup.Provider)p_81269_.getLevel().registryAccess())).isEmpty()) {
            return itemstack.copyWithCount(p_81268_.getCount() * itemstack.getCount());
        }
        LOGGER.warn("Couldn't smelt {} because there is no smelting recipe", (Object)p_81268_);
        return p_81268_;
    }

    public static LootItemConditionalFunction.Builder<?> smelted() {
        return SmeltItemFunction.simpleBuilder(SmeltItemFunction::new);
    }
}

