/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.network.Filterable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.ListOperation;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetWrittenBookPagesFunction
extends LootItemConditionalFunction {
    public static final MapCodec<SetWrittenBookPagesFunction> CODEC = RecordCodecBuilder.mapCodec(p_393456_ -> SetWrittenBookPagesFunction.commonFields(p_393456_).and(p_393456_.group((App)WrittenBookContent.PAGES_CODEC.fieldOf("pages").forGetter(p_333939_ -> p_333939_.pages), (App)ListOperation.UNLIMITED_CODEC.forGetter(p_333933_ -> p_333933_.pageOperation))).apply((Applicative)p_393456_, SetWrittenBookPagesFunction::new));
    private final List<Filterable<Component>> pages;
    private final ListOperation pageOperation;

    public SetWrittenBookPagesFunction(List<LootItemCondition> p_333863_, List<Filterable<Component>> p_333788_, ListOperation p_334047_) {
        super(p_333863_);
        this.pages = p_333788_;
        this.pageOperation = p_334047_;
    }

    @Override
    protected ItemStack run(ItemStack p_333960_, LootContext p_333892_) {
        p_333960_.update(DataComponents.WRITTEN_BOOK_CONTENT, WrittenBookContent.EMPTY, this::apply);
        return p_333960_;
    }

    @VisibleForTesting
    public WrittenBookContent apply(WrittenBookContent p_333830_) {
        List<Filterable<Component>> list = this.pageOperation.apply(p_333830_.pages(), this.pages);
        return p_333830_.withReplacedPages((List)list);
    }

    public LootItemFunctionType<SetWrittenBookPagesFunction> getType() {
        return LootItemFunctions.SET_WRITTEN_BOOK_PAGES;
    }
}

